/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.Filter;
import com.sun.web.admin.util.ValidateUtil;
import com.sun.web.admin.util.XmlNode;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class LSInfoBean {
    private XmlNode root = null;
    private String lsId = "";
    private String ip = "";
    private String port = "";
    private String securityStatus = "";
    private String acc = "";

    public static void AddDefaultSSLParams(XmlNode xmlNode) throws Exception {
        XmlNode xmlNode2 = xmlNode.findConfig("SSLPARAMS");
        if (xmlNode2 == null) {
            xmlNode2 = LSInfoBean.GetDefaultSSLNode(xmlNode);
            xmlNode.addChild(xmlNode2);
        }
    }

    public static void RemoveSSLParams(XmlNode xmlNode) throws Exception {
        XmlNode xmlNode2 = xmlNode.findConfig("SSLPARAMS");
        if (xmlNode2 != null) {
            xmlNode.removeChild(xmlNode2);
        }
    }

    public static int EditLS(String string, String string2, String string3, String string4, String string5, XmlNode xmlNode, String string6, String string7) throws Exception {
        if (!LSInfoBean.checkPort(string, string2, string3, xmlNode)) {
            return -2;
        }
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate("LS");
        XmlNode xmlNode3 = new XmlNode(xmlNode, "LS", "", "", 0);
        xmlNode3.setAttribute("id", string);
        xmlNode3.setAttribute("ip", string2);
        if (LSInfoBean.isIPv6(string2)) {
            xmlNode3.addChild("family", "inet6", "", 0);
        }
        xmlNode3.setAttribute("port", string3);
        xmlNode3.setAttribute("security", string4);
        xmlNode3.setAttribute("acceptorthreads", string5);
        if (string4.equals("off")) {
            LSInfoBean.RemoveSSLParams(xmlNode3);
        } else {
            LSInfoBean.AddDefaultSSLParams(xmlNode3);
        }
        xmlNode2.addChild(xmlNode3);
        if (!LSInfoBean.checkPortOfOtherInstance(string2, string3, string6, string7)) {
            return -1;
        }
        return 0;
    }

    static boolean isIPv6(String string) {
        return string.indexOf(58) != -1;
    }

    public static int DeleteLS(String string, XmlNode xmlNode) {
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getName().equals("LS") || !xmlNode3.getString("id", "null").equals(string)) continue;
            xmlNode2.removeChild(xmlNode3);
            break;
        }
        return 0;
    }

    public static boolean checkId(String string, XmlNode xmlNode) {
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getName().equals("LS") || !xmlNode3.getString("id", "null").equals(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPort(String string, String string2, String string3, XmlNode xmlNode) {
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate();
        while (iterator.hasNext()) {
            String string4;
            String string5;
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getName().equals("LS") || xmlNode3.getString("id", "null").equals(string) || LSInfoBean.validatePort(string5 = xmlNode3.getString("ip", "null"), string2, string4 = xmlNode3.getString("port", "null"), string3)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPort(String string, String string2, XmlNode xmlNode) {
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            if (!xmlNode3.getName().equals("LS") || LSInfoBean.validatePort(string4 = xmlNode3.getString("ip", "null"), string, string3 = xmlNode3.getString("port", "null"), string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean validatePort(String string, String string2, String string3, String string4) {
        if (string3.equals(string4)) {
            if (string.equals(string2)) {
                return false;
            }
            if (ValidateUtil.isIpAny(string) && ValidateUtil.isIpAny(string2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkPortOfAllInstance(String string, String string2, String string3) throws Exception {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("https-");
            }
        };
        return LSInfoBean.checkPortOfInstance(string, string2, string3, filenameFilter);
    }

    public static boolean checkPortOfOtherInstance(String string, String string2, String string3, String string4) throws Exception {
        Filter filter = new Filter(string4);
        return LSInfoBean.checkPortOfInstance(string, string2, string3, filter);
    }

    private static boolean checkPortOfInstance(String string, String string2, String string3, FilenameFilter filenameFilter) throws Exception {
        File file = new File(string3);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                XmlNode xmlNode = AdminConfig.getInstance(string3, "server.xml", stringArray[i]);
                if (LSInfoBean.checkPort(string, string2, xmlNode)) continue;
                return false;
            }
        }
        return true;
    }

    public static int CreateLS(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, XmlNode xmlNode, String string9, String string10) throws Exception {
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate();
        if (!LSInfoBean.checkId(string, xmlNode) || !LSInfoBean.checkPort(string, string2, string3, xmlNode)) {
            return -2;
        }
        XmlNode xmlNode3 = new XmlNode(xmlNode, "LS", "", "", 0);
        xmlNode3.setAttribute("id", string);
        xmlNode3.setAttribute("port", string3);
        xmlNode3.setAttribute("servername", string7);
        xmlNode3.setAttribute("defaultvs", string8);
        xmlNode3.setAttribute("security", string4);
        xmlNode3.setAttribute("ip", string2);
        xmlNode3.setAttribute("blocking", "false");
        xmlNode3.setAttribute("acceptorthreads", string6);
        if (string4.equals("on")) {
            XmlNode xmlNode4 = LSInfoBean.GetDefaultSSLNodeCert(xmlNode3, string5);
            xmlNode3.addChild(xmlNode4);
        }
        xmlNode2.addChild(xmlNode3);
        if (!LSInfoBean.checkPortOfOtherInstance(string2, string3, string9, string10)) {
            return -1;
        }
        return 0;
    }

    public void init(String string, String string2, String string3) throws Exception {
        this.root = AdminConfig.getInstance(string, string2);
        this.initialize(string3);
    }

    public void init(String string, String string2, String string3, String string4) throws Exception {
        this.root = AdminConfig.getInstance(string, string2);
        this.initialize(string4);
    }

    public void init(String string, XmlNode xmlNode, String string2) {
        this.root = xmlNode;
        this.initialize(string2);
    }

    private void initialize(String string) {
        XmlNode xmlNode = this.root.findConfig("SERVER");
        Iterator iterator = xmlNode.iterate("LS");
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (!string.trim().equals(xmlNode2.getString("id", "null").trim())) continue;
            this.lsId = string;
            this.securityStatus = xmlNode2.getString("security", "null").trim();
            this.ip = xmlNode2.getString("ip", "null");
            this.port = xmlNode2.getString("port", "null");
        }
    }

    public static XmlNode formNode(Hashtable hashtable, String string) throws Exception {
        XmlNode xmlNode;
        Iterator iterator;
        LSInfoBean lSInfoBean = new LSInfoBean();
        String string2 = hashtable.get("id").toString();
        lSInfoBean.init(hashtable.get("SROOT").toString(), string, string2);
        if (hashtable.get("ip") != null) {
            lSInfoBean.ip = hashtable.get("ip").toString();
        }
        if (hashtable.get("portNumber") != null) {
            lSInfoBean.port = hashtable.get("portNumber").toString();
        }
        if (hashtable.get("security") != null) {
            lSInfoBean.securityStatus = hashtable.get("security").toString();
        }
        if ((iterator = (xmlNode = lSInfoBean.root.findConfig("SERVER")).iterate("LS")).hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (lSInfoBean.lsId.trim().equals(xmlNode2.getString("id", "null").trim())) {
                XmlNode xmlNode3 = new XmlNode(lSInfoBean.root, "LS", "", "", 0);
                xmlNode3.addChild("id", xmlNode2.getString("id", "null"), "", 0);
                xmlNode3.addChild("ip", xmlNode2.getString("ip", "null"), "", 0);
                if (LSInfoBean.isIPv6(xmlNode2.getString("ip", "null"))) {
                    xmlNode3.addChild("family", "inet6", "", 0);
                }
                xmlNode3.addChild("port", xmlNode2.getString("port", "null"), "", 0);
                xmlNode3.addChild("security", hashtable.get("security").toString(), "", 0);
                xmlNode3.addChild("acceptorthreads", xmlNode2.getString("acceptorthreads", "null"), "", 0);
                xmlNode.removeChild(xmlNode2);
                xmlNode.addChild(xmlNode3);
            }
            return xmlNode;
        }
        return xmlNode;
    }

    public String getLsId() {
        return this.lsId;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPortNumber() {
        return this.port;
    }

    public String getSecurityStatus() {
        if (this.securityStatus == null) {
            return "off";
        }
        if (this.securityStatus.trim().equalsIgnoreCase("yes") || this.securityStatus.trim().equalsIgnoreCase("on") || this.securityStatus.trim().equalsIgnoreCase("1")) {
            return "on";
        }
        return "off";
    }

    public static XmlNode GetDefaultSSLNode(XmlNode xmlNode) {
        XmlNode xmlNode2 = new XmlNode(xmlNode, "SSLPARAMS", "", "", 0);
        xmlNode2.setAttribute("servercertnickname", "Server-Cert");
        xmlNode2.setAttribute("ssl2", "off");
        xmlNode2.setAttribute("ssl2ciphers", "-rc4,-rc4export,-rc2,-rc2export,-desede3,-des");
        xmlNode2.setAttribute("ssl3", "on");
        xmlNode2.setAttribute("ssl3tlsciphers", "-rsa_rc4_128_sha,+rsa_rc4_128_md5,-rsa_rc4_56_sha,-rsa_rc4_40_md5,+rsa_3des_sha,+rsa_des_sha,-rsa_des_56_sha,-rsa_rc2_40_md5,-rsa_null_md5,-fortezza,-fortezza_rc4_128_sha,-fortezza_null,+fips_3des_sha,-fips_des_sha");
        xmlNode2.setAttribute("tls", "on");
        xmlNode2.setAttribute("tlsrollback", "off");
        xmlNode2.setAttribute("clientauth", "off");
        return xmlNode2;
    }

    public static XmlNode GetDefaultSSLNodeCert(XmlNode xmlNode, String string) {
        XmlNode xmlNode2 = new XmlNode(xmlNode, "SSLPARAMS", "", "", 0);
        xmlNode2.setAttribute("servercertnickname", string);
        xmlNode2.setAttribute("ssl2", "off");
        xmlNode2.setAttribute("ssl2ciphers", "-rc4,-rc4export,-rc2,-rc2export,-desede3,-des");
        xmlNode2.setAttribute("ssl3", "on");
        xmlNode2.setAttribute("ssl3tlsciphers", "-rsa_rc4_128_sha,+rsa_rc4_128_md5,-rsa_rc4_56_sha,-rsa_rc4_40_md5,+rsa_3des_sha,+rsa_des_sha,-rsa_des_56_sha,-rsa_rc2_40_md5,-rsa_null_md5,-fortezza,-fortezza_rc4_128_sha,-fortezza_null,+fips_3des_sha,-fips_des_sha");
        xmlNode2.setAttribute("tls", "on");
        xmlNode2.setAttribute("tlsrollback", "off");
        xmlNode2.setAttribute("clientauth", "off");
        return xmlNode2;
    }

    public static String[] getNodeArrayFromVector(Vector vector) {
        Object[] objectArray = vector.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        vector.clear();
        return stringArray;
    }
}

