/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.MagObj;
import com.sun.web.admin.util.StatsUtil;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;

public class IWSStatsBean {
    private XmlNode parentNode = null;
    private String statsXmlFileName = null;
    private String statsDtdFileName = null;
    private String serverHostName = null;
    private String serverInstanceName = null;
    private String protocolName = null;
    private XmlConfig xConfig = null;
    private XmlNode rootNode = null;
    private String sRoot = null;

    public XmlNode getStatsXmlNode(String string, String string2, String string3) throws Exception, IOException {
        this.sRoot = string3;
        this.serverInstanceName = this.getServerInstanceName(string);
        String string4 = this.getServerPortNumber(string);
        this.protocolName = this.getProtocolName(string2);
        if (this.getStatsFiles(string)) {
            this.parseStatsXml();
        }
        return this.parentNode;
    }

    private boolean getStatsFiles(String string) throws Exception {
        boolean bl = false;
        try {
            File file = File.createTempFile("stats", ".dtd");
            File file2 = File.createTempFile("stats", ".xml");
            file.deleteOnExit();
            file2.deleteOnExit();
            this.statsXmlFileName = file2.getPath();
            this.statsDtdFileName = file.getPath();
            MagObj magObj = new MagObj();
            magObj.init(this.sRoot, string);
            String string2 = magObj.get_mag_var("TempDir");
            if (StatsUtil.writeStatsDtd(this.statsDtdFileName) && StatsUtil.writeStatsXml(this.statsXmlFileName, string, file.getName(), string2)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.toString());
        }
        return bl;
    }

    private String getProtocolName(String string) {
        int n = string.indexOf("https:");
        if (n < 0) {
            return "http";
        }
        return "https";
    }

    private String getServerInstanceName(String string) {
        int n = string.length();
        int n2 = string.indexOf("https-");
        String string2 = string.substring(n2 += 6, n);
        return string2;
    }

    private String getServerPortNumber(String string) throws Exception {
        XmlNode xmlNode = null;
        xmlNode = AdminConfig.getInstance(this.sRoot, string);
        this.serverHostName = InetAddress.getLocalHost().getHostName();
        XmlNode xmlNode2 = xmlNode.findConfig("SERVER");
        Iterator iterator = xmlNode2.iterate("LS");
        if (iterator.hasNext()) {
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            return xmlNode3.getString("port", "null");
        }
        return "-1";
    }

    private void parseStatsXml() throws Exception {
        this.xConfig = new XmlConfig(this.statsXmlFileName);
        this.rootNode = null;
        this.rootNode = this.xConfig.parseConfig();
        this.parentNode = this.xConfig.findConfig("stats");
    }

    public void cleanUp() {
        File file = new File(this.statsXmlFileName);
        file.delete();
        File file2 = new File(this.statsDtdFileName);
        file2.delete();
    }
}

