#!/usr/bin/sh -- # This comment tells perl not to loop!
eval 'exec perl -S $0 ${1+"$@"}'
   if 0;

$PROGNAME = "ac_update_script.pl";

###############################################################################
#
#                       Main  Program
#
#   ident "@(#)ac_update_script.pl 1.1     04/05/16 SMI"
#
#   This script runs pprosvc to apply the array controller patches
#
#
###############################################################################

$INVENTORY_FILE         ="/var/opt/SUNWstade/DATA/inventory.xml";
$INVENTORY_FILE_ORIG     ="inventory.xml.orig";
$INVENTORY_FILE_NEW     ="inventory.xml.new";
$STORADE                ="storade";
$CONF_FILE              ="/etc/opt/SUNWppro/etc/patchpro.conf";
$CONF_FILE_ORIG          ="patchpro.conf.orig";
$CONF_FILE_NEW          ="patchpro.conf.new";
$OUTPUT_DIR             = "/var/tmp/pprosvc_";
$IP_ADDRS               = "array_ips";
$SCRIPT_NAME            ="ppro.sh";
$patch_id               = "115179-11";
$ERROR_FILE             ="error.log";
$PPRO_OUT               ="/tmp/pprosvc.out";
$COUNTERS_OUT           ="/tmp/pprosvc.cnt";

$inventory_exists=1;

&getnstore_input;

&create_filename_ppro_output;

&update_array;


##################################################
##
##
##        Get the user input and store it in
##        the file array_ips in the current directory.
##
##
##################################################

sub getnstore_input()
{
print "Enter the number of arrays to be upgraded.\n";

$cnt=<STDIN>;
if ($cnt>0) {
	open(IPFILE, ">$IP_ADDRS") || die "Couldn't open file : $IP_ADDRS";
        for ($i=0; $i<$cnt; $i++) {
        	print "Enter the ipaddress of the array to be upgraded.\n";
                $ipaddress=<STDIN>;
                print IPFILE "$ipaddress";
        }
                close(IPFILE);
} else {
	print "Reissue the script and enter a valid number of arrays to be upgraded.";
        exit 1;
}
}

##################################################
##
##
##        Change the patchpro.conf file to  not update
##        the inventory xml file
##
##
##################################################           


sub array_conf_file
{
	system("cp $CONF_FILE $CONF_FILE_ORIG");

open(OUT, ">>$CONF_FILE_NEW") || die "Couldn't open file : $CONF_FILE_NEW";
open(FILE, "$CONF_FILE") || die "Couldn't open file : $CONF_FILE";

while($line=<FILE>) {

        chop $line;
        $search = "get.inventory";
        $replace = "sleep 3";
        {
        if ($line =~ /\b$search\b/ )
                {
        print OUT "patchpro.storade.command.get.inventory=sleep 3\n";
                }
        else    {
                print OUT "$line\n";}
                        }
}
close(OUT);
close(FILE);
        system("mv $CONF_FILE_NEW $CONF_FILE");
}

##################################################
##
##
##        Determine which directories already exist 
##        to create a unique PPRO directory to store 
##        results.
##
##################################################           


sub create_filename_ppro_output
{
$cnt=0;
$file="$OUTPUT_DIR.$cnt";
while ( -e $file )
        {
        ++$cnt;
        $file="$OUTPUT_DIR$STORADE.$cnt";
        }
$PPRO_OUTPUT = "$STORADE.$cnt";
}

##################################################
##
##
##   Read array_ips file and for each array listed
##   use the pprosvc command to force application of patch
##
##   
##
##
##################################################           


sub update_array 
{
open(IPFILE, "$IP_ADDRS") || die "Couldn't open file : $IP_ADDRS";
$array_cnt=0;
        system("date >> $COUNTERS_OUT");

while($ipaddr=<IPFILE>) {
chop $ipaddr;
&check_inventory_file_exists;
&array_conf_file;

       system("/opt/SUNWppro/bin/pprosvc -i -o $ipaddr -p $patch_id -s $PPRO_OUTPUT >> $PPRO_OUT\n");
        ++$array_cnt;
        system("cat /tmp/pprosvc.out | grep applied >> $COUNTERS_OUT");
        open(CNT, ">>$COUNTERS_OUT") || die "Couldn't open file : $COUNTERS_OUT"
;
        print "array # $array_cnt: $ipaddr\n";
        system("mv $CONF_FILE_ORIG $CONF_FILE");
	if ($inventory_exists>0) {
        	system("mv $INVENTORY_FILE_ORIG $INVENTORY_FILE");
	} else {
		system("rm $INVENTORY_FILE");
	}
}

system("date >> $COUNTERS_OUT");
print CNT "Total # of arrays that tried to be upgraded $array_cnt\n";
close(CNT);
close(IPFILE);
system("rm array_ips");
system("rm /tmp/pprosvc.out");
}

##################################################
##
##
##    Create the inventory xml file if it does not
##    exist, and make a call to the subroutine that
##    updates the xml file to show downlevel
##    versions of the firmware.
##
##
##
##
##################################################

sub check_inventory_file_exists
{
open(FILE_1, "$INVENTORY_FILE");

	if($line_1=<FILE_1>) {
		system("cp $INVENTORY_FILE $INVENTORY_FILE_ORIG");
system("/opt/SUNWstade/bin/inventory -f /var/opt/SUNWstade/DATA/inventory.xml");
		&change_inventory_file;
	} else {
		$inventory_exists=0;
system("/opt/SUNWstade/bin/inventory -f /var/opt/SUNWstade/DATA/inventory.xml");
		&change_inventory_file;
	}
}
##################################################
##
##
##    Change the inventory xml file to 
##    show downlevel versions of the firmware 
##
##   
##
##
##################################################           


sub change_inventory_file
{
system("cp $INVENTORY_FILE $INVENTORY_FILE_ORIG");

open(ERR, ">>$ERROR_FILE") || die "Couldn't open file : $ERROR_FILE";
open(OUT, ">>$INVENTORY_FILE_NEW") || die "Couldn't open file : $INVENTORY_FILE_
NEW";
open(FILE_1, "$INVENTORY_FILE") || die "Couldn't open file : $INVENTORY_FILE";

while($line_1=<FILE_1>) {

        chop $line_1;
        {
        $search_ctrl = "030104";
        $search_loop = "loopVersion>";
        if ($line_1 =~ /\b$search_ctrl\b/ )
                {
                $line_1 =~ s/030104/030103/;
                print OUT "$line_1\n";
                }
        elsif ($line_1 =~ /\b$search_loop\b/ )
                {
                $line_1 =~ s/loopVersion>\d.\d\d</loopVersion>6.27</;
                print OUT "$line_1\n";
                }
        else { print OUT "$line_1\n";}
                        }
}
close(OUT);
close(FILE_1);
        system("mv $INVENTORY_FILE_NEW $INVENTORY_FILE");
}
