#!/bin/sh

# PROPRIETARY AND CONFIDENTIAL
#
# Copyright  2004 Sun Microsystems, Inc. All rights reserved.
#
# Use of this product is subject to license terms. Federal Acquisitions:
# Commercial Software Government Users Subject to Standard License Terms
# and Conditions. Sun, Sun Microsystems, the Sun logo, iPlanet, and
# Sun Java System  are trademarks or registered trademarks of Sun Microsystems, Inc.
# in the United States and other countries.
#

################################/etc/init.d/sunwics5########################
#
# This script starts and stops Sun Java System Calendar Server at boot time.
#
############################################################################

if [ ! -d /usr/bin ]
then      # /usr not mounted
  exit 1
fi

# default return value
rval=0

# Save the current directory
savedCurDir=`pwd`

# First find out on which OS we are
os=`uname`

if [ "$os" = "SunOS" ] 
then
  BASEDIR=`/bin/pkgparam SUNWics5 BASEDIR`
else
  if [ "$os" = "Linux" ] 
  then
    BASEDIR=`/bin/rpm -query --queryformat %{INSTALLPREFIX} sun-calendar-core`
  else
    echo "$0 ERROR: Sun Java System Calendar Server: OS not supported by the startup script"
  fi
fi

if [ -z "$BASEDIR" ] 
then
  echo "$0 ERROR: Sun Java System Calandar Server: Unable to find an instance of the Calendar Server"
  exit 1
fi

# Build the ServerRoot based on the BASEDIR value
ServerRoot="$BASEDIR"

if [ "$os" = "SunOS" ] 
then
  ServerRoot="$BASEDIR/SUNWics5"
fi

if [ ! -d ${ServerRoot} ] ; then
  cat > /dev/console 2>&1 << EOF_FINDSERVERROOT

$0 ERROR: Sun Java System Calendar Server: Unable to find install directory "${ServerRoot}" read from " ${ServerRootFile}"

Sun Java System Calendar Server may not be installed properly or has been corrupted.

EOF_FINDSERVERROOT
  exit 1
fi

# define start/stop programs and commands (program is executable to run, commands are program with necessary arguments)
if [ "$os" = "Linux" ]
then
  csStartDir=${ServerRoot}/calendar/sbin
  csStopDir=${ServerRoot}/calendar/sbin
else
  csStartDir=${ServerRoot}/cal/sbin
  csStopDir=${ServerRoot}/cal/sbin
fi
csStartPgm=start-cal
csStartCmd=${csStartDir}/${csStartPgm}
csStopPgm=stop-cal
csStopCmd=${csStopDir}/${csStopPgm}

if [ ! -f ${csStartCmd} ] ; then
  cat > /dev/console 2>&1 << EOF_FINDCSSTART

$0 ERROR: Sun Java System Calendar Server: Unable to find product startup component "${csStartPgm}"
EOF_FINDCSSTART
  exit 1
fi

if [ ! -f ${csStopCmd} ] ; then
  cat > /dev/console 2>&1 << EOF_FINDCSSTOP
$0 ERROR: Sun Java System Calendar Server: Unable to find product shutdown component "${csStopPgm}"
EOF_FINDCSSTOP
  exit 1
fi

#
# Start/stop Sun Java System Calendar Server
#

case "$1" in
'start')
  if [ -x ${csStartCmd} ]
  then
    echo "Starting Sun Java System Calendar Server" > /dev/console 2>&1
    cd ${csStartDir} 
    ${csStartCmd} > /dev/console 2>&1
  else
    echo "$0 ERROR: Sun Java System Calendar Server Startup Program ${csStartCmd} is not executable" > /dev/console 2>&1
    exit 1
  fi
  ;;

'stop')
  if [ -x ${csStopCmd} ]
  then
    echo "Stopping Sun Java System Calendar Server" > /dev/console 2>&1
    cd ${csStopDir}
    ${csStopCmd} > /dev/console 2>&1
  else
    echo "$0 ERROR: Sun Java System Calendar Server Shutdown Program ${csStopCmd} is not executable" > /dev/console 2>&1
    exit 1
  fi
  ;;

*)
  echo " $0 start      (start Sun Java System Calendar Server)"
  echo " $0 stop       (stop Sun Java System Calendar Server)"
  rval=1
  ;;

esac

exit $rval
