<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Untitled
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Sunday</xsl:if>
  <xsl:if test=".='2'">Monday</xsl:if>
  <xsl:if test=".='3'">Tuesday</xsl:if>
  <xsl:if test=".='4'">Wednesday</xsl:if>
  <xsl:if test=".='5'">Thursday</xsl:if>
  <xsl:if test=".='6'">Friday</xsl:if>
  <xsl:if test=".='7'">Saturday</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">S</xsl:if>
  <xsl:if test="$downum='2'">M</xsl:if>
  <xsl:if test="$downum='3'">T</xsl:if>
  <xsl:if test="$downum='4'">W</xsl:if>
  <xsl:if test="$downum='5'">T</xsl:if>
  <xsl:if test="$downum='6'">F</xsl:if>
  <xsl:if test="$downum='7'">S</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">Jan</xsl:if>
  <xsl:if test=".='02'">Feb</xsl:if>
  <xsl:if test=".='03'">March</xsl:if>
  <xsl:if test=".='04'">April</xsl:if>
  <xsl:if test=".='05'">May</xsl:if>
  <xsl:if test=".='06'">June</xsl:if>
  <xsl:if test=".='07'">July</xsl:if>
  <xsl:if test=".='08'">Aug</xsl:if>
  <xsl:if test=".='09'">Sep</xsl:if>
  <xsl:if test=".='10'">Oct</xsl:if>
  <xsl:if test=".='11'">Nov</xsl:if>
  <xsl:if test=".='12'">Dec</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Jan</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Feb</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Mar</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Apr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">May</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Jun</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Jul</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Aug</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Sep</xsl:if>
  <xsl:if test="$MonthNum=10">Oct</xsl:if>
  <xsl:if test="$MonthNum=11">Nov</xsl:if>
  <xsl:if test="$MonthNum=12">Dec</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">January</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">February</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">March</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">April</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">May</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">June</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">July</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">August</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">September</xsl:if>
  <xsl:if test="$MonthNum=10">October</xsl:if>
  <xsl:if test="$MonthNum=11">November</xsl:if>
  <xsl:if test="$MonthNum=12">December</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      The date and time you entered is invalid. Please correct it.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      A calendar already exists with this name. Please choose another name.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      A group already exists with this name. Please choose another name.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> to </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      There was a problem with the directory server with this search.&nbsp;
      Please provide another search string.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      Too many results match this search.&nbsp;
      Please provide a more detailed search string.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      Too many results match this search.&nbsp;
      Please provide a more detailed search string.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      Too many results match this search.&nbsp;
      Please provide a more detailed search string.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      A connection to the directory server could not be established.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      A connection to the directory server could not be established.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      There was a problem with the directory server with this search.&nbsp;
      Please provide another search string.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE Error: event was deleted
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE Error: unsupported implementation
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE Error: malloc failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE Error: cannot create multiple instance of GSE
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE Error: GSE entry is invalid
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE Error: event is invalid
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE Error: cannot find transport interface
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE Error: cannot find attendee in organizer calendar
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE Error: cannot create resource such as lock, GDisp, ...etc
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE Error: expect iCS user, instead get SMTP user
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE Error: invalid component method and state
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE Error: request time conflict with another existing meeting request
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB Error: component not found
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB Error: IO error
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB Error: one or more values of the event are invalid
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB Error: function call does not operate on the supplied component
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB Error: requested query is unknown or unsupported
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB Error: a required parameter is NULL, not set, or not present
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB Error: write was aborted because the requested SequenceNo condition check failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB Error: write was aborted because the requested modified time condition check failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB Error: write was aborted because the calendar does not allow overlapping appointments
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB Error: ENS notification returned an error
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB Error: a required value is null
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '1'">
      Invitee Error: bad argument
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Invitee Error: calendar not found
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Invitee Error: calendar is disabled
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Invitee Error: user is not allowed to access the calendar
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Invitee Error: Group was clipped
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Invitee Error: Cannot remove organizer
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Calendar Error: calendar creation failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Calendar Error: existing calendar with same identifier
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Calendar Error: User does not have the access privilege needed
      to perform this operation.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Calendar Error: User trying to access calendar that does not exist.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Calendar Error: illegal calendar identifier
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Invitee Error: Cannot double book to invitee.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Calendar Error: User does not have the access privilege needed
      to perform this operation.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Calendar Error: User must be an owner or co-owner
      to perform this operation.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '140'">
      Please see availability tab to find free time.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Group Error: illegal group identifier
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Calendar Error: Cannot add unknown user to privacy or owner list.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP Error: no mail host
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP Error: connect failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP Error: expect response to connect did not happen
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP Error: problem addressing message
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP Error: no recipient
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Error: Connection to Backend Database Failed.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Error: Maximum Connections to Backend Database Reached.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Error: Unable to resolve Calendar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Error: Bad Data Backend Database Unreachable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Error: DWP Host Context Unavailable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Error: Backend Host Unresolvable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Error: No Data - Backend Database Unreachable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Error: Connection to Backend Database Failed.
    </xsl:when>
    <xsl:otherwise>
      Unknown error #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Error: One instance of recurrence cannot skip over another.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Error: Two instances of recurrence cannot occur on the same day.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Error: Cannot change privacy of only one instance.
    </xsl:when>
    <xsl:otherwise>
      Unknown recurrence error #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">America/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">America/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">America/Los_Angeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">America/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">America/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">America/Costa_Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">America/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">America/Indianapolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">America/New_York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">America/Havana</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">America/Port-au-Prince</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">America/Grand_Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">America/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">America/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">America/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">America/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlantic/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">America/St_Johns</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">America/Buenos_Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">America/Sao_Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">America/Miquelon</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">America/Godthab</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlantic/South_Georgia</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlantic/Cape_Verde</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlantic/Azores</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">Africa/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europe/London</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">Africa/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europe/Paris</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">Africa/Tripoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europe/Warsaw</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">Africa/Johannesburg</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europe/Bucharest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europe/Istanbul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">Africa/Cairo</xsl:when> 
     <xsl:when test="$tzid='Africa/Amman'">Africa/Amman</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europe/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">Africa/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europe/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europe/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europe/Moscow</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europe/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asia/Beirut</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asia/Jerusalem</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asia/Riyadh</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asia/Tehran</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asia/Yerevan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asia/Aqtau</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asia/Baku</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asia/Kabul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asia/Karachi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asia/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asia/Bishkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asia/Yekaterinburg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asia/Calcutta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asia/Katmandu</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asia/Dacca</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asia/Alma-Ata</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asia/Novosibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asia/Rangoon</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asia/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asia/Krasnoyarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asia/Ulan_Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asia/Shanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asia/Taipei</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asia/Irkutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asia/Tokyo</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asia/Seoul</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asia/Yakutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australia/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australia/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australia/Adelaide</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australia/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australia/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australia/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asia/Vladivostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australia/Lord_Howe</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pacific/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pacific/Noumea</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asia/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pacific/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pacific/Fiji</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pacific/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asia/Kamchatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pacific/Chatham</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pacific/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anandyr'">Asia/Anandyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pacific/Kiritimati</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pacific/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pacific/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pacific/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pacific/Marquesas</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pacific/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pacific/Pitcairn</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pacific/Easter</xsl:when> 
    <xsl:otherwise>
      Unknown time zone #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">OK</xsl:variable>

<xsl:variable name="cancel_title">Cancel</xsl:variable>
<xsl:variable name="close_title">Close</xsl:variable>
<xsl:variable name="help_title">Help</xsl:variable>
<xsl:variable name="apply_title">Apply</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">No events or tasks</xsl:variable>
<xsl:variable name="week_ahead_title">The Week Ahead</xsl:variable>
<xsl:variable name="alt_text_schedule">Schedule a new appointment</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">Enter a user's name below; then click the OK button.</xsl:variable>

<xsl:variable name="user_name_title">User Name</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">Jump to the previous day</xsl:variable>

<xsl:variable name="alt_jump_next_day">Jump to the next day</xsl:variable>

<xsl:variable name="alt_jump_new_date">Jump to a new date</xsl:variable>

<xsl:variable name="available_title">Available</xsl:variable>

<xsl:variable name="busy_title">Busy</xsl:variable>

<xsl:variable name="hour_text">hour</xsl:variable>
<xsl:variable name="minutes_text">minutes</xsl:variable>

<xsl:variable name="show_availability_title">Show Availability</xsl:variable>

<xsl:variable name="error_cal_privacy">The privacy on this calendar does not allow you to view it, or this calendar does not exist.</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">North/South America</xsl:variable>

<xsl:variable name="europe_africa_title">Europe/Africa</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">Asia/Pacific Rim</xsl:variable>

<xsl:variable name="time_zone_title">Time Zone</xsl:variable>

<xsl:variable name="gmt_offset_title">GMT Offset</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">Groups</xsl:variable>

<xsl:variable name="groups_msg">Use a calendar group to see multiple calendars at one time. To view a calendar group, click the group name link. To add or remove calendars from a group, click the Edit link.</xsl:variable>

<xsl:variable name="select_title">Select</xsl:variable>

<xsl:variable name="group_title">Group</xsl:variable>

<xsl:variable name="group_colon_title">Group:</xsl:variable>

<xsl:variable name="description_title">Description</xsl:variable>

<xsl:variable name="properties_title">Properties</xsl:variable>

<xsl:variable name="error_cal_access">You do not have permission to access this calendar.</xsl:variable>

<xsl:variable name="error_cal_not_exist">This calendar does not exist.</xsl:variable>

<xsl:variable name="edit_title">Edit</xsl:variable>
<xsl:variable name="edit_calendar_title">Edit Calendar</xsl:variable>

<xsl:variable name="remove_selected_title">Remove Selected</xsl:variable>

<xsl:variable name="calendars_title">Calendars</xsl:variable>

<xsl:variable name="calendars_msg">List of calendars you own or have subscribed to. To view a calendar, click the calendar name. To edit a calendar, click Edit.</xsl:variable>

<xsl:variable name="calendar_title">Calendar</xsl:variable>

<xsl:variable name="view_title">View</xsl:variable>
<xsl:variable name="view_calendar_title">View Calendar</xsl:variable>

<xsl:variable name="view_colon_title">View:</xsl:variable>

<xsl:variable name="options_title">Options</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">Change Default Time Zone: Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">overview</xsl:variable>

<xsl:variable name="day_tab_title">day</xsl:variable>

<xsl:variable name="week_tab_title">week</xsl:variable>

<xsl:variable name="month_tab_title">month</xsl:variable>

<xsl:variable name="year_tab_title">year</xsl:variable>

<xsl:variable name="comparison_tab_title">comparison</xsl:variable>

<xsl:variable name="repeat_title">Repeat</xsl:variable>

<xsl:variable name="change_repeat_title">Change repeat pattern</xsl:variable>

<xsl:variable name="alt_jump_prev_month">Jump to the previous month</xsl:variable>

<xsl:variable name="alt_jump_next_month">Jump to the next month</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">Today is: </xsl:variable>

<xsl:variable name="alt_jump_this_date">Jump to this date</xsl:variable>

<xsl:variable name="action_items_title">Action Items</xsl:variable>

<xsl:variable name="invitations_title">Invitations</xsl:variable>

<xsl:variable name="no_invitations_msg">No Invitations</xsl:variable>

<xsl:variable name="tasks_title">Tasks</xsl:variable>

<xsl:variable name="overdue_msg">overdue</xsl:variable>

<xsl:variable name="no_tasks_msg">No Tasks</xsl:variable>

<xsl:variable name="errors_title">Errors</xsl:variable>

<xsl:variable name="no_errors_msg">No Errors</xsl:variable>

<xsl:variable name="daily_title">Daily</xsl:variable>

<xsl:variable name="weekly_title">Weekly</xsl:variable>

<xsl:variable name="monthly_title">Monthly</xsl:variable>

<xsl:variable name="yearly_title">Yearly</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">Repeating Selection: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">This one only</xsl:variable>

<xsl:variable name="this_and_future_title">This and future ones</xsl:variable>

<xsl:variable name="all_instances_title">All instances</xsl:variable>

<xsl:variable name="repeating_selection_title">Repeating Selection</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">Due Today</xsl:variable>

<xsl:variable name="other_tasks_title">Other Tasks</xsl:variable>

<xsl:variable name="overdue_tasks_title">Overdue Tasks</xsl:variable>

<xsl:variable name="all_day_events_title">All-Day Events</xsl:variable>

<xsl:variable name="conflict_msg">conflict</xsl:variable>

<xsl:variable name="overdue_title">Overdue</xsl:variable>

<xsl:variable name="due_at_title">Due at</xsl:variable>

<xsl:variable name="untitled_task_title">Untitled Task</xsl:variable>

<xsl:variable name="alt_view_this_task">View This Task</xsl:variable>

<xsl:variable name="alt_delete_this_task">Delete This Task</xsl:variable>

<xsl:variable name="untitled_event_title">Untitled Event</xsl:variable>

<xsl:variable name="alt_delete_this_event">Delete This Event</xsl:variable>

<xsl:variable name="alt_view_this_event">View This Event</xsl:variable>

<xsl:variable name="all_day_title">All Day</xsl:variable>

<xsl:variable name="overdue_from_title">Overdue from</xsl:variable>

<xsl:variable name="from_txt">from</xsl:variable>

<xsl:variable name="due_on_title">Due on</xsl:variable>

<xsl:variable name="not_due_title">Not due</xsl:variable>

<xsl:variable name="due_title">Due</xsl:variable>

<xsl:variable name="on_txt">on</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">am</xsl:variable>

<xsl:variable name="pm_txt">pm</xsl:variable>

<xsl:variable name="midnight_title">Midnight</xsl:variable>

<xsl:variable name="noon_title">Noon</xsl:variable>

<xsl:variable name="from_title">From</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">Schedule a new appointment</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">Errors List: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">This panel shows you a list of outstanding scheduling errors.</xsl:variable>

<xsl:variable name="organizer_title">Organizer</xsl:variable>

<xsl:variable name="attendee_title">Attendee</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">No outstanding errors</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">Recurrence: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">Recurrence</xsl:variable>

<xsl:variable name="start_title">Start</xsl:variable>

<xsl:variable name="end_title">End</xsl:variable>

<xsl:variable name="create_title">Create</xsl:variable>

<xsl:variable name="events_text">events</xsl:variable>

<xsl:variable name="alert_provide_valid_count">Please provide a valid count</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">Please provide a number that is less than or equal to</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">Reminder for this event is set to a time after the start of the event. Hit cancel to go back and change the time.</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">Reminder for this task is set to a time after the task due time. Hit cancel to go back and change the time.</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">Compose</xsl:variable>

<xsl:variable name="reminders_title">Reminders</xsl:variable>

<xsl:variable name="availability_title">Availability</xsl:variable>

<xsl:variable name="preview_title">Preview</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">Invitations List: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">Delete</xsl:variable>

<xsl:variable name="recurring_event_msg">Recurring Event</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">No outstanding invitations</xsl:variable>

<xsl:variable name="all_title">All</xsl:variable>

<xsl:variable name="delete_all_title">Delete All</xsl:variable>

<xsl:variable name="save_and_close_title">Save and Close</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">You have selected a blank choice</xsl:variable>

<xsl:variable name="alert_min_year">You cannot view a year prior to 1970</xsl:variable>
<xsl:variable name="alert_max_year">You cannot view a year after 2036</xsl:variable>

<xsl:variable name="alert_invalid_date">This is an invalid date. Please correct it.</xsl:variable>

<xsl:variable name="january_title">January</xsl:variable>
<xsl:variable name="february_title">February</xsl:variable>
<xsl:variable name="march_title">March</xsl:variable>
<xsl:variable name="april_title">April</xsl:variable>
<xsl:variable name="may_title">May</xsl:variable>
<xsl:variable name="june_title">June</xsl:variable>
<xsl:variable name="july_title">July</xsl:variable>
<xsl:variable name="august_title">August</xsl:variable>
<xsl:variable name="september_title">September</xsl:variable>
<xsl:variable name="october_title">October </xsl:variable>
<xsl:variable name="november_title">November</xsl:variable>
<xsl:variable name="december_title">December</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">Please provide a valid date for</xsl:variable>

<xsl:variable name="provide_good_date_msg">Please provide a valid date</xsl:variable>

<xsl:variable name="provide_good_month_msg">Please provide a month between 1 and 12</xsl:variable>

<xsl:variable name="provide_good_year_msg">Please provide a valid year.\n\nIf you use two digits to represent a year, values less than 37\nwill be interpreted as if they are in the 21st century.\n\nFor example: 03 is equivalent to 2003</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">Please provide a year that is greater than 1970</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">Please provide a year that is less than 2037</xsl:variable>

<xsl:variable name="provide_good_hour_msg">Please provide an hour value that is valid. (1-12) in 12hr mode or (0-23) for 24hr mode</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">Please provide an hour value that is valid (0-23)</xsl:variable>

<xsl:variable name="provide_good_minute_msg">Please provide a minute value between 0 and 59</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">Choose an until date after the start date</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">Date entered does not exist.\nSetting calendar to nearest valid date in</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">Jump To Date: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">Jump to the previous year</xsl:variable>

<xsl:variable name="alt_jump_next_year">Jump to the next year</xsl:variable>

<xsl:variable name="jump_to_date_title">Jump To Date</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">Are you sure you want to delete this privacy entry?</xsl:variable>

<xsl:variable name="edit_calendar_page_title">Edit Calendar: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">Indicates required information.</xsl:variable>

<xsl:variable name="calendar_name_msg">Provide a short name for the calendar such as "baseball" (spaces aren't allowed).</xsl:variable>

<xsl:variable name="display_name_title">Display Name</xsl:variable>

<xsl:variable name="display_name_msg">This is an optional field to remind you of the purpose of this calendar, such as "Billy's Baseball Schedule."</xsl:variable>

<xsl:variable name="include_in_availability_msg">Include this calendar when calculating your availability</xsl:variable>

<xsl:variable name="calendar_address_title">Calendar Address</xsl:variable>

<xsl:variable name="calendar_address_msg">You can give others access to this calendar by giving them the link here. They can then use it in their browsers to view this calendar, provided that access control is set to give them access.</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">Permissions for calendar:</xsl:variable>

<xsl:variable name="cal_permissions_msg">Permissions determine how others can see and change this calendar. To give certain permissions to all users, select the appropriate permissions from the columns next to Everybody. To give certain permissions to individuals, enter their user ID in the User field and click "Add User". Then select the appropriate permissions from the columns next to the user's name.</xsl:variable>

<xsl:variable name="user_title">User</xsl:variable>
<xsl:variable name="user_title_with_colon">User:</xsl:variable>

<xsl:variable name="permissions_title">Permissions</xsl:variable>

<xsl:variable name="invite_title">Invite</xsl:variable>

<xsl:variable name="read_title">Read</xsl:variable>

<xsl:variable name="modify_title">Modify</xsl:variable>

<xsl:variable name="delete_selected_user_title">Delete Selected User</xsl:variable>

<xsl:variable name="add_user_title">Add User</xsl:variable>

<xsl:variable name="everybody_title">Everybody</xsl:variable>

<xsl:variable name="this_domain_title">This Domain</xsl:variable>

<xsl:variable name="tip_cal_owners">Tip for assigning owners to calendar:</xsl:variable>

<xsl:variable name="cal_owner_msg">You may add one or more owners for this calendar. An owner has the ability to act on your behalf to reply to invitations, and to create, modify, and delete events.</xsl:variable>

<xsl:variable name="no_owners_msg">There are no owners.</xsl:variable>

<xsl:variable name="delete_owner_title">Delete Owner</xsl:variable>

<xsl:variable name="add_owner_title">Add Owner</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">Are you sure you want to delete this calendar</xsl:variable>

<xsl:variable name="alert_supply_cal_name">You must supply a calendar name</xsl:variable>

<xsl:variable name="owners_title">Owners</xsl:variable>

<xsl:variable name="time_zones_title">Time Zones</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">Are you sure you want to delete this event?</xsl:variable>

<xsl:variable name="edit_event_page_title">Edit Event: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---Quick Invite---</xsl:variable>

<xsl:variable name="event_title_title">Event Title</xsl:variable>

<xsl:variable name="date_title">Date</xsl:variable>

<xsl:variable name="time_title">Time</xsl:variable>

<xsl:variable name="all_day_msg">All Day (For example, vacation or birthday)</xsl:variable>

<xsl:variable name="privacy_title">Privacy</xsl:variable>

<xsl:variable name="public_event_title">Public Event</xsl:variable>

<xsl:variable name="confidential_event_title">Time and Date Only</xsl:variable>

<xsl:variable name="private_event_title">Private Event</xsl:variable>

<xsl:variable name="location_title">Location</xsl:variable>

<xsl:variable name="invite_others_msg">Invite other users or resources:</xsl:variable>

<xsl:variable name="search_title">Search...</xsl:variable>

<xsl:variable name="inform_title">Inform</xsl:variable>

<xsl:variable name="invite_instructions_msg">(Enter userid, calendar id or email address. If you don't know the name click Search.)</xsl:variable>

<xsl:variable name="invitees_title">Invitees</xsl:variable>

<xsl:variable name="no_invitees_msg">No Invitees</xsl:variable>

<xsl:variable name="remove_title">Remove</xsl:variable>

<xsl:variable name="inform_event_title">Inform about Event</xsl:variable>

<xsl:variable name="no_informees_msg">No Informees</xsl:variable>

<xsl:variable name="event_reminders_msg">You may send yourself an email reminder for this event. Enter one or more of your email addresses below. Separate each email address using a comma (,) or semicolon (;).</xsl:variable>

<xsl:variable name="remind_title">Remind</xsl:variable>

<xsl:variable name="alert_provide_valid_time">Please provide a valid time</xsl:variable>

<xsl:variable name="hours_text">hours</xsl:variable>

<xsl:variable name="days_text">days</xsl:variable>

<xsl:variable name="before_the_event_begins_text">before the event begins</xsl:variable>

<xsl:variable name="at_text">at</xsl:variable>

<xsl:variable name="text_reminder_msg">You can send a text message with the email reminder.</xsl:variable>

<xsl:variable name="message_title">Message</xsl:variable>

<xsl:variable name="title_title">Title</xsl:variable>

<xsl:variable name="attendees_title">Attendees</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">OK to delete?</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">Edit Calendar Group: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---Quick Add---</xsl:variable>

<xsl:variable name="delete_calendar_text">Are you sure you want to remove this calendar?</xsl:variable>

<xsl:variable name="group_name_title">Group Name</xsl:variable>

<xsl:variable name="group_view_msg">Open group in Day View (By default, group opens in Comparison View.)</xsl:variable>

<xsl:variable name="calendar_id_title">Calendar ID</xsl:variable>

<xsl:variable name="add_title">Add</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(Enter calendar id. If you don't know the id, click Search.)</xsl:variable>

<xsl:variable name="group_members_title">Group Members</xsl:variable>

<xsl:variable name="group_description_msg">Provide a description of your group here. You can also decide whether the day view of this group will display each of the calendars separately</xsl:variable>

<xsl:variable name="day_view_title">Day View</xsl:variable>

<xsl:variable name="day_view_merge_msg">By default, calendars in the day view appear unmerged.</xsl:variable>

<xsl:variable name="alert_group_name">You must supply a name for the group</xsl:variable>

<xsl:variable name="calendar_group_title">Calendar Group</xsl:variable>

<xsl:variable name="details_title">Details</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">Are you sure you want to delete this task?</xsl:variable>

<xsl:variable name="edit_task_page_title">Edit Task: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">Compose Task</xsl:variable>

<xsl:variable name="task_title_title">Task Title</xsl:variable>

<xsl:variable name="due_date_title">Due Date</xsl:variable>

<xsl:variable name="no_time_title">No Time</xsl:variable>

<xsl:variable name="public_task_title">Public Task</xsl:variable>

<xsl:variable name="confidential_task_title">Time and Date Only</xsl:variable>

<xsl:variable name="private_task_title">Private Task</xsl:variable>

<xsl:variable name="status_title">Status</xsl:variable>

<xsl:variable name="complete_title">Complete</xsl:variable>

<xsl:variable name="task_reminder_msg">You may send yourself an email reminder for this task. Enter one or more of your email addresses below. Separate each email address using a comma (,) or semicolon (;).</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">You cannot set an alarm on a task that is not due</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">before the task is due</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">Appearance</xsl:variable>

<xsl:variable name="settings_title">Settings</xsl:variable>

<xsl:variable name="import_title">Import</xsl:variable>

<xsl:variable name="export_title">Export</xsl:variable>

<xsl:variable name="settings_msg">Use this form to modify the behavior of Calendar Express.</xsl:variable>

<xsl:variable name="default_view_title">Default Initial View</xsl:variable>

<xsl:variable name="default_view_msg">Always display the following view after logging in:</xsl:variable>

<xsl:variable name="default_group_title">Default Calendar Group</xsl:variable>

<xsl:variable name="default_group_msg">Always display the following calendar group after logging in:</xsl:variable>

<xsl:variable name="no_cal_group_title">No Calendar Group</xsl:variable>

<xsl:variable name="date_format_msg">Show brief dates in the following order:</xsl:variable>

<xsl:variable name="m_d_y_format_text">Month, Date, Year</xsl:variable>

<xsl:variable name="d_m_y_format_text">Date, Month, Year</xsl:variable>

<xsl:variable name="y_m_d_format_text">Year, Month, Date</xsl:variable>

<xsl:variable name="date_delimiter_msg">Use the following character to delimit brief dates:</xsl:variable>

<xsl:variable name="use_12_clock_msg">Use 12 hour clock</xsl:variable>

<xsl:variable name="use_24_clock_msg">Use 24 hour clock</xsl:variable>

<xsl:variable name="day_title">Day</xsl:variable>

<xsl:variable name="day_starts_msg">Day starts at:</xsl:variable>

<xsl:variable name="day_ends_msg">Day ends at:</xsl:variable>

<xsl:variable name="day_interval_msg">Split days</xsl:variable>

<xsl:variable name="every_15_minutes_text">every fifteen minutes</xsl:variable>

<xsl:variable name="every_half_hour_text">every half hour</xsl:variable>

<xsl:variable name="every_hour_text">every hour</xsl:variable>

<xsl:variable name="every_2_hours_text">every two hours</xsl:variable>

<xsl:variable name="every_four_hours_text">every four hours</xsl:variable>

<xsl:variable name="first_dow_title">First Day of the Week</xsl:variable>

<xsl:variable name="sunday_title">Sunday</xsl:variable>

<xsl:variable name="monday_title">Monday</xsl:variable>

<xsl:variable name="tuesday_title">Tuesday</xsl:variable>

<xsl:variable name="wednesday_title">Wednesday</xsl:variable>

<xsl:variable name="thursday_title">Thursday</xsl:variable>

<xsl:variable name="friday_title">Friday</xsl:variable>

<xsl:variable name="saturday_title">Saturday</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">Exclude Saturday and Sunday from week and month views</xsl:variable>

<xsl:variable name="default_tz_msg">By default, display dates and times using the following time zone:</xsl:variable>

<xsl:variable name="none_selected_title">None Selected</xsl:variable>

<xsl:variable name="single_tz_use_msg">When displaying a single calendar use its time zone</xsl:variable>

<xsl:variable name="tz_timescales_msg">Show time scale for each displayed calendar time zone</xsl:variable>

<xsl:variable name="event_task_reminders_title">Event &amp; Task Reminders</xsl:variable>

<xsl:variable name="email_reminder_msg">Email me a reminder</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">Please provide a valid time interval for reminders</xsl:variable>

<xsl:variable name="before_every_event_task_text">before every event and task</xsl:variable>

<xsl:variable name="note_title">Note:</xsl:variable>

<xsl:variable name="reminders_tip_msg">If you want reminders sent to multiple email addresses (for example, abc@company22.com, abc@sesta.com), separate email addresses with a comma(,) or semicolon(;).</xsl:variable>

<xsl:variable name="event_notifications_title">Event Notifications</xsl:variable>

<xsl:variable name="event_notifications_msg">Email me a notification whenever someone schedules an event on my calendar</xsl:variable>

<xsl:variable name="only_one_email_msg">Only one email address is allowed.</xsl:variable>

<xsl:variable name="alert_only_one_email">Please provide only one address for event notification</xsl:variable>

<xsl:variable name="declined_events_delete_title">Declined events</xsl:variable>

<xsl:variable name="declined_events_delete_msg">Do not show declined events</xsl:variable>

<xsl:variable name="appearance_msg">Use this form to modify the look of Calendar Express.</xsl:variable>

<xsl:variable name="color_scheme_title">Color Scheme</xsl:variable>

<xsl:variable name="toolbar_title">Toolbar</xsl:variable>

<xsl:variable name="icons_and_text_msg">Show icons and text</xsl:variable>

<xsl:variable name="icons_only_msg">Show icons only</xsl:variable>

<xsl:variable name="text_only_msg">Show text only</xsl:variable>

<xsl:variable name="display_font_title">Display Font</xsl:variable>

<xsl:variable name="face_title">Face</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">Size</xsl:variable>

<xsl:variable name="larger_title">Larger</xsl:variable>

<xsl:variable name="default_title">Default</xsl:variable>

<xsl:variable name="smaller_title">Smaller</xsl:variable>

<xsl:variable name="event_destination_title">Event Destination</xsl:variable>

<xsl:variable name="session_expired_msg">Your session has expired</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">You must specify a valid calendar</xsl:variable>

<xsl:variable name="add_events_to_text">Add events to</xsl:variable>

<xsl:variable name="select_calendar_title">Select Calendar:</xsl:variable>

<xsl:variable name="import_format_title">Import Format</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Outlook format</xsl:variable>

<xsl:variable name="source_file_invalid_error">The specified source file was invalid</xsl:variable>

<xsl:variable name="format_file_mismatch_error">The specified format doesn't match source file</xsl:variable>

<xsl:variable name="successful_import_msg">File imported successfully</xsl:variable>

<xsl:variable name="source_file_title">Source File</xsl:variable>

<xsl:variable name="date_range_title">Date Range</xsl:variable>

<xsl:variable name="import_all_msg">Import all events from file</xsl:variable>

<xsl:variable name="invalid_date_range_error">The date range you specified was invalid</xsl:variable>

<xsl:variable name="beginning_title">Beginning</xsl:variable>

<xsl:variable name="ending_title">Ending</xsl:variable>

<xsl:variable name="calendars_to_export_title">Calendars To Export</xsl:variable>

<xsl:variable name="addarrow_title">Add >></xsl:variable>

<xsl:variable name="export_all_msg">Export all events</xsl:variable>

<xsl:variable name="export_format_title">Export Format</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">The Day end time should be later than the Day start time</xsl:variable>

<xsl:variable name="save_changes_title">Save Changes</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">Current Calendar:</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">Repeat Pattern</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">Invalid repeat pattern: select a day to repeat on</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">Repeat pattern cannot be changed for a single instance</xsl:variable>

<xsl:variable name="recurrence_skips_title">One instance of a recurring event cannot skip over another</xsl:variable>

<xsl:variable name="recurrence_same_day">Two instances of a recurring event cannot occur on the same day</xsl:variable>

<xsl:variable name="recurrence_privacy">Cannot change privacy of only one instance</xsl:variable>

<xsl:variable name="every_day_title">Every day</xsl:variable>

<xsl:variable name="every_weekday_title">Every weekday</xsl:variable>

<xsl:variable name="every_title">Every</xsl:variable>

<xsl:variable name="weekday_text">weekday</xsl:variable>

<xsl:variable name="weekendday_text">weekend day</xsl:variable>

<xsl:variable name="m_w_f_text">Monday, Wednesday and Friday</xsl:variable>

<xsl:variable name="t_th_text">Tuesday and Thursday</xsl:variable>

<xsl:variable name="sat_sun_text">Saturday and Sunday</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">Please provide a valid interval</xsl:variable>

<xsl:variable name="every_week_title">Every week</xsl:variable>

<xsl:variable name="weeks_text">weeks</xsl:variable>

<xsl:variable name="repeat_on_title">Repeat On</xsl:variable>

<xsl:variable name="sunday_abbrev">Sun</xsl:variable>

<xsl:variable name="monday_abbrev">Mon</xsl:variable>

<xsl:variable name="tuesday_abbrev">Tue</xsl:variable>

<xsl:variable name="wednesday_abbrev">Wed</xsl:variable>

<xsl:variable name="thursday_abbrev">Thu</xsl:variable>

<xsl:variable name="friday_abbrev">Fri</xsl:variable>

<xsl:variable name="saturday_abbrev">Sat</xsl:variable>

<xsl:variable name="every_month_title">Every month</xsl:variable>

<xsl:variable name="months_text">months</xsl:variable>

<xsl:variable name="ordinal_1">1st</xsl:variable>
<xsl:variable name="ordinal_2">2nd</xsl:variable>
<xsl:variable name="ordinal_3">3rd</xsl:variable>
<xsl:variable name="ordinal_4">4th</xsl:variable>
<xsl:variable name="ordinal_5">5th</xsl:variable>
<xsl:variable name="ordinal_6">6th</xsl:variable>
<xsl:variable name="ordinal_7">7th</xsl:variable>
<xsl:variable name="ordinal_8">8th</xsl:variable>
<xsl:variable name="ordinal_9">9th</xsl:variable>
<xsl:variable name="ordinal_10">10th</xsl:variable>
<xsl:variable name="ordinal_11">11th</xsl:variable>
<xsl:variable name="ordinal_12">12th</xsl:variable>
<xsl:variable name="ordinal_13">13th</xsl:variable>
<xsl:variable name="ordinal_14">14th</xsl:variable>
<xsl:variable name="ordinal_15">15th</xsl:variable>
<xsl:variable name="ordinal_16">16th</xsl:variable>
<xsl:variable name="ordinal_17">17th</xsl:variable>
<xsl:variable name="ordinal_18">18th</xsl:variable>
<xsl:variable name="ordinal_19">19th</xsl:variable>
<xsl:variable name="ordinal_20">20th</xsl:variable>
<xsl:variable name="ordinal_21">21st</xsl:variable>
<xsl:variable name="ordinal_22">22nd</xsl:variable>
<xsl:variable name="ordinal_23">23rd</xsl:variable>
<xsl:variable name="ordinal_24">24th</xsl:variable>
<xsl:variable name="ordinal_25">25th</xsl:variable>
<xsl:variable name="ordinal_26">26th</xsl:variable>
<xsl:variable name="ordinal_27">27th</xsl:variable>
<xsl:variable name="ordinal_28">28th</xsl:variable>
<xsl:variable name="ordinal_29">29th</xsl:variable>
<xsl:variable name="ordinal_30">30th</xsl:variable>
<xsl:variable name="ordinal_31">31st</xsl:variable>

<xsl:variable name="day_of_month_text">day of the month</xsl:variable>
<xsl:variable name="cap_last_text">Last</xsl:variable>

<xsl:variable name="of_month_text">of the month</xsl:variable>

<xsl:variable name="every_year_text">Every year</xsl:variable>

<xsl:variable name="years_text">years</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">This is a repeating event. Delete this one only, or all events?</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">This is a repeating event. Apply change to this one only, or all events?</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">This is a repeating task. Delete this one only, or all tasks?</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">This is a repeating task. Apply change to this one only, or all tasks?</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">Summary</xsl:variable>

<xsl:variable name="reply_title">Reply</xsl:variable>

<xsl:variable name="will_attend_msg">I will attend</xsl:variable>

<xsl:variable name="will_not_attend_msg">I will NOT attend</xsl:variable>

<xsl:variable name="confirm_later_msg">I will confirm later</xsl:variable>

<xsl:variable name="reply_reminders_msg">Schedule email reminders here by providing email addresses (separated by commas or semi-colons) and choosing a date and time for delivery.</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">You cannot set an alarm for an unconfirmed event before the event begins</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">Use the following space to provide additional information with the reminder. The title, date, time and location of an event are automatically included in all reminders.</xsl:variable>

<xsl:variable name="cal_select_msg">Select the calendar in which to store the event</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">Calendars Search: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">Calendars Search</xsl:variable>

<xsl:variable name="cal_search_msg1">Search for calendars where the calendar</xsl:variable>
        
<xsl:variable name="name_or_id_text">name or ID</xsl:variable>

<xsl:variable name="name_text">name</xsl:variable>

<xsl:variable name="primary_owner_text">primary owner</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">contains</xsl:variable>

<xsl:variable name="begins_with_text">begins with</xsl:variable>

<xsl:variable name="search_plain_title">Search</xsl:variable>

<xsl:variable name="already_selected_cals_title">Already selected calendars</xsl:variable>

<xsl:variable name="cal_id_title">Calendar ID</xsl:variable>

<xsl:variable name="search_results_title">Search Results</xsl:variable>

<xsl:variable name="no_match_found_msg">No Match Found</xsl:variable>

<xsl:variable name="owner_title">Owner</xsl:variable>

<xsl:variable name="owner_name_colon_title">Owner Name:</xsl:variable>

<xsl:variable name="cal_name_title">Calendar Name</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">Search: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">Search for events and tasks that contain</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">User Search: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">User Search</xsl:variable>

<xsl:variable name="search_local_msg">Search local directory</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(Enter first name, last name, or user id)</xsl:variable>

<xsl:variable name="legend_title">Legend:</xsl:variable>

<xsl:variable name="resource_title">Resource;</xsl:variable>

<xsl:variable name="already_selected_users_title">Already selected users</xsl:variable>

<xsl:variable name="name_userid_title">Name (User ID)</xsl:variable>

<xsl:variable name="name_title">Name</xsl:variable>

<xsl:variable name="userid_title">User ID</xsl:variable>

<xsl:variable name="email_title">Email</xsl:variable>

<xsl:variable name="for_text">for</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">Task List: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">Use this panel to keep track of all of your things to do. You can mark tasks completed by clicking the checkboxes in the "Done" column. Click "Save and Close" to commit your changes.</xsl:variable>

<xsl:variable name="done_title">Done</xsl:variable>

<xsl:variable name="task_title">Task</xsl:variable>

<xsl:variable name="select_all_title">Select All</xsl:variable>

<xsl:variable name="alert_processing">Processing</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">tasks</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">help</xsl:variable>

<xsl:variable name="logout_text">logout</xsl:variable>

<xsl:variable name="login_text">login</xsl:variable>

<xsl:variable name="home_text">home</xsl:variable>

<xsl:variable name="alt_schedule_msg">Schedule a meeting, birthday or other event</xsl:variable>

<xsl:variable name="new_event_title">New Event</xsl:variable>

<xsl:variable name="alt_todo_msg">Add an item to your list of things to do</xsl:variable>

<xsl:variable name="new_task_title">New Task</xsl:variable>

<xsl:variable name="jump_to_title">Jump To</xsl:variable>

<xsl:variable name="alt_print_msg">Open a version of the current view suitable for printing</xsl:variable>

<xsl:variable name="printable_title">Printable</xsl:variable>

<xsl:variable name="alt_search_msg">Search events and tasks</xsl:variable>

<xsl:variable name="alt_new_calendar">Create a new calendar</xsl:variable>

<xsl:variable name="new_cal_title">New Cal</xsl:variable>

<xsl:variable name="alt_new_group">Create a new group of calendars</xsl:variable>

<xsl:variable name="new_group_title">New Group</xsl:variable>

<xsl:variable name="alt_search_cals">Search for calendars</xsl:variable>

<xsl:variable name="subscribe_title">Subscribe</xsl:variable>

<xsl:variable name="paren_subscribed_title">(Subscribed)</xsl:variable>

<xsl:variable name="alt_jump_next_week">Jump to the next week</xsl:variable>

<xsl:variable name="alt_jump_prev_week">Jump to the previous week</xsl:variable>

<xsl:variable name="sunday_letter_title">S</xsl:variable>
<xsl:variable name="monday_letter_title">M</xsl:variable>
<xsl:variable name="tuesday_letter_title">T</xsl:variable>
<xsl:variable name="wednesday_letter_title">W</xsl:variable>
<xsl:variable name="thursday_letter_title">T</xsl:variable>
<xsl:variable name="friday_letter_title">F</xsl:variable>
<xsl:variable name="saturday_letter_title">S</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">Selected events will be removed from your calendar.  For recurring events, only instances with errors will be removed.  Click OK to continue.</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">When creating an event while displaying a calendar group, invite all the calendars in the group</xsl:variable>

<xsl:variable name="invite_this_group_msg">When creating an event while displaying this calendar group, invite all the calendars in the group</xsl:variable>

<xsl:variable name="group_invitations_title">Group Invitations</xsl:variable>

<xsl:variable name="starting_at_txt">Starting at</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">unknown</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">No Attendees</xsl:variable>

<xsl:variable name="today_title">Today</xsl:variable>

<xsl:variable name="confirm_event_delete_text">Do you want to delete this event?</xsl:variable>
<xsl:variable name="confirm_task_delete_text">Do you want to delete this task?</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">Connection to Backend Database Failed.</xsl:variable>
<xsl:variable name="dwp_max_connections_error">Maximum Connections to Backend Database Reached.</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">Bad Data Backend Database Unreachable.</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">Unable to resolve Calendar.</xsl:variable>
<xsl:variable name="dwp_down_error">is down</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">DWP Host Context Unavailable.</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">Backend Host Unresolvable.</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">No Data - Backend Database Unreachable.</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">Include this event in calculating availability</xsl:variable>
<xsl:variable name="freebusy_title">Free/Busy</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">You are creating an All Day event that will be used in calculating your availability. If this is incorrect, hit cancel to go back and uncheck the Free/Busy checkbox.</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">You are creating a private event that will be used in calculating your availability. If this is incorrect, hit cancel to go back and uncheck the Free/Busy checkbox.</xsl:variable>

<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">No end date </xsl:variable>
<xsl:variable name="cap_the_text">The </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Remove</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Welcome  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Tasks for </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>'s Calendar (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Start at </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 hour</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> minutes</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>More than 1 hour</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> available)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Creates a maximum of </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> instances</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>One or more time zones from any region can be associated with the current calendar. In gridded views such as the day view, all time zones associated with the calendar become part of the view's time scale. If no time zone is specified with this calendar, then the default time zone will be used. The following time zones are available in the </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>One time zone from any region can be associated with the current calendar. In gridded views such as the day view, the time zone associated with the calendar becomes part of the view's time scale. If no time zone is specified with this calendar, then the default time zone will be used. The following time zones are available in the </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>North/South America </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europe/Africa </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asia/Pacific Rim </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>region:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>The following event has been added to your calendar by "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". You can accept or decline this invitation by selecting the appropriate option for your reply below.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Click</xsl:text>&nbsp;
  <B><xsl:text>Browse...</xsl:text></B>&nbsp;
  <xsl:text>to select a file.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Use this panel to accept </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> or decline </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> or leave undecided </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> invitations to events.</xsl:text>
  <br/>
  <xsl:text>For recurring events, the setting will be applied to the entire sequence.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>The results from a search with less than </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> characters may not be complete. For better results, try using at least </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> characters.</xsl:text>

</xsl:template>


</xsl:stylesheet>
