#!/bin/sh

if [ $# != 2 ]
then
  echo "Usage: $0 commandlog.txt outputfile"
  exit 1
fi

INPUT=$1
OUTPUT=$2
TMP1=/tmp/tutu1.$$
TMP2=/tmp/tutu2.$$
TMP3=/tmp/tutu3.$$
TMP4=/tmp/tutu4.$$
TMP5=/tmp/tutu5.$$

rm -rf $OUTPUT
more $INPUT | nawk 'BEGIN {FS=" "
           nbPost=0;
           nbGet=0;
           nbStatic=0;
           nbNotFound=0;
           beginingDate = "";
           endDate = "";
         }
         {
           fullDate = $1;
           command = $7;
           if (command != "GET" && command != "POST:")
             continue;

           if (command == "GET") {
             url = $9;
           }
           else {
             url = $8;
           }


           endDate = substr(fullDate,2);
           if (beginingDate == "")
             beginingDate = endDate;


           if (command == "GET") {
             nbGet++;
           }
           else {
             nbPost++;
           }

           if (url ~ /\.gif$/ || url ~ /\.css$/ || url ~ /\.js$/) {
             nbStatic++;
             continue;
           }
           if (url == "/default.html") {
             nbNotFound++;
             continue;
           }

           hour = substr(fullDate, 14,2);
           hour_name[hour] = hour;
           hour_count[hour]++;
           
           nbStuff = split(url,user1,"calid=");
           if (nbStuff > 1) {
             nbStuff = split(user1[2],user2,"&");
             if (nbStuff > 0) {
               user = user2[1];
               if (user != "") {
                 user_name[user]=user;
                 user_count[user]++;
               }
             }
           }

           if (url ~ /\/*.wcap?/ ) {
               nbStuff = split(url,wcapcommand1,"?");
               wcapcommand=substr(wcapcommand1[1],2);
               wcap_name[wcapcommand] = wcapcommand;
               wcap_count[wcapcommand]++;
               if (wcapcommand == "login.wcap") {
                 loginhour_count[hour]++;
               }
               continue;
           }

           if (url ~/type=new_task&shortcut=true/) {
               views_name["deletetask"] = "deletetask";
               views_count["deletetask"]++;
               continue;
           }
           if (url ~/type=new_event&shortcut=true/) {
               views_name["deleteevent"] = "deleteevent";
               views_count["deleteevent"]++;
               continue;
           }

           nbStuff = split(url,views1,"view=");
           if (nbStuff < 2) {
             printf("Unkwown view: %s\n", $0);
             continue;
           }
           nbStuff = split(views1[2],views2,"&");
           if (nbStuff == 0) {
             printf("Unkwown view: %s\n", $0);
             continue;
           }
           view = views2[1];
           if (view == "")
             printf("Unkown: %s\n", $0);

           if (  view == "formstuff" || view ~ /:button/ || view ~ /:main/ || view ~ /:tabs/ || view ~ /:toolbar/ || view ~ /:searchProperties/ )
             continue;

           views_name[view] = view;
           views_count[view]++;
           
         } 
         END {
           wcaptotal = 0;
           viewtotal = 0;
           printf("Start: %s\n", beginingDate) >> output;
           printf("End:   %s\n", endDate) >> output;
           printf("Nb GET: %s\n", nbGet) >> output;
           printf("Nb POST: %s\n", nbPost) >> output;
           printf("Nb Total: %s\n", nbGet + nbPost) >> output;
           printf("\n") >> output;

           for (wcapname in wcap_name) {
             wcapbis = wcapname;
             if (wcapname == "")
               wcapbis = "[empty]";
             printf("\t%-25s:\t\t%s\n", wcapbis, wcap_count[wcapname]) >> tmp3;
             printf("\t%s: %s\n", wcap_count[wcapname], wcapbis) >> tmp4;
             wcaptotal = wcaptotal + wcap_count[wcapname];
           }

           for (viewname in views_name) {
             viewbis = viewname;
             if (viewname == "")
               viewbis = "[empty]";
             printf("\t%-25s:\t\t%s\n", viewbis, views_count[viewname]) >> tmp1;
             printf("\t%s: %s\n", views_count[viewname], viewbis) >> tmp2;
             viewtotal = viewtotal + views_count[viewname];
           }

           printf("Total UI views (3 to 4 requests) : %s\n", viewtotal) >> output;
           printf("Total wcap commands              : %s\n", wcaptotal) >> output;
           if (nbStatic > 0)
             printf("Total static files (.gif,.js,...): %s\n", nbStatic) >> output;
           if (nbNotFound > 0)
             printf("Total Not found (/default.html)  : %s\n", nbNotFound) >> output;

           for (i = 0; i < 24; i++) {
             hour = sprintf("%.2d", i);
             totalPerHour = totalPerHour + hour_count[hour];
           }
           printf("\n*** Activity (UI + wcap) per hour of the day (shown if > 5 %% ) ***\n\n") >> output;
           for (i = 0; i < 24; i++) {
             hour = sprintf("%.2d", i);
             hourcount = hour_count[hour];
             loginhourcount = loginhour_count[hour];
             percent = (hourcount * 100) / totalPerHour;
             if (percent >= 5)
               printf("\t%s: %.2f %% of activity (%s requests, %s logins)\n", hour, percent, hourcount,loginhourcount) >> output;
           }

           for (username in user_name) {
             printf("\t%s:\t\t%s\n", user_count[username], username) >> viewPerUser
           }
         }' output=$OUTPUT tmp1=$TMP1 tmp2=$TMP2 tmp3=$TMP3 tmp4=$TMP4 viewPerUser=$TMP5
echo "\n*** Top 10 UI Views ***\n" >> $OUTPUT
sort -rn $TMP2 | head -10 >> $OUTPUT

echo "\n\n*** Details per view ***\n" >> $OUTPUT
echo "\tView\t\t\t :\t\tNb Requests\n" >> $OUTPUT
sort $TMP1 >> $OUTPUT

echo "\n*** Top 10 wcap commands ***\n" >> $OUTPUT
sort -rn $TMP4 | head -10 >> $OUTPUT

echo "\n\n*** Details per wcap commands ***\n" >> $OUTPUT
echo "\tCommand\t\t\t :\t\tNb Requests\n" >> $OUTPUT
sort $TMP3 >> $OUTPUT

echo "\n\n*** Top 10 most active calendars (UI+wcap) ***\n" >> $OUTPUT
sort -rn $TMP5 | head -10 >> $OUTPUT

#
# Now print per nb of attendees
#
echo "\n\n*** Number of Invitees per Event ***\n" >> $OUTPUT
more $INPUT | grep "type=new_event" | grep e_isNewEvent | nawk 'BEGIN {FS=" "
           nbHundred=0;
           nbFifty=0;
           nbTwenty=0;
           nbTen=0;
           nbFive=0;
           nbTwo=0;
           nbOne=0;
         }
         {
           url = $0;
           if (url ~/e_attendee_100/) {
             nbHundred++;
             continue;
           }
           if (url ~/e_attendee_50/) {
             nbFifty++;
             continue;
           }
           if (url ~/e_attendee_20/) {
             nbTwenty++;
             continue;
           }
           if (url ~/e_attendee_10/) {
             nbTen++;
             continue;
           }
           if (url ~/e_attendee_5/) {
             nbFive++;
             continue;
           }
           if (url ~/e_attendee_2/) {
             nbTwo++;
             continue;
           }
           nbOne++;
           
         } 
         END {
           nbEvents = nbOne + nbTwo + nbFive + nbTen + nbTwenty + nbFifty + nbHundred;
           if (nbEvents > 0) {
             printf("\tNo Invitee:         %s (%.2f %%)\n", nbOne, (nbOne * 100) / nbEvents);
             printf("\tBetween 1 and 4:    %s (%.2f %%)\n", nbTwo, (nbTwo * 100) / nbEvents);
             printf("\tBetween 5 and 9:    %s (%.2f %%)\n", nbFive, (nbFive * 100) / nbEvents);
             printf("\tBetween 10 and 19:  %s (%.2f %%)\n", nbTen, (nbTen * 100) / nbEvents);
             printf("\tBetween 20 and 49:  %s (%.2f %%)\n", nbTwenty, (nbTwenty * 100) / nbEvents);
             printf("\tBetween 50 and 99:  %s (%.2f %%)\n", nbFifty, (nbFifty * 100) / nbEvents);
             printf("\t100 and more:       %s (%.2f %%)\n", nbHundred, (nbHundred * 100) / nbEvents);
           }
           else {
             printf("\tNo Event with Invitee\n");
           }
         }' >> $OUTPUT
rm -rf $TMP1 $TMP2 $TMP3 $TMP4 $TMP5
