#!/bin/sh

# 
# Script to launch java configurator
# Find out where the java package is installed 
# and execute the java configurator.
#
# Command line arguments are tranfered to java command line
# 
# Last revision: 03/12/2003
#

#Save the current path
CUR_DIR=`pwd`

#Java command
JAVA_CMD="java"

#Name of the Calendar package
CS_PACKAGE_NAME="SUNWics5"

#Java bin directory
JAVA_BIN="bin"

#Get the JAVA BASEDIR from the CSJAVADIR variable in the SUNWics5 pkg
JAVA_BASEDIR=`pkgparam $CS_PACKAGE_NAME CSJAVADIR` 

#If the JAVA BASEDIR has not been provided by the CSJAVADIR variable
#Then try to get it from the SUNWj3rt package
if [ "$JAVA_BASEDIR" = "" ]; then
  #Get the BASEDIR for SUNWj3rt
  JAVA_BASEDIR=`pkgparam SUNWj3rt BASEDIR`/j2se
fi

#Get the BASEDIR for SUNWics5
CS_BASEDIR=`pkgparam $CS_PACKAGE_NAME BASEDIR` 

#Path to the configure class
CONFIGURE_PATH="$CS_PACKAGE_NAME/cal/jconfigure"

#Class to run
CONFIGURE_CMD="configure"

#Java arguments: classpath
JAVA_ARGS="-cp ."

#Execute the command
cd $CS_BASEDIR/$CONFIGURE_PATH
echo $JAVA_BASEDIR/$JAVA_BIN/$JAVA_CMD $JAVA_ARGS $CONFIGURE_CMD $@
$JAVA_BASEDIR/$JAVA_BIN/$JAVA_CMD $JAVA_ARGS $CONFIGURE_CMD $@
cd $CUR_DIR
