<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<!--
<xsl:variable name="Delete_Text">
Are you sure you want to delete this event?
</xsl:variable>
-->

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>	
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 2">
              <xsl:call-template name="reminders_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 3">
              <xsl:call-template name="calendars_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (reply_event.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Summary</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Reminders</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template>
        <!-- <xsl:call-template name="tab_item"><xsl:with-param name="Index">3</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Calendars</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[3]"/></xsl:with-param></xsl:call-template> -->
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="main_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus()">

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
   <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="e_newstatus" value="1"/>
<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
<xsl:call-template name="emit_new_event_errors"/>
  <TR>
    <TD colspan="2"><FONT face="{$font_name}" size="{$font_size_big}">
      <xsl:call-template name="reply_event_msg_template">
        <xsl:with-param name="org_id" select="./eventdata/Event/@e_Organizer"/>
      </xsl:call-template>
      </FONT>
    </TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Title</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:value-of select="./eventdata/Event/@e_Summary"/></FONT></TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Date</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:choose>
    <xsl:when test="./eventdata/Event/@e_allday='1'">
        <xsl:call-template name="date_long_no_time"><xsl:with-param name="date_range" select="./eventdata/Event"/></xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:call-template name="date_long"><xsl:with-param name="date_range" select="./eventdata/Event"/></xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
    </FONT></TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Location</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:value-of select="./eventdata/Event/@e_Location"/></FONT></TD>
  </TR>
  <xsl:if test="./eventdata/Event/@rsvp = 'TRUE'">
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Reply</B></FONT></TD>
    <TD valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><SELECT name="reply_option"><OPTION value="1">I will confirm later</OPTION><OPTION value="2"><xsl:if test="./eventdata/Event/@partstat = 2"><xsl:attribute name="selected"></xsl:attribute></xsl:if>I will attend</OPTION><OPTION value="3"><xsl:if test="./eventdata/Event/@partstat = 3"><xsl:attribute name="selected"></xsl:attribute></xsl:if>I will NOT attend</OPTION></SELECT></FONT></TD>
  </TR>
  </xsl:if>
  <TR>
    <TD width="1%" align="right" valign="top"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Organizer</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:value-of select="./eventdata/Event/@e_Organizer"/></FONT></TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="top"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Attendees</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><xsl:call-template name="attendee_long"><xsl:with-param name="event" select="./eventdata/Event"/></xsl:call-template></TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Description</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:value-of select="./eventdata/Event/@e_Description"/></FONT></TD>
  </TR>
</TABLE>
</CENTER>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="reminders_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
   <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="e_newstatus" value="1"/>
<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
<xsl:call-template name="emit_new_event_errors"/>
  <TR>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big}">
        Schedule email reminders here by providing email addresses (separated by commas or semi-colons) and choosing a date and time for delivery.
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <HR size="{$font_size_big}"/>
    </TD>
  </TR>

  <!-- REMIND -->
  
  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>Remind</B>
      </FONT>
    </TD>
    <TD valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_3}">
      
      <INPUT type="checkbox" name="Remind">
      <xsl:if test="./eventdata/Event/@partstat=1">
        <xsl:attribute name="onClick">
            var f = document.forms[0];
            alert('You cannot set an alarm for an unconfirmed event before the event begins');
            f['Remind'].checked = false;
          </xsl:attribute>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="./eventdata/Event/@e_alarm_on = 1">
          <xsl:attribute name="checked"/>
        </xsl:when>
      </xsl:choose>
      </INPUT>
      
      <INPUT type="text" name="Others" size="35" >
      <xsl:attribute name="value">
        <xsl:choose>
         <xsl:when test="string-length(./eventdata/Event/@e_alarm_emails) > 0">
           <xsl:value-of select="./eventdata/Event/@e_alarm_emails"/>
         </xsl:when>
         <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmEmail) > 0">
           <xsl:value-of select="/calendar/usrctx/userprefs/@ceDefaultAlarmEmail"/>
         </xsl:when>
         <xsl:when test="string-length(/calendar/usrctx/user/@mail) > 0">
           <xsl:value-of select="/calendar/usrctx/user/@mail"/>
         </xsl:when>
        </xsl:choose>
      </xsl:attribute>
      <xsl:choose>
      <xsl:when test="./eventdata/Event/@partstat=1">
          <xsl:attribute name="onChange">
            var f = document.forms[0];
            alert('You cannot set an alarm for an unconfirmed event before the event begins');
            f['Others'].value = '';
            f['Remind'].checked = false;
          </xsl:attribute>
         </xsl:when>
         <xsl:otherwise>
          <xsl:attribute name="onChange">
            var f = document.forms[0];
            if (f['Others'].value.length &gt; 0) {
              f['Remind'].checked = true;
            } else {
              f['Remind'].checked = false;
            }
          </xsl:attribute>
         </xsl:otherwise>
        </xsl:choose>
      </INPUT>
      
      <!-- <xsl:value-of select="/calendar/usrctx/user/@fullName"/>&nbsp;
      &amp;lt;<xsl:value-of select="/calendar/usrctx/user/@mail"/>&amp;gt;
      -->

      </FONT>
     </TD>
  </TR>

  <!-- TRIGGER BEFORE EVENT BEGINS -->

  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B><xsl:text>&nbsp;</xsl:text></B>
      </FONT>
    </TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <INPUT type="radio" name="triggertype"  value="relative">
          <xsl:if test="./eventdata/Event/@e_alarm_absolute_trigger != 1">
            <xsl:attribute name="checked"/>
          </xsl:if>
          <xsl:choose>
           <xsl:when test="./eventdata/Event/@partstat=1">
            <xsl:attribute name="onChange">
             var f = document.forms[0];
             alert('You cannot set an alarm for an unconfirmed event before the event begins');
             f['Others'].value = '';
             f['Remind'].checked = false;
            </xsl:attribute>
           </xsl:when>
          <xsl:otherwise>
           <xsl:attribute name="onClick">
             var f = document.forms[0];
             if (f['Others'].value.length &gt; 0) {
              f['Remind'].checked = true;
             } else {
              f['Remind'].checked = false;
             }
           </xsl:attribute>
          </xsl:otherwise>
         </xsl:choose>
        </INPUT>
        <xsl:call-template  name="time_before_selector">
          <xsl:with-param name="time_offset" select="./eventdata/Event/@e_alarm_offset"/>
          <xsl:with-param name="time_units" select="./eventdata/Event/@e_alarm_units"/>
          <xsl:with-param name="before_text">before the event begins</xsl:with-param>
        </xsl:call-template>
      </FONT>
    </TD>
  </TR>

  <!-- ABSOLUTE TRIGGER TIME -->
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B><xsl:text>&nbsp;</xsl:text></B></FONT></TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <INPUT type="radio" name="triggertype" value="absolute">
        <xsl:if test="./eventdata/Event/@e_alarm_absolute_trigger = 1">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:choose>
        <xsl:when test="./eventdata/Event/@partstat=1">
         <xsl:attribute name="onChange">
             var f = document.forms[0];
             alert('You cannot set an alarm for an unconfirmed event before the event begins');
             f['Others'].value = '';
             f['Remind'].checked = false;
            </xsl:attribute>
           </xsl:when>
          <xsl:otherwise>
           <xsl:attribute name="onClick">
             var f = document.forms[0];
             if (f['Others'].value.length &gt; 0) {
              f['Remind'].checked = true;
             } else {
              f['Remind'].checked = false;
             }
           </xsl:attribute>
          </xsl:otherwise>
         </xsl:choose>
      </INPUT>
      </FONT>

      <xsl:choose>
        <xsl:when test="./eventdata/Event/@e_alarm_absolute_trigger = 1">
          <xsl:call-template  name="absolute_datetime_selector">
            <xsl:with-param name="input_prefix" select="'trig'"/>
            <xsl:with-param name="month" select="./eventdata/Event/AbsoluteAlarmTime/@month"/>
            <xsl:with-param name="day" select="./eventdata/Event/AbsoluteAlarmTime/@date"/>
            <xsl:with-param name="year" select="./eventdata/Event/AbsoluteAlarmTime/@year"/>
            <xsl:with-param name="start_hour" select="./eventdata/Event/AbsoluteAlarmTime/@hour"/>
            <xsl:with-param name="start_min" select="./eventdata/Event/AbsoluteAlarmTime/@minute"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
          <xsl:when test="./eventdata/Event/@e_allday = '1'">
            <xsl:call-template  name="absolute_datetime_selector">
              <xsl:with-param name="input_prefix" select="'trig'"/>
              <xsl:with-param name="month" select="./eventdata/Event/StartTime/@month"/>
              <xsl:with-param name="day" select="./eventdata/Event/StartTime/@date"/>
              <xsl:with-param name="year" select="./eventdata/Event/StartTime/@year"/>
              <xsl:with-param name="start_hour" select="/calendar/usrctx/userprefs/@ceDayHead"/>
              <xsl:with-param name="start_min">00</xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template  name="absolute_datetime_selector">
              <xsl:with-param name="input_prefix" select="'trig'"/>
              <xsl:with-param name="month" select="./eventdata/Event/StartTime/@month"/>
              <xsl:with-param name="day" select="./eventdata/Event/StartTime/@date"/>
              <xsl:with-param name="year" select="./eventdata/Event/StartTime/@year"/>
              <xsl:with-param name="start_hour" select="./eventdata/Event/StartTime/@hour"/>
              <xsl:with-param name="start_min" select="./eventdata/Event/StartTime/@minute"/>
            </xsl:call-template>
          </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </TD>
  </TR>

  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <HR size="{$font_size_big}"/>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big}">
        Use the following space to provide additional information with the reminder. The title, date, time and location of an event are automatically included in all reminders.
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="top" nowrap="">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>Message</B>
      </FONT>
    </TD>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <TEXTAREA cols="42" rows="5" name="reminderMessage" wrap="virtual">
          <xsl:value-of select="./eventdata/Event/@e_alarm_description"/>
        </TEXTAREA>
      </FONT>
    </TD>
  </TR>
</TABLE>
</CENTER>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="calendars_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
   <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
  <TR>
    <TD colspan="4"><FONT face="{$font_name}" 
    size="{$font_size_big}"> Select the calendar in which to store the event.</FONT></TD>
  </TR>
  <TR><TD colspan="4"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD colspan="4">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>Calendar</B>
      </FONT> 
      <xsl:text>&nbsp;</xsl:text>
     <xsl:variable name="selectedCalid">
       <xsl:value-of select="./eventdata/Event/@e_Calid"/>
     </xsl:variable>
     <SELECT name="new_calid">
       <xsl:for-each select="/calendar/usrctx/calendarList/calID">
         <OPTION value="{@name}">
           <xsl:value-of select="@name"/><xsl:text>&nbsp;</xsl:text>(<xsl:value-of select="@printableName"/>)
           <xsl:if test="$selectedCalid = @name">
             <xsl:attribute name="selected"/>
           </xsl:if>
         </OPTION>
       </xsl:for-each>
     </SELECT>
    </TD>
  </TR>
</TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
  <xsl:call-template name="javascript_strings"/>
  <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <xsl:if test="(string-length(./eventdata/Event/@e_uid) > 0) and (./eventdata/Event/@e_deleteAccessAllowed = 'true')">
      <TD align="left" bgcolor="{$bgcolor_button}">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
          <INPUT type="button" name="delete" width="72" value="Delete">
            <xsl:attribute name="onClick">
              if (parent.frames[1].document.forms[0]['e_rid'].value != '0') {
               <xsl:value-of select="./command[@name='repeating_event_delete']"/>
              } else {
                <xsl:value-of select="./button[@name='delete']"/>
              }
            </xsl:attribute>
          </INPUT>
        </FONT>
      </TD>
    </xsl:if>
    <TD align="right" bgcolor="{$bgcolor_button}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <xsl:choose>
        <xsl:when test="./eventdata/Event/@e_writeAccessAllowed = 'true'">
          <INPUT type="button" name="ok" width="72" value="OK">
            <xsl:attribute name="onClick">
              if (parent.date_error == '1') {
                    parent.date_error = '0';
                    return;
              }
              <!-- Warn about absolute alarms if alarm is set to after the event -->
              var f = parent.frames[1].document.forms[0];
              var isampm = 0;
              var isalldayevent = 0;
                 
              <!-- Does the time in the form have to be converted to 24 hour clock before comparison? -->
	      <xsl:if test="/calendar/usrctx/userprefs/@ceClock='12'">
                 isampm = 1;
              </xsl:if>

	      if(f['isallday'].value == 1) {
	  	isalldayevent = 1;
    	      }

	      <!-- Was absolute alarm set? Then compare times -->
              if ((f['absalarmset'].value == 1) || (f['triggertype'] &amp;&amp; f['triggertype'][1].checked)) {
                if (comparetime(f, isampm, 'trig', isalldayevent) != 0) {
                  if(!confirm('Reminder for this event is set to a time after the start of the event. Hit cancel to go back and change the time.')) {
                      return;
                  }
                }
              }
              if (parent.frames[1].document.forms[0]['e_rid'].value != '0') {
                <xsl:value-of select="./command[@name='repeating_event_store']"/>
              } else {
                <xsl:value-of select="./button[@name='ok']"/>
              }
            </xsl:attribute>
          </INPUT>
          <INPUT type="button" name="esc" width="72" value="Cancel" onClick="{./button[@name='cancel']}"/>
        </xsl:when>
        <xsl:otherwise>
          <INPUT type="button" name="esc" width="72" value="Close" onClick="{./button[@name='cancel']}"/>
        </xsl:otherwise>
      </xsl:choose>
      <INPUT type="button" name="help" width="72" value="Help" onClick="{./button[@name='help']}"/></FONT> </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML></xsl:template>

</xsl:stylesheet>
