<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="cal_timezones.xsl"/>

<!--
<xsl:variable name="Delete_Text">
Are you sure you want to delete this privacy entry?
</xsl:variable>
-->

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Edit Calendar: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="77,*,41">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 2">
              <xsl:call-template name="privacy_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 3">
              <xsl:call-template name="owners_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 4">
              <xsl:call-template name="timezones_America_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="./caldata/@tzid"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 5">
              <xsl:call-template name="timezones_EuropeAfrica_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="./caldata/@tzid"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 6">
              <xsl:call-template name="timezones_AsiaPacific_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="./caldata/@tzid"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (new_cal.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="main_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
  <xsl:attribute name="onload">
    window.focus();
    <xsl:choose>
     <xsl:when test="./caldata/@e_isNew = 1">
       document.forms[0].calendarID.focus();
     </xsl:when>
     <xsl:otherwise>
       document.forms[0].displayName.focus();
     </xsl:otherwise>
    </xsl:choose>
  </xsl:attribute>

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:attribute name="onSubmit">
    <xsl:if test="./caldata/@e_isNew = 1">
      document.forms[0]['newCalCalID'].value = '<xsl:value-of select="/calendar/usrctx/user/@name"/>:' + document.forms[0]['calendarID'].value;
    </xsl:if>
    return false;
  </xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="targetGroup"/>
  <xsl:if test="./caldata/@e_isNew = 1">
     <INPUT type="hidden" name="e_isNew" value="1"/>
  </xsl:if>

<CENTER>
<TABLE border="0" cellpadding="1" cellspacing="1">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>
  <TR>
    <TD colspan="2">
    <FONT face="{$font_name}" size="{$font_size_big}" color="#0000FF">* </FONT>
    <FONT face="{$font_name}" size="{$font_size_big}"><xsl:text>&nbsp;</xsl:text>Indicates required information.<BR/><BR/></FONT></TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD align="right" valign="baseline" nowrap="">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <B>Calendar</B>
      </FONT>
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#0000FF">
      *
      </FONT>
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <xsl:text>&nbsp;&nbsp;</xsl:text>
      </FONT></TD>
    <TD valign="baseline">
        <xsl:choose>
          <xsl:when test="./caldata/@e_isNew = 1">
              <FONT face="monospace" size="{$font_size_big_2}">
                <xsl:value-of select="/calendar/usrctx/user/@name"/>:
              </FONT>
              <INPUT type="hidden" name="newCalCalID"/>
              <FONT face="{$font_name}" size="{$font_size_big_2}">
              <INPUT type="text" name="calendarID" size="33">
                <xsl:attribute name="value">
                  <xsl:choose>
                    <xsl:when test="string-length(./caldata/@shortCalID) &gt; 0">
                      <xsl:value-of select="./caldata/@shortCalID"/>
                    </xsl:when>
                  </xsl:choose>
                </xsl:attribute>
              </INPUT>
              </FONT>
              <BR/>
              <FONT face="{$font_name}" size="{$font_size_big}">
              Provide a short name for the calendar such as "baseball" (spaces aren't allowed).
              </FONT>
          </xsl:when>
          <xsl:otherwise>
              <INPUT type="hidden" name="newCalCalID"/>
              <FONT face="monospace" size="{$font_size_big_2}">
                <xsl:call-template name="printLimitedName">
                  <xsl:with-param name="name" select="./caldata/@newCalCalID"/>
                </xsl:call-template>
              </FONT>
          </xsl:otherwise>
        </xsl:choose>
    </TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD align="right" valign="baseline" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Display Name</B></FONT></TD>
    <TD valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <INPUT type="text" name="displayName" size="42">
        <xsl:attribute name="value">
          <xsl:choose>
            <xsl:when test="string-length(./caldata/@displayName) &gt; 0"><xsl:value-of select="./caldata/@displayName"/></xsl:when>
          </xsl:choose>
        </xsl:attribute>
      </INPUT>
      </FONT>
      <BR/>
     <FONT face="{$font_name}" size="{$font_size_big}">This is an optional field to remind you of the purpose of this calendar, such as "Billy's Baseball Schedule."</FONT>
    </TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD align="right" valign="top"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Description</B></FONT></TD>
    <TD valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <TEXTAREA cols="42" rows="5" name="description" wrap="virtual">
        <xsl:if test="string-length(./caldata/@description) &gt; 0">
          <xsl:value-of select="./caldata/@description"/>
        </xsl:if>
      </TEXTAREA>
      </FONT>
    </TD>
  </TR>

<!-- Our UI forces the default cal to remain part of availability -->
  <xsl:if test="(./caldata/@e_isDefaultCalendar != 'true') or (./caldata/@e_isNew = 1)">
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD width="1%" align="right" valign="baseline" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Availability</B></FONT></TD>
    <TD valign="baseline">
      <INPUT type="checkbox" name="freebusy">
        <xsl:if test="./caldata/@freebusy = 1">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          if (document.forms[0]['e_freebusy']) {
            if (document.forms[0]['freebusy'].value) {
              document.forms[0]['e_freebusy'].value = '0';
            } else {
              document.forms[0]['e_freebusy'].value = '1';
            }
          }
        </xsl:attribute>
      </INPUT>
      <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>Include this calendar when calculating your availability</FONT>
    </TD>
  </TR>
  </xsl:if>

  <xsl:if test="string-length(./caldata/@viewCommand) > 0">
    <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
    <TR>
      <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Calendar Address</B></FONT></TD>
      <TD valign="baseline">
        <FONT face="{$font_name}" size="{$font_size_big}">You can give others access to this calendar by giving them the link here. They can then use it in their browsers to view this calendar, provided that access control is set to give them access.</FONT>
        <BR/>
        <A target="_blank">
          <xsl:attribute name="href">
            <xsl:value-of select="./caldata/@viewCommand"/>
          </xsl:attribute>
          <FONT face="{$font_name}" size="{$font_size_big_2}">
            <xsl:value-of select="./caldata/@viewCommand"/>
          </FONT>
        </A>
      </TD>
    </TR>
  </xsl:if>
</TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="privacy_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
  <xsl:attribute name="onload">
    document.forms[0].add_user_name.focus();
  </xsl:attribute>

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:attribute name="onSubmit">return x('add_user')</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="newPerson" />
  <INPUT type="hidden" name="targetGroup"/>

<TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>
  <TR>
    <TD width="1%">
      <B>Permissions for calendar:<xsl:text> </xsl:text>
      <xsl:call-template name="printCalendarName">
        <xsl:with-param name="name" select="caldata/@shortCalID"/>
        <xsl:with-param name="printname" select="caldata/@displayName"/>
      </xsl:call-template>
      </B>
      <BR/><BR/><FONT face="{$font_name}" size="{$font_size_normal}"
      color="#000000">Permissions determine how others can see and change this calendar. To give certain permissions to all users, select the appropriate permissions from the columns next to Everybody. To give certain permissions to individuals, enter their user ID in the User field and click "Add User". Then select the appropriate permissions from the columns next to the user's name.</FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2" width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
  </TR>
</TABLE>
<TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <TR>
    <TD>
      <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
        <TR>
          <TD bgcolor="{$bgcolor_table_border}">
            <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
              <TR bgcolor="{$bgcolor_table_top}">
                <TD nowrap="" align="left"   rowspan="2" colspan="1"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Select</FONT></TD>
                <TD nowrap="" align="left"   rowspan="2" colspan="1"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">User</FONT></TD>
                <TD nowrap="" align="center" rowspan="1" colspan="5"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Permissions</FONT></TD>
              </TR>
              <TR bgcolor="{$bgcolor_table_top}">
                <TD nowrap="" align="center" width="60"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">Availability</FONT></TD>
                <TD nowrap="" align="center" width="60"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">Invite</FONT></TD>
                <TD nowrap="" align="center" width="60"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">Read</FONT></TD>
                <TD nowrap="" align="center" width="60"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">Delete</FONT></TD>
                <TD nowrap="" align="center" width="60"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">Modify</FONT></TD>
              </TR>

  <!--
        The real data
  -->
              <xsl:for-each select="caldata/privacyEntry">
                <xsl:if test="@type = 'person'">
                  <xsl:call-template name="privacy_entry">
                    <xsl:with-param name="privacy_data" select="."></xsl:with-param>
                  </xsl:call-template>
                </xsl:if>
              </xsl:for-each>

              <TR bgcolor="{$bgcolor_table_top}"><TD colspan="7"><xsl:text>&nbsp;</xsl:text></TD></TR>

              <xsl:if test="count(caldata/privacyEntry[@type='domain']) > 0">
               <xsl:call-template name="privacy_entry">
                <xsl:with-param name="privacy_data" select="caldata/privacyEntry[@type='domain']"/>
               </xsl:call-template>
              </xsl:if>

              <xsl:if test="count(caldata/privacyEntry[@type='anyone']) > 0">
               <xsl:call-template name="privacy_entry">
                <xsl:with-param name="privacy_data" select="caldata/privacyEntry[@type='anyone']"/>
               </xsl:call-template>
              </xsl:if>

            </TABLE>
          </TD>
        </TR>
      </TABLE>
    </TD>
  </TR>
  <TR>
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <input type="button" name="Remove_Selected" value="Delete Selected User" onClick="{button[@name='remove_user']}" width="72"/>
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      User:<xsl:text>&nbsp;</xsl:text><INPUT TYPE="text" value="" name="add_user_name"/><xsl:text>&nbsp;</xsl:text><INPUT TYPE="Submit" value="Add User" name="add_user"/>
      </FONT>
    </TD>
  </TR>
</TABLE>

</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="privacy_entry">
  <xsl:param name="privacy_data"/>

  <TR bgcolor="#FFFFFF">

 <!-- Select Col -->
  <TD nowrap="" align="left">
    <xsl:if test="$privacy_data/@type = 'person'">
      <input type="checkbox" align="center">
        <xsl:attribute name="name">remove_user_<xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
      </input>
    </xsl:if>
  </TD>

 <!-- User ID Col -->
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
        <xsl:if test="$privacy_data/@type = 'person'">
          <xsl:if test="string-length($privacy_data/@name) > 0"><xsl:value-of select="$privacy_data/@name"/></xsl:if>
        </xsl:if>
        <xsl:if test="$privacy_data/@type = 'anyone'">
          Everybody
        </xsl:if>
        <xsl:if test="$privacy_data/@type = 'domain'">
          This Domain
        </xsl:if>
      </FONT>
    </TD>

  <!-- Privacy -->
    <TD nowrap="" align="center">
      <INPUT TYPE="checkbox" value="ACo">
      <xsl:attribute name="name">user_ACo_<xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
      <xsl:if test="$privacy_data/@availability = 1"><xsl:attribute name="checked"></xsl:attribute></xsl:if>
      </INPUT>
    </TD>
    <TD nowrap="" align="center">
      <INPUT TYPE="checkbox" value="SCo">
      <xsl:attribute name="name">user_SCo_<xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
      <xsl:if test="$privacy_data/@schedule = 1"><xsl:attribute name="checked"></xsl:attribute></xsl:if>
      </INPUT>
    </TD>
    <TD nowrap="" align="center">
      <INPUT TYPE="checkbox" value="RA">
      <xsl:attribute name="name">user_RA_<xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
      <xsl:if test="$privacy_data/@read = 1"><xsl:attribute name="checked"></xsl:attribute></xsl:if>
      </INPUT>
    </TD>
    <TD nowrap="" align="center">
      <INPUT TYPE="checkbox" value="DCo">
      <xsl:attribute name="name">user_DCo_<xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
      <xsl:if test="$privacy_data/@delete = 1"><xsl:attribute name="checked"></xsl:attribute></xsl:if>
      </INPUT>
    </TD>
    <TD nowrap="" align="center">
      <INPUT TYPE="checkbox" value="MCo">
      <xsl:attribute name="name">user_MCo_<xsl:value-of select="$privacy_data/@name"/></xsl:attribute>
      <xsl:if test="$privacy_data/@modify = 1"><xsl:attribute name="checked"></xsl:attribute></xsl:if>
      </INPUT>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="owners_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
  <xsl:attribute name="onload">
    document.forms[0].add_owner_name.focus();
  </xsl:attribute>

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:attribute name="onSubmit">return x('add_owner')</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="newPerson" />
  <INPUT type="hidden" name="targetGroup"/>

<TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>
  <TR>
    <TD width="1%">
      <B>Tip for assigning owners to calendar:<xsl:text> </xsl:text>
      <xsl:call-template name="printCalendarName">
        <xsl:with-param name="name" select="caldata/@shortCalID"/>
        <xsl:with-param name="printname" select="caldata/@displayName"/>
      </xsl:call-template>
      </B>
      <BR/><BR/><FONT face="{$font_name}" size="{$font_size_normal}" color="#000000">You may add one or more owners for this calendar. An owner has the ability to act on your behalf to reply to invitations, and to create, modify, and delete events.</FONT> </TD>
  </TR>
  <TR>
    <TD colspan="2" width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
  </TR>
</TABLE>
<TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <TR>
    <TD>
     <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
        <TR>
          <TD bgcolor="{$bgcolor_table_border}">
            <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
              <TR bgcolor="{$bgcolor_table_top}">
                <TD nowrap="" align="left" width="1%"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Select</FONT></TD>
                <TD nowrap="" align="left" ><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">User</FONT></TD>
              </TR>

  <!--
        The real data
  -->
                <xsl:if test="count(caldata/OtherOwner) = 0">
                  <TR bgcolor="#FFFFFF"><TD colspan="2" align="center"><FONT face="{$font_name}" size="{$font_size_big_2}">There are no owners.</FONT></TD></TR>
                </xsl:if>
               <xsl:for-each select="caldata/OtherOwner">
                  <xsl:call-template name="otherowners_entry">
                    <xsl:with-param name="otherowners_data" select="."></xsl:with-param>
                  </xsl:call-template>
               </xsl:for-each>

            </TABLE>
          </TD>
        </TR>
      </TABLE>
    </TD>
  </TR>
  <xsl:if test="count(caldata/OtherOwner) > 0">
  <TR>
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <input type="button" name="remove_owner" value="Delete Owner" onClick="{button[@name='remove_owner']}" width="72"/>
      </FONT>
    </TD>
  </TR>
  </xsl:if>
  <TR>
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      Owner Name:<xsl:text>&nbsp;</xsl:text><INPUT TYPE="text" value="" name="add_owner_name"/><xsl:text>&nbsp;</xsl:text><INPUT TYPE="Submit" value="Add Owner" name="add_owner"/>
      </FONT>
    </TD>
  </TR>
</TABLE>

</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="otherowners_entry">
  <xsl:param name="otherowners_data"/>

  <TR bgcolor="#FFFFFF">

 <!-- Select Col -->
  <TD nowrap="" align="left">
    <input type="checkbox" align="center">
      <xsl:attribute name="name">remove_owner_<xsl:value-of select="$otherowners_data/@name"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="$otherowners_data/@name"/></xsl:attribute>
    </input>
  </TD>
 <!-- User ID Col -->
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
        <xsl:if test="string-length($otherowners_data/@name) > 0"><xsl:value-of select="$otherowners_data/@name"/></xsl:if>
      </FONT>
    </TD>
  </TR>
</xsl:template>

<xsl:template name="button_root">
<HTML>
<HEAD>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="javascript"/> -->
<SCRIPT SRC="javascript.js">alert('NotFound!');</SCRIPT>
<!--  <xsl:call-template name="javascriptNormalize"/> -->
  <SCRIPT SRC="js_normalize.js">alert('NotFound!');</SCRIPT>
</HEAD>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">

<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <xsl:if test="(./caldata/@e_isNew = 0) and
    (./caldata/@e_writeAccessAllowed = 'true') and
    (./caldata/@e_isDefaultCalendar = 'false')">
      <TD align="left" bgcolor="{$bgcolor_button}">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
          <INPUT type="button" name="delete" value="Delete" width="72">
            <xsl:attribute name="onClick">
              if (!confirm('Are you sure you want to delete this calendar?')) {
                return;
              }

              var f = parent.frames[1].document.forms[0];
              f['myaction'].value='delete';
              var x=f.submit();
            </xsl:attribute>
          </INPUT>
        </FONT>
      </TD>
    </xsl:if>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <xsl:choose>
          <xsl:when test="(./caldata/@e_isNew = 1) or (./caldata/@e_writeAccessAllowed = 'true')">
            <INPUT type="button" name="ok" value="OK" width="72">
              <xsl:attribute name="onClick">
                var f = parent.frames[1].document.forms[0];
                if (parent &amp;&amp; parent.opener) {
                  var openerForm;
                  if (parent.opener.document.forms[0]) {
                    openerForm = parent.opener.document.forms[0];
                  } else {
                    openerForm = parent.opener.frames[0].document.forms[0];
                  }
                  if (openerForm['calgroup']) {
                    f['targetGroup'].value = normalize(openerForm['calgroup'].options[openerForm['calgroup'].selectedIndex].value);
                  }
                }

<!-- If we're setting a new calendarID then it needs to have a value -->
                if ( f['calendarID'] &amp;&amp; f['calendarID'].value == '')
                {
                  alert('You must supply a calendar name');
                } else {
                  f['myaction'].value='store';
                  if (f['newCalCalID'] &amp;&amp; f['calendarID']) {
                    f['newCalCalID'].value = '<xsl:value-of select="/calendar/usrctx/user/@name"/>:' + f['calendarID'].value;
                  }
                  var x=f.submit();
                }
              </xsl:attribute>
            </INPUT>
            <INPUT type="button" name="esc" value="Cancel" onClick="{./button[@name='cancel']}" width="72"/>
          </xsl:when>
          <xsl:otherwise>
            <INPUT type="button" name="esc" value="Close" onClick="{./button[@name='cancel']}" width="72"/>
          </xsl:otherwise>
        </xsl:choose>
        <INPUT type="button" name="help" value="Help" onClick="{./button[@name='help']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>


<!-- Special version of tab_item that sets newCalCalID properly -->
<xsl:template name="new_cal_tab_item">
  <xsl:param name="Index"/>
  <xsl:param name="Selected_Index"/>
  <xsl:param name="Name"/>
  <xsl:param name="Action"/>

  <xsl:choose>
    <xsl:when test="$Selected_Index!=$Index">
      <TD width="1%" nowrap="" align="center">
        <A href="{$Action}">
          <xsl:attribute name="onClick">
            var f = parent.frames[1].document.forms[0];
            if (f['newCalCalID'] &amp;&amp; f['calendarID']) {
              f['newCalCalID'].value = '<xsl:value-of select="/calendar/usrctx/user/@name"/>:' + f['calendarID'].value;
            }
          </xsl:attribute>
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            <xsl:value-of select="$Name"/>
          </FONT>
        </A>
      </TD>
    </xsl:when>

    <xsl:when test="$Selected_Index=$Index">
      <TD width="1%" nowrap="" align="center" bgcolor="{$bgcolor_selected}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B><xsl:value-of select="$Name"/></B></FONT></TD>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
<HEAD></HEAD>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="new_cal_tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Calendar</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="new_cal_tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Permissions</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="new_cal_tab_item"><xsl:with-param name="Index">3</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Owners</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[3]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="new_cal_tab_item"><xsl:with-param name="Index">4</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:choose><xsl:when test="/calendar/@tab &gt;= 4">4</xsl:when><xsl:otherwise><xsl:value-of select="/calendar/@tab"/></xsl:otherwise></xsl:choose></xsl:with-param><xsl:with-param name="Name">Time Zones</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[4]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>

<xsl:call-template name="outputTimezoneTabs">
  <xsl:with-param name="timezone_tab">4</xsl:with-param>
</xsl:call-template>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
