<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="cal_timezones.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>
    <TITLE>Repeating Selection: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (repeating_selection.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="common_main_root">
  <xsl:param name="message"/>

<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>

  <TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
    <TR>
      <TD valign="top" width="1%">
        <IMG src="imx/alert.gif" width="32" height="32"/>
      </TD>
      <TD>
        <FONT size="{$font_size_big_2}" face="{$font_name}">
          <xsl:value-of select="$message"/>
        </FONT>
      </TD>
    </TR>
  </TABLE>

</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="common_button_root">
  <xsl:param name="action"/>

<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM method="post">

<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <INPUT type="button" name="thisInstance" value="This one only" width="72">
          <xsl:attribute name="onClick">
            if (parent &amp;&amp; parent.opener &amp;&amp; parent.opener.parent.frames[1].document.forms[0]['e_repeatModifier']) {
                setModifier('THISINSTANCE','<xsl:value-of select="$action"/>');
            } else {
              var f = parent.frames[1].document.forms[0];
              f['e_repeatModifier'].value = 'THISINSTANCE';
              f['myaction'].value = 'delete';
              f.submit();
              close();
            }
          </xsl:attribute>
        </INPUT>
        <INPUT type="button" name="thisAndAll" value="All instances" width="72">
          <xsl:attribute name="onClick">
            if (parent &amp;&amp; parent.opener &amp;&amp; parent.opener.parent.frames[1].document.forms[0]['e_repeatModifier']) {
                setModifier('THISANDALL','<xsl:value-of select="$action"/>');
            } else {
              var f = parent.frames[1].document.forms[0];
              f['e_repeatModifier'].value = 'THISANDALL';
              f['myaction'].value = 'delete';
              f.submit();
              close();
            }
          </xsl:attribute>
        </INPUT>
        <INPUT type="button" name="esc" value="Cancel" width="72">
          <xsl:attribute name="onClick">
            parent.close();
          </xsl:attribute>
        </INPUT>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Repeating Selection</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
