#ifndef csIDBTranslator_h___
#define csIDBTranslator_h___

#include "nsISupports.h"
#include "array.h"
#include "cal_comparray.h"
#include "cal_miscinfo.h"

/**
 * This interface defines a translator from DB to the desired output format.
 */
class csIDBTranslator : public nsISupports 
{

public:

    /**
     * Always gets caled after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;

    /**
     * GetSupportedContentType - get content type this dbtranslator supports
     *
     * @param aContentType  - the content type, allocated by plugin, freed by server
     * @result NS_OK if successful
     */
    NS_IMETHOD GetSupportedContentType(char ** aContentType, PRInt32 * aReturnCode) = 0;

    /**
     * Translate from DB format to MIME type
     *
     * @param aComponents  - cal_comparray to print out.   
                             cal_comparray is a struct containing 
                             arrays of calprops, events, todos, etc. 
     * @param anErrorList  - list of errors for each calendar
     * @param aPrevErrorList  - list of errors for earlier commands
     * @param aSortFormat  - a sorting format
     * @param pProtStream  - protstream to write to
     * @result NS_OK if successful
     */
    NS_IMETHOD Translate(cal_comparray * aComponents, cal_miscinfo * pMiscInfo, array_t * anErrorList, array_t * aPrevErrorList, cal_compfmt * pCompFmt,
                         char * aSortFormat, struct protstream * pProtStream,
                         PRInt32 * aReturnCode) = 0;

    /**
     * Translate from DB format to MIME type given format string of properties to emit
     *
     * @param aComponents  - cal_comparray to print out.   
                             cal_comparray is a struct containing 
                             arrays of calprops, events, todos, etc. 
     * @param anErrorList  - list of errors for each calendar
     * @param aPrevErrorList  - list of errors for earlier commands
     * @param aSortFormat  - a sorting format
     * @param propFmtString  - a format string following Julian convention
     * @param pProtStream  - protstream to write to
     * @result NS_OK if successful
     */
    NS_IMETHOD TranslatePropFmt(cal_comparray * aComponents, cal_miscinfo * pMiscInfo, array_t * anErrorList, array_t * aPrevErrorList, cal_compfmt * pCompFmt, 
                                char * aSortFormat, char * propFmtString, struct protstream * pProtStream,
                                PRInt32 * aReturnCode) = 0;

};

#define CS_IDBTRANSLATOR_IID                       \
{ /* fc0fd860-cec1-11d3-9ead-00105ae811b7 */         \
    0xfc0fd860,                                      \
    0xcec1,                                          \
    0x11d3,                                          \
    {0x9e, 0xad, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


#endif /* csIDBTranslator_h___ */
