[
  {
    blockid="main";
    help=ug_mailgroup_main;
    layout=[border];
    custom=com.netscape.management.msgserv.ug.MailGroupControl;
    localvar=
    {
      .settings.title="Settings";
      .owners.title="Owners";
      .descriptions.title="Descriptions";
      .emailonlymembers.title="Email-Only Members";
      .access.title="Access";
      .restrictions.title="Restrictions";
      //.actions.title="Actions";
      .moderator.title="Moderators";
      .listjoinability.items=[Closed, Local, World];
      .listjoinability.labels=["Closed",
                               "Open to local users",
                               "Open to all users"];
      .joinlocaltype.items=[DN, RFC822, MOG];
      .joinlocaltype.labels=["Local members with all LDAP privileges",
                             "Email-only members",
                             "Member of group"];
      .membervisibility.items=[Closed, Member, Local, World];
      .membervisibility.labels=["Closed",
                                "Allowed for list members only",
                                "Allowed for local users",
                                "Allowed for all users"];
      .primaddr.text="*Primary email address:";
      .primaddr.hint="Primary email address:";
      .altaddrs.text="Alternative email addresses:";
      .errsto.text="Errors to: (Enter email address)";
      .errsto.hint="Errors to:";
      .hostname.text="Messaging server hostname:";
      .hostname.hint="Messaging server hostname:";
      .owners.text="Mail list owners:";
      .desccomments.text="Descriptive comments:";
      .url.text="URL for additional information:";
      .url.hint="URL for additional information:";
      .dyncriteria.text="Dynamic criteria for email-only membership:";
      .emailonly.text="Members with email-only membership:";
      .membership.text="List membership is:";
      .joinas.text="Local users can join this list as:";
      .viewlist.text="Viewing of list members is:";
      .searchlist.text="When users search for mailing lists:";
      .hidelist.text="Hide this list from end-user queries";
      .allowedsenders.text="Allowed senders:";
      .anyone.text="Anyone";
      .anyoneinlist.text="Anyone in the mailing list";
      .anyoneinfollowlist.text="Anyone in the following list";
      /*
      .smtpauth.text="Only allow senders with SMTP Authentication";
      .allowpassword.text="Only allow messages with the following password:";
      .password.text="Password:";
      .again.text="Password (again):";
      */ //Commented as it is not supported in IMS 5.0 MTA
      .senderdomains.text="Allowed sender domains:";
      .maxsize.text="Maximum message size (in bytes):";
      .maxsize.hint="Maximum message size:";
      /*
      .whenrejected.text="When message to list is rejected:";
      */
      .sendtomod.text="Send message to the moderator(s)";
      .listmods.text="List moderators:";
      /*
      .sendreply.text="Send the following reply to the sender";
      .includeorig.text="Include original message with reply";
      .reply.text="Reply text:";
      */ //Commented as it is not supported in IMS 5.0 MTA
      .dnbut.text="Search";
      .testbut.text="Test";
      .required.text="* Indicates a required field";
      .entryunique.error="The specified value already exists in the list. Please enter a different value.";
    };
    content=
    [
      {
        ctrl=tabbedpane;
        id=mailgrouptabs;
        content=
        [
          {
            ctrl=pane;
            title=$.settings.title;
            help=ug_mailgroup_settings;
            layout=[ybox];
            border=[empty,8,8,8,8];
            content=
            [
              {
                ctrl=label;
                id=primlabel;
                text=$.primaddr.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=text;
                label=primlabel;
                val=$mail;
                validate=[com.netscape.management.msgserv.util.ValidEMailAddress,true];
                errhint=$.primaddr.hint;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=altlabel;
                text=$.altaddrs.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=table;
                label=altlabel;
                id=stdtable;
                addui=altdlg;
                addtext=$g.addbutton.text;
                edittext=$g.editbutton.text;
                deltext=$g.deletebutton.text;
                editui=altdlg;
                showedit=true;
                stdtable=true;
                val=$mailalternateaddress;
                delimiter=" ";
                visiblerows=3;
                columns=
                [
                  {
                    varname=altaddr;
                    unique=$.entryunique.error;
                  }
                ]
              },
              {
                ctrl=hglue;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=errtolabel;
                text=$.errsto.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=text;
                label=errtolabel;
                val=$mgrperrorsto;
                validate=[com.netscape.management.msgserv.util.ValidEMailAddress,true];
                errhint=$.errsto.hint;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=hostlabel;
                text=$.hostname.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=text;
                label=hostlabel;
                val=$mailhost;
                validate=[com.netscape.management.msgserv.util.ValidFQDN,true];
                errhint=$.hostname.hint;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                text=$.required.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=vstrut;
              }
            ]
          },
          {
            ctrl=pane;
            title=$.owners.title;
            help=ug_mailgroup_owners;
            layout=[ybox];
            border=[empty,8,8,8,8];
            content=
            [
              {
                ctrl=label;
                id=ownlabel;
                text=$.owners.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=table;
                label=ownlabel;
                id=ownertable;
                addui=owndlg;
                addtext=$g.addbutton.text;
                edittext=$g.editbutton.text;
                deltext=$g.deletebutton.text;
                editui=owndlg;
                showedit=true;
                val=$owner;
                visiblerows=5;
                buttonsat=south;
                columns=
                [
                  {
                    varname=ownval;
                  }
                ],
		        buttons=
		        [
		          {
		            text=$.dnbut.text;
		            cmd=".dn.search";
		          }
		        ]
              },
              {
                ctrl=vstrut;
              }
            ]
          },
          {
            ctrl=pane;
            title=$.descriptions.title;
            help=ug_mailgroup_descriptions;
            layout=[ybox];
            border=[empty,8,8,8,8];
            content=
            [
              {
                ctrl=label;
                id=desclabel;
                text=$.desccomments.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=textarea;
                label=desclabel;
                val=$multilinedescription;
              },
              {
                ctrl=hglue;
              },
              {
                ctrl=vstrut;
              }
              /*
              ,
              {
                ctrl=label;
                id=urllabel;
                text=$.url.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=text;
                label=urllabel;
                val=$labeleduri;
                validate=[com.netscape.management.msgserv.util.ValidURL,true];
                errhint=$.url.hint;
              },
              {
                ctrl=vstrut;
              }
              */
            ]
          },
          {
            ctrl=pane;
            title=$.emailonlymembers.title;
            help=ug_mailgroup_members;
            layout=[ybox];
            border=[empty,8,8,8,8];
            content=
            [
              {
                ctrl=label;
                id=dynlabel;
                text=$.dyncriteria.text;
                wrap=$g.label.size5;
              },
              {
                ctrl=table;
                label=dynlabel;
                id=urltable;
                addui=urldlg;
                addtext=$g.addbutton.text;
                edittext=$g.editbutton.text;
                deltext=$g.deletebutton.text;
                editui=urldlg;
                showedit=true;
                val=$mgrpdeliverto;
                visiblerows=2;
                columns=
                [
                  {
                    varname=urlval;
                  }
                ],
		        buttons=
		        [
		          {
		            text=$.testbut.text;
		            cmd=".url.test";
		            type=edit;
		          }
		        ]
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=rfc822label;
                text=$.emailonly.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=table;
                label=rfc822label;
                id=stdtable;
                addui=rfc822dlg;
                addtext=$g.addbutton.text;
                edittext=$g.editbutton.text;
                deltext=$g.deletebutton.text;
                editui=rfc822dlg;
                showedit=true;
                stdtable=true;
                delimiter=" ";
                val=$mgrprfc822mailmember;
                visiblerows=7;
                columns=
                [
                  {
                    varname=rfc822addr;
                    unique=$.entryunique.error;
                  }
                ]
              },
              {
                ctrl=vstrut;
              }
            ]
          },
          /*
          {
            ctrl=pane;
            title=$.access.title;
            layout=[ybox];
            border=[empty,8,8,8,8];
            content=
            [
              {
                ctrl=label;
                id=joinlabel;
                text=$.membership.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=togglepane;
                id=listjoinabilityctrl;
                label=joinlabel;
                style=radio;
                items=$.listjoinability.items;
                labels=$.listjoinability.labels;
                group=listjoinabilitygroup;
                val=$mgmanjoinability;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=locallabel;
                text=$.joinas.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=togglepane;
                id=joinlocaltypectrl;
                label=locallabel;
                style=radio;
                items=$.joinlocaltype.items;
                labels=$.joinlocaltype.labels;
                group=joinlocaltypegroup;
                val=$mgmanjoinlocaltype;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=vislabel;
                text=$.viewlist.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=togglepane;
                id=membervisibilityctrl;
                label=vislabel;
                style=radio;
                items=$.membervisibility.items;
                labels=$.membervisibility.labels;
                group=membervisibilitygroup;
                val=$mgmanmembervisibility;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=searchlabel;
                text=$.searchlist.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=togglepane;
                id=listvisibilityctrl;
                label=searchlabel;
                text=$.hidelist.text;
                val=$mgmanhidden;
              },
              {
                ctrl=vstrut;
              }
            ]
          },
          */
          {
            ctrl=pane;
            title=$.restrictions.title;
            help=ug_mailgroup_restrictions;
            layout=[ybox];
            border=[empty,8,8,8,8];
            content=
            [
              {
                ctrl=label;
                id=senderlabel;
                text=$.allowedsenders.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=pane;
                content=
                [
                  {
                    ctrl=rigid;
                  },
                  {
                    ctrl=togglepane;
                    id=senderanyonectrl;
                    label=senderlabel;
                    text=$.anyone.text;
                    group=sendergroup;
                    style=radio;
                    val=$mgrpallowedbroadcaster.anyone;
                  }
                ]
              },
              {
                ctrl=pane;
                content=
                [
                  {
                    ctrl=rigid;
                  },
                  {
                    ctrl=togglepane;
                    id=sendermlistctrl;
                    label=senderlabel;
                    text=$.anyoneinlist.text;
                    group=sendergroup;
                    style=radio;
                    val=$mgrpallowedbroadcaster.mlist;
                  }
                ]
              },
              {
                ctrl=togglepane;
                id=senderlistctrl;
                label=senderlabel;
                text=$.anyoneinfollowlist.text;
                group=sendergroup;
                style=radio;
                val=$mgrpallowedbroadcaster.slist;
                content=
                [
                  {
                    ctrl=table;
                    id=sendertable;
                    addui=senderdlg;
                    addtext=$g.addbutton.text;
                    edittext=$g.editbutton.text;
                    deltext=$g.deletebutton.text;
                    editui=senderdlg;
                    showedit=true;
                    val=$mgrpallowedbroadcaster;
                    visiblerows=5;
                    buttonsat=south;
                    columns=
                    [
                      {
                        varname=senderval;
                      }
                    ],
    		        buttons=
    		        [
    		          {
    		            text=$.dnbut.text;
    		            cmd=".dn.search";
    		            type=add;
    		          }
    		        ]
                  },
                  {
                    ctrl=vstrut;
                  }
                ]
              },
              {
                ctrl=vstrut;
              },
              /*
              {
                ctrl=pane;
                content=
                [
                  {
                    ctrl=rigid;
                  },
                  {
                    ctrl=togglepane;
                    id=smtpauthctrl;
                    text=$.smtpauth.text;
                    val=$mgrpbroadcasterpolicy.smtp;
                  }
                ]
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=togglepane;
                id=passwdctrl;
                text=$.allowpassword.text;
                val=$mgrpbroadcasterpolicy.pwd;
                content=
                [
                  {
                    ctrl=label;
                    id=newpswdlabel;
                    text=$.password.text;
                    wrap=$g.label.size3;
                  },
                  {
                    ctrl=password;
                    label=newpswdlabel;
                    val=$mgrppassword.new;
                  },
                  {
                    ctrl=vstrut;
                  },
                  {
                    ctrl=label;
                    id=confpswdlabel;
                    text=$.again.text;
                    wrap=$g.label.size3;
                  },
                  {
                    ctrl=password;
                    label=confpswdlabel;
                    val=$mgrppassword.again;
                  },
                  {
                    ctrl=vstrut;
                  }
                ]
              },
              {
                ctrl=vstrut;
              },
              */
              {
                ctrl=label;
                id=domlabel;
                text=$.senderdomains.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=table;
                label=domlabel;
                id=stdtable;
                addui=domdlg;
                addtext=$g.addbutton.text;
                edittext=$g.editbutton.text;
                deltext=$g.deletebutton.text;
                editui=domdlg;
                showedit=true;
                stdtable=true;
                delimiter=" ";
                val=$mgrpalloweddomain;
                visiblerows=3;
                columns=
                [
                  {
                    varname=domaddr;
                    unique=$.entryunique.error;
                  }
                ]
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=maxlabel;
                text=$.maxsize.text;
                wrap=$g.label.size3;
              },
              {
                ctrl=text;
                label=maxlabel;
                val=$mgrpmsgmaxsize;
                validate=com.netscape.management.msgserv.util.ValidNumeric;
                errhint=$.maxsize.hint;
              },
              {
                ctrl=vstrut;
              }
            ]
          },
          {
            ctrl=pane;
            //title=$.actions.title;
            title=$.moderator.title;
            help=ug_mailgroup_rejactions;
            layout=[ybox];
            border=[empty, 8, 8, 8, 8];
            content=
            [
              {
                ctrl=pane;
                layout=[ybox];
                content=
                [
                /*
                  {
                    ctrl=label;
                    id=rejectlabel;
                    text=$.whenrejected.text;
                    wrap=$g.label.size3;
                  },
                */
                  {
                    /*
                    ctrl=togglepane;
                    id=rejmodctrl;
                    label=rejectlabel;
                    text=$.sendtomod.text;
                    val=$mgrpmsgrejectaction.tomoderator;
                    */
                    ctrl=pane;
                    layout=[ybox];
                    content=
                    [
                      {
                        ctrl=label;
                        id=modlabel;
                        text=$.listmods.text;
                        wrap=$g.label.size3;
                      },
                      {
                        ctrl=table;
                        label=modlabel;
                        id=modtable;
                        addui=moddlg;
                        addtext=$g.addbutton.text;
                        edittext=$g.editbutton.text;
                        deltext=$g.deletebutton.text;
                        editui=moddlg;
                        showedit=true;
                        val=$mgrpmoderator;
                        visiblerows=3;
                        buttonsat=south;
                        columns=
                        [
                          {
                            varname=modval;
                          }
                        ],
                        buttons=
		        [
		          {
		            text=$.dnbut.text;
		            cmd=".dn.search";
		            type=add;
		          }
		        ]
                      },
                      {
                        ctrl=vstrut;
                      }
                    ]
                  },
                  {
                    ctrl=vstrut;
                  }
                  /*,
                  {
                    ctrl=togglepane;
                    id=bouncectrl;
                    label=rejectlabel;
                    text=$.sendreply.text;
                    val=$mgrpmsgrejectaction.reply;
                    content=
                    [
                      {
                        ctrl=pane;
                        content=
                        [
                          {
                            ctrl=rigid;
                          },
                          {
                            ctrl=togglepane;
                            id=replyctrl;
                            text=$.includeorig.text;
                            val=$mgrpmsgrejectaction.inclmsg;
                          }
                        ]
                      },
                      {
                        ctrl=vstrut;
                      },
                      {
                        ctrl=label;
                        id=rejecttextlabel;
                        text=$.reply.text;
                        wrap=$g.label.size3;
                      },
                      {
                        ctrl=switchboard;
                        id=replytextctrl;
                        switchborder=false;
                        switchalign=right;
                        switch=
                        [
                          {
                            ctrl=choice;
                            id=rejectlang;
                            items=$g.usrlang.items;
                            labels=$g.usrlang.labels;
                            sendmodified=false;
                          }
                        ];
                        content=
                        [
                          {
                            ctrl=textarea;
                            id=rejecttext;
                            label=rejecttextlabel;
                          },
                          {
                            ctrl=hglue;
                          }
                        ]
                      }
                    ]
                  }
                  */
                ]
              },
              {
                ctrl=vstrut;
              }
            ]
          }
        ]
      }
    ]
  },
  {
    blockid=altdlg;
    help=ug_mailgroup_altdlg;
    localvar=
    {
      /* translate this block */
      .label.text="Enter alternative email address for the mailing list:";
      .altaddr.hint="Alternative email address:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            /* Dummy control to make dialog bigger */
            ctrl=label;
            text=" ";
            wrap=$g.label.size5;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=label;
                id=altlabel;
                wrap=$g.label.size1;
                text=$.label.text;
              },
              {
                ctrl=text;
                label=altlabel;
                val=$altaddr;
                validate=[com.netscape.management.msgserv.util.ValidAltAddress,false];
                errhint=$.altaddr.hint;
                focus=true;
              }
            ]
          }
        ]
      }
    ]
  },
  {
    blockid=rfc822dlg;
    help=ug_mailgroup_rfc822dlg;
    localvar=
    {
      /* translate this block */
      .label.text="Enter user's email address:";
      .emailonly.hint="Email address:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            /* Dummy control to make dialog bigger */
            ctrl=label;
            text=" ";
            wrap=$g.label.size5;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=label;
                id=rfc822label;
                wrap=$g.label.size1;
                text=$.label.text;
              },
              {
                ctrl=text;
                label=rfc822label;
                val=$rfc822addr;
                validate=[com.netscape.management.msgserv.util.ValidEMailAddress,false];
                errhint=$.emailonly.hint;
                focus=true;
              }
            ]
          }
        ]
      }
    ]
  },
  {
    blockid=domdlg;
    help=ug_mailgroup_domdlg;
    localvar=
    {
      /* translate this block */
      .label.text="Enter a domain name:";
      .domaddr.hint="Domain name:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            /* Dummy control to make dialog bigger */
            ctrl=label;
            text=" ";
            wrap=$g.label.size5;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=label;
                id=domlabel;
                wrap=$g.label.size1;
                text=$.label.text;
              },
              {
                ctrl=text;
                label=domlabel;
                val=$domaddr;
                validate=[com.netscape.management.msgserv.util.ValidDomain,false];
                errhint=$.domaddr.hint;
                focus=true;
              }
            ]
          }
        ]
      }
    ]
  },
  {
    blockid=owndlg;
    help=ug_mailgroup_owndlg;
    localvar=
    {
      /* translate this block */
      .label.owntext="Enter list owner's DN:";
      .owndn.hint="Owner's DN:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            /* Dummy control to make the dialog bigger */
            ctrl=label;
            text=" ";
            wrap=$g.label.size5;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=label;
                id=ownlabel;
                wrap=$g.label.size1;
              },
              {
                ctrl=text;
                id=owntext;
                label=ownlabel;
                val=$ownval;
                validate=[com.netscape.management.msgserv.util.ValidDN,false];
                errhint=$.owndn.hint;
                focus=true;
              }
            ]
          }
        ]
      }
    ]
  },
  {
    blockid=senderdlg;
    help=ug_mailgroup_senderdlg;
    localvar=
    {
      /* translate this block */
      .label.sendtext="Enter sender's DN or email address:";
      .dn.text="DN";
      .emailaddr.text="Email address";
      .sender.hint="Sender's DN or email address:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            ctrl=label;
            id=senderlabel;
            wrap=$g.label.size3;
          },
          {
            ctrl=vstrut;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=togglepane;
                id=dnctrl;
                text=$.dn.text;
                group=entrygroup;
                label=senderlabel;
                style=radio;
                val=$entry.dn;
              },
              {
                ctrl=hstrut;
              },
              {
                ctrl=togglepane;
                id=emailctrl;
                text=$.emailaddr.text;
                group=entrygroup;
                label=senderlabel;
                style=radio;
                val=$entry.email;
              }
            ]
          },
          {
            ctrl=text;
            id=sendertext;
            label=senderlabel;
            val=$senderval;
            validate=[com.netscape.management.msgserv.util.ValidEMailDN,false];
            errhint=$.sender.hint;
            focus=true;
          }
        ]
      }
    ]
  },
  {
    blockid=moddlg;
    help=ug_mailgroup_moddlg;
    localvar=
    {
      /* translate this block */
      .label.modtext="Enter moderator's DN or email address:";
      .dn.text="DN";
      .emailaddr.text="Email address";
      .moderator.hint="Moderator's DN or email address:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            ctrl=label;
            id=modlabel;
            wrap=$g.label.size3;
          },
          {
            ctrl=vstrut;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=togglepane;
                id=dnctrl;
                text=$.dn.text;
                group=entrygroup;
                label=modlabel;
                style=radio;
                val=$entry.dn;
              },
              {
                ctrl=hstrut;
              },
              {
                ctrl=togglepane;
                id=emailctrl;
                text=$.emailaddr.text;
                group=entrygroup;
                label=modlabel;
                style=radio;
                val=$entry.email;
              }
            ]
          },
          {
            ctrl=text;
            id=modtext;
            label=modlabel;
            val=$modval;
            validate=[com.netscape.management.msgserv.util.ValidEMailDN,false];
            errhint=$.moderator.hint;
            focus=true;
          }
        ]
      }
    ]
  },
  {
    blockid=urldlg;
    help=ug_mailgroup_urldlg;
    localvar=
    {
      /* translate this block */
      .urlbut.text="Construct";
      .label.urltext="Enter a LDAP search URL:";
      .ldapurl.hint="LDAP search URL:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[ybox];
        content=
        [
          {
            /* Dummy control to make the dialog bigger */
            ctrl=label;
            text=" ";
            wrap=$g.label.size5;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=label;
                id=urllabel;
                wrap=$g.label.size1;
              },
              {
                ctrl=text;
                id=urltext;
                label=urllabel;
                val=$urlval;
                validate=[com.netscape.management.msgserv.util.ValidLDAPURL,false];
                errhint=$.ldapurl.hint;
                focus=true;
              }
            ]
          },
          {
            ctrl=vstrut;
          },
          {
            ctrl=pane;
            content=
            [
              {
                ctrl=pane;
                content=
                [
                  {
                    ctrl=label;
                    text=" ";
                    wrap=$g.label.size1;
                  },
                  {
                    ctrl=button;
                    id=urlbutton;
                    text=$.urlbut.text;
                    cmd=".url.generate";
                  },
                  {
                    ctrl=hglue;
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  {
    blockid=testdlg;
    help=ug_mailgroup_testdlg;
    localvar=
    {
      /* translate this block */
      .label.testtext="Dynamic criteria:";
      .label.resulttext="Members list:";
    };
    content=
    [
      {
        ctrl=pane;
        layout=[border];
        content=
        [
          {
            ctrl=pane;
            constraint=north;
            layout=[ybox];
            content=
            [
              {
                ctrl=label;
                id=testlabel;
                text=$.label.testtext;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=text;
                id=testtext;
                editable=false;
                val=$testval;
                maxwidth=-1;
              },
              {
                ctrl=vstrut;
              },
              {
                ctrl=label;
                id=resultlabel;
                text=$.label.resulttext;
              },
              {
                ctrl=vstrut;
              }
            ]
          },
          {
            ctrl=pane;
            layout=[border];
            id=resultpane;
            constraint=center;
          }
        ]
      }
    ]
  }
]
