
#ifndef _INCLUDED_gap_reader
#define _INCLUDED_gap_reader

#include "GDisp.h"
#include "ASock.h"

typedef struct gap_reader_struct gap_reader_t;


gap_reader_t *gap_reader_new(ASock *asock,
			     GDisp *gdisp,
			     void (*recv_cb)(void *ctx, char *buf, unsigned int len),
			     void *recv_ctx,
			     void (*error)(void *ctx, int rc),
			     void *ctx);

void gap_reader_delete(gap_reader_t *reader);

void gap_reader_unrecv(gap_reader_t *reader, char *buf, unsigned int len);

#endif /* _INCLUDED_gap_reader */
