
/*
 * ENS monitoring API
 *
 * Copyright 2000 Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _INCLUDED_ensmon
#define _INCLUDED_ensmon

#ifdef _WIN32
#define __export __declspec(dllexport)
#else /* #ifdef _WIN32 */
#define __export
#endif /* #ifdef _WIN32 */

#ifdef __cplusplus
extern "C" {
#endif


/**
 * Contacts ens, issue a subscription, publish an event matching this
 * subscription and wait for the notification to received.  Return 
 * successfully if the notification is received.  fail if the notification
 * is not received before the specified timeout or is some other error
 * occurred.
 *
 * @param	host	ens host to monitor
 *
 * @param	port	ens listening port
 *
 * @param	timeout	how long to wait for a response
 *
 * @return	0 if the ens service is responding
 *		>0 if timed out
 *		<0 some other error
 *
 */ 
__export int ens_ping(const char *host,
		      unsigned short port,
		      unsigned int timeout);

    
#ifdef __cplusplus
}
#endif

#endif /* _INCLUDED_ensmon */

