/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.UITools;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.page.ISpinListener;
import com.netscape.page.SpinControl;
import com.netscape.page.SpinEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

class TimePicker
extends JPanel
implements SuiConstants {
    TimeField hourField;
    TimeField minuteField;
    TimeField secondField;
    AmPmTimeField ampmField;
    TimeField activeField;
    Calendar calendar;
    Border emptyBorder = BorderFactory.createEmptyBorder(1, 6, 1, 6);

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getHour() {
        return this.calendar.get(10);
    }

    public int getHourOfDay() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public boolean isAM() {
        return this.calendar.get(9) == 0;
    }

    public TimePicker(Calendar calendar) {
        this.calendar = calendar;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createCompoundBorder(UITools.createLoweredBorder(), BorderFactory.createEmptyBorder(1, 3, 1, 3)));
        this.hourField = new HourTimeField();
        this.hourField.setHorizontalAlignment(4);
        this.activeField = this.hourField;
        this.minuteField = new TimeField(12);
        this.minuteField.setHorizontalAlignment(0);
        this.secondField = new TimeField(13);
        this.ampmField = new AmPmTimeField();
        GridBagUtil.constrain((Container)jPanel, (Component)this.hourField, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
        JLabel jLabel = new JLabel(":");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 3));
        GridBagUtil.constrain((Container)jPanel, (Component)jLabel, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)3, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)jPanel, (Component)this.minuteField, (int)2, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
        jLabel = new JLabel(":");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 3));
        GridBagUtil.constrain((Container)jPanel, (Component)jLabel, (int)3, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)3, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)jPanel, (Component)this.secondField, (int)4, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)jPanel, (Component)this.ampmField, (int)5, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)0, (int)0);
        SpinControl spinControl = new SpinControl(jPanel);
        spinControl.addSpinListener(new TimeSpinListener());
        GridBagUtil.constrain((Container)this, (Component)spinControl, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)0, (int)0);
        GridBagUtil.constrain((Container)this, (Component)new JLabel(), (int)2, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)0, (int)0);
        this.updateFields();
    }

    private int getIntFromString(String string) {
        Integer n = new Integer(string);
        return n;
    }

    private void updateFields() {
        int n = this.calendar.get(10);
        if (n == 0) {
            n = 12;
        }
        this.hourField.setText(String.valueOf(n));
        this.minuteField.setText(this.getZeroPrefixedString(this.calendar.get(12)));
        this.secondField.setText(this.getZeroPrefixedString(this.calendar.get(13)));
        this.ampmField.setAmPm(this.calendar.get(9));
    }

    private String getZeroPrefixedString(int n) {
        String string = String.valueOf(n);
        if (n < 10) {
            string = "0" + string;
        }
        return string;
    }

    class TimeSpinListener
    implements ISpinListener {
        TimeSpinListener() {
        }

        public void actionUp(SpinEvent spinEvent) {
            int n = TimePicker.this.activeField.getCalendarFieldID();
            if (n == 9) {
                TimePicker.this.calendar.add(11, 12);
            } else {
                TimePicker.this.calendar.roll(TimePicker.this.activeField.getCalendarFieldID(), true);
            }
            TimePicker.this.updateFields();
        }

        public void actionDown(SpinEvent spinEvent) {
            int n = TimePicker.this.activeField.getCalendarFieldID();
            if (n == 9) {
                TimePicker.this.calendar.add(11, -12);
            } else {
                TimePicker.this.calendar.roll(TimePicker.this.activeField.getCalendarFieldID(), false);
            }
            TimePicker.this.updateFields();
        }
    }

    class HourTimeField
    extends TimeField {
        public HourTimeField() {
            super(11);
        }

        public void setText(String string) {
            if (string.equals("0")) {
                super.setText("12");
            } else {
                super.setText(string);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            String string = this.getText();
            if (string != null && string.length() > 0) {
                if (string.equals("12") && TimePicker.this.isAM()) {
                    string = "0";
                }
                TimePicker.this.calendar.set(this.getCalendarFieldID(), TimePicker.this.getIntFromString(string));
            }
            TimePicker.this.updateFields();
        }
    }

    class AmPmTimeField
    extends TimeField {
        public AmPmTimeField() {
            super(9);
        }

        public void setAmPm(int n) {
            if (n == 0) {
                this.setText("AM");
            } else {
                this.setText("PM");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            String string = this.getText();
            if (string != null && string.length() > 0) {
                int n = 0;
                if (string.equalsIgnoreCase("pm")) {
                    if (TimePicker.this.calendar.get(11) < 12) {
                        n = 12;
                    }
                } else if (TimePicker.this.calendar.get(11) >= 12) {
                    n = -12;
                }
                TimePicker.this.calendar.add(11, n);
            }
            TimePicker.this.updateFields();
        }
    }

    class TimeField
    extends JTextField
    implements FocusListener {
        int fieldID;

        public TimeField(int n) {
            super(2);
            this.fieldID = n;
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(true);
            this.addFocusListener(this);
        }

        public int getCalendarFieldID() {
            return this.fieldID;
        }

        public void focusGained(FocusEvent focusEvent) {
            TimePicker.this.activeField = (TimeField)focusEvent.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
            String string = this.getText();
            if (string != null && string.length() > 0) {
                TimePicker.this.calendar.set(this.getCalendarFieldID(), TimePicker.this.getIntFromString(this.getText()));
            }
            TimePicker.this.updateFields();
        }
    }
}

