/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.AbstractEditor;
import com.netscape.page.AttrValue;
import com.netscape.page.Debug;
import com.netscape.page.Layout;
import com.netscape.page.PageUI;
import com.netscape.page.PropDialog;
import com.netscape.page.QSortString;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PageUtil {
    public static final Integer INTEGER_0 = new Integer(0);
    public static final Float FLOAT_0 = new Float(0.0f);
    public static final Float FLOAT_05 = new Float(0.5f);
    public static final Boolean BOOLEAN_TRUE = new Boolean(true);
    public static final Boolean BOOLEAN_FALSE = new Boolean(false);
    private static final Integer DEFAULT_WINDOW_INSET = new Integer(12);
    public static int BUTTON_MIN = 24;
    public static int TEXTFIELD_MIN = 26;
    public static int COMBO_MIN = 30;
    public static int[] LIST_MIN = new int[]{26, 16};
    public static int BUTTON_MAX = 60;
    public static int TEXTFIELD_MAX = 72;
    public static int COMBO_MAX = 100;
    public static int[] LIST_MAX = new int[]{98, 24};
    public static Hashtable SPRING_TABLE;
    private static Frame _sharedFrame;
    private static String _errorTitle;
    private static int[] _bitMasks;
    private static boolean canAccessEventQueue;
    private static boolean eventQueueTested;
    public static final int BUTTON_WIDTH_INCREMENT = 18;
    public static final int HELP_BUTTON_SPACE = 18;

    public static void placeWindow(Component component, Component component2) {
        Dimension dimension = component2.getSize();
        Dimension dimension2 = component.getSize();
        if (component.isVisible()) {
            Point point = component.getLocationOnScreen();
            int n = dimension2.width - dimension.width;
            int n2 = dimension2.height - dimension.height;
            component2.setLocation(n / 2 + point.x, n2 / 2 + point.y);
        }
    }

    public static void placeWindow(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width - dimension.width;
        int n2 = dimension2.height - dimension.height;
        component.setLocation(n / 2 % n, n2 / 2 % n);
    }

    public static Window getTopLevelWindow(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        for (container = component.getParent(); !(container instanceof Window) && container != null; container = container.getParent()) {
        }
        if (container instanceof Window) {
            return (Window)container;
        }
        return null;
    }

    public static PropDialog getPropDialog(Component component) {
        PropDialog propDialog = null;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof PropDialog)) continue;
            propDialog = (PropDialog)container;
            break;
        }
        return propDialog;
    }

    public static Frame getRootFrame(Component component) {
        Container container;
        if (component == null) {
            return _sharedFrame;
        }
        for (container = component.getParent(); !(container instanceof Frame) && container != null; container = container.getParent()) {
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return _sharedFrame;
    }

    public static String getErrorTitle() {
        if (_errorTitle == null) {
            _errorTitle = (String)PageUI.getGlobalAttr("g.error.title");
        }
        return _errorTitle;
    }

    public static boolean emptyString(String string) {
        return string == null || "".equals(string);
    }

    public static int[] sortStrings(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return new QSortString().sort(stringArray);
    }

    public static String upperCaseAt(String string, int n) {
        char[] cArray = string.toCharArray();
        cArray[n] = Character.toUpperCase(cArray[n]);
        return new String(cArray);
    }

    public static final Hashtable createUITable(Object[] objectArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Hashtable) {
                    String string;
                    PageUI pageUI = new PageUI((Hashtable)objectArray[i]);
                    if (null == pageUI || (string = pageUI.getBlockID()) == null) continue;
                    hashtable.put(string, pageUI);
                    hashtable.put(string + ":file", objectArray[i]);
                    continue;
                }
                Debug.println("PageUtil::createUITable: Incorrect input format");
            }
        }
        return hashtable;
    }

    public static void addHashEntries(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            hashtable2.put(k, v);
        }
    }

    public static final void containerSetEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                componentArray[i].setEnabled(bl);
                PageUtil.containerSetEnabled((Container)componentArray[i], bl);
                continue;
            }
            componentArray[i].setEnabled(bl);
        }
    }

    public static int getUnitX() {
        return 3;
    }

    public static int getUnitY() {
        return 3;
    }

    public static void stepSize(JComponent jComponent, int n, int n2) {
        int n3;
        Dimension dimension = jComponent.getPreferredSize();
        int n4 = 8 * PageUtil.getUnitY();
        for (n3 = n * PageUtil.getUnitX(); dimension.width > n3; n3 += 8 * PageUtil.getUnitX()) {
        }
        jComponent.setMinimumSize(new Dimension(n3, n4));
        jComponent.setPreferredSize(new Dimension(n3, n4));
        int n5 = jComponent.getMaximumSize().width;
        if (n2 >= n) {
            n5 = n2 * PageUtil.getUnitX();
        }
        jComponent.setMaximumSize(new Dimension(n5, n4));
    }

    public static void stepSize(JComponent jComponent, int[] nArray, int[] nArray2) {
        int n;
        Dimension dimension = jComponent.getPreferredSize();
        int n2 = nArray[0] * PageUtil.getUnitX();
        int n3 = nArray[1] * PageUtil.getUnitY();
        int n4 = nArray2[0] * PageUtil.getUnitX();
        int n5 = nArray2[1] * PageUtil.getUnitY();
        n4 = n2 > n4 ? n2 : n4;
        n5 = n3 > n5 ? n3 : n5;
        int n6 = n3;
        for (n = n2; dimension.width > n; n += 8 * PageUtil.getUnitX()) {
        }
        while (dimension.height > n6) {
            n6 += 8 * PageUtil.getUnitY();
        }
        n = n > n4 ? n4 : n;
        n6 = n6 > n5 ? n5 : n6;
        jComponent.setMinimumSize(new Dimension(n, n6));
        jComponent.setPreferredSize(new Dimension(n, n6));
    }

    public static Border windowInsets() {
        int n = 9;
        int n2 = 9;
        Hashtable hashtable = PageUI.getGlobalAttrs();
        if (hashtable != null) {
            Layout layout = new Layout(hashtable);
            AttrValue attrValue = layout.getIntTag("g.window.inset.h", DEFAULT_WINDOW_INSET);
            n2 = (Integer)attrValue.getValue();
            attrValue = layout.getIntTag("g.window.inset.v", DEFAULT_WINDOW_INSET);
            n = (Integer)attrValue.getValue();
        }
        return new EmptyBorder(n, n2, n, n2);
    }

    public static Component componentSpacer() {
        int n = 6;
        Hashtable hashtable = PageUI.getGlobalAttrs();
        if (hashtable != null) {
            Layout layout = new Layout(hashtable);
            AttrValue attrValue = layout.getIntTag("g.comp.space");
            n = (Integer)attrValue.getValue();
        }
        return Box.createRigidArea(new Dimension(n, n));
    }

    public static Calendar internalToCalendar(String string) {
        try {
            String string2 = string.substring(0, 4);
            int n = Integer.valueOf(string2);
            string2 = string.substring(4, 6);
            int n2 = Integer.valueOf(string2) - 1;
            string2 = string.substring(6, 8);
            int n3 = Integer.valueOf(string2);
            string2 = string.substring(8, 10);
            int n4 = Integer.valueOf(string2);
            string2 = string.substring(10, 12);
            int n5 = Integer.valueOf(string2);
            string2 = string.substring(12, 14);
            int n6 = Integer.valueOf(string2);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(n, n2, n3, n4, n5, n6);
            return gregorianCalendar;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String calendarToLocale(Calendar calendar) {
        if (calendar != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, Locale.getDefault());
            return dateFormat.format(calendar.getTime());
        }
        return null;
    }

    public static String internalToLocale(String string) {
        Calendar calendar = PageUtil.internalToCalendar(string);
        if (calendar != null) {
            return PageUtil.calendarToLocale(calendar);
        }
        return string;
    }

    public static void bitsToToggles(String string, AbstractEditor[] abstractEditorArray) {
        try {
            int n = Integer.parseInt(string);
            for (int i = 0; i < abstractEditorArray.length; ++i) {
                if (abstractEditorArray[i] == null) continue;
                if ((n & _bitMasks[i]) != 0) {
                    abstractEditorArray[i].setValue(BOOLEAN_TRUE);
                    continue;
                }
                abstractEditorArray[i].setValue(BOOLEAN_FALSE);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static String togglesToBits(AbstractEditor[] abstractEditorArray) {
        int n = 0;
        for (int i = 0; i < abstractEditorArray.length; ++i) {
            boolean bl;
            if (abstractEditorArray[i] == null || !(bl = ((Boolean)abstractEditorArray[i].getValue()).booleanValue())) continue;
            n += _bitMasks[i];
        }
        return String.valueOf(n);
    }

    public static boolean checkModified(AbstractEditor[] abstractEditorArray) {
        boolean bl = false;
        for (int i = 0; i < abstractEditorArray.length; ++i) {
            if (abstractEditorArray[i] == null) continue;
            bl = bl || abstractEditorArray[i].isModified();
        }
        return bl;
    }

    public static void dumpStack() {
        int[] nArray = new int[1];
        nArray[2] = 0;
        System.exit(0);
    }

    public static final synchronized EventQueue getEventQueue() {
        if (!eventQueueTested) {
            try {
                EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                canAccessEventQueue = true;
            }
            catch (Exception exception) {
                canAccessEventQueue = false;
            }
            eventQueueTested = true;
        }
        if (eventQueueTested && canAccessEventQueue) {
            return Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        return null;
    }

    public static JPanel createHorizontalButtonBar(JButton[] jButtonArray, int n, int n2, int n3, boolean bl) {
        if (jButtonArray == null || jButtonArray.length == 0) {
            return null;
        }
        if (n >= jButtonArray.length || n2 >= jButtonArray.length || n3 >= jButtonArray.length) {
            return null;
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < jButtonArray.length; ++i) {
            n4 = Math.max(n4, jButtonArray[i].getPreferredSize().width);
            n5 = Math.max(n5, jButtonArray[i].getPreferredSize().height);
        }
        if (n4 <= 0 || n5 <= 0) {
            return null;
        }
        if (n4 % 18 != 0) {
            n4 = 18 * (n4 / 18 + 1);
        }
        Dimension dimension = new Dimension(n4, n5);
        for (int i = 0; i < jButtonArray.length; ++i) {
            jButtonArray[i].setMinimumSize(dimension);
            jButtonArray[i].setPreferredSize(dimension);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = jButtonArray.length - 1;
        if (n >= 0) {
            gridBagConstraints.insets = new Insets(0, 18, 0, 0);
            jPanel.add((Component)jButtonArray[n], gridBagConstraints);
            --gridBagConstraints.gridx;
        }
        if (n2 >= 0) {
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            jPanel.add((Component)jButtonArray[n2], gridBagConstraints);
            --gridBagConstraints.gridx;
        }
        if (n3 >= 0) {
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            jPanel.add((Component)jButtonArray[n3], gridBagConstraints);
            --gridBagConstraints.gridx;
        }
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        for (int i = jButtonArray.length - 1; i >= 0; --i) {
            if (i == n || i == n2 || i == n3) continue;
            jPanel.add((Component)jButtonArray[i], gridBagConstraints);
            --gridBagConstraints.gridx;
        }
        JPanel jPanel2 = null;
        if (bl) {
            jPanel2 = new JPanel();
            jPanel2.setBorder(new EmptyBorder(0, 0, 0, 0));
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(PageUtil.getSEPARATOR());
        }
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new EmptyBorder(0, 0, 0, 0));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        if (jPanel2 != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel3.add((Component)jPanel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        return jPanel3;
    }

    public static JComponent getSEPARATOR() {
        JSeparator jSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return new Dimension(0, 2);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, 2);
            }
        };
        return jSeparator;
    }

    static {
        _bitMasks = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        canAccessEventQueue = false;
        eventQueueTested = false;
        _sharedFrame = new Frame();
    }
}

