/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.IResourceEditorPage;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.msgserv.ug.MailGroupPage;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.page.AttrNotFoundException;
import com.netscape.page.PageUI;
import com.netscape.page.PageUtil;
import com.netscape.page.TABBEDPANEeditor;
import com.netscape.page.TOGGLEPANEeditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class ResourceEditorMailGroupPage
extends JPanel
implements IResourceEditorPage,
Observer {
    static final String REJECTLANG = "rejectlang";
    static final String REJECTTEXT = "rejecttext";
    static final String REJECTVAR = "mgrpmsgrejecttext;lang-";
    private String ID;
    private String _displayName;
    boolean _isModified = false;
    boolean _isReadOnly = false;
    boolean _isEnable = true;
    boolean _createNewGroup;
    ResourcePageObservable _observable;
    PageUI _editorUI;
    Hashtable _uiTable;
    MailGroupPage _pageModel;
    TABBEDPANEeditor _mailGroupTabs;

    public ResourceEditorMailGroupPage() {
        super(true);
        this.setLayout(new BorderLayout());
    }

    public void update(Observable observable, Object object) {
        this._observable = (ResourcePageObservable)observable;
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._observable = resourcePageObservable;
        Object[] objectArray = MsgUtil.getLayout("mailgroup");
        if (objectArray != null) {
            this._uiTable = PageUtil.createUITable(objectArray);
            this._editorUI = (PageUI)this._uiTable.get("main");
            if (this._editorUI != null) {
                this.add((Component)this._editorUI, "Center");
            }
            this._mailGroupTabs = (TABBEDPANEeditor)this._editorUI.getCtrlByName("mailgrouptabs");
            this.ID = "Mail";
            this._pageModel = new MailGroupPage(resourcePageObservable, resourceEditor);
            this._pageModel.setUITable(this._uiTable);
            TOGGLEPANEeditor tOGGLEPANEeditor = (TOGGLEPANEeditor)this._editorUI.getCtrlByName("senderanyonectrl");
            Hashtable hashtable = this._editorUI.getLayoutAttrs();
            this._displayName = (String)hashtable.get(".displayname.text");
            if (PageUtil.emptyString(this._displayName)) {
                this._displayName = this.ID;
            }
        }
    }

    public String getID() {
        return this.ID;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        this._editorUI.saveAll();
        return this._pageModel.saveAttributes(resourcePageObservable);
    }

    public boolean afterSave(ResourcePageObservable resourcePageObservable) throws Exception {
        return true;
    }

    public void clear() {
    }

    public void reset() {
    }

    public void setDefault() {
    }

    public boolean isModified() {
        return true;
    }

    public void setModified(boolean bl) {
        this._isModified = bl;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public void setEnable(boolean bl) {
        this._isEnable = bl;
    }

    public boolean isComplete() {
        block8: {
            String string = this._editorUI.validateAll();
            if (!PageUtil.emptyString(string)) {
                JOptionPane.showMessageDialog(PageUtil.getRootFrame(this), string, MsgUtil.getString("error", "title"), 0);
                return false;
            }
            this._editorUI.saveAll();
            try {
                string = (String)this._pageModel.getAttribute("mail");
                if (PageUtil.emptyString(string)) {
                    MsgUtil.dspMsg("error", "mailmissing", "Primary email address is required.", MsgUtil.getString("error", "title"), 0);
                    return false;
                }
                ConsoleInfo consoleInfo = this._observable.getConsoleInfo();
                String string2 = this._observable.getDN();
                LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
                if (lDAPConnection == null) break block8;
                try {
                    String[] stringArray = new String[]{"mail"};
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(consoleInfo.getUserBaseDN(), 2, "(mail=" + string + ")", stringArray, false);
                    while (lDAPSearchResults.hasMoreElements()) {
                        LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                        String string3 = lDAPEntry.getDN();
                        if (string2 != null && string2.equalsIgnoreCase(string3)) continue;
                        MsgUtil.dspMsg("error", "addressexist", "The primary email address specified already exist in the directory.", MsgUtil.getString("error", "title"), 0);
                        return false;
                    }
                }
                catch (LDAPException lDAPException) {
                    JOptionPane.showMessageDialog(PageUtil.getRootFrame(this), MsgUtil.getString("error", "ldaperror") + lDAPException.getLDAPResultCode(), MsgUtil.getString("error", "title"), 0);
                    return false;
                }
            }
            catch (AttrNotFoundException attrNotFoundException) {
                MsgUtil.dspMsg("error", "mailmissing", "Primary email address is required.", MsgUtil.getString("error", "title"), 0);
                return false;
            }
        }
        Boolean bl = (Boolean)this._pageModel.getAttrValue("mgrpallowedbroadcaster.slist");
        if (bl.booleanValue() && !this._pageModel.checkAllowedSenders()) {
            MsgUtil.dspMsg("error", "noallowedsender", "Please specify the allowed senders.", MsgUtil.getString("error", "title"), 0);
            return false;
        }
        return true;
    }

    public void help() {
        MsgUtil.help(this._mailGroupTabs.getHelpToken());
    }

    public String getDisplayName() {
        return this._displayName;
    }
}

