/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.gap;

import com.iplanet.ens.gap.GapMsg;
import com.iplanet.ens.gap.GapMsgListener;
import com.iplanet.ens.gap.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class GapReader
implements Runnable {
    private boolean _keepGoing;
    private GapMsgListener _listener;
    private Vector _messages;
    private Vector _listeners;
    private Reader _inputReader;
    private InputStream _inputStream;
    private Exception _exception;
    OutputStream _log;
    String _encoding;
    public int MAX_LINE_LENGTH;

    public GapReader(InputStream inputStream, String string, OutputStream outputStream) {
        block3: {
            this._keepGoing = true;
            this.MAX_LINE_LENGTH = 1024;
            this._messages = new Vector();
            this._listeners = new Vector();
            this._log = outputStream;
            this._inputStream = inputStream;
            this._encoding = string;
            try {
                if (string != null) {
                    this._inputReader = new InputStreamReader(inputStream, string);
                    break block3;
                }
                this._inputReader = new InputStreamReader(inputStream);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    public String readLine() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = (char)this._inputStream.read()) != '\r') {
            stringBuffer.append(c);
        }
        this._inputStream.read();
        if (this._log != null) {
            this._log.write(("<< " + stringBuffer.toString() + "\n").getBytes());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block15: {
            this._keepGoing = true;
            try lbl-1000:
            // 2 sources

            {
                while (true) {
                    block16: {
                        if (!this._keepGoing) {
                            return;
                        }
                        var1_1 = new GapMsg(this.readLine());
                        var2_3 = var1_1.getLen();
                        if (var2_3 > 0) {
                            var3_5 /* !! */  = new byte[var2_3];
                            var4_7 = 0;
                            var5_9 = this._inputStream.read(var3_5 /* !! */ , var4_7, var2_3);
                            if (var5_9 == -1) {
                                throw new ParseException("Error in parsing payload: numBytes read = " + var5_9 + " len = " + var2_3);
                            }
                            var6_10 = var2_3 - var5_9;
                            var4_7 += var5_9;
                            while (true) {
                                if (var6_10 <= 0) {
                                    if (var6_10 == 0) break;
                                    throw new ParseException("Error in parsing payload: numBytes = " + var5_9 + " numLeft = " + var6_10 + " len = " + var2_3);
                                }
                                var5_9 = this._inputStream.read(var3_5 /* !! */ , var4_7, var6_10);
                                if (var5_9 == -1) {
                                    throw new ParseException("Error in parsing payload: numBytes = " + var5_9 + " numLeft = " + var6_10 + " len = " + var2_3);
                                }
                                var6_10 -= var5_9;
                                var4_7 += var5_9;
                            }
                            var7_11 = this._encoding != null ? new String(var3_5 /* !! */ , this._encoding) : new String(var3_5 /* !! */ );
                            var1_1.setPayload(var7_11);
                        }
                        if (this._listeners.isEmpty()) break block16;
                        var3_5 /* !! */  = (byte[])this._listeners.elements();
                        if (true) ** GOTO lbl48
                    }
                    v0 = this;
                    var3_5 /* !! */  = (byte[])v0;
                    // MONITORENTER : v0
                    this._messages.addElement(var1_1);
                    this.notifyAll();
                    // MONITOREXIT : var3_5 /* !! */ 
                    continue;
                    break;
                }
            }
            catch (Exception var1_2) {
                this._exception = var1_2;
                var1_2.printStackTrace();
                if (this._listeners.isEmpty()) break block15;
                var2_4 = this._listeners.elements();
                if (true) ** GOTO lbl53
            }
            do {
                var4_8 = (GapMsgListener)var3_5 /* !! */ .nextElement();
                var4_8.onMessage(var1_1);
lbl48:
                // 2 sources

            } while (var3_5 /* !! */ .hasMoreElements());
            ** while (true)
            do {
                var3_6 = (GapMsgListener)var2_4.nextElement();
                var3_6.onMessage(null);
lbl53:
                // 2 sources

            } while (var2_4.hasMoreElements());
        }
        var2_4 = this;
        // MONITORENTER : var2_4
        this._keepGoing = false;
        this.notifyAll();
        // MONITOREXIT : var2_4
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        GapReader gapReader = this;
        synchronized (gapReader) {
            this._keepGoing = false;
            this.notifyAll();
        }
    }

    public synchronized GapMsg readMsg() throws InterruptedException, ParseException, IOException {
        if (this._keepGoing) {
            if (this._messages.isEmpty()) {
                this.wait();
            }
            if (!this._messages.isEmpty()) {
                GapMsg gapMsg = (GapMsg)this._messages.firstElement();
                this.releaseMsg(gapMsg);
                return gapMsg;
            }
        }
        return null;
    }

    public synchronized GapMsg readMsg(int n) throws InterruptedException, ParseException, IOException {
        if (this._keepGoing) {
            if (this._messages.isEmpty()) {
                this.wait(n);
            }
            if (!this._messages.isEmpty()) {
                return (GapMsg)this._messages.firstElement();
            }
        }
        return null;
    }

    protected void releaseMsg(GapMsg gapMsg) {
        this._messages.remove(gapMsg);
    }

    protected void addListener(GapMsgListener gapMsgListener) {
        this._listeners.addElement(gapMsgListener);
    }
}

