#if !defined(__PMDF_ERR_H)

#define __PMDF_ERR_H 1


/*
 *  PMDF_ERR Error Messages
 */


/*
 *  'PMDF Version 6.1'
 */


/*
 *  Informational messages
 */

#define PMDF__AOK         0x0A9C800B /* Address !AD is okay */
#define PMDF__MOK         0x0A9C8013 /* Message is okay */
#define PMDF__OK          0x0A9C801B /* Successful, normal completion */
#define PMDF__BADSTKELE   0x0A9C8023 /* Bad stack element found, internal error */
#define PMDF__TEXT        0x0A9C802B /* !AD */

/*
 *  Warning messages
 */

#define PMDF__FILIMPTER   0x0A9C8030 /* File data terminates improperly */
#define PMDF__ERAOPNERR   0x0A9C8038 /* ERA temp file "!AD" open error, ERA components not processed */
#define PMDF__UNKERAACT   0x0A9C8040 /* Unknown ERA action for address "!AD", address ignored */
#define PMDF__HEANOTKNW   0x0A9C8048 /* Header type "!AD" is not known */
#define PMDF__HEANOTFND   0x0A9C8050 /* Header line "!AD" not found */
#define PMDF__DUPENTRY    0x0A9C8058 /* Duplicate entries not allowed: !AD */
#define PMDF__CANOPNDAT   0x0A9C8060 /* Cannot open database to add entry */
#define PMDF__DATACCERR   0x0A9C8068 /* Error accessing database to add entry */
#define PMDF__ENTWONFIT   0x0A9C8070 /* Entry will not fit in database */
#define PMDF__STRTRU      0x0A9C8078 /* String truncated */

/*
 *  Error messages
 */

#define PMDF__HOST        0x0A9C8082 /* Illegal host/domain in address !AD */
#define PMDF__NDEL        0x0A9C808A /* Couldn't deliver */
#define PMDF__NO          0x0A9C8092 /* Basic NO */
#define PMDF__AGN         0x0A9C809A /* Try again later */
#define PMDF__NOOP        0x0A9C80A2 /* No operation */
#define PMDF__PUNT        0x0A9C80AA /* Bad MM package error code */
#define PMDF__MSGWRTERR   0x0A9C80B2 /* Error writing message text to MAIL for delivery */
#define PMDF__UNKFUNC     0x0A9C80BA /* Foreign MAIL protocol invoked with unknown function !UL */
#define PMDF__ERAFORMERR  0x0A9C80C2 /* Error in ERA form build, status = !UL */
#define PMDF__ERARESPERR  0x0A9C80CA /* Error in ERA response build, status = !UL */
#define PMDF__ERASHRERR   0x0A9C80D2 /* Cannot load routines from ERA shareable image */
#define PMDF__UNSFORMERR  0x0A9C80DA /* Cannot present necessary forms within this user agent */
#define PMDF__HEADERNOTNEEDED 0x0A9C80E2 /* Foreign message not needed; address rejected as irrelevant */
#define PMDF__MESFILERR   0x0A9C80EA /* Error in accessing intermediate message file */
#define PMDF__FCRT        0x0A9C80F2 /* File create error */
#define PMDF__FOPN        0x0A9C80FA /* File open error */
#define PMDF__EOF         0x0A9C8102 /* End of file */
#define PMDF__NOADDRESSES 0x0A9C810A /* No addresses specified */
#define PMDF__ALLADDRBAD  0x0A9C8112 /* All addresses specified are bad; message not sent */
#define PMDF__TIME        0x0A9C811A /* Timeout error */
#define PMDF__STRTRUERR   0x0A9C8122 /* String truncated */
#define PMDF__INVSTRDES   0x0A9C812A /* Invalid string descriptor */
#define PMDF__INSVIRMEM   0x0A9C8132 /* Insufficient virtual memory */
#define PMDF__BADITEMADDR 0x0A9C813A /* Bad item list item_address */
#define PMDF__BADITEMCODE 0x0A9C8142 /* Bad item list item_code */
#define PMDF__MISGNSTART  0x0A9C814A /* PMDF_FAX_START or PMDF_PRT_START item missing */
#define PMDF__INCOMPITMS  0x0A9C8152 /* Incompatible item codes; PMDF_USER and PMDF_ENV_FROM */

/*
 *  Fatal messages
 */

#define PMDF__INTSTKOVR   0x0A9C815C /* Internal PMDF stack has overflowed */
#define PMDF__STKEMPTY    0x0A9C8164 /* Internal PMDF stack has been exhausted */
#define PMDF__GETFILERR   0x0A9C816C /* Error getting file parameter off command line */
#define PMDF__FATERRLIB   0x0A9C8174 /* Fatal error in VMS Run Time Library */

/*
 *  Warning messages
 */

#define PMDF__ERROPENINP  0x0A9C8178 /* Error opening file !AD for input */
#define PMDF__ERRPROCINP  0x0A9C8180 /* Error processing file !AD */
#define PMDF__ILLADDRESS  0x0A9C8188 /* Illegal address -- !AD */
#define PMDF__ERRFDLPROC  0x0A9C8190 /* Error in FDL processing for !AD */

/*
 *  Error messages
 */

#define PMDF__FORMNOTALLOWED 0x0A9C819A /* Popup forms are not allowed in this environment */
#define PMDF__BADITEMSIZE 0x0A9C81A2 /* Bad item list item_size */

/*
 *  Fatal messages
 */

#define PMDF__NOFILESFND  0x0A9C81AC /* No files found */
#define PMDF__FILOPNERRS  0x0A9C81B4 /* File open errors occurred; message not sent */
#define PMDF__ADDRERRS    0x0A9C81BC /* Some addresses in error; message not sent */

/*
 *  Informational messages
 */

#define PMDF__READRECORDS 0x0A9C81C3 /* Read !AD (!UL record!%S) */
#define PMDF__READBLOCKS  0x0A9C81CB /* Read !AD (!UL block!%S) */
#define PMDF__MESSAGESENT 0x0A9C81D3 /* Message sent: !UL file!%S, !UL line!%S, !UL recipient!%S */
#define PMDF__MESSAGEID   0x0A9C81DB /* Message ID !AD */
#define PMDF__DONE        0x0A9C81E3 /* Operation done */
#define PMDF__DOK         0x0A9C81EB /* Operation okay but delayed */
#define PMDF__HOK         0x0A9C81F3 /* Host processing okay */

/*
 *  Error messages
 */

#define PMDF__NET         0x0A9C81FA /* Network error */
#define PMDF__BHST        0x0A9C8202 /* Foreign host error */
#define PMDF__DHST        0x0A9C820A /* Host is dead */
#define PMDF__NIO         0x0A9C8212 /* Temporary network I/O problem */
#define PMDF__NS          0x0A9C821A /* Temporary nameserver failure */
#define PMDF__FIO         0x0A9C8222 /* File I/O error */
#define PMDF__LIO         0x0A9C822A /* Local I/O error */
#define PMDF__LOCK        0x0A9C8232 /* Resource locked */
#define PMDF__HUH         0x0A9C823A /* Could not parse request */
#define PMDF__NCMD        0x0A9C8242 /* No such command */
#define PMDF__PARM        0x0A9C824A /* Bad command parameter */
#define PMDF__UCMD        0x0A9C8252 /* Command not implemented */
#define PMDF__PARSE       0x0A9C825A /* Error parsing address !AD */
#define PMDF__MECH        0x0A9C8262 /* Bad mechanism or path */
#define PMDF__BAD         0x0A9C826A /* Basic no */
#define PMDF__PROT        0x0A9C8272 /* Protocol error */
#define PMDF__RPLY        0x0A9C827A /* Bad reply code */
#define PMDF__NAUTH       0x0A9C8282 /* User authorization failure */
#define PMDF__USER        0x0A9C828A /* No such user or alias in address !AD */
#define PMDF__AMBPARAM    0x0A9C8292 /* Ambiguous parameter name !AD specified */
#define PMDF__UNKPARAM    0x0A9C829A /* Unknown parameter name !AD specified */
#define PMDF__CANSETPARAM 0x0A9C82A2 /* Cannot set parameter !AD to value !AD */
#define PMDF__ENTLONGFORW 0x0A9C82AA /* Entry too long to fit in forwarding database */
#define PMDF__CANOPNFORW  0x0A9C82B2 /* Forwarding database does not exist or cannot be opened */
#define PMDF__ERRACCFORW  0x0A9C82BA /* Error accessing forwarding database */
#define PMDF__PHAERRFORW  0x0A9C82C2 /* Phase error in accessing forwarding database */
#define PMDF__NOFORWSET   0x0A9C82CA /* No forwarding address is set for this user */
#define PMDF__ENTLONGPROF 0x0A9C82D2 /* Entry too long to fit in profile database */
#define PMDF__CANOPNPROF  0x0A9C82DA /* Profile database does not exist or cannot be opened */
#define PMDF__ERRACCPROF  0x0A9C82E2 /* Error accessing profile database */
#define PMDF__PHAERRPROF  0x0A9C82EA /* Phase error in accessing profile database */
#define PMDF__NOCHANNEL   0x0A9C82F2 /* Cannot find channel */
#define PMDF__FORWDELETED 0x0A9C82F9 /* Forwarding address for user !AD has been deleted */
#define PMDF__FORWADDED   0x0A9C8301 /* Forwarding entry !AD added for user !AD */
#define PMDF__NOFORWADDR  0x0A9C8309 /* User !AD has no forwarding set */
#define PMDF__FORWSETTO   0x0A9C8311 /* User !AD has forwarding set to !AD */

/*
 *  Informational messages
 */

#define PMDF__VERSION     0x0A9C831B /* PMDF version is PMDF !AD!/!_!AD running OpenVMS !AD !AD!/!_PMDF_SHARE_LIBRARY ver */
#define PMDF__SUCCESS     0x0A9C8323 /* Last operation successful */

/*
 *  Warning messages
 */

#define PMDF__CANTUPDAT   0x0A9C8328 /* Cannot update database */
#define PMDF__READSTRSEEN 0x0A9C8330 /* readstring operator seen; wrapped PostScript may be bad */

/*
 *  Error messages
 */

#define PMDF__FILALROPE   0x0A9C833A /* File is already open */
#define PMDF__ERRDUROPE   0x0A9C8342 /* Error during OPEN */
#define PMDF__FILNOTFOU   0x0A9C834A /* File not found */
#define PMDF__INVFILSYN   0x0A9C8352 /* Invalid filename syntax */
#define PMDF__ACCMETINC   0x0A9C835A /* ACCESS_METHOD specified is incompatible with file */
#define PMDF__RECLENINC   0x0A9C8362 /* RECORD_LENGTH specified is inconsistent with file */
#define PMDF__RECTYPINC   0x0A9C836A /* RECORD_TYPE specified is inconsistent with file */
#define PMDF__ORGSPEINC   0x0A9C8372 /* ORGANIZATION specified is inconsistent with file */
#define PMDF__INVKEYDEF   0x0A9C837A /* Invalid key definition */
#define PMDF__KEYDEFINC   0x0A9C8382 /* KEY(n) definition is inconsistent with this file */
#define PMDF__KEYNOTDEF   0x0A9C838A /* KEY(n) is not defined in this file */
#define PMDF__INVRECLEN   0x0A9C8392 /* Invalid record length of */
#define PMDF__TEXREQSEQ   0x0A9C839A /* Textfiles require sequential organization, access */
#define PMDF__FILNAMREQ   0x0A9C83A2 /* FILE_NAME required for this HISTORY or DISPOSITION */
#define PMDF__FILALRCLO   0x0A9C83AA /* File is already closed */
#define PMDF__ERRDURCLO   0x0A9C83B2 /* Error during CLOSE */
#define PMDF__AMBVALENU   0x0A9C83BA /* Ambiguous value given for an enumerated type */
#define PMDF__INVSYNENU   0x0A9C83C2 /* Invalid syntax for an enumerated value */
#define PMDF__INVSYNINT   0x0A9C83CA /* Invalid syntax for an integer value */
#define PMDF__INVSYNREA   0x0A9C83D2 /* Invalid syntax for a real value */
#define PMDF__INVSYNUNS   0x0A9C83DA /* Invalid syntax for an unsigned value */
#define PMDF__NOTVALTYP   0x0A9C83E2 /* Invalid value given for this type */
#define PMDF__ERRDURPRO   0x0A9C83EA /* Error during prompting */
#define PMDF__INVSYNBIN   0x0A9C83F2 /* Invalid syntax for binary value */
#define PMDF__INVSYNHEX   0x0A9C83FA /* Invalid syntax for hexadecimal value */
#define PMDF__INVSYNOCT   0x0A9C8402 /* Invalid syntax for octal value */
#define PMDF__ERRDURWRI   0x0A9C840A /* Error during WRITELN */
#define PMDF__INVFIESPE   0x0A9C8412 /* Invalid field specification for WRITE */
#define PMDF__LINTOOLON   0x0A9C841A /* Line is too long, exceeded record length */
#define PMDF__NEGWIDDIG   0x0A9C8422 /* Negative Width or Digits specification not allowed */
#define PMDF__WRIINVENU   0x0A9C842A /* WRITE of an invalid enumerated value */
#define PMDF__KEYVALINC   0x0A9C8432 /* Key value incompatible with this file''s key */
#define PMDF__KEYDUPNOT   0x0A9C843A /* Key field duplication is not allowed */
#define PMDF__KEYCHANOT   0x0A9C8442 /* Key field change is not allowed */
#define PMDF__CURCOMUND   0x0A9C844A /* Current component undefined for DELETE or UPDATE */
#define PMDF__FAIGETLOC   0x0A9C8452 /* Failed to GET locked component */
#define PMDF__DELNOTALL   0x0A9C845A /* DELETE not allowed on a sequential file */
#define PMDF__ERRDURDEL   0x0A9C8462 /* Error during DELETE */
#define PMDF__ERRDURFIN   0x0A9C846A /* Error during FIND or FINDK */
#define PMDF__ERRDURGET   0x0A9C8472 /* Error during GET */
#define PMDF__ERRDURPUT   0x0A9C847A /* Error during PUT */
#define PMDF__ERRDURRES   0x0A9C8482 /* Error during RESET or RESETK */
#define PMDF__ERRDURREW   0x0A9C848A /* Error during REWRITE */
#define PMDF__ERRDURTRU   0x0A9C8492 /* Error during TRUNCATE */
#define PMDF__ERRDURUNL   0x0A9C849A /* Error during UNLOCK */
#define PMDF__ERRDURUPD   0x0A9C84A2 /* Error during UPDATE */
#define PMDF__FILNOTDIR   0x0A9C84AA /* File is not opened for direct access */
#define PMDF__FILNOTGEN   0x0A9C84B2 /* File is not in Generation mode */
#define PMDF__FILNOTINS   0x0A9C84BA /* File is not in Inspection mode */
#define PMDF__FILNOTKEY   0x0A9C84C2 /* File is not opened for keyed access */
#define PMDF__FILNOTOPE   0x0A9C84CA /* File is not open */
#define PMDF__FILNOTSEQ   0x0A9C84D2 /* File is not sequential organization */
#define PMDF__FILNOTTEX   0x0A9C84DA /* File is not a textfile */
#define PMDF__GENNOTALL   0x0A9C84E2 /* Generation mode is not allowed for a READONLY file */
#define PMDF__GETAFTEOF   0x0A9C84EA /* GET attempted after end-of-file */
#define PMDF__INSNOTALL   0x0A9C84F2 /* Inspection mode is not allowed on a WRITEONLY file */
#define PMDF__INVARGPAS   0x0A9C84FA /* Invalid argument to Pascal Run-Time Library */
#define PMDF__LINVALEXC   0x0A9C8502 /* LINELIMIT value exceeded */
#define PMDF__REWNOTALL   0x0A9C850A /* REWRITE is not allowed for a shared file */
#define PMDF__RESNOTALL   0x0A9C8512 /* RESET is not allowed on an unopened internal file */
#define PMDF__TRUNOTALL   0x0A9C851A /* TRUNCATE is not allowed for a shared file */
#define PMDF__UPDNOTALL   0x0A9C8522 /* UPDATE not allowed on sequential organization file */
#define PMDF__ERRDUREXT   0x0A9C852A /* Error during EXTEND */
#define PMDF__EXTNOTALL   0x0A9C8532 /* EXTEND is not allowed for a shared file */
#define PMDF__PASUNKNOWN  0x0A9C853A /* Unknown Pascal status value !UL */
#define PMDF__RPUNKNOWN   0x0A9C8542 /* Unknown RP error code !UL */

/*
 *  Fatal messages
 */

#define PMDF__INCFILNEST  0x0A9C854C /* PMDF CRDB/PTOREW include files nested too deeply */
#define PMDF__MMINITERR   0x0A9C8554 /* Cannot read PMDF configuration */
#define PMDF__INSUFPRIV   0x0A9C855C /* Insufficient privileges to perform the requested operation */
#define PMDF__NLIC        0x0A9C8564 /* Product license is invalid for present usage */
#define PMDF__NOWORLD     0x0A9C856C /* operation requires WORLD privilege */

/*
 *  Warning messages
 */

#define PMDF__NOMAPPING   0x0A9C8570 /* Cannot locate specified mapping table */

/*
 *  Error messages
 */

#define PMDF__FORCERETURN 0x0A9C857A /* Conversion result forced return of message */
#define PMDF__POPSTORE    0x0A9C8582 /* Error !UL returned from the popstore routines!/!_!AZ */
#define PMDF__CONFLICT    0x0A9C858A /* Conflicting values */
#define PMDF__IVQUAL      0x0A9C8592 /* Invalid qualifier */
#define PMDF__IVKEYW      0x0A9C859A /* Invalid keyword */
#define PMDF__IVQLOC      0x0A9C85A2 /* Invalid qualifier location */
#define PMDF__IVVALU      0x0A9C85AA /* Invalid value */
#define PMDF__MAXPARM     0x0A9C85B2 /* Too many parameters */
#define PMDF__CANDELPARAM 0x0A9C85BA /* Cannot delete parameter !AD */

/*
 *  Warning messages
 */

#define PMDF__ABSENT      0x0A9C85C0 /* Value is absent */
#define PMDF__NEGATED     0x0A9C85C8 /* Value is negated */
#define PMDF__LOCNEG      0x0A9C85D0 /* Value is negated locally */

/*
 *  Error messages
 */

#define PMDF__ENTLONGPASS 0x0A9C85DA /* Entry too long to fit in password file */
#define PMDF__CANOPNPASS  0x0A9C85E2 /* Password file does not exist or cannot be opened */
#define PMDF__ERRACCPASS  0x0A9C85EA /* Error accessing password file */
#define PMDF__PHAERRPASS  0x0A9C85F2 /* Password not in expected state in password file */
#define PMDF__NOPASSSET   0x0A9C85FA /* No password is set */
#define PMDF__PASSDELETED 0x0A9C8601 /* Password for user !AD service !AD has been deleted */
#define PMDF__PASSADDED   0x0A9C8609 /* Password entry added/replaced for user !AD service !AD */

/*
 *  Error messages
 */

#define PMDF__FORCEPOST   0x0A9C8612 /* Conversion result forced message to be sent to the postmaster */
#define PMDF__INCOMPLETE  0x0A9C861A /* Operation incomplete */
#define PMDF__CANTDELETE  0x0A9C8622 /* Cannot delete file !AD */
#define PMDF__NOFILES     0x0A9C862A /* No files match mattern !AD */
#define PMDF__FORCEASIS   0x0A9C8632 /* Conversion result forced part to be passed on as-is */
#define PMDF__FILEDELETED 0x0A9C8639 /* Deleted file !AD */
#define PMDF__DEFAULT     0x0A9C8641 /* Value defaulted */
#define PMDF__CONCAT      0x0A9C8649 /* Value concatenated */

/*
 *  Error messages
 */

#define PMDF__SIZE        0x0A9C8652 /* Exceeded storage allocation */
#define PMDF__LOCAL       0x0A9C865A /* User not local */
#define PMDF__FORCEDELETE 0x0A9C8662 /* Conversion result forced deletion of part */
#define PMDF__ERRDURWRITE 0x0A9C866A /* Error during write operation */

/*
 *  Fatal messages
 */

#define PMDF__INVMODE     0x0A9C8674 /* Invalid or nonexistant conversion mode selected */
#define PMDF__REQSTREAMMIS 0x0A9C867C /* Required stream not specified */
#define PMDF__ERRREAATT   0x0A9C8684 /* Error reading file attributes */
#define PMDF__ERRMODE     0x0A9C868C /* Error during mode conversion operation */
#define PMDF__ERRREAINP   0x0A9C8694 /* Error reading input file */

/*
 *  Warning messages
 */

#define PMDF__ERROPENOUT  0x0A9C8698 /* Error opening file !AD for output */

/*
 *  Error messages
 */

#define PMDF__BADCONTEXT  0x0A9C86A2 /* Illegal or corrupt context */
#define PMDF__FORCEHOLD   0x0A9C86AA /* Conversion result forced message to be held */

/*
 *  Informational messages
 */

#define PMDF__FORCEDISCARD 0x0A9C86B3 /* Message discard forced */

/*
 *  Warning messages
 */

#define PMDF__FILOPNERR   0x0A9C86B8 /* File open errors occurred; message sent anyway */
#define PMDF__ENCERROR    0x0A9C86C0 /* Encoding errors occured; message sent anyway */
#define PMDF__ADDRERR     0x0A9C86C8 /* Some addresses in error; message sent anyway */

/*
 *  Fatal messages
 */

#define PMDF__ENCERRORS   0x0A9C86D4 /* Encoding errors occurred; message not sent */
#define PMDF__FORCEACCEPT 0x0A9C86D9 /* Conversion result forced into message */

#endif
