/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.page.DayPicker;
import com.netscape.page.ISpinListener;
import com.netscape.page.PageUI;
import com.netscape.page.SpinControl;
import com.netscape.page.SpinEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DatePicker
extends JPanel
implements SuiConstants {
    Calendar calendar;
    JComboBox monthField = new JComboBox();
    JTextField yearField = new JTextField(8);
    SpinControl yearSpinner;
    DayPicker dayPicker;
    int oldYear = 0;

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getDay() {
        return this.dayPicker.getDay();
    }

    public DatePicker(Calendar calendar) {
        this.calendar = calendar;
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        GridBagUtil.constrain((Container)this, (Component)this.monthField, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)6, (int)6);
        GridBagUtil.constrain((Container)this, (Component)this.yearField, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)6, (int)0);
        this.yearSpinner = new SpinControl(this.yearField);
        GridBagUtil.constrain((Container)this, (Component)this.yearSpinner, (int)2, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)6, (int)0);
        this.dayPicker = new DayPicker(calendar);
        GridBagUtil.constrain((Container)this, (Component)this.dayPicker, (int)0, (int)1, (int)3, (int)1, (double)0.0, (double)0.0, (int)18, (int)1, (int)0, (int)0, (int)6, (int)0);
        Hashtable hashtable = PageUI.getGlobalAttrs();
        Object[] objectArray = (Object[])hashtable.get("g.month.labels");
        if (objectArray == null) {
            objectArray = stringArray;
        } else if (objectArray.length != 12) {
            MsgUtil.dspMsg("error", "monthlables", "Error reading month lables from global_<LANG>.properties OR global.properties file.\n Provide exactly 12 comma separated month lables for variable 'g.month.labels'.\n Using default month lables for the time being.", MsgUtil.getString("error", "title"), 0);
            objectArray = stringArray;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.monthField.addItem(objectArray[i]);
        }
        this.monthField.setSelectedIndex(calendar.get(2));
        this.yearField.setText(String.valueOf(calendar.get(1)));
        this.monthField.addActionListener(new MonthChangeListener());
        this.yearField.addFocusListener(new YearFocusListener());
        this.yearSpinner.addSpinListener(new YearSpinListener());
    }

    int getIntFromString(String string) {
        Integer n = new Integer(string);
        return n;
    }

    public void update() {
        int n = this.getYear();
        if (this.oldYear != n) {
            this.yearField.setText(String.valueOf(n));
            this.dayPicker.updatePicker();
            this.oldYear = n;
        }
    }

    class YearFocusListener
    implements FocusListener {
        YearFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            int n = DatePicker.this.getIntFromString(DatePicker.this.yearField.getText());
            if (n < 1900 || n > 9999) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                n = gregorianCalendar.get(1);
            }
            DatePicker.this.calendar.set(1, n);
            DatePicker.this.update();
        }
    }

    class YearSpinListener
    implements ISpinListener {
        YearSpinListener() {
        }

        public void actionUp(SpinEvent spinEvent) {
            DatePicker.this.calendar.add(1, 1);
            DatePicker.this.update();
        }

        public void actionDown(SpinEvent spinEvent) {
            DatePicker.this.calendar.add(1, -1);
            DatePicker.this.update();
        }
    }

    class MonthChangeListener
    implements ActionListener {
        MonthChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatePicker.this.calendar.set(2, DatePicker.this.monthField.getSelectedIndex());
            DatePicker.this.dayPicker.updatePicker();
        }
    }
}

