/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.msgserv.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.msgserv.util.MsgUtil;
import com.netscape.page.AttrNotFoundException;
import com.netscape.page.PageModel;
import com.netscape.page.PageUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class MailGroupPage
extends PageModel {
    static final String[] OBJECT_CLASSES = new String[]{"inetmailgroup", "inetmailgroupmanagement", "inetlocalmailrecipient"};
    ResourcePageObservable _observable;
    Hashtable _dataTable = new Hashtable();
    JFrame _parent;
    ConsoleInfo _consoleInfo;

    public MailGroupPage(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this.setAttributes(this._dataTable);
        this._observable = resourcePageObservable;
        this._parent = resourceEditor.getFrame();
        this._consoleInfo = resourcePageObservable.getConsoleInfo();
        this.getTextAttrs();
        this.getMultiTextAttrs();
        this.getListAttrs();
        this.getChoiceAttrs();
        this.getToggleAttrs();
    }

    public JFrame getParent() {
        return this._parent;
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }

    public void setUITable(Hashtable hashtable) {
        super.setUITable(hashtable);
    }

    public final Enumeration getMailAttributesList() {
        return this._dataTable.keys();
    }

    public Object getAttribute(String string) throws AttrNotFoundException {
        Object object = this.getAttrValue(string);
        if (object != null) {
            return object;
        }
        throw new AttrNotFoundException("Attribute not found", string);
    }

    public Object getAttrValue(String string) {
        if (this._dataTable.containsKey(string)) {
            Object v = this._dataTable.get(string);
            return v;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        this._dataTable.put(string, object);
    }

    public boolean saveAttributes(ResourcePageObservable resourcePageObservable) {
        int n;
        boolean bl = false;
        Vector vector = resourcePageObservable.get("objectclass");
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (n = 0; n < vector.size(); ++n) {
            String string = (String)vector.elementAt(n);
            vector2.addElement(string.toLowerCase());
        }
        for (n = 0; n < OBJECT_CLASSES.length; ++n) {
            if (vector2.contains(OBJECT_CLASSES[n])) continue;
            bl = true;
            vector.addElement(OBJECT_CLASSES[n]);
        }
        if (bl) {
            resourcePageObservable.replace("objectclass", vector);
        }
        if (!this.saveRequiredAttrs(resourcePageObservable)) {
            return false;
        }
        if (!this.saveTextAttrs(resourcePageObservable)) {
            return false;
        }
        if (!this.saveMultiTextAttrs(resourcePageObservable)) {
            return false;
        }
        if (!this.saveListAttrs(resourcePageObservable)) {
            return false;
        }
        if (!this.saveChoiceAttrs(resourcePageObservable)) {
            return false;
        }
        return this.saveToggleAttrs(resourcePageObservable);
    }

    public final String checkPassword() {
        String string = (String)this.getAttrValue("mgrppassword.new");
        String string2 = (String)this.getAttrValue("mgrppassword.again");
        if (PageUtil.emptyString(string)) {
            MsgUtil.dspMsg("error", "pswdmissing", "Password is required.", MsgUtil.getString("error", "title"), 0);
            return null;
        }
        if (PageUtil.emptyString(string2)) {
            MsgUtil.dspMsg("error", "pswdmismatch", "Password and confirmed password must match.", MsgUtil.getString("error", "title"), 0);
            return null;
        }
        if (!string.equals(string2)) {
            MsgUtil.dspMsg("error", "pswdmismatch", "Password and confirmed password must match.", MsgUtil.getString("error", "title"), 0);
            return null;
        }
        return string;
    }

    public final boolean checkModerators() {
        Vector vector = this.vectorToList((Vector)this.getAttrValue("mgrpmoderator"));
        return vector != null;
    }

    public final boolean checkAllowedSenders() {
        Vector vector = this.vectorToList((Vector)this.getAttrValue("mgrpallowedbroadcaster"));
        return vector != null;
    }

    final String getSingleString(String string) {
        Vector vector = this._observable.get(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        if (n > 0) {
            for (int i = 0; i < vector.size() - 1; ++i) {
                stringBuffer.append((String)vector.elementAt(i));
                stringBuffer.append(" ");
            }
            String string2 = (String)vector.lastElement();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    final Vector listToVector(String string) {
        if (PageUtil.emptyString(string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        return vector;
    }

    final Vector getVector(String string) {
        Vector vector = this._observable.get(string);
        if (vector != null && vector.size() > 0) {
            Vector vector2 = new Vector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector3 = new Vector(1);
                vector3.addElement(enumeration.nextElement());
                vector2.addElement(vector3);
            }
            return vector2;
        }
        return null;
    }

    final Vector vectorToList(Vector vector) {
        Vector vector2 = new Vector();
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                vector2.addElement(((Vector)enumeration.nextElement()).firstElement());
            }
            return vector2;
        }
        return null;
    }

    final void getTextAttrs() {
        String string = this.getSingleString("mail");
        if (null != string) {
            this._dataTable.put("mail", string);
        }
        if (null != (string = this.getSingleString("mgrperrorsto"))) {
            this._dataTable.put("mgrperrorsto", string);
        }
        if (null != (string = this.getSingleString("mailhost"))) {
            this._dataTable.put("mailhost", string);
        }
        if (null != (string = this.getSingleString("mgrpmsgmaxsize"))) {
            this._dataTable.put("mgrpmsgmaxsize", string);
        }
    }

    final void getMultiTextAttrs() {
        String string = this.getSingleString("multilinedescription");
        if (null != string) {
            this._dataTable.put("multilinedescription", MsgUtil.decodeMultiLine(string));
        }
    }

    final void getListAttrs() {
        Vector vector;
        String string = this.getSingleString("mailalternateaddress");
        if (null != string) {
            this._dataTable.put("mailalternateaddress", string);
        }
        if (null != (vector = this.getVector("owner"))) {
            this._dataTable.put("owner", vector);
        }
        if (null != (vector = this.getVector("mgrpdeliverto"))) {
            this._dataTable.put("mgrpdeliverto", vector);
        }
        if (null != (string = this.getSingleString("mgrprfc822mailmember"))) {
            this._dataTable.put("mgrprfc822mailmember", string);
        }
        boolean bl = false;
        vector = this.getVector("mgrpallowedbroadcaster");
        if (null != vector) {
            string = (String)((Vector)vector.firstElement()).firstElement();
            string = string.substring(string.indexOf(58) + 1).trim();
            this._dataTable.put("mgrpallowedbroadcaster.anyone", new Boolean(false));
            String string2 = this.getSingleString("mail");
            String string3 = this._observable.getDN();
            if (vector.size() == 1 && (string.equalsIgnoreCase(string2) || string.equalsIgnoreCase(string3))) {
                this._dataTable.put("mgrpallowedbroadcaster.mlist", new Boolean(true));
                this._dataTable.put("mgrpallowedbroadcaster.slist", new Boolean(false));
            } else {
                this._dataTable.put("mgrpallowedbroadcaster.mlist", new Boolean(false));
                this._dataTable.put("mgrpallowedbroadcaster.slist", new Boolean(true));
                this._dataTable.put("mgrpallowedbroadcaster", vector);
            }
        } else {
            this._dataTable.put("mgrpallowedbroadcaster.anyone", new Boolean(true));
            bl = true;
            this._dataTable.put("mgrpallowedbroadcaster.mlist", new Boolean(false));
            this._dataTable.put("mgrpallowedbroadcaster.slist", new Boolean(false));
        }
        string = this.getSingleString("mgrpalloweddomain");
        if (null != string) {
            this._dataTable.put("mgrpalloweddomain", string);
        }
        if (null != (vector = this.getVector("mgrpmoderator"))) {
            this._dataTable.put("mgrpmoderator", vector);
        }
    }

    final void getChoiceAttrs() {
        String string = this.getSingleString("mgmanjoinability");
        if (null != string) {
            this._dataTable.put("mgmanjoinability", string);
        } else {
            this._dataTable.put("mgmanjoinability", "NONE");
        }
        string = this.getSingleString("mgmanmembervisibility");
        if (null != string) {
            this._dataTable.put("mgmanmembervisibility", string);
        } else {
            this._dataTable.put("mgmanmembervisibility", "NONE");
        }
    }

    final void getToggleAttrs() {
        String string = this.getSingleString("mgmanhidden");
        if (null != string) {
            this._dataTable.put("mgmanhidden", new Boolean(string));
        } else {
            this._dataTable.put("mgmanhidden", new Boolean(false));
        }
    }

    final boolean saveRequiredAttrs(ResourcePageObservable resourcePageObservable) {
        try {
            String string = (String)this.getAttribute("mail");
            resourcePageObservable.replace("mail", string);
        }
        catch (AttrNotFoundException attrNotFoundException) {
            MsgUtil.dspMsg("error", "mailmissing", "Primary email address is required.", MsgUtil.getString("error", "title"), 0);
            return false;
        }
        return true;
    }

    final boolean saveTextAttrs(ResourcePageObservable resourcePageObservable) {
        String string = (String)this.getAttrValue("mgrperrorsto");
        if (!PageUtil.emptyString(string)) {
            resourcePageObservable.replace("mgrperrorsto", string);
        } else {
            resourcePageObservable.delete("mgrperrorsto", string);
        }
        string = (String)this.getAttrValue("mailhost");
        if (!PageUtil.emptyString(string)) {
            resourcePageObservable.replace("mailhost", string);
        } else {
            resourcePageObservable.delete("mailhost", string);
        }
        string = (String)this.getAttrValue("mgrpmsgmaxsize");
        if (!PageUtil.emptyString(string)) {
            resourcePageObservable.replace("mgrpmsgmaxsize", string);
        } else {
            resourcePageObservable.delete("mgrpmsgmaxsize", string);
        }
        return true;
    }

    final boolean saveMultiTextAttrs(ResourcePageObservable resourcePageObservable) {
        String string = (String)this.getAttrValue("multilinedescription");
        if (!PageUtil.emptyString(string)) {
            resourcePageObservable.replace("multilinedescription", MsgUtil.encodeMultiLine(string));
        } else {
            resourcePageObservable.delete("multilinedescription", string);
        }
        return true;
    }

    final boolean saveListAttrs(ResourcePageObservable resourcePageObservable) {
        Vector vector;
        String string = (String)this.getAttrValue("mailalternateaddress");
        if (null != string) {
            vector = this.listToVector(string);
            if (vector != null) {
                resourcePageObservable.replace("mailalternateaddress", vector);
            } else {
                resourcePageObservable.delete("mailalternateaddress");
            }
        }
        if (null != (vector = this.vectorToList((Vector)this.getAttrValue("owner")))) {
            resourcePageObservable.replace("owner", vector);
        } else {
            resourcePageObservable.delete("owner");
        }
        vector = this.vectorToList((Vector)this.getAttrValue("mgrpdeliverto"));
        if (null != vector) {
            resourcePageObservable.replace("mgrpdeliverto", vector);
        } else {
            resourcePageObservable.delete("mgrpdeliverto");
        }
        string = (String)this.getAttrValue("mgrprfc822mailmember");
        if (null != string) {
            vector = this.listToVector(string);
            if (vector != null) {
                resourcePageObservable.replace("mgrprfc822mailmember", vector);
            } else {
                resourcePageObservable.delete("mgrprfc822mailmember");
            }
        }
        Boolean bl = (Boolean)this.getAttrValue("mgrpallowedbroadcaster.anyone");
        vector = this.vectorToList((Vector)this.getAttrValue("mgrpallowedbroadcaster"));
        if (bl.booleanValue()) {
            resourcePageObservable.delete("mgrpallowedbroadcaster");
        } else {
            bl = (Boolean)this.getAttrValue("mgrpallowedbroadcaster.mlist");
            if (bl.booleanValue()) {
                string = (String)this.getAttrValue("mail");
                resourcePageObservable.replace("mgrpallowedbroadcaster", "mailto:" + string);
            } else {
                bl = (Boolean)this.getAttrValue("mgrpallowedbroadcaster.slist");
                if (bl.booleanValue()) {
                    if (vector == null) {
                        MsgUtil.dspMsg("error", "noallowedsender", "Please specify the allowed senders.", MsgUtil.getString("error", "title"), 0);
                        return false;
                    }
                    resourcePageObservable.replace("mgrpallowedbroadcaster", vector);
                }
            }
        }
        string = (String)this.getAttrValue("mgrpalloweddomain");
        if (null != string) {
            vector = this.listToVector(string);
            if (vector != null) {
                resourcePageObservable.replace("mgrpalloweddomain", vector);
            } else {
                resourcePageObservable.delete("mgrpalloweddomain");
            }
        }
        return true;
    }

    final boolean saveChoiceAttrs(ResourcePageObservable resourcePageObservable) {
        String string = (String)this.getAttrValue("mgmanjoinability");
        if (!PageUtil.emptyString(string)) {
            resourcePageObservable.replace("mgmanjoinability", string);
        }
        if (!PageUtil.emptyString(string = (String)this.getAttrValue("mgmanmembervisibility"))) {
            resourcePageObservable.replace("mgmanmembervisibility", string);
        }
        return true;
    }

    final boolean saveToggleAttrs(ResourcePageObservable resourcePageObservable) {
        Boolean bl = (Boolean)this.getAttrValue("mgmanhidden");
        resourcePageObservable.replace("mgmanhidden", bl.toString());
        Vector vector = this.vectorToList((Vector)this.getAttrValue("mgrpmoderator"));
        if (vector != null) {
            resourcePageObservable.replace("mgrpmoderator", vector);
        } else {
            resourcePageObservable.delete("mgrpmoderator");
        }
        return true;
    }
}

