function psSplit( aURI )
{
    var arrayResult = new Array( aURI, "", "" );
    var re = /[\s\"\'\\]/;
    for( var i=0; i < aURI.length; i++ )
    {
	var c = aURI.charAt(i);
	if( !re.test( c ) )
	{
	    arrayResult[0] = aURI.substring( 0, i );
	    arrayResult[1] = aURI.substring( i );
	    break;
	}
    }

    for( var i = arrayResult[1].length-1; i >= 0 ; i-- )
    {
	var c = arrayResult[1].charAt(i);
	if( !re.test( c ) )
	{
	    arrayResult[2] = arrayResult[1].substring( i + 1 );
	    arrayResult[1] = arrayResult[1].substring( 0, i + 1 );
	    break;
	}
    }

    return arrayResult;
}//psSplit()

function psGetProtocol( aURI )
{
    var i = aURI.indexOf( '://' );

    if ( i != -1 )
    {
	var protocol = aURI.substr( 0, i )
	var arrayOfStrings = protocol.split(/[^\w]/);

	if( arrayOfStrings != null && arrayOfStrings.length == 1 )
	{
	    return protocol;
	}
    }

    return -1;
}//psGetProtocol()

function psGetDefaultPort( aProtocol )
{
    var lProtocol = aProtocol.toLowerCase();

    if ( lProtocol.indexOf( 'https' ) == 0 )
    {
	return 443;
    }

    if ( lProtocol.indexOf( 'http' ) == 0 )
    {
	return 80;
    }

    return -1;
}//psGetDefaultPort()

function psGetNetworkURI( aURI )
{
    var lURI = aURI;
    var bProtocolIndex = lURI.indexOf( '://' ) + 3;
    var bSearchPart = lURI.substr( bProtocolIndex );

    //search for / or / or # in the order & take the least one
    var bIndex =  bSearchPart.indexOf( '/' );
    if ( bIndex != -1 )
    {
	bSearchPart = bSearchPart.substr( 0, bIndex );

	var bQueryIndex = bSearchPart.indexOf( '?' );
	if( bQueryIndex != -1 )
	{
	    bIndex = bQueryIndex;
	}
	else
	{
	    var bReferenceIndex = bSearchPart.indexOf( '#' )
	    if( bReferenceIndex != -1 )
	    {
		bIndex = bReferenceIndex;
	    }
	}
    }
    else
    {
	var bQueryIndex = bSearchPart.indexOf( '?' );
	if( bQueryIndex != -1 )
	{
	    bIndex = bQueryIndex;
	}
	else
	{
	    var bReferenceIndex = bSearchPart.indexOf( '#' )
	    if( bReferenceIndex != -1 )
	    {
		bIndex = bReferenceIndex;
	    }
	}
    }

    if ( bIndex != -1 )
    {
	return lURI.substr( 0, bProtocolIndex + bIndex );
    }

    return lURI;
}//psGetNetworkURI()

function psNormalizePort( aURI, aDefaultPort )
{
    var lURI = aURI;

    //absoute url
    var bDefaultPortString = ':' + aDefaultPort;
    var bNetworkURI = psGetNetworkURI( lURI );
    var bRest = lURI.substr( bNetworkURI.length );
    var bPortIndex = bNetworkURI.indexOf( bDefaultPortString );
    var bCalPortIndex = bNetworkURI.length - bDefaultPortString.length;

    if (  ( bPortIndex != -1 ) &&
	  ( bPortIndex == bCalPortIndex ) )
    {
	return bNetworkURI.substr( 0, bPortIndex ) + bRest;
    }

    return lURI;
}//psNormalizePort()