/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.xml;

import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.urlscraper.URLScraperProvider;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLProvider
extends URLScraperProvider {
    private ResourceBundle bundle = null;
    private static Map xslTransformerMap = new HashMap(10);
    private static final String EMPTY_XSL_FILENAME = "emptyXslFileName";
    private static final String XML_FETCH_ERROR = "xmlFetchError";
    private static final String XML_TRANSFOMING_ERROR = "xmlTransformingError";

    protected File getXSL(String string) throws ProviderException {
        File file = null;
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("XMLProvider.getXSL(): XSL File Name  = " + string));
        }
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("XMLProvider.getXSL(): XSL File Name  = " + string));
        }
        if (string.indexOf(58) == -1) {
            if (string.charAt(0) == '/') {
                file = super.getFile(string);
            } else {
                try {
                    file = this.getProviderContext().getTemplatePath(this.getName(), string);
                }
                catch (ProviderContextException providerContextException) {
                    throw new ProviderException("XMLProvider.getXSL(): ", (Throwable)providerContextException);
                }
                if (file != null && this.getProviderContext().isDebugMessageEnabled()) {
                    this.getProviderContext().debugMessage((Object)("XMLProvider.getXSL: the file:" + file.getName()));
                }
            }
            return file;
        }
        throw new ProviderException("XMLProvider.getXSL(): Unsupported URL type ");
    }

    protected StringBuffer getXML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        String string = this.getURL();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.substring(0, string.indexOf(58));
        if (string2.equalsIgnoreCase("http") || string2.equalsIgnoreCase("https") || string2.equalsIgnoreCase("file")) {
            try {
                stringBuffer = super.getContent(httpServletRequest, httpServletResponse);
            }
            catch (ProviderException providerException) {
                this.getProviderContext().debugError((Object)"XMLProvider:getXML(): ", (Throwable)providerException);
            }
            ResourceBundle resourceBundle = super.getResourceBundle();
            if (stringBuffer != null && !stringBuffer.equals(resourceBundle.getString("timeout"))) {
                return stringBuffer;
            }
            throw new ProviderException("XMLProvider.getXML(): Getting XML failed from source: " + string);
        }
        this.getProviderContext().debugError((Object)"XMLProvider.getXML(): Getting XML failed. Unsupported URL type");
        throw new ProviderException("XMLProvider.getXML(): Getting XML failed. Unsupported URL type");
    }

    private synchronized StringBuffer doTransform(StringBuffer stringBuffer, String string) throws ProviderException {
        StringWriter stringWriter;
        StringBuffer stringBuffer2 = null;
        Transformer transformer = null;
        try {
            transformer = this.getXslTransformer(string);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.getProviderContext().debugError((Object)"TransformerWrapperImpl.doTransform: ", (Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            this.getProviderContext().debugError((Object)"TransformerWrapperImpl.doTransform:", (Throwable)transformerException);
        }
        if (transformer != null) {
            StreamSource streamSource = new StreamSource(new StringReader(stringBuffer.toString()));
            stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            try {
                transformer.transform(streamSource, streamResult);
            }
            catch (TransformerException transformerException) {
                this.getProviderContext().debugError((Object)("XMLProvider.doTransform():Error in transforming xml: " + this.getURL()), (Throwable)transformerException);
                throw new ProviderException("XMLProvider.doTransform():Error in transforming xml.");
            }
        } else {
            this.getProviderContext().debugError((Object)("XMLProvider.doTransform():Error in getting XSL transformer: " + string));
            throw new ProviderException("XMLProvider.doTransform():Error in getting XSL transformer.");
        }
        stringBuffer2 = stringWriter.getBuffer();
        return stringBuffer2;
    }

    public StringBuffer getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getStringProperty("xslFileName");
        this.bundle = this.getResourceBundle();
        if (string == null || string.equals("")) {
            stringBuffer = stringBuffer.append(this.bundle.getString(EMPTY_XSL_FILENAME));
            return stringBuffer;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            stringBuffer2 = this.getXML(httpServletRequest, httpServletResponse);
        }
        catch (ProviderException providerException) {
            this.getProviderContext().debugError((Object)"XMLProvider.getContent():Can not get XML file.", (Throwable)providerException);
            stringBuffer = stringBuffer.append(this.bundle.getString(XML_FETCH_ERROR));
            return stringBuffer;
        }
        if (stringBuffer2 == null) {
            this.getProviderContext().debugError((Object)"XMLProvider.getContent(): Can not get XML File.");
            stringBuffer = stringBuffer.append(this.bundle.getString(XML_FETCH_ERROR));
            return stringBuffer;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)"XMLProvider.getContent(): Got XML.");
        }
        try {
            stringBuffer = this.doTransform(stringBuffer2, string);
        }
        catch (ProviderException providerException) {
            this.getProviderContext().debugError((Object)"XMLProvider.getContent():Error in XML transformation.");
            stringBuffer = stringBuffer.append(this.bundle.getString(XML_TRANSFOMING_ERROR));
        }
        return stringBuffer;
    }

    protected String getContentEncodingFromContentBytes(byte[] byArray) {
        String string;
        String string2;
        int n;
        int n2;
        String string3;
        String string4;
        int n3;
        String string5 = null;
        int n4 = byArray.length;
        int n5 = 1000;
        if (n4 < n5) {
            n5 = n4;
        }
        if ((n3 = (string4 = (string3 = new String(byArray, 0, n5)).toLowerCase()).indexOf("<?xml")) != -1 && (n2 = string4.indexOf(">", n3)) != -1 && (n = (string2 = (string = string3.substring(n3, n2)).toLowerCase()).indexOf("encoding=")) != -1) {
            int n6 = string2.indexOf("\"", n);
            int n7 = string2.indexOf("\"", n6 + 1);
            string5 = string.substring(n6 + 1, n7);
        }
        return string5;
    }

    private Transformer getXslTransformer(String string) throws TransformerConfigurationException, TransformerException {
        Object object;
        int n = PerfThreadLocalizer.mark();
        Object var3_3 = null;
        CacheEntry cacheEntry = (CacheEntry)xslTransformerMap.get(string);
        if (cacheEntry == null) {
            object = null;
            cacheEntry = new CacheEntry();
            try {
                object = this.getXSL(string);
                if (object == null) {
                    this.getProviderContext().debugError((Object)"XMLProvider.getXslTransformer():Getting XSL File failed");
                    return null;
                }
            }
            catch (ProviderException providerException) {
                this.getProviderContext().debugError((Object)"XMLProvider.getXslTransformer():Error in getting the XSLFile", (Throwable)providerException);
                return null;
            }
            cacheEntry.xslFile = (File)object;
            cacheEntry.lastModTime = -1L;
            Map map = xslTransformerMap;
            synchronized (map) {
                xslTransformerMap.put(string, cacheEntry);
            }
        }
        if (cacheEntry.lastModTime == -1L || cacheEntry.lastModTime < cacheEntry.xslFile.lastModified()) {
            object = TransformerFactory.newInstance();
            cacheEntry.xslTransformer = ((TransformerFactory)object).newTransformer(new StreamSource(cacheEntry.xslFile));
            cacheEntry.lastModTime = cacheEntry.xslFile.lastModified();
        }
        PerfThreadLocalizer.add((int)n, (String)"XMLProvider.getXslTransformer()");
        return cacheEntry.xslTransformer;
    }

    class CacheEntry {
        private Transformer xslTransformer;
        private File xslFile;
        private long lastModTime;
    }
}

