/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.urlscraper.HTMLFetcher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class URLScraperProvider
extends ProfileProviderAdapter {
    private ResourceBundle bundle = null;
    private final int CONTENT_BUFFER_SIZE = 1000;
    Hashtable cookieTable = new Hashtable();
    protected static String[][] typeTable = new String[][]{{".html", "text/html"}, {".htm", "text/html"}, {".gif", "image/gif"}, {".txt", "text/plain"}, {".jpg", "image/jpeg"}, {".xml", "text/xml"}};

    protected int getTimeout() throws ProviderException {
        return this.getIntegerProperty("timeout");
    }

    protected String getURL() throws ProviderException {
        return this.getStringProperty("url", true);
    }

    protected String getRuleSetID() throws ProviderException {
        return this.getStringProperty("urlScraperRulesetID");
    }

    protected boolean forward(String string, boolean bl, List list) {
        if (bl) {
            return true;
        }
        return list.contains(string);
    }

    public String getInputEncoding() throws ProviderException {
        return this.getStringProperty("inputEncoding");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public StringBuffer getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        StringBuffer stringBuffer = new StringBuffer();
        this.bundle = this.getResourceBundle();
        String string = this.getURL();
        String string2 = null;
        try {
            string2 = string.substring(0, string.indexOf(58));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (string2 != null && string2.equalsIgnoreCase("file")) {
            String string3 = null;
            try {
                string3 = string.substring(string.indexOf(47));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.getProviderContext().debugError((Object)"URLScraperProvider.getContent(): Unsupported URL type.");
                return stringBuffer.append(this.bundle.getString("unsupportedurl"));
            }
            try {
                return this.getFileAsBuffer(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.getProviderContext().debugError((Object)"URLScraperProvider.getContent():Unsupported Encoding.");
                return stringBuffer.append(this.bundle.getString("unsupportedencoding"));
            }
            catch (IOException iOException) {
                this.getProviderContext().debugError((Object)"URLScraperProvider.getContent():IOException received.");
                return null;
            }
        }
        HTMLFetcher hTMLFetcher = null;
        String string4 = this.getRuleSetID();
        Object object = null;
        try {
            object = new Object();
            hTMLFetcher = new HTMLFetcher(string, this, httpServletRequest, httpServletResponse, this.bundle, string4, object);
        }
        catch (MalformedURLException malformedURLException) {
            this.getProviderContext().debugError((Object)"URLScraperProvider.getContent(): ", (Throwable)malformedURLException);
            return stringBuffer.append(this.bundle.getString("unsupportedurl"));
        }
        hTMLFetcher.start();
        try {
            block34: {
                try {
                    Object object2 = object;
                    // MONITORENTER : object2
                    if (!hTMLFetcher.isFinished()) {
                        object.wait(this.getTimeout() * 1000);
                    }
                    // MONITOREXIT : object2
                    if (!hTMLFetcher.isFinished()) {
                        this.getProviderContext().debugWarning((Object)"URLScraperProvider.getContent(): fetcher did not finish!");
                        if (((ProviderAdapter)this).context.isDebugMessageEnabled()) {
                            ((ProviderAdapter)this).context.debugMessage((Object)"URLScraperprovider.getContent(): trying Again");
                        }
                        if (hTMLFetcher.isAlive()) {
                            hTMLFetcher.terminate();
                        }
                        hTMLFetcher = null;
                        try {
                            hTMLFetcher = new HTMLFetcher(string, this, httpServletRequest, httpServletResponse, this.bundle, string4, object);
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.getProviderContext().debugError((Object)"URLScraperProvider.getContent(): ", (Throwable)malformedURLException);
                            StringBuffer stringBuffer2 = stringBuffer = stringBuffer.append(this.bundle.getString("unsupportedurl"));
                            Object var14_23 = null;
                            if (hTMLFetcher.isAlive()) {
                                hTMLFetcher.terminate();
                            }
                            hTMLFetcher = null;
                            return stringBuffer2;
                        }
                        hTMLFetcher.start();
                        try {
                            Object malformedURLException = object;
                            // MONITORENTER : malformedURLException
                            if (!hTMLFetcher.isFinished()) {
                                object.wait(this.getTimeout() * 1000);
                            }
                            // MONITOREXIT : malformedURLException
                            if (!hTMLFetcher.isFinished()) {
                                this.getProviderContext().debugError((Object)"URLScraperProvider.getContent(): fetcher did not finish second time!");
                                StringBuffer stringBuffer3 = stringBuffer = stringBuffer.append(this.bundle.getString("timeout"));
                                Object var14_24 = null;
                                if (hTMLFetcher.isAlive()) {
                                    hTMLFetcher.terminate();
                                }
                                hTMLFetcher = null;
                                return stringBuffer3;
                            }
                            stringBuffer = hTMLFetcher.getContent();
                            break block34;
                        }
                        catch (InterruptedException object3) {
                            this.getProviderContext().debugError((Object)"URLScraperProvider.getContent()", (Throwable)object3);
                            StringBuffer stringBuffer2 = stringBuffer = stringBuffer.append(this.bundle.getString("timeout"));
                            Object var14_25 = null;
                            if (hTMLFetcher.isAlive()) {
                                hTMLFetcher.terminate();
                            }
                            hTMLFetcher = null;
                            return stringBuffer2;
                        }
                    }
                    stringBuffer = hTMLFetcher.getContent();
                }
                catch (InterruptedException interruptedException) {
                    this.getProviderContext().debugError((Object)"URLScraperProvider.getContent()", (Throwable)interruptedException);
                    StringBuffer interruptedException2 = stringBuffer = stringBuffer.append(this.bundle.getString("timeout"));
                    Object var14_27 = null;
                    if (hTMLFetcher.isAlive()) {
                        hTMLFetcher.terminate();
                    }
                    hTMLFetcher = null;
                    return interruptedException2;
                }
            }
            Object var14_26 = null;
            if (hTMLFetcher.isAlive()) {
                hTMLFetcher.terminate();
            }
            hTMLFetcher = null;
            return stringBuffer;
        }
        catch (Throwable throwable) {
            Object var14_28 = null;
            if (hTMLFetcher.isAlive()) {
                hTMLFetcher.terminate();
            }
            hTMLFetcher = null;
            throw throwable;
        }
    }

    protected File getFile(String string) {
        File file = null;
        try {
            file = new File(string);
            if (file.exists() && file.isFile() && file.canRead()) {
                return file;
            }
            return null;
        }
        catch (SecurityException securityException) {
            this.getProviderContext().debugError((Object)"URLScraperProvider.getFile(): ", (Throwable)securityException);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            this.getProviderContext().debugError((Object)"URLScraperProvider.getFile(): Null path name ", (Throwable)nullPointerException);
            return null;
        }
    }

    protected StringBuffer getFileAsBuffer(String string) throws IOException, ProviderException {
        File file = null;
        try {
            file = this.getFile(string);
            if (file != null) {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = this.readContent(fileInputStream, -1);
                String string2 = this.getMIMEType(file.getName());
                String string3 = this.getContentEncoding(null, byArray, string2);
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (string3 != null && string3.length() != 0) {
                    return new StringBuffer(new String(byArray, string3));
                }
                return new StringBuffer(new String(byArray));
            }
            this.getProviderContext().debugError((Object)"URLScraperProvider.getFileAsBuffer(): getFile() returned null");
            return null;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            this.getProviderContext().debugError((Object)"URLScraperProvider.getFileAsBuffer():", (Throwable)negativeArraySizeException);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getProviderContext().debugError((Object)"URLScraperProvider.getFileAsBuffer():", (Throwable)fileNotFoundException);
            return null;
        }
    }

    protected String getContentEncoding(String string, byte[] byArray, String string2) throws ProviderException {
        int n;
        String string3 = null;
        if (string != null && (n = string.indexOf("charset=")) != -1 && (string3 = string.substring(n + 8).trim()) != null && string3.length() != 0) {
            if (string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            return string3;
        }
        string3 = this.getInputEncoding();
        if (string3 != null && string3.length() != 0) {
            return string3;
        }
        if (string2 != null && (string2.equalsIgnoreCase("text/html") || string2.equalsIgnoreCase("text/xml") || string2.equalsIgnoreCase("application/xml"))) {
            string3 = this.getContentEncodingFromContentBytes(byArray);
        }
        return string3;
    }

    protected String getContentEncodingFromContentBytes(byte[] byArray) {
        int n;
        int n2;
        String string = null;
        String string2 = new String(byArray);
        String string3 = string2.toLowerCase();
        int n3 = 0;
        while ((n2 = string3.indexOf("<meta http-equiv=\"content-type\"", n3)) != -1 && (n = string3.indexOf(">", n2)) != -1) {
            String string4 = string2.substring(n2, n);
            String string5 = string4.toLowerCase();
            int n4 = string5.indexOf("charset=");
            if (n4 == -1) {
                n3 = n + 1;
                continue;
            }
            int n5 = n4 + 8;
            char c = string5.charAt(n5);
            if (c == '\"') {
                ++n5;
            }
            int n6 = n5;
            char c2 = string5.charAt(n6);
            while (Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_') {
                c2 = string5.charAt(++n6);
            }
            if (n6 <= n5) break;
            string = string4.substring(n5, n6);
            return string;
        }
        return string;
    }

    private String getMIMEType(String string) {
        String string2 = null;
        if (string != null) {
            Object object;
            try {
                object = URLConnection.getFileNameMap();
                if (object.getContentTypeFor(string) != null) {
                    string2 = object.getContentTypeFor(string);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (string2 == null) {
                object = string.toLowerCase();
                int n = 0;
                while (n < typeTable.length && string2 == null) {
                    if (((String)object).endsWith(typeTable[n][0])) {
                        string2 = typeTable[n][1];
                    }
                    ++n;
                }
            }
        }
        return string2;
    }

    byte[] readContent(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[1000];
        byArray = n != -1 ? new byte[n] : new byte[1000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        return byArray2;
    }
}

