/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.urlscraper.Header;
import com.sun.portal.providers.urlscraper.URLScraperProvider;
import com.sun.portal.rewriter.DefaultTranslator;
import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.RewriterFactory;
import com.sun.portal.rewriter.RewriterModule;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.URISpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class HTMLFetcher
extends Thread {
    private final int CONTENT_BUFFER_SIZE = 2048;
    private StringBuffer content = null;
    private String data = null;
    private URL url = null;
    private URL requestURL = null;
    private URLScraperProvider provider = null;
    private boolean terminated = false;
    private boolean finished = false;
    private boolean allCookies = false;
    private List cookiesToForwardList = null;
    private ProviderContext context = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ResourceBundle bundle = null;
    private String rulesetID = null;
    private Object providerWaitObj = null;
    private static final byte[] crlf = new byte[]{13, 10};
    private static final String scrlf = new String(crlf);

    public HTMLFetcher(String string, URLScraperProvider uRLScraperProvider, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceBundle resourceBundle, String string2, Object object) throws MalformedURLException, ProviderException {
        this.provider = uRLScraperProvider;
        this.context = this.provider.getProviderContext();
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.requestURL = new URL(this.context.getRequestServer(this.request).toString());
        this.url = new URL(this.getAbsURL(string));
        this.bundle = resourceBundle;
        this.rulesetID = string2;
        this.providerWaitObj = object;
        this.allCookies = this.provider.getBooleanProperty("cookiesToForwardAll");
        this.cookiesToForwardList = this.provider.getListProperty("cookiesToForwardList");
        this.initRewriter();
        this.setDaemon(true);
    }

    public StringBuffer getContent() {
        return this.content;
    }

    private void initRewriter() {
        RewriterModule.init(null);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block53: {
            block52: {
                if (this.isTerminated()) {
                    return;
                }
                var1_1 = null;
                var2_2 = null;
                try {
                    try {
                        var3_3 = null;
                        try {
                            var3_3 = (HttpURLConnection)this.url.openConnection();
                        }
                        catch (ClassCastException var4_5) {
                            throw new ProviderException("URLScraperProvider doesn't support ftp, file urls. URL:" + this.url, (Throwable)var4_5);
                        }
                        catch (Exception var5_9) {
                            this.context.debugError((Object)("HTMLFetcher:run() Cannot open a connection to URL:" + this.url));
                            this.context.debugError((Object)"Exception in HTMLFetcher:run()", (Throwable)var5_9);
                            this.content = null;
                        }
                        if (var3_3 != null) {
                            var3_3.setDoInput(true);
                            var3_3.setUseCaches(false);
                            if (this.request != null) {
                                var4_6 = this.request.getHeader("User-Agent");
                                if (var4_6 != null) {
                                    var3_3.setRequestProperty("User-Agent", this.request.getHeader("User-Agent"));
                                }
                                var5_10 = this.request.getCookies();
                                var6_13 = null;
                                if (var5_10 != null) {
                                    var6_13 = new Vector<E>(var5_10.length);
                                    var7_14 = 0;
                                    while (var7_14 < var5_10.length) {
                                        if (this.provider.forward(var5_10[var7_14].getName(), this.allCookies, this.cookiesToForwardList)) {
                                            var6_13.add(var5_10[var7_14]);
                                        }
                                        ++var7_14;
                                    }
                                }
                                if (var6_13 != null && var6_13.size() > 0) {
                                    var7_15 = new StringBuffer();
                                    var8_18 = var6_13.iterator();
                                    while (true) {
                                        if (!var8_18.hasNext()) {
                                            if (this.context.isDebugMessageEnabled()) {
                                                this.context.debugMessage((Object)("HTMLFetcher.run(): Forwarded cookie header: " + var7_15.toString()));
                                            }
                                            var3_3.setRequestProperty("Cookie", var7_15.toString());
                                            break;
                                        }
                                        var9_19 = (Cookie)var8_18.next();
                                        var10_21 /* !! */  = null;
                                        var11_22 = null;
                                        if (this.provider.cookieTable != null && this.provider.cookieTable.containsKey(var9_19.getName())) {
                                            var12_23 = (domainPathEntry)this.provider.cookieTable.get(var9_19.getName());
                                            var10_21 /* !! */  = (byte[])var12_23.getPath();
                                            var11_22 = var12_23.getDomain();
                                        }
                                        var7_15.append(var9_19.getName()).append("=").append(URLEncoder.encode(var9_19.getValue()));
                                        if (var10_21 /* !! */  != null) {
                                            var7_15.append("; ").append("$Path=" + (String)var10_21 /* !! */ );
                                        }
                                        if (var11_22 != null) {
                                            var7_15.append("; ").append("$Domain=" + var11_22);
                                        }
                                        if (!var8_18.hasNext()) continue;
                                        var7_15.append("; ");
                                    }
                                }
                            }
                            var4_7 = var3_3.getContentLength();
                            var5_11 = var3_3.getResponseCode();
                            if (this.context.isDebugMessageEnabled()) {
                                this.context.debugMessage((Object)("HTMLFetcher.run(): got response, code=" + var5_11));
                            }
                            if (var5_11 == -1) {
                                this.context.debugError((Object)"HTMLFetcher.run(): response code was -1!");
                                var14_24 = null;
                                var15_31 = this.providerWaitObj;
                                break block52;
                            }
                            if (var5_11 == 301 || var5_11 == 302) {
                                var6_13 = var3_3.getHeaderField("Location");
                                var7_16 = new Header((String)var6_13);
                                if (this.context.isDebugMessageEnabled()) {
                                    this.context.debugMessage((Object)("HTMLFetcher.run(): got redirect, location=" + var7_16.getValue()));
                                }
                                this.url = new URL(this.getAbsURL(var7_16.getValue()));
                                var9_20 = 1;
                                while (true) {
                                    if ((var8_18 = var3_3.getHeaderFieldKey(var9_20)) == null) break;
                                    if (var8_18.equalsIgnoreCase("Set-cookie")) {
                                        var10_21 /* !! */  = (byte[])var3_3.getHeaderField(var9_20);
                                        this.processSetCookieHeader((String)var10_21 /* !! */ );
                                    }
                                    ++var9_20;
                                }
                                this.run();
                                var14_25 = null;
                                var15_32 = this.providerWaitObj;
                                synchronized (var15_32) {
                                    this.providerWaitObj.notify();
                                }
                                try {
                                    if (var1_1 == null) return;
                                    var1_1.close();
                                    return;
                                }
                                catch (IOException var16_39) {
                                    // empty catch block
                                }
                                return;
                            }
                            var7_17 = 1;
                            while (true) {
                                if ((var6_13 = var3_3.getHeaderFieldKey(var7_17)) == null) {
                                    var8_18 = var3_3.getContentType();
                                    var9_19 = new URISpec(var3_3.getURL().toString(), (String)var8_18);
                                    var1_1 = var3_3.getInputStream();
                                    var10_21 /* !! */  = this.provider.readContent(var1_1, var4_7);
                                    var2_2 = this.provider.getContentEncoding((String)var8_18, var10_21 /* !! */ , var9_19.getMIME());
                                    this.data = var2_2 != null && var2_2.length() != 0 ? new String(var10_21 /* !! */ , var2_2) : new String(var10_21 /* !! */ );
                                }
                                if (var6_13.equalsIgnoreCase("Set-cookie")) {
                                    var8_18 = var3_3.getHeaderField(var7_17);
                                    this.processSetCookieHeader((String)var8_18);
                                }
                                ++var7_17;
                            }
                            var11_22 = RewriterFactory.getInstance((String)this.rulesetID, (URISpec)var9_19);
                            if (var11_22 != null) {
                                var12_23 = new DefaultTranslator((URISpec)var9_19);
                                this.content = new StringBuffer(var11_22.rewrite(this.data, (Translator)var12_23));
                            } else {
                                this.content = new StringBuffer(this.data);
                            }
                            if (this.context.isDebugMessageEnabled()) {
                                this.context.debugMessage((Object)("HTMLFetcher.run(): got content=\n" + this.content.toString()));
                            }
                        }
                        this.finished = true;
                        break block53;
                    }
                    catch (InvalidXMLException var3_4) {
                        this.context.debugError((Object)"HTMLFetcher.run(): ", (Throwable)var3_4);
                        this.content = new StringBuffer(this.bundle.getString("invalidruleset"));
                        this.finished = true;
                        var14_27 = null;
                        var15_34 = this.providerWaitObj;
                        synchronized (var15_34) {
                            this.providerWaitObj.notify();
                        }
                        try {}
                        catch (IOException var16_41) {
                            return;
                        }
                        if (var1_1 == null) return;
                        var1_1.close();
                        return;
                    }
                    catch (UnsupportedEncodingException var4_8) {
                        this.context.debugError((Object)("HTMLFetcher.run():Invalid charset " + var2_2));
                        this.context.debugError((Object)"HTMLFetcher.run():Unsupported Encoding.", (Throwable)var4_8);
                        this.content = new StringBuffer(this.bundle.getString("unsupportedencoding"));
                        this.finished = true;
                        var14_28 = null;
                        var15_35 = this.providerWaitObj;
                        synchronized (var15_35) {
                            this.providerWaitObj.notify();
                        }
                        try {}
                        catch (IOException var16_42) {
                            return;
                        }
                        if (var1_1 == null) return;
                        var1_1.close();
                        return;
                    }
                    catch (Exception var5_12) {
                        this.context.debugError((Object)"Exception in HTMLFetcher:run()", (Throwable)var5_12);
                        this.content = null;
                        this.finished = true;
                        var14_29 = null;
                        var15_36 = this.providerWaitObj;
                        synchronized (var15_36) {
                            this.providerWaitObj.notify();
                        }
                        try {}
                        catch (IOException var16_43) {
                            return;
                        }
                        if (var1_1 == null) return;
                        var1_1.close();
                        return;
                    }
                }
                catch (Throwable var13_45) {
                    var14_30 = null;
                    var15_37 = this.providerWaitObj;
                    synchronized (var15_37) {
                        this.providerWaitObj.notify();
                    }
                    ** try [egrp 4[TRYBLOCK] [7 : 1239->1250)] { 
lbl177:
                    // 1 sources

                    if (var1_1 == null) throw var13_45;
                    var1_1.close();
                    throw var13_45;
lbl180:
                    // 1 sources

                    catch (IOException var16_44) {
                        // empty catch block
                    }
                    throw var13_45;
                }
            }
            synchronized (var15_31) {
                this.providerWaitObj.notify();
            }
            ** try [egrp 4[TRYBLOCK] [7 : 1239->1250)] { 
lbl187:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl190:
            // 1 sources

            catch (IOException var16_38) {
                // empty catch block
            }
            return;
        }
        var14_26 = null;
        var15_33 = this.providerWaitObj;
        synchronized (var15_33) {
            this.providerWaitObj.notify();
        }
        try {}
        catch (IOException var16_40) {}
        if (var1_1 == null) return;
        var1_1.close();
        return;
    }

    private String getCookieName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void processSetCookieHeader(String string) {
        String string2 = this.modifyCookieHeader(string);
        if (string2 != null) {
            string = string2;
        }
        try {
            String string3;
            if (string != null && this.response != null && (string3 = this.getCookieName(string)) != null && this.provider.forward(string3, this.allCookies, this.cookiesToForwardList)) {
                this.response.addHeader("Set-Cookie", string);
            }
        }
        catch (Exception exception) {
            this.context.debugError((Object)("HTMLFetcher.processSetCookieHeader(): invalid cookie: " + string), (Throwable)exception);
        }
    }

    private String getAbsURL(String string) throws MalformedURLException {
        if (!string.regionMatches(true, 0, "http://", 0, 7) && !string.regionMatches(true, 0, "https://", 0, 8)) {
            String string2 = this.requestURL.getProtocol();
            StringBuffer stringBuffer = new StringBuffer().append(string2).append("://").append(this.requestURL.getHost()).append(":");
            int n = this.requestURL.getPort();
            if (string2.equals("http") && n <= 0) {
                n = 80;
            } else if (string2.equals("https") && n <= 0) {
                n = 443;
            }
            stringBuffer.append(n).append(string);
            return stringBuffer.toString();
        }
        return string;
    }

    private String modifyCookieHeader(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            return string;
        }
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = this.getCookieName(string);
        String string4 = this.url.getHost();
        String string5 = this.requestURL.getHost();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        String string6 = null;
        String string7 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string8;
            String string9;
            String string10 = stringTokenizer.nextToken().trim();
            if (string10.length() == 0) continue;
            int n = string10.indexOf(61);
            if (n < 0) {
                string9 = string10;
                string8 = null;
            } else {
                string9 = string10.substring(0, n).trim();
                string8 = n + 1 == string10.length() ? null : string10.substring(n + 1).trim();
            }
            if (string9.equalsIgnoreCase("path")) {
                string6 = string8;
                if (string6 == null || string6.startsWith("/")) continue;
                return null;
            }
            if (string9.equalsIgnoreCase("domain")) {
                string7 = string8;
                if (string7 == null) continue;
                if (string7.charAt(0) != '.' || string7.length() < 4) {
                    return null;
                }
                if (string7.charAt(string7.length() - 1) == '.') {
                    return null;
                }
                if (string4.toLowerCase().endsWith(string7.toLowerCase())) continue;
                return null;
            }
            stringBuffer.append("; " + string10);
        }
        String string11 = this.getDomain(string5);
        if (string7 != null && string6 != null) {
            if (!string7.equalsIgnoreCase(string11) || !string6.equalsIgnoreCase(this.getPath())) {
                this.provider.cookieTable.put(string3, new domainPathEntry(string7, string6));
            }
        } else {
            this.provider.cookieTable.put(string3, new domainPathEntry(string7, string6));
        }
        stringBuffer.append(";domain=").append(string11).append(";path=/");
        return stringBuffer.toString();
    }

    private String getPath() {
        return this.request.getContextPath() + this.request.getServletPath();
    }

    private String getDomain(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        int n2 = string.substring(0, n).lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return string;
        }
        return string.substring(n2);
    }

    static class domainPathEntry {
        String domain = null;
        String path = null;

        domainPathEntry(String string, String string2) {
            this.domain = string;
            this.path = string2;
        }

        String getDomain() {
            return this.domain;
        }

        String getPath() {
            return this.path;
        }
    }
}

