/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.servlet;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.log.LogManager;
import com.iplanet.log.LogRecord;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.Base64;
import com.sun.portal.netlet.servlet.Rules;
import com.sun.portal.netlet.util.UrlDecoder;
import com.sun.portal.netlet.util.UserAttributes;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetletConfig
extends HttpServlet
implements SSOTokenListener {
    private static final String sccsID = "@(#)NetletConfig.java\t1.37 01/07/16 Sun Microsystems, Inc.";
    private Debug debug = null;
    private String serverName = null;
    private String serverPort = null;
    private String serverProtocol = null;
    private String serverDomain = null;
    private boolean logCreated = false;
    private Hashtable sessionHash = new Hashtable();
    private final int STATUS_LOADING = 1;
    private final int STATUS_LOADED = 2;
    private final int STATUS_NOT_LOADED = 3;
    private final int STATUS_UNLOADED = 4;
    private SecureRandom sRandom = null;

    public NetletConfig() {
        this.debug = Debug.getInstance((String)"srapNetlet");
        try {
            this.sRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] seed = this.sRandom.generateSeed(32);
            this.sRandom.setSeed(seed);
        }
        catch (NoSuchAlgorithmException ne) {
            this.sRandom = new SecureRandom();
        }
    }

    private String getCommand(HttpServletRequest req) {
        String command = req.getParameter("func");
        try {
            String queryString = req.getQueryString();
            int funcStartIndex = queryString.indexOf("func=");
            if (funcStartIndex == -1) {
                return UrlDecoder.decode((String)command);
            }
            int funcEndIndex = (queryString = queryString.substring(funcStartIndex + 5)).indexOf("&");
            queryString = funcEndIndex == -1 ? queryString : queryString.substring(0, funcEndIndex);
            return UrlDecoder.decode((String)queryString);
        }
        catch (Exception ex) {
            this.debug.error("NetletConfig: Exception in getting the command -> " + ex);
            return UrlDecoder.decode((String)command);
        }
    }

    private void doGetPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, FileNotFoundException {
        String command;
        if (this.serverName == null || this.serverPort == null || this.serverProtocol == null) {
            this.serverName = req.getServerName();
            if (this.serverName != null && this.serverName.trim().length() != 0 && this.serverName.indexOf(".") != -1) {
                this.serverDomain = this.serverName.substring(this.serverName.indexOf(".") + 1);
            }
            this.serverProtocol = req.getScheme();
            int sPort = req.getServerPort();
            this.serverPort = "" + sPort;
        }
        if ((command = this.getCommand(req)) == null || command.trim().length() == 0) {
            this.debug.error("Error no function specified");
            return;
        }
        NetletUser nu = null;
        String sid = null;
        try {
            nu = new NetletUser(req);
            nu.setRes(res);
            sid = new String(nu.getSSOTokenID().toString());
            if (!SSOTokenManager.getInstance().isValidToken(nu.getSSOToken())) {
                this.debug.error("Invalid SSOToken");
                this.redirectToPage(res, "invalidsession", null, null, null);
                return;
            }
            if (!nu.getNetletUserAttributes().getBoolean("Execute", true)) {
                this.redirectToPage(res, "noprivilege", null, nu.getLocale(), nu.getHTMLcharsetname());
                return;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("Command -> " + command);
            }
            if (command.equals("makepage") || command.equals("load")) {
                if (this.getStatus(sid) == 2) {
                    this.debug.message("Netlet already loaded for " + nu.getClientID());
                    res.setStatus(204);
                    return;
                }
                this.setStatus(sid, 1);
                this.makeNetletPage(nu);
            } else if (command.equals("makeNetletFrame")) {
                nu.getUserAttributes();
                this.printRules(nu);
                this.makeNetletFrame(nu);
            } else if (command.equals("makeInfoFrame")) {
                this.makeInfoFrame(nu);
            } else if (command.equals("setLoaded")) {
                this.setStatus(sid, 2);
                res.setStatus(200);
            } else if (command.equals("setLoading")) {
                this.setStatus(sid, 1);
                res.setStatus(200);
            } else if (command.equals("isLoaded")) {
                if (this.getStatus(sid) == 2 || this.getStatus(sid) == 1) {
                    res.setStatus(200);
                } else {
                    res.setStatus(204);
                }
            } else if (command.equals("unload")) {
                this.setStatus(sid, 4);
                res.sendRedirect(this.getDefaultRedirectURL(nu));
            } else if (command.equals("loadResources")) {
                this.setStatus(sid, 1);
                this.outputResources(nu);
            } else if (command.equals("parsePacFile")) {
                this.parsePacFile(nu);
            } else if (command.equals("storeProxySettings")) {
                this.storeProxySettings(nu);
            } else if (command.equals("doReauth")) {
                this.doReauth(nu);
            } else {
                if (this.getStatus(sid) == 4) {
                    String agent = req.getHeader("user-agent");
                    this.makeErrorMsg(nu, "nc2");
                    return;
                }
                if (this.getStatus(sid) != 2) {
                    this.makeLoadingPage(nu, req);
                    return;
                }
                nu.getUserAttributes();
                this.printRules(nu);
                if (!this.openDynamic(nu, command)) {
                    this.debug.error("Error processsing dynamic rule for " + command);
                }
            }
        }
        catch (SSOException ssoe) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)ssoe);
            this.redirectToPage(res, "invalidsession", null, null, null);
            return;
        }
        catch (AMException ame) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)ame);
            this.redirectToPage(res, "invalidsession", null, null, null);
            return;
        }
        catch (MissingResourceException ex) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)ex);
            return;
        }
    }

    private void addLoopbackRule(NetletUser u) {
        Rules lb = new Rules();
        lb.name = "loopback";
        lb.url = "";
        lb.lport = new Vector();
        lb.lport.add(new String("" + u.getDefaultLBPort()));
        lb.dport = new Vector();
        lb.dport.add(this.serverPort);
        lb.dhost = new Vector();
        lb.dhost.add(this.serverName);
        u.addRule(lb);
    }

    void makeLoadingPage(NetletUser user, HttpServletRequest req) throws IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        StringBuffer url = new StringBuffer();
        url.append(this.getDynamicUrl() + req.getServletPath()).append("?").append(req.getQueryString());
        StringBuffer outBuf = new StringBuffer();
        outBuf.append("<html>\n");
        outBuf.append("<head>\n");
        outBuf.append("<script language=javascript>\n");
        outBuf.append("\tfunction doRedirect() {\n");
        outBuf.append("\t\twindow.location='" + url.toString() + "';\n");
        outBuf.append("\t}\n");
        outBuf.append("</script>\n");
        outBuf.append("<title>");
        outBuf.append(user.getBundle().getString("ntitle2"));
        outBuf.append("</title></head>\n");
        outBuf.append("<BODY TEXT=\"" + user.getBundle().getString("ntxcolor") + "\" BGCOLOR=\"" + user.getBundle().getString("nbgcolor") + "\">\n");
        outBuf.append("<p>" + user.getBundle().getString("nc3") + "\n");
        outBuf.append("<form>\n");
        outBuf.append("<input type=button name=continue value='" + user.getBundle().getString("contButton") + "'" + " onClick='doRedirect()'" + ">\n");
        outBuf.append("</form>\n");
        outBuf.append("</body></html>\n");
        out.print(outBuf.toString());
        out.close();
    }

    void makeErrorMsg(NetletUser user, String key) throws IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        out.print("<html>\n");
        out.print("<head><title>");
        out.print(user.getBundle().getString("ntitle"));
        out.print("</title></head>\n");
        out.print("<BODY TEXT=\"" + user.getBundle().getString("ntxcolor") + "\" BGCOLOR=\"" + user.getBundle().getString("nbgcolor") + "\">\n");
        out.print("<p>" + user.getBundle().getString(key) + "</body></html>\n");
        out.close();
    }

    void makeNetletPage(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        String url = user.getReq().getServletPath();
        url = this.getDynamicUrl() + url;
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<head><title>");
        outBuffer.append(user.getBundle().getString("ntitle"));
        outBuffer.append("</title></head>\n");
        outBuffer.append("<FRAMESET FRAMEBORDER=\"no\" COLS=\"*\" ROWS=\"60,5\" BORDER=0>\n");
        outBuffer.append("\t<FRAME NAME=\"info\" BORDER=0 SCROLLING=\"yes\" MARGINHEIGHT=10 SRC=\"" + url + "?func=makeInfoFrame" + "\">\n");
        outBuffer.append("\t<FRAME NAME=\"netlet\" BORDER=0 SCROLLING=\"no\" MARGINHEIGHT=0 SRC=\"" + url + "?func=makeNetletFrame" + "\">\n");
        outBuffer.append("</FRAMESET>\n");
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void makeNetletFrame(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<head><title>");
        outBuffer.append(user.getBundle().getString("ntitle"));
        outBuffer.append("</title></head>\n");
        outBuffer.append("\t<script language=javascript>\n");
        outBuffer.append("\t\tvar needToSleep = true;\n");
        outBuffer.append("\t</script>\n");
        outBuffer.append("</head>\n");
        outBuffer.append("<BODY TEXT=\"").append(user.getBundle().getString("ntxcolor"));
        outBuffer.append("\" BGCOLOR=\"").append(user.getBundle().getString("nbgcolor")).append("\">\n");
        outBuffer.append("<p><applet codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        outBuffer.append("<param name=\"cabbase\" value=\"netlet.cab\">\n");
        outBuffer.append("<param name=\"cookiename\" value=\"" + SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro") + "\">\n");
        outBuffer.append("<param name=\"configURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig\">\n");
        outBuffer.append("<param name=\"resourcesURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig?func=loadResources\">\n");
        int count = 0;
        this.addLoopbackRule(user);
        Enumeration e = user.getRules();
        while (e.hasMoreElements()) {
            Rules r = (Rules)e.nextElement();
            int i = 0;
            while (i < r.lport.size()) {
                outBuffer.append("<param name=listenPort_" + count + " value=" + (String)r.lport.elementAt(i) + ">\n");
                outBuffer.append("<param name=serverPort_" + count + " value=" + (String)r.dport.elementAt(i) + ">\n");
                outBuffer.append("<param name=serverHost_" + count + " value=" + (String)r.dhost.elementAt(i) + ">\n");
                outBuffer.append("<param name=cipher_" + count + " value=" + user.getAlgorithm(r) + ">\n");
                outBuffer.append("<param name=key_" + count + " value=" + user.getKeyLength(user.getAlgorithm(r)) + ">\n");
                ++count;
                ++i;
            }
        }
        outBuffer.append("<param name=sessionId value=" + user.getSSOTokenID().toString() + ">\n");
        outBuffer.append("<param name=numParms value=" + count + ">\n");
        outBuffer.append("<param name=doPortWarning value=" + user.getPortWarn() + ">\n");
        outBuffer.append("<param name=doReauth value=" + user.getReauth() + ">\n");
        outBuffer.append("<param name=showPortWarnCheckbox value=" + user.getPortWarnCheckbox() + ">\n");
        outBuffer.append("<param name=defaultCipher value=" + user.getDefaultCipher() + ">\n");
        outBuffer.append("<param name=defaultKeyLen value=" + user.getKeyLength(user.getDefaultCipher()) + ">\n");
        outBuffer.append("<param name=proxytype value=" + user.getNetletUserAttributes().getString("ProxyType", "") + ">\n");
        outBuffer.append("<param name=proxyhost value=" + user.getNetletUserAttributes().getString("ProxyHost", "") + ">\n");
        outBuffer.append("<param name=proxyport value=" + user.getNetletUserAttributes().getString("ProxyPort", "") + ">\n");
        outBuffer.append("<param name=proxyoverride value=" + user.getNetletUserAttributes().getString("ProxyOverride", "") + ">\n");
        outBuffer.append("</applet>\n");
        outBuffer.append("</body>\n");
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void makeInfoFrame(NetletUser user) throws ServletException, IOException {
        StringBuffer outBuffer = new StringBuffer();
        HttpServletResponse res = user.getRes();
        HttpServletRequest req = user.getReq();
        String stat = req.getParameter("stat");
        if (stat == null || stat.equals("")) {
            stat = "nc4";
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        res.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.setHeader("Pragma", "no-cache");
        outBuffer.append("<html>\n");
        outBuffer.append("<BODY TEXT=\"").append(user.getBundle().getString("ntxcolor"));
        outBuffer.append("\" BGCOLOR=\"").append(user.getBundle().getString("nbgcolor")).append("\">\n");
        outBuffer.append("<p>").append(user.getBundle().getString(stat));
        outBuffer.append("</body>\n");
        outBuffer.append("</html>\n");
        out.print(outBuffer.toString());
        out.close();
    }

    void outputResources(NetletUser user) throws ServletException, IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = res.getWriter();
        res.setContentType("text/plain");
        Enumeration<String> e = user.getAppletBundle().getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = user.getAppletBundle().getString(key);
            out.println(key + "=" + NetletConfig.encodeJavaString(value));
        }
        try {
            out.println("_sessionKey=" + this.getKey(user));
        }
        catch (SSOException se) {
            se.printStackTrace();
            this.redirectToPage(user.getRes(), "invalidsession", null, user.getLocale(), user.getHTMLcharsetname());
            return;
        }
        out.close();
    }

    public static String encodeJavaString(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = s.charAt(i);
            int ic = c;
            if (ic >= 32 && ic <= 127) {
                buf.append((char)c);
            } else {
                buf.append("\\u");
                int j = 4;
                while (j > 0) {
                    buf.append(Character.forDigit((ic & 0xF000) >> 12, 16));
                    ic <<= 4;
                    --j;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private boolean isIPAddress(String hostName) {
        StringTokenizer st = new StringTokenizer(hostName, ".");
        int count = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            System.out.println(str);
            try {
                int intVal = Integer.parseInt(str);
                if (intVal > 255) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
            ++count;
        }
        return count == 4;
    }

    public boolean isValidHost(String hostName) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        String resolvedHostName = inetaddr.getHostName();
        return !this.isIPAddress(hostName) || !hostName.equals(resolvedHostName);
    }

    public String getIPAddress(String hostName) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        return inetaddr.getHostAddress();
    }

    public String getHostName(String IPAddress) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(IPAddress);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        String hostName = inetaddr.getHostName();
        if (hostName.indexOf(".") == -1 && this.serverDomain != null) {
            hostName = hostName + ".";
            hostName = hostName + this.serverDomain;
        }
        return hostName;
    }

    boolean openDynamic(NetletUser user, String type) throws IOException {
        this.debug.message("openDynanic " + type);
        Rules r = user.getRule(type);
        if (r == null) {
            this.debug.message("Error No rule for " + type);
            return false;
        }
        String url = null;
        url = !r.loopback ? r.url : this.serverProtocol + "://localhost:" + r.clientLoopbackPort + r.url;
        this.debug.message("Open dynamic port url " + url);
        HttpServletRequest req = user.getReq();
        HttpServletResponse res = user.getRes();
        String targetHost = req.getParameter("machine");
        targetHost = URLEncoder.encode(targetHost);
        if (targetHost == null || targetHost.equals("")) {
            this.debug.message("Error: no target host specified for " + type);
            return false;
        }
        if (user.inPrivilegeList("DenyRules", type, false, false)) {
            this.redirectToPage(user.getRes(), "noprivilege.rule", type, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        if (!user.inPrivilegeList("AccessRules", type, false, false)) {
            this.redirectToPage(user.getRes(), "noprivilege.rule", type, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        String tempTargetHost = new String(targetHost);
        StringTokenizer hostNames = new StringTokenizer(tempTargetHost, "+");
        Vector<String> newTargetHosts = new Vector<String>();
        while (hostNames.hasMoreTokens()) {
            String hostName = hostNames.nextToken();
            if (!this.isValidHost(hostName)) continue;
            if (hostName.indexOf(".") == -1 && this.serverDomain != null) {
                hostName = hostName + ".";
                hostName = hostName + this.serverDomain;
            }
            newTargetHosts.add(hostName);
        }
        if (newTargetHosts.size() == 0) {
            this.redirectToPage(user.getRes(), "invalidhost", null, user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        int i = 0;
        while (i < newTargetHosts.size()) {
            boolean inDeniedList;
            String hostName = (String)newTargetHosts.get(i);
            boolean bl = inDeniedList = user.inPrivilegeList("DenyHosts", this.getHostName(hostName), true, true) || user.inPrivilegeList("DenyHosts", this.getIPAddress(hostName), true, true);
            if (inDeniedList) {
                newTargetHosts.remove(hostName);
                --i;
            }
            ++i;
        }
        if (newTargetHosts.size() == 0) {
            this.redirectToPage(user.getRes(), "noprivilege.host", targetHost.replace('+', ','), user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        int i2 = 0;
        while (i2 < newTargetHosts.size()) {
            boolean inAllowedList;
            String hostName = (String)newTargetHosts.get(i2);
            boolean bl = inAllowedList = user.inPrivilegeList("AccessHosts", this.getHostName(hostName), true, true) || user.inPrivilegeList("AccessHosts", this.getIPAddress(hostName), true, true);
            if (!inAllowedList) {
                newTargetHosts.remove(hostName);
                --i2;
            }
            ++i2;
        }
        if (newTargetHosts.size() == 0) {
            this.redirectToPage(user.getRes(), "noprivilege.host", targetHost.replace('+', ','), user.getLocale(), user.getHTMLcharsetname());
            return false;
        }
        String localPort = "";
        String targetPort = "";
        StringBuffer newTargets = new StringBuffer();
        Iterator iter = ((AbstractList)newTargetHosts).iterator();
        if (iter.hasNext()) {
            newTargets.append((String)iter.next());
        }
        while (iter.hasNext()) {
            newTargets.append("+");
            newTargets.append((String)iter.next());
        }
        targetHost = newTargets.toString();
        this.debug.message("Server domain -> " + this.serverDomain + " Valid and allowed targets -> " + targetHost);
        int i3 = 0;
        while (i3 < r.ruleCount) {
            localPort = (String)r.lport.elementAt(i3);
            targetPort = (String)r.dport.elementAt(i3);
            String targetHostInRule = (String)r.dhost.elementAt(i3);
            if (targetHostInRule.equals("TARGET")) {
                try {
                    user.getSSOToken().setProperty(localPort, targetHost + "^" + targetPort);
                }
                catch (SSOException ex) {
                    this.debug.error("Error setting session " + (Object)((Object)ex));
                    return false;
                }
            }
            ++i3;
        }
        this.openPage(user, res, url);
        return true;
    }

    void openPage(NetletUser user, HttpServletResponse res, String url) throws IOException {
        StringBuffer outBuffer = new StringBuffer();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), user.getHTMLcharsetname())));
        res.setContentType("text/html; charset=" + user.getHTMLcharsetname());
        outBuffer.append("<html>\n");
        if (url == null || url.equals("")) {
            outBuffer.append("<body onload=window.close()>\n");
        } else {
            outBuffer.append("<body onload=window.location.replace(\"" + url + "\")>\n");
        }
        outBuffer.append("</body></html>\n\n");
        out.print(outBuffer.toString());
        out.close();
    }

    /*
     * WARNING - void declaration
     */
    void returnFile(String filename, OutputStream out) {
        FileInputStream fis = null;
        try {
            int bytesRead;
            fis = new FileInputStream(filename);
            byte[] buf = new byte[4096];
            while ((bytesRead = fis.read(buf)) != -1) {
                void var5_6;
                out.write(buf, 0, (int)var5_6);
            }
            fis.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    void printRules(NetletUser u) {
        Enumeration e = u.getRules();
        while (e.hasMoreElements()) {
            Rules r = (Rules)e.nextElement();
            int i = 0;
            while (i < r.lport.size()) {
                ++i;
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    void logIt(NetletUser user, String s) {
        try {
            LogManager log = new LogManager(user.getSSOToken());
            if (!this.logCreated) {
                log.create("NetletConfig");
                this.logCreated = true;
            }
            log.write(new LogRecord("NetLetConfig", s), "Netlet");
        }
        catch (Exception ex) {
            System.out.println("Logging exception:" + ex);
        }
    }

    private synchronized int getStatus(String sid) {
        Integer status = (Integer)this.sessionHash.get(sid);
        if (status == null) {
            return 3;
        }
        return status;
    }

    private synchronized void removeSession(SSOTokenID sid) {
        this.sessionHash.remove(sid);
    }

    private synchronized void setStatus(String sid, int state) {
        Integer status = this.sessionHash.put(sid, new Integer(state));
        if (status != null) {
            return;
        }
        try {
            SSOToken token = SSOTokenManager.getInstance().createSSOToken(sid.toString());
            token.addSSOTokenListener((SSOTokenListener)this);
        }
        catch (SSOException e) {
            e.printStackTrace();
        }
    }

    public void ssoTokenChanged(SSOTokenEvent se) {
        try {
            int type = se.getType();
            this.removeSession(se.getToken().getTokenID());
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
    }

    void parsePacFile(NetletUser user) throws ServletException, IOException {
        HttpServletResponse res = user.getRes();
        PrintWriter out = res.getWriter();
        res.setContentType("text/plain");
        HttpServletRequest req = user.getReq();
        String result = "FAILED";
        try {
            String pacUrl = req.getParameter("PacFileUrl");
            String serverURL = req.getParameter("ServerURL");
            String pacFileBody = req.getParameter("PacFileBody");
            String clientIPAddr = req.getParameter("ClientIPAddr");
            Cookie[] cookieArr = req.getCookies();
            int i = 0;
            while (i < cookieArr.length) {
                Cookie cookie = cookieArr[i];
                if (cookie.getName().equals("iPlanetUserId")) {
                    String value = cookie.getValue();
                    try {
                        clientIPAddr = value.substring(0, value.indexOf(":"));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                ++i;
            }
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
            }
            String contentType = req.getContentType();
            if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
                pacFileBody = this.extractParameter(req, "PacFileBody");
            }
            Vector<String> arguments = new Vector<String>();
            arguments.add(serverURL);
            String host = "localhost";
            int indDoubleSlash = serverURL.indexOf("//");
            if (indDoubleSlash > -1) {
                int ind1 = serverURL.indexOf("/", indDoubleSlash + 2);
                int ind2 = serverURL.indexOf(":", indDoubleSlash + 2);
                host = ind2 > -1 && ind2 < ind1 ? serverURL.substring(indDoubleSlash + 2, ind2) : serverURL.substring(indDoubleSlash + 2, ind1);
            }
            arguments.add(host);
            try {
                Runtime rt = Runtime.getRuntime();
                String javaHome = System.getProperty("java.home", "/usr/java1.2/jre");
                String command = javaHome + "/bin/java com.sun.portal.netlet.servlet.EvalPAC " + URLEncoder.encode(pacFileBody) + " " + arguments.elementAt(0) + " " + arguments.elementAt(1) + " " + clientIPAddr;
                Object obj = this.getServletContext().getAttribute("com.ibm.websphere.servlet.application.classpath");
                String ibmAppClassPath = obj == null ? null : obj.toString();
                String classPath = System.getProperty("java.class.path", ".");
                String[] env = new String[1];
                if (ibmAppClassPath != null && ibmAppClassPath.trim().length() != 0) {
                    classPath = ibmAppClassPath;
                }
                env[0] = new String("CLASSPATH=" + classPath);
                Process proc = rt.exec(command, env);
                DataInputStream in = new DataInputStream(proc.getInputStream());
                result = in.readLine();
                this.debug.message("Proxy from PAC file -> " + result);
            }
            catch (Exception ex) {
                this.debug.error("Exception in processing PAC file: ", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.println(result);
        out.close();
    }

    private String getSessionKey(byte[] rdata, SSOTokenID sid) {
        String sessionId = sid.toString();
        byte[] sidBytes = new byte[sessionId.length()];
        sidBytes = sessionId.getBytes();
        byte[] encodedKey = new byte[sidBytes.length + rdata.length];
        encodedKey[0] = rdata[1];
        encodedKey[1] = rdata[3];
        encodedKey[2] = sidBytes[3];
        encodedKey[3] = rdata[2];
        encodedKey[4] = sidBytes[1];
        encodedKey[5] = rdata[0];
        encodedKey[6] = sidBytes[2];
        encodedKey[7] = rdata[4];
        encodedKey[8] = rdata[14];
        encodedKey[9] = rdata[5];
        encodedKey[10] = rdata[6];
        encodedKey[11] = sidBytes[4];
        encodedKey[12] = rdata[8];
        encodedKey[13] = rdata[9];
        encodedKey[14] = rdata[10];
        encodedKey[15] = sidBytes[5];
        encodedKey[16] = rdata[12];
        encodedKey[17] = rdata[13];
        encodedKey[18] = sidBytes[6];
        encodedKey[19] = sidBytes[7];
        encodedKey[20] = rdata[11];
        encodedKey[21] = sidBytes[8];
        encodedKey[22] = sidBytes[9];
        encodedKey[23] = sidBytes[10];
        encodedKey[24] = rdata[15];
        encodedKey[25] = rdata[7];
        encodedKey[26] = rdata[18];
        encodedKey[27] = rdata[23];
        encodedKey[28] = rdata[21];
        encodedKey[29] = sidBytes[4];
        encodedKey[30] = rdata[26];
        encodedKey[31] = rdata[25];
        encodedKey[32] = rdata[22];
        encodedKey[33] = sidBytes[5];
        encodedKey[34] = rdata[20];
        encodedKey[35] = rdata[24];
        encodedKey[36] = sidBytes[6];
        encodedKey[37] = sidBytes[7];
        encodedKey[38] = rdata[16];
        encodedKey[39] = sidBytes[8];
        encodedKey[40] = rdata[19];
        encodedKey[41] = sidBytes[10];
        encodedKey[42] = rdata[17];
        encodedKey[43] = sidBytes[7];
        encodedKey[44] = rdata[28];
        encodedKey[45] = sidBytes[1];
        encodedKey[46] = sidBytes[0];
        encodedKey[47] = sidBytes[4];
        encodedKey[48] = rdata[31];
        encodedKey[49] = sidBytes[11];
        encodedKey[50] = rdata[27];
        encodedKey[51] = sidBytes[5];
        encodedKey[52] = sidBytes[8];
        encodedKey[53] = sidBytes[32];
        encodedKey[54] = sidBytes[6];
        encodedKey[55] = sidBytes[7];
        encodedKey[56] = sidBytes[24];
        encodedKey[57] = sidBytes[8];
        encodedKey[58] = rdata[30];
        encodedKey[59] = sidBytes[10];
        encodedKey[60] = sidBytes[12];
        encodedKey[61] = rdata[29];
        int i = 61;
        int j = 0;
        while (i < encodedKey.length) {
            if (j < sidBytes.length - 1) {
                encodedKey[i] = sidBytes[j++];
            } else {
                j = 0;
                encodedKey[i] = sidBytes[0];
            }
            ++i;
        }
        byte[] b64 = Base64.encode(encodedKey);
        return new String(b64);
    }

    private String getKey(NetletUser user) throws ServletException, IOException, SSOException {
        String oKey = user.getSSOToken().getProperty("_sessionKey");
        if (oKey == null) {
            byte[] rdata = new byte[32];
            this.sRandom.nextBytes(rdata);
            oKey = this.getSessionKey(rdata, user.getSSOTokenID());
            user.getSSOToken().setProperty("_sessionKey", oKey);
        }
        return oKey;
    }

    public String getStaticUrl() {
        try {
            return this.getServletConfig().getServletContext().getInitParameter("staticContext");
        }
        catch (NullPointerException npe) {
            this.debug.error("Cannot find init parameter - staticContext");
            return new String("/ips-static");
        }
    }

    public String getDynamicUrl() {
        try {
            return this.getServletConfig().getServletContext().getInitParameter("dynamicContext");
        }
        catch (NullPointerException npe) {
            this.debug.error("Cannot find init parameter - dynamicContext");
            return new String("/ips");
        }
    }

    public String getDefaultRedirectURL(NetletUser nu) {
        UserAttributes userAttrs = new UserAttributes(nu.getSSOToken(), "iplanet-am-auth-");
        String defaultRedirectURL = userAttrs.getString("default-url", "");
        return defaultRedirectURL;
    }

    public void redirectToPage(HttpServletResponse res, String stat, String val, String loc, String charset) {
        StringBuffer outBuffer = new StringBuffer();
        try {
            if (charset != null && charset.trim().length() != 0) {
                res.setContentType("text/html; charset=" + charset);
            } else {
                res.setContentType("text/html");
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), charset)));
            ResourceBundle bundle = null;
            bundle = loc == null || loc.trim().length() == 0 ? Locale.getInstallResourceBundle((String)"srapNetletServlet") : Locale.getResourceBundle((String)"srapNetletServlet", (String)loc);
            outBuffer.append("<html>\n");
            outBuffer.append("<BODY TEXT=\"").append(bundle.getString("ntxcolor"));
            outBuffer.append("\" BGCOLOR=\"").append(bundle.getString("nbgcolor")).append("\">\n");
            outBuffer.append("<p>").append(bundle.getString(stat));
            if (val != null && val.trim().length() != 0) {
                outBuffer.append(val);
            }
            outBuffer.append("</body>\n");
            outBuffer.append("</html>\n");
            out.print(outBuffer.toString());
            out.close();
        }
        catch (IOException ioe) {
            this.debug.error("Error redirecting to session invalid page." + ioe);
        }
    }

    public void storeProxySettings(NetletUser nu) {
        HttpServletRequest req = nu.getReq();
        UserAttributes attrs = nu.getNetletUserAttributes();
        try {
            attrs.setString("ProxyType", req.getParameter("proxytype"));
            attrs.setString("ProxyHost", req.getParameter("proxyhost"));
            attrs.setString("ProxyPort", req.getParameter("proxyport"));
            attrs.setString("ProxyOverride", req.getParameter("proxyoverride"));
        }
        catch (Exception e) {
            this.debug.error("Exception in setting attribute: " + e);
        }
        nu.setNetletUserAttributes(attrs);
        HttpServletResponse res = nu.getRes();
        try {
            PrintWriter out = res.getWriter();
            out.println("");
            out.close();
        }
        catch (IOException ioe) {
            this.debug.error("Exception in sending respose : " + ioe);
        }
    }

    public void doReauth(NetletUser nu) {
        HttpServletRequest req = nu.getReq();
        String password = req.getParameter("password");
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            password = this.extractParameter(req, "password");
        }
        String result = this.verifyPassword(nu, password);
        this.writeResult(nu, result);
    }

    public String verifyPassword(NetletUser nu, String password) {
        if (password == null || password.trim().length() == 0) {
            return "FAILED";
        }
        UserAttributes attrs = nu.getNetletUserAttributes();
        String actualPassword = attrs.getString("Password", "srap-netlet");
        return actualPassword.equals(password) ? "SUCCESS" : "FAILED";
    }

    public void writeResult(NetletUser nu, String result) {
        HttpServletResponse res = nu.getRes();
        try {
            PrintWriter out = res.getWriter();
            out.println(result);
            out.close();
        }
        catch (IOException ioe) {
            this.debug.error("Exception in sending respose : " + ioe);
        }
    }

    public String extractParameter(HttpServletRequest req, String paramName) {
        HashMap<String, String> reqList = new HashMap<String, String>();
        try {
            DataInputStream in = new DataInputStream((InputStream)req.getInputStream());
            int formDataLength = req.getContentLength();
            byte[] dataBytes = new byte[formDataLength];
            in.readFully(dataBytes);
            String file = new String(dataBytes, "ISO-8859-1");
            dataBytes = null;
            StringTokenizer strTok = new StringTokenizer(file, "&");
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                int ind = token.indexOf("=");
                if (ind <= -1) continue;
                String key = token.substring(0, ind);
                String value = token.substring(ind + 1);
                reqList.put(key, value);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return URLDecoder.decode(reqList.get(paramName).toString());
    }

    class NetletUser {
        private Hashtable netletRules = new Hashtable();
        private HttpServletRequest req = null;
        private HttpServletResponse res = null;
        private boolean portWarn = false;
        private boolean portwarnCheckbox = true;
        private boolean doReauth = false;
        private int defaultLoopbackPort = 8000;
        private String enc = null;
        private ResourceBundle bundle = null;
        private ResourceBundle appletBundle = null;
        private String HTMLcharsetname = null;
        private SSOToken ssoToken = null;
        private UserAttributes amUserAttrs = null;
        private UserAttributes srapNetletAttrs = null;
        private Hashtable cipherList = new Hashtable();
        private Hashtable userCipherPreference = new Hashtable();
        private String defaultCipher = null;

        private SSOToken createSSOToken(HttpServletRequest httpreq) {
            SSOToken token = null;
            String cookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
            Cookie[] cks = httpreq.getCookies();
            if (cks != null) {
                int i = 0;
                while (i < cks.length) {
                    String cName = cks[i].getName();
                    if (cName != null && cName.equals(cookieName)) {
                        String sessID = cks[i].getValue();
                        try {
                            token = SSOTokenManager.getInstance().createSSOToken(sessID);
                        }
                        catch (SSOException ssoe) {
                            try {
                                token = SSOTokenManager.getInstance().createSSOToken(URLDecoder.decode(sessID));
                            }
                            catch (SSOException ssoe2) {}
                        }
                        break;
                    }
                    ++i;
                }
            }
            return token;
        }

        public NetletUser(HttpServletRequest httpreq) throws SSOException {
            this.req = httpreq;
            this.ssoToken = this.createSSOToken(this.req);
            if (this.ssoToken == null) {
                throw new SSOException("NetletUser.java Can't get ssoToken");
            }
            this.amUserAttrs = new UserAttributes(this.ssoToken, "iplanet-am-user-");
            this.srapNetletAttrs = new UserAttributes(this.ssoToken, "sunPortalNetlet");
            this.enc = this.amUserAttrs.getPreferredLocale(Locale.getDefaultLocale().toString());
            this.bundle = Locale.getResourceBundle((String)"srapNetletServlet", (String)this.enc);
            this.appletBundle = Locale.getResourceBundle((String)"srapNetletApplet", (String)this.enc);
            this.HTMLcharsetname = this.findHTMLCharset(this.req);
            NetletConfig.this.debug.message("Netlet using encoding : " + this.enc + "  charset : " + this.HTMLcharsetname);
            this.defaultCipher = this.srapNetletAttrs.getString("DefaultCipher", "RC4");
            List userCipherList = this.srapNetletAttrs.getStringList("UserCipher");
            StringBuffer algoBuff = new StringBuffer();
            int x = 0;
            while (x < userCipherList.size()) {
                algoBuff.append((String)userCipherList.get(x)).append("|");
                ++x;
            }
            StringTokenizer algoSplitter = new StringTokenizer(algoBuff.toString(), "|");
            while (algoSplitter.hasMoreElements()) {
                this.userCipherPreference.put(algoSplitter.nextToken(), algoSplitter.nextToken());
            }
        }

        public String findHTMLCharset(HttpServletRequest req) {
            String HTMLcharset = null;
            AMClientDetector amCD = new AMClientDetector();
            String clientType = amCD.getClientType(req);
            try {
                Client clientObj = Client.getInstance((String)clientType);
                HTMLcharset = clientObj.getCharset(Locale.getLocale((String)this.getLocale()));
            }
            catch (ClientException ce) {
                NetletConfig.this.debug.error("NetletConfig: ClientException in determining charset, reading charset from properties file.");
                try {
                    HTMLcharset = this.getBundle().getString("HTMLcharset");
                }
                catch (Exception mre) {
                    NetletConfig.this.debug.error("NetletConfig: Exception in reading HTMLcharset from properties file, using ISO-8859-1.");
                    HTMLcharset = "ISO-8859-1";
                }
            }
            return HTMLcharset;
        }

        public String getAlgorithm(Rules r) {
            String ruleName = r.name;
            if (ruleName == null || ruleName.trim().length() == 0) {
                return "RC4";
            }
            if (r.algorithms == null || r.algorithms.size() == 0) {
                return this.defaultCipher;
            }
            if (r.algorithms.size() == 1) {
                return (String)r.algorithms.get(0);
            }
            Object algo = this.userCipherPreference.get(ruleName);
            if (algo == null || algo.equals("null") || !r.algorithms.contains(algo)) {
                return (String)r.algorithms.get(0);
            }
            return algo.toString();
        }

        public String getKeyLength(String algoName) {
            Object key;
            if (algoName == null) {
                return new Integer(128).toString();
            }
            if (algoName.indexOf("/") != -1) {
                algoName = algoName.substring(0, algoName.indexOf("/") - 1);
            }
            if ((key = this.cipherList.get(algoName)) == null || key.equals("null")) {
                return new Integer(128).toString();
            }
            return key.toString();
        }

        public String getDefaultCipher() {
            return this.defaultCipher;
        }

        public void getUserAttributes() throws SSOException {
            this.portWarn = this.srapNetletAttrs.getBoolean("PortWarn", true);
            this.doReauth = this.srapNetletAttrs.getBoolean("DoReauth", false);
            this.portwarnCheckbox = this.srapNetletAttrs.getBoolean("PortWarnCheckbox", true);
            List algoEnum = this.srapNetletAttrs.getStringList("Ciphers");
            StringBuffer algoList = new StringBuffer();
            int x = 0;
            while (x < algoEnum.size()) {
                algoList.append((String)algoEnum.get(x)).append("|");
                ++x;
            }
            StringTokenizer algoSplitter = new StringTokenizer(algoList.toString(), "|");
            while (algoSplitter.hasMoreElements()) {
                this.cipherList.put(algoSplitter.nextToken(), algoSplitter.nextToken());
            }
            this.defaultLoopbackPort = this.srapNetletAttrs.getInt("ClientLoopbackPort", 8000);
            this.parseRules(new ArrayList(this.srapNetletAttrs.getStringList("Rules")));
        }

        public int getDefaultLBPort() {
            return this.defaultLoopbackPort;
        }

        public boolean getPortWarn() {
            return this.portWarn;
        }

        public boolean getPortWarnCheckbox() {
            return this.portwarnCheckbox;
        }

        public boolean getReauth() {
            return this.doReauth;
        }

        public void addRule(Rules r) {
            if (r == null) {
                return;
            }
            this.netletRules.put(r.name, r);
        }

        public Enumeration getRules() {
            return this.netletRules.elements();
        }

        public Rules getRule(String cmd) {
            return (Rules)this.netletRules.get(cmd);
        }

        private void parseRules(ArrayList cmds) {
            StringTokenizer algoTokens = null;
            String tmpStr = null;
            int x = 0;
            while (x < cmds.size()) {
                block18: {
                    String rule = (String)cmds.get(x);
                    boolean isExtend = rule.endsWith("EXTEND");
                    if (isExtend) {
                        rule = rule.substring(0, rule.lastIndexOf("|"));
                    }
                    Rules r = new Rules();
                    StringTokenizer st = new StringTokenizer(rule, "|");
                    try {
                        while (st.hasMoreElements()) {
                            String tmp;
                            tmpStr = (String)st.nextElement();
                            algoTokens = new StringTokenizer(tmpStr, "^");
                            try {
                                r.name = algoTokens.nextElement().toString();
                                tmpStr = algoTokens.nextElement().toString();
                                if (tmpStr.startsWith("ALGO")) {
                                    r.isAlgoUserConfigurable = true;
                                    try {
                                        tmpStr = algoTokens.nextElement().toString();
                                    }
                                    catch (NoSuchElementException ne) {
                                        tmpStr = this.defaultCipher;
                                    }
                                }
                                algoTokens = new StringTokenizer(tmpStr, "+");
                                while (algoTokens.hasMoreElements()) {
                                    r.algorithms.add(algoTokens.nextElement());
                                }
                            }
                            catch (NoSuchElementException ne) {
                                r.name = tmpStr;
                                r.algorithms.add(this.defaultCipher);
                            }
                            r.url = (String)st.nextElement();
                            if (r.url.equalsIgnoreCase("null")) {
                                r.url = "";
                            }
                            if ((tmp = (String)st.nextElement()).equalsIgnoreCase("false")) {
                                r.loopback = false;
                            } else if (tmp.equalsIgnoreCase("true")) {
                                r.loopback = true;
                                r.clientLoopbackPort = new String("" + this.defaultLoopbackPort + "");
                                r.loopbackServer = NetletConfig.this.serverName;
                                r.serverLoopbackPort = NetletConfig.this.serverPort;
                            } else {
                                StringTokenizer st1 = new StringTokenizer(tmp, ":");
                                r.loopback = true;
                                r.clientLoopbackPort = (String)st1.nextElement();
                                r.loopbackServer = (String)st1.nextElement();
                                r.serverLoopbackPort = (String)st1.nextElement();
                                r.lport.add(r.clientLoopbackPort);
                                r.dhost.add(r.loopbackServer);
                                r.dport.add(r.serverLoopbackPort);
                                ++r.ruleCount;
                            }
                            while (st.hasMoreElements()) {
                                ++r.ruleCount;
                                r.lport.add(this.expandAttributes((String)st.nextElement()));
                                r.dhost.add(this.expandAttributes((String)st.nextElement()));
                                r.dport.add(this.expandAttributes((String)st.nextElement()));
                            }
                            r.isExtend = isExtend;
                        }
                    }
                    catch (NoSuchElementException ex) {
                        break block18;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    this.addRule(r);
                }
                ++x;
            }
        }

        private String expandAttributes(String val) {
            int i = val.indexOf(36);
            if (i == -1) {
                return val;
            }
            int state = 0;
            StringBuffer buf = new StringBuffer();
            StringBuffer attr = null;
            char[] cval = val.toCharArray();
            while (i < cval.length) {
                char c = cval[i++];
                switch (state) {
                    case 0: {
                        if (c == '$') {
                            state = 1;
                            break;
                        }
                        buf.append(c);
                        break;
                    }
                    case 1: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                            attr = new StringBuffer();
                            attr.append(c);
                            state = 2;
                            break;
                        }
                        if (c == '{') {
                            attr = new StringBuffer();
                            state = 3;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') {
                            attr.append(c);
                            break;
                        }
                        buf.append(this.getAttr(attr.toString()));
                        buf.append(c);
                        state = 0;
                        break;
                    }
                    case 3: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') {
                            attr.append(c);
                            break;
                        }
                        if (c == '}') {
                            buf.append(this.getAttr(attr.toString()));
                            state = 0;
                            break;
                        }
                        state = 0;
                    }
                }
            }
            switch (state) {
                case 1: {
                    break;
                }
                case 2: {
                    buf.append(this.getAttr(attr.toString()));
                    break;
                }
            }
            String rval = buf.toString();
            return rval;
        }

        private String getAttr(String aname) {
            return this.amUserAttrs.getString(aname, "");
        }

        public void setReq(HttpServletRequest r) {
            this.req = r;
        }

        public HttpServletRequest getReq() {
            return this.req;
        }

        public void setRes(HttpServletResponse r) {
            this.res = r;
        }

        public HttpServletResponse getRes() {
            return this.res;
        }

        public String getLocale() {
            return this.enc;
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }

        public ResourceBundle getAppletBundle() {
            return this.appletBundle;
        }

        public String getHTMLcharsetname() {
            return this.HTMLcharsetname;
        }

        public SSOToken getSSOToken() {
            return this.ssoToken;
        }

        public SSOTokenID getSSOTokenID() {
            return this.ssoToken.getTokenID();
        }

        public UserAttributes getAMUserAttributes() {
            return this.amUserAttrs;
        }

        public UserAttributes getNetletUserAttributes() {
            return this.srapNetletAttrs;
        }

        public void setNetletUserAttributes(UserAttributes attrs) {
            this.srapNetletAttrs = attrs;
        }

        public String getClientHostName() throws SSOException {
            return this.ssoToken.getHostName();
        }

        public String getClientID() throws SSOException, AMException {
            AMStoreConnection amsc = new AMStoreConnection(this.ssoToken);
            AMUser amuser = amsc.getUser(this.ssoToken.getPrincipal().getName());
            String dn = amuser.getDN();
            String clientId = "";
            try {
                clientId = dn.substring(dn.indexOf("=") + 1, dn.indexOf(","));
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            return clientId;
        }

        public boolean inPrivilegeList(String privilege, String value, boolean ignoreCase, boolean isHost) {
            if (value == null) {
                return false;
            }
            boolean stringMatch = false;
            ArrayList privilegeList = new ArrayList(this.srapNetletAttrs.getStringList(privilege));
            if (privilegeList != null) {
                int i = 0;
                while (i < privilegeList.size()) {
                    String privilegeString = (String)privilegeList.get(i);
                    if (privilegeString.equals("*")) {
                        return true;
                    }
                    if (isHost && !NetletConfig.this.isIPAddress(privilegeString) && privilegeString.indexOf(".") == -1 && NetletConfig.this.isValidHost(privilegeString) && NetletConfig.this.serverDomain != null) {
                        privilegeString = privilegeString + ".";
                        privilegeString = privilegeString + NetletConfig.this.serverDomain;
                    }
                    if (stringMatch = ignoreCase ? this.wildcardMatch(value.toLowerCase(), privilegeString.toLowerCase()) : this.wildcardMatch(value, privilegeString)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private boolean wildcardMatch(String str1, String str2) {
            block11: {
                beginIndex1 = 0;
                endIndex1 = 0;
                beginIndex2 = 0;
                endIndex2 = 0;
                strlen1 = str1.length();
                strlen2 = str2.length();
                substr = null;
                if (str1 == null || str2 == null) {
                    return false;
                }
                endIndex2 = str2.indexOf(42, beginIndex2);
                if (endIndex2 == -1) break block11;
                substr = str2.substring(beginIndex2, endIndex2);
                if (endIndex2 > beginIndex2) {
                    if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                        return false;
                    }
                    if (beginIndex1 != beginIndex2) {
                        return false;
                    }
                }
                beginIndex1 += endIndex2 - beginIndex2;
                if (endIndex2 >= strlen2 - 1) {
                    return true;
                }
                beginIndex2 = endIndex2 + 1;
                if (true) ** GOTO lbl36
            }
            beginIndex1 = str1.indexOf(str2);
            if (beginIndex1 == -1) {
                return false;
            }
            return strlen1 == strlen2;
            do {
                substr = str2.substring(beginIndex2, endIndex2);
                if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                beginIndex1 += endIndex2 - beginIndex2;
                if (endIndex2 >= strlen2 - 1) {
                    return true;
                }
                beginIndex2 = endIndex2 + 1;
lbl36:
                // 2 sources

            } while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1);
            substr = str2.substring(beginIndex2, strlen2);
            endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
            if (endIndex1 == -1) {
                return false;
            }
            if (beginIndex1 > endIndex1) {
                return false;
            }
            beginIndex1 = endIndex1;
            return strlen1 - beginIndex1 == strlen2 - beginIndex2;
        }
    }
}

