/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.sun.nfs.XFileExtensionAccessor;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.shared.NetFileException;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;

class NfsFile {
    private Debug debug;
    public static boolean SHOULD_HAVE_READ_PERMISSION = true;
    public static boolean SHOULD_NOT_HAVE_READ_PERMISSION = false;
    public static final String encoding = "UTF8";
    private static final int[] ia_unable_to_login = new int[]{-1, -1};
    private String s_machine_encoding;
    private XFileInputStream instream = null;
    private XFileOutputStream outstream = null;
    private int i_number_of_directories_traversed;
    public int authenticationPort = 57946;

    public native int[] getUserInfo(String var1) throws Exception;

    NfsFile(String s_machine_encoding) {
        this.s_machine_encoding = s_machine_encoding;
        this.i_number_of_directories_traversed = 0;
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    NfsFile(String s_machine_encoding, int authPort) {
        this(s_machine_encoding);
        this.authenticationPort = authPort;
    }

    int[] getUserIDs(String user_name, String password) throws NetFileException {
        int[] i_ids = ia_unable_to_login;
        try {
            i_ids = this.getUserInfo(new String(user_name.getBytes(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new NetFileException(500, "System encoding used(UTF8) is not supported for authentication");
        }
        catch (Exception e) {
            throw new NetFileException(500, "Unable to login. Please verify login id and password");
        }
        if (i_ids[0] == -1) {
            throw new NetFileException(500, "Unable to login. Please verify login id and password");
        }
        return i_ids;
    }

    String mkdir(String machine, String share, String user_name, String password, String target_dir, String directory_to_create, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, user_name, password)) {
                throw new NetFileException(500, "Unable to login. Please verify login id and password");
            }
            int[] i_ids = this.getUserIDs(user_name, password);
            XFile xf_parent_dir = this.getXFile(share, machine, target_dir, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_dir.canWrite()) {
                throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.3", new Object[]{xf_parent_dir.getPath()}));
            }
            XFile xfile = this.getXFile(share, machine, target_dir + "/" + directory_to_create, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
            if (!xfile.mkdir()) {
                throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.4"));
            }
        }
        catch (Exception e) {
            if (e instanceof NetFileException) {
                throw (NetFileException)e;
            }
            throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.4"));
        }
        return nfr_user_locale_i18n_bucket.getString("warning52");
    }

    String[] getNFSDir(String username, String password, String VMSnam, String machname, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
            throw new NetFileException(500, "Unable to login. Please verify login id and password");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xfile = this.getXFile(VMSnam, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        String[] sa_files_list = xfile.list();
        String[] sa_listing = null;
        if (sa_files_list == null) {
            throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.5"));
        }
        sa_listing = new String[sa_files_list.length * 4];
        int i = 0;
        int j = 0;
        while (i < sa_files_list.length) {
            XFile xf_curr_file = new XFile(xfile, sa_files_list[i]);
            sa_listing[j] = xf_curr_file.isFile() ? "-" : "d";
            sa_listing[++j] = xf_curr_file.getName();
            sa_listing[++j] = new Long(xf_curr_file.length()).toString();
            sa_listing[++j] = new Date(xf_curr_file.lastModified()).toString();
            ++j;
            ++i;
        }
        if (sa_listing == null) {
            throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.5"));
        }
        return sa_listing;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        block14: {
            temp_file = null;
            try {
                try {
                    if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                        throw new NetFileException(500, "Unable to login. Please verify login id and password");
                    }
                    i_ids = this.getUserIDs(username, password);
                    this.writeDebug("Getting file " + machname + ":" + VMSname + dir_nam + "/" + mainfilename);
                    xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, NfsFile.SHOULD_HAVE_READ_PERMISSION, i_ids);
                    xfis_file = new XFileInputStream(xfile);
                    time = new Long(System.currentTimeMillis());
                    s_temp_file = tmpdir + "/" + time.toString() + username.toUpperCase() + mainfilename;
                    temp_file = new File(s_temp_file);
                    temp_file.createNewFile();
                    fops_tmp = new FileOutputStream(temp_file);
                    c = 0;
                    while (true) {
                        if ((c = xfis_file.read()) <= -1) {
                            fops_tmp.close();
                            fops_tmp = null;
                            xfis_file.close();
                            xfis_file = null;
                            xfile = null;
                            time = null;
                            temp_file = null;
                            this.writeDebug("Got " + machname + ":" + VMSname + dir_nam + "/" + mainfilename);
                            var18_20 = s_temp_file;
                            var20_21 = null;
                            if (temp_file == null) return var18_20;
                            break;
                        }
                        fops_tmp.write(c);
                    }
                }
                catch (Exception e) {
                    this.writeErrorDebug("Error in putting NFS File", e);
                    var12_14 = "ERROR:" + e.getMessage();
                    var20_22 = null;
                    if (temp_file == null) return var12_14;
                    try {
                        temp_file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    temp_file = null;
                    return var12_14;
                }
            }
            catch (Throwable var19_27) {
                block13: {
                    var20_23 = null;
                    if (temp_file == null) throw var19_27;
                    ** try [egrp 2[TRYBLOCK] [2 : 384->393)] { 
lbl54:
                    // 1 sources

                    temp_file.delete();
                    break block13;
lbl57:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                temp_file = null;
                throw var19_27;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 384->393)] { 
lbl64:
            // 1 sources

            temp_file.delete();
            break block14;
lbl67:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        temp_file = null;
        return var18_20;
    }

    /*
     * Unable to fully structure code
     */
    String putNFSFile(String username, String password, String machname, String VMSname, String localfil_arg, String remotefil_arg, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        block15: {
            f_local_file = null;
            try {
                if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                    throw new NetFileException(500, "Unable to login. Please verify login id and password");
                }
                i_ids = this.getUserIDs(username, password);
                xf_parent_dir = this.getXFile(VMSname, machname, dir_nam, true, NfsFile.SHOULD_HAVE_READ_PERMISSION, i_ids);
                if (!xf_parent_dir.canWrite()) {
                    throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.3", new Object[]{xf_parent_dir.getPath()}));
                }
                xfile = this.getXFile(VMSname, machname, dir_nam + "/" + remotefil_arg, false, NfsFile.SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
                f_local_file = new File(localfil_arg);
                if (!f_local_file.exists()) {
                    throw new NetFileException();
                }
                fips_local_file = new FileInputStream(f_local_file);
                xfops_destination_file = new XFileOutputStream(xfile);
                c = 0;
                while ((c = fips_local_file.read()) > -1) {
                    xfops_destination_file.write(c);
                }
                fips_local_file.close();
                f_local_file.delete();
                fips_local_file = null;
                xfops_destination_file.close();
                xfops_destination_file = null;
                f_local_file = null;
                xf_parent_dir = null;
                xfile = null;
                var18_19 = null;
                ** if (f_local_file == null) goto lbl-1000
            }
            catch (Throwable var17_25) {
                var18_21 = null;
                if (f_local_file != null) {
                    try {
                        f_local_file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var17_25;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    f_local_file.delete();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception e) {
                    this.writeErrorDebug("Error in putting NFS File", e);
                    var12_14 = "ERROR:" + e.getMessage();
                    var18_20 = null;
                    if (f_local_file != null) {
                        try {
                            f_local_file.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return var12_14;
                }
            }
        }
        f_local_file = null;
        return nfr_user_locale_i18n_bucket.getString("info6");
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, String domainname, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        return this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir);
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir) throws NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, usernam, passwrd)) {
            throw new NetFileException(500, "Unable to login. Please verify login id and password");
        }
        int[] i_ids = this.getUserIDs(usernam, passwrd);
        XFile xfile = this.getXFile(VMSnam, machnam, dir_nam, true, false, i_ids);
        String s_prefix = "nfs://" + machnam;
        int i_prefix_length = s_prefix.length();
        if (xfile.isFile()) {
            throw new NetFileException(500, "Exception occured in the search " + s_prefix);
        }
        Vector<String> v_search_results = new Vector<String>();
        if (xfile.toString().substring(i_prefix_length, xfile.toString().length()).indexOf(pattern) > -1) {
            v_search_results.addElement(xfile.toString().substring(i_prefix_length, xfile.toString().length()));
        }
        int i_directories_searched = 0;
        this.search(xfile, ++i_directories_searched, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids);
        String[] sa_resulsts = new String[v_search_results.size()];
        int i = 0;
        while (i < v_search_results.size()) {
            sa_resulsts[i] = (String)v_search_results.elementAt(i);
            this.writeDebug("Search result:" + sa_resulsts[i]);
            ++i;
        }
        return sa_resulsts;
    }

    void search(XFile xfile, int i_directories_searched, int maxsrchdir, int i_prefix_length, Vector v_search_results, String pattern, int[] i_ids) throws NetFileException {
        ++this.i_number_of_directories_traversed;
        if (i_directories_searched > maxsrchdir) {
            return;
        }
        if (xfile.isFile()) {
            throw new NetFileException(500, "Exception occured in the search ");
        }
        String[] sa_contents = xfile.list();
        String s_path = xfile.toString();
        this.writeDebug("Searching:" + s_path);
        if (sa_contents == null) {
            v_search_results.addElement("Permission denied :" + s_path.substring(i_prefix_length, s_path.length()));
        } else {
            int i = 0;
            while (i < sa_contents.length && this.i_number_of_directories_traversed <= maxsrchdir) {
                String s_current_path = s_path + "/" + sa_contents[i];
                XFile x_file = null;
                try {
                    x_file = this.getXFile(s_current_path, true, false, i_ids);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (sa_contents[i].indexOf(pattern) > -1) {
                    v_search_results.addElement(x_file.toString().substring(i_prefix_length, x_file.toString().length()));
                }
                if (x_file.isDirectory()) {
                    if (x_file.canRead()) {
                        this.search(x_file, ++i_directories_searched, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids);
                    } else {
                        v_search_results.addElement("Permission denied :" + x_file.toString().substring(i_prefix_length, x_file.toString().length()));
                    }
                }
                ++i;
            }
        }
    }

    String delNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                throw new NetFileException(500, "Unable to login. Please verify login id and password");
            }
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_directory = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.3", new Object[]{xf_parent_directory.getPath()}));
            }
            XFile xf_file = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_file.canWrite()) {
                throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("nf.3", new Object[]{xf_parent_directory.getPath()}));
            }
            xf_file.delete();
        }
        catch (Exception e) {
            this.writeErrorDebug("Error in putting NFS File", e);
            return "ERROR:" + e.getMessage();
        }
        return nfr_user_locale_i18n_bucket.getString("info5");
    }

    private String getFileURL(String VMSnam, String machname, String dir_nam) {
        StringBuffer sb_file_pointer = new StringBuffer("nfs://");
        sb_file_pointer.append(machname);
        sb_file_pointer.append(VMSnam);
        sb_file_pointer.append(dir_nam);
        return sb_file_pointer.toString();
    }

    public XFileOutputStream getNFSOutputStream(String username, String password, String machname, String VMSname, String remotefil_arg, String dir_nam) throws Exception, NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
            throw new NetFileException(500, "Unable to login. Please verify login id and password");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xf_parent_dir = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        if (!xf_parent_dir.canWrite()) {
            throw new NetFileException(500, "No permission to write to " + xf_parent_dir.getPath());
        }
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + remotefil_arg, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
        this.outstream = new XFileOutputStream(xfile);
        return this.outstream;
    }

    public XFileInputStream getNFSInputStream(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam) throws Exception, NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
            throw new NetFileException(500, "Unable to login. Please verify login id and password");
        }
        int[] i_ids = this.getUserIDs(username, password);
        this.writeDebug("Getting file " + machname + ":" + VMSname + dir_nam + "/" + mainfilename);
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        this.instream = new XFileInputStream(xfile);
        return this.instream;
    }

    public void closeNfsFile() throws IOException {
        if (this.instream != null) {
            this.instream.close();
        }
        if (this.outstream != null) {
            this.outstream.close();
        }
        this.instream = null;
        this.outstream = null;
    }

    private XFile getXFile(String s_nfs_url, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids) throws NetFileException {
        XFile xfile = new XFile(s_nfs_url);
        XFileExtensionAccessor nfsx = new XFileExtensionAccessor(xfile);
        int i_uid = i_ids[0];
        int i_gid = i_ids[1];
        int[] i_gids = new int[]{i_gid};
        nfsx.loginUGID(i_uid, i_gid, i_gids);
        if (b_file_should_exist) {
            if (!xfile.exists()) {
                this.writeDebug(xfile.toString() + "," + xfile.getPath() + " does not exist");
                throw new NetFileException(500, "Path to " + xfile.getPath() + " not found");
            }
            this.writeDebug(xfile.getPath() + " exists");
        }
        if (b_is_read_allowed && !xfile.canRead()) {
            throw new NetFileException(500, "Permission to read does not exist");
        }
        return xfile;
    }

    private XFile getXFile(String VMSName, String machname, String file, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids) throws NetFileException {
        this.writeDebug("Machine=" + machname + ",Share=" + VMSName + ",file=" + file);
        if (!VMSName.startsWith("/")) {
            VMSName = "/" + VMSName;
        }
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        this.writeDebug("Machine=" + machname + ",Share=" + VMSName + ",file=" + file);
        String s_nfs_url = this.getFileURL(VMSName, machname, file);
        this.writeDebug("File URL supplied to WebNFS is " + s_nfs_url);
        return this.getXFile(s_nfs_url, b_file_should_exist, b_is_read_allowed, i_ids);
    }

    void rename(String username, String password, String machine, String share, String directory, String old_file_name, String new_file_name) throws NetFileException {
        try {
            if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                throw new NetFileException(500, "Unable to login. Please verify login id and password");
            }
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_directory = this.getXFile(share, machine, directory, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(500, "Unable to rename file. Permission to write to " + xf_parent_directory.getPath() + " does not exist");
            }
            XFile xf_file = this.getXFile(share, machine, directory + "/" + old_file_name, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_file.canWrite()) {
                throw new NetFileException(500, "Unable to rename file. Permission to write to " + xf_parent_directory.getPath() + " does not exist");
            }
            XFile xf_renamed_file = new XFile(xf_parent_directory, new_file_name);
            if (xf_renamed_file.exists()) {
                this.writeDebug(xf_renamed_file + " exists");
                if (!xf_renamed_file.canWrite()) {
                    throw new NetFileException(500, "Permission to write to " + xf_parent_directory.getPath() + " does not exist");
                }
            }
            xf_file.renameTo(xf_renamed_file);
        }
        catch (Exception e) {
            this.writeErrorDebug("Error in putting NFS File", e);
            if (e instanceof NetFileException) {
                throw (NetFileException)e;
            }
            throw new NetFileException(500, "Unable to rename file. Permission to write to directory/file might not exist");
        }
    }

    /*
     * Loose catch block
     */
    boolean doAuthenticate(String host, int port, String username, String passwd) {
        boolean returnValue;
        block21: {
            Socket sock = null;
            returnValue = false;
            sock = new Socket(host, port);
            BufferedReader buffRdr = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(sock.getOutputStream(), "ISO-8859-1"));
            boolean stop = false;
            do {
                char[] buf = new char[254];
                int i = buffRdr.read(buf, 0, 254);
                String output = new String(buf);
                if (output.startsWith("Enter Service Name :")) {
                    pw.println("srapnetfileservice");
                    pw.flush();
                    continue;
                }
                if (output.startsWith("Enter Unix login:")) {
                    pw.println(username);
                    pw.flush();
                    continue;
                }
                if (output.startsWith("Enter password:")) {
                    pw.println(passwd);
                    pw.flush();
                    continue;
                }
                if (output.startsWith("Enter Client IP Address:")) {
                    pw.println("127.0.0.1");
                    pw.flush();
                    continue;
                }
                if (output.startsWith("Authentication passed")) {
                    stop = true;
                    returnValue = true;
                    continue;
                }
                if (output.indexOf("return") > 0) {
                    stop = true;
                    returnValue = false;
                    continue;
                }
                if (!output.startsWith("Authentication Failed")) continue;
                stop = true;
                returnValue = false;
            } while (!stop);
            Object var14_15 = null;
            try {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
                break block21;
            }
            catch (Exception ee) {
                returnValue = false;
            }
            break block21;
            {
                catch (ConnectException ce) {
                    this.writeErrorDebug("NfsFile, Exception while authenticating, ", ce);
                    returnValue = false;
                    Object var14_16 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                            sock = null;
                        }
                        break block21;
                    }
                    catch (Exception ee) {
                        returnValue = false;
                    }
                    break block21;
                }
                catch (Exception e) {
                    this.writeErrorDebug("NfsFile, Exception while authenticating, ", e);
                    returnValue = false;
                    Object var14_17 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                            sock = null;
                        }
                        break block21;
                    }
                    catch (Exception ee) {
                        returnValue = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    if (sock != null) {
                        sock.close();
                        sock = null;
                    }
                }
                catch (Exception ee) {
                    returnValue = false;
                }
                throw throwable;
            }
        }
        return returnValue;
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }

    static {
        System.loadLibrary("getpwnam2");
    }
}

