/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.netfile.servlet.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.NetFileContext;
import com.sun.portal.netfile.servlet.NetFileHostDataProcessor;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.servlet.NetFileServlet;
import com.sun.portal.netfile.shared.NetFileException;
import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class NetFileUserProfileHandler {
    private Debug debug = null;
    private SSOToken ssoToken = null;
    private NetFileContext nfContext = null;
    private NetFileResource nfRes = null;
    private NetFileAttributeExtractor nfAttrs = null;

    public NetFileUserProfileHandler(SSOToken token, NetFileContext context, NetFileResource res) {
        this.ssoToken = token;
        this.nfContext = context;
        this.nfRes = res;
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public Hashtable getSessionPreferences() throws NetFileException {
        return this.getNetFileUserAttributes();
    }

    public void saveSessionData(Vector nfReqData) throws NetFileException {
        try {
            HashMap<String, HashSet<String>> prefs;
            block12: {
                HashSet<String> hsWinLoc;
                block11: {
                    HashSet<String> hsWinSize;
                    block10: {
                        SSOToken ssoToken = (SSOToken)nfReqData.get(6);
                        Hashtable data = (Hashtable)nfReqData.get(4);
                        String winsize = (String)data.get("sunPortalNetFileWindowSize");
                        String winloc = (String)data.get("sunPortalNetFileWindowLocation");
                        Vector nfVecData = (Vector)data.get("sunPortalNetFileHostTypePassShare");
                        Enumeration e = nfVecData.elements();
                        HashSet<String> hsHostData = new HashSet<String>();
                        if (!nfVecData.isEmpty()) {
                            while (e.hasMoreElements()) {
                                hsHostData.add(AMPasswordUtil.encrypt((String)((String)e.nextElement())));
                            }
                        }
                        hsWinSize = new HashSet<String>();
                        hsWinSize.add(winsize);
                        hsWinLoc = new HashSet<String>();
                        hsWinLoc.add(winloc);
                        prefs = new HashMap<String, HashSet<String>>();
                        prefs.put("sunPortalNetFileHostTypePassShare", hsHostData);
                        try {
                            this.nfContext.savePreferences(prefs);
                        }
                        catch (Exception ex) {
                            if (!this.debug.messageEnabled()) break block10;
                            this.debug.message("Exception in saving user host data", (Throwable)ex);
                        }
                    }
                    prefs.remove("sunPortalNetFileHostTypePassShare");
                    prefs.put("sunPortalNetFileWindowSize", hsWinSize);
                    try {
                        this.nfContext.savePreferences(prefs);
                    }
                    catch (Exception ex) {
                        if (!this.debug.messageEnabled()) break block11;
                        this.debug.message("Exception in saving win size", (Throwable)ex);
                    }
                }
                prefs.remove("sunPortalNetFileWindowSize");
                prefs.put("sunPortalNetFileWindowLocation", hsWinLoc);
                try {
                    this.nfContext.savePreferences(prefs);
                }
                catch (Exception ex) {
                    if (!this.debug.messageEnabled()) break block12;
                    this.debug.message("Exception in saving win location", (Throwable)ex);
                }
            }
            this.nfContext.savePreferences(prefs);
        }
        catch (Exception e) {
            throw new NetFileException(6, "Exception in saving the session information");
        }
    }

    private Hashtable getNetFileUserAttributes() {
        String commondata = null;
        List mergedHosts = null;
        List listOfHosts = null;
        ArrayList deniedHosts = null;
        ArrayList allowedHosts = null;
        Hashtable<String, Object> htSessionData = new Hashtable<String, Object>();
        String szDefaultDomain = "";
        try {
            Principal princi = this.ssoToken.getPrincipal();
            String userIdentity = princi.getName();
            int startIndex = userIdentity.indexOf(61, 0);
            int endIndex = userIdentity.indexOf(44, 0);
            htSessionData.put("userid", userIdentity.substring(startIndex + 1, endIndex));
            Map[] prefs = this.nfContext.getPreferences();
            this.createNetFileAttributeExtractor(prefs[0]);
            this.nfContext.loadMailAttributesAsCollection(htSessionData);
            htSessionData.put("sunPortalNetFileNTDomain", this.nfAttrs.getString("sunPortalNetFileNTDomain", ""));
            htSessionData.put("sunPortalNetFileWindowLocation", this.nfAttrs.getString("sunPortalNetFileWindowLocation", "100|50"));
            htSessionData.put("sunPortalNetFileWindowSize", this.nfAttrs.getString("sunPortalNetFileWindowSize", "700|400"));
            htSessionData.put("iplanet-am-user-preferredlocale", this.nfContext.getUserLocale());
            szDefaultDomain = this.nfAttrs.getString("sunPortalNetFileDefaultDomain", "");
            htSessionData.put("sunPortalNetFileDefaultDomain", szDefaultDomain);
            deniedHosts = this.getDeniedHosts();
            if (this.debug.messageEnabled()) {
                if (deniedHosts != null) {
                    this.debug.message("Denied hosts obtained are " + ((Object)deniedHosts).toString());
                } else {
                    this.debug.message("Denied host list is empty for this user");
                }
            }
            allowedHosts = this.getAllowedHosts();
            if (this.debug.messageEnabled()) {
                if (allowedHosts != null) {
                    this.debug.message("Allowed hosts obtained are " + ((Object)allowedHosts).toString());
                } else {
                    this.debug.message("Allowed host list is empty for this user");
                }
            }
            commondata = this.getCommonHosts();
            listOfHosts = this.getUserAddedHosts();
            NetFileHostDataProcessor nfHostProc = new NetFileHostDataProcessor(null, this.nfContext, this.nfRes);
            nfHostProc.setDefaultDomain(szDefaultDomain);
            try {
                if (commondata != null && commondata.trim().length() != 0) {
                    if (listOfHosts == null || listOfHosts.isEmpty()) {
                        mergedHosts = nfHostProc.getMergedCommonDeniedHosts(commondata, deniedHosts, allowedHosts);
                        htSessionData.put("sunPortalNetFileUserCommonHostData", mergedHosts);
                    } else {
                        mergedHosts = nfHostProc.getMergedCommonUserHosts(commondata, deniedHosts, allowedHosts, listOfHosts);
                        htSessionData.put("sunPortalNetFileHostTypePassShare", mergedHosts);
                        htSessionData.put("sunPortalNetFileUserCommonHostData", nfHostProc.getNotMergedCommonHosts());
                    }
                } else if (listOfHosts != null && !listOfHosts.isEmpty()) {
                    mergedHosts = nfHostProc.mergeDeniedUserHosts(deniedHosts, allowedHosts, listOfHosts);
                    htSessionData.put("sunPortalNetFileHostTypePassShare", mergedHosts);
                }
            }
            catch (Exception e) {
                this.debug.error("Exception extracting common data or host data or in merging them", (Throwable)e);
            }
            if (nfHostProc.getCommonHostsAsList() == null) {
                htSessionData.put("sunPortalNetFileCommonHostData", new ArrayList(1));
            } else {
                htSessionData.put("sunPortalNetFileCommonHostData", nfHostProc.getCommonHostsAsList());
            }
            if (nfHostProc.getUserDeniedHostsAsList() == null) {
                htSessionData.put("sunPortalNetFileUserDeniedHostList", new ArrayList(1));
            } else {
                htSessionData.put("sunPortalNetFileUserDeniedHostList", nfHostProc.getUserDeniedHostsAsList());
            }
            if (deniedHosts == null) {
                deniedHosts = new ArrayList(1);
            }
            htSessionData.put("sunPortalNetFileDeniedHostList", deniedHosts);
            if (allowedHosts == null) {
                allowedHosts = new ArrayList(1);
            }
            htSessionData.put("sunPortalNetFileAllowedHostList", allowedHosts);
            htSessionData.put("sunPortalNetFileMaxSearchDir", this.nfAttrs.getInt("sunPortalNetFileMaxSearchDir", 100));
            htSessionData.put("sunPortalNetFileAccessWin", this.nfAttrs.getBoolean("sunPortalNetFileAccessWin", true).toString());
            htSessionData.put("sunPortalNetFileAccessNFS", this.nfAttrs.getBoolean("sunPortalNetFileAccessNFS", true).toString());
            htSessionData.put("sunPortalNetFileAccessFTP", this.nfAttrs.getBoolean("sunPortalNetFileAccessFTP", true).toString());
            htSessionData.put("sunPortalNetFileAccessNetware", this.nfAttrs.getBoolean("sunPortalNetFileAccessNetware", true).toString());
            htSessionData.put("sunPortalNetFileAllowDelete", this.nfAttrs.getBoolean("sunPortalNetFileAllowDelete", true));
            htSessionData.put("sunPortalNetFileAllowRename", this.nfAttrs.getBoolean("sunPortalNetFileAllowRename", true));
            htSessionData.put("sunPortalNetFileAllowChangeUserId", this.nfAttrs.getBoolean("sunPortalNetFileAllowChangeUserId", true).toString());
            htSessionData.put("sunPortalNetFileAllowChangeDomain", this.nfAttrs.getBoolean("sunPortalNetFileAllowChangeDomain", true).toString());
            htSessionData.put("sunPortalNetFileFileUploadLimit", this.nfAttrs.getInt("sunPortalNetFileFileUploadLimit", 5));
            this.nfAttrs.setUserAttributesMap(prefs[1]);
            htSessionData.put("sunPortalNetFileApplicationName", this.nfAttrs.getString("sunPortalNetFileApplicationName", "SunONE Portal Server"));
            htSessionData.put("sunPortalNetFileApplicationRelease", this.nfAttrs.getString("sunPortalNetFileApplicationRelease", "6.0.1"));
            htSessionData.put("sunPortalNetFileApplicationReleaseDate", this.nfAttrs.getString("sunPortalNetFileApplicationReleaseDate", "2003"));
            htSessionData.put("sunPortalNetFileCompanyName", this.nfAttrs.getString("sunPortalNetFileCompanyName", "Sun Microsystems Inc."));
            htSessionData.put("sunPortalNetFileOSCharSet", this.nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileOSCharSet", "UTF-8"));
            String szBaseTempDir = this.nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileTempDir", "/tmp");
            htSessionData.put("sunPortalNetFileTempDir", this.getTemporaryDirectory(this.ssoToken, szBaseTempDir));
            htSessionData.put("sunPortalNetFileSMBClientLocation", this.nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileSMBClientLocation", ""));
            htSessionData.put("sunPortalNetFileMimetypesConfigFileLocation", this.nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileMimetypesConfigFileLocation", ""));
            return htSessionData;
        }
        catch (Exception e) {
            this.debug.error("Exception getting attributes data", (Throwable)e);
            return null;
        }
    }

    private void createNetFileAttributeExtractor(Map m) {
        this.nfAttrs = new NetFileAttributeExtractor(m);
    }

    private List getUserAddedHosts() {
        return this.nfAttrs.getStringList("sunPortalNetFileHostTypePassShare");
    }

    private List getDeniedHosts() {
        return this.nfAttrs.getStringList("sunPortalNetFileDeniedHostList");
    }

    private String getCommonHosts() {
        return this.nfAttrs.getString("sunPortalNetFileCommonHostData", "");
    }

    private List getAllowedHosts() {
        return this.nfAttrs.getStringList("sunPortalNetFileAllowedHostList");
    }

    String getTemporaryDirectory(SSOToken ssoToken, String szBaseTempDir) throws NetFileException {
        if (szBaseTempDir == null || szBaseTempDir.trim().length() == 0) {
            throw new NetFileException(6, "Could not create temporary directory");
        }
        String szTheTempDir = null;
        try {
            szTheTempDir = this.createTemporaryDirectoryName(ssoToken, szBaseTempDir);
            if (!this.createTemporaryDirectory(szTheTempDir)) {
                throw new NetFileException(6, "Could not create temporary directory");
            }
            NetFileServlet.putTempDirCache(ssoToken.getTokenID().toString(), szTheTempDir);
            if (this.debug.messageEnabled()) {
                this.debug.message("Temporary directory created is " + szTheTempDir);
            }
            ssoToken.addSSOTokenListener((SSOTokenListener)NetFileServlet.getNetFileSessionCleaner());
        }
        catch (Exception e) {
            this.debug.error("Exception in creating temporary directory ", (Throwable)e);
            throw new NetFileException(6, "Could not create temporary directory");
        }
        return szTheTempDir;
    }

    String createTemporaryDirectoryName(SSOToken ssoToken, String szBaseTempDir) {
        String szSSOToken = ssoToken.getTokenID().toString();
        int index = szSSOToken.indexOf(64);
        int length = szSSOToken.length();
        int i = 0;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(szSSOToken.charAt(i))) {
                if (i <= 1) break;
                index = i;
                break;
            }
            ++i;
        }
        return szBaseTempDir + "/nfj2" + szSSOToken.substring(0, index);
    }

    boolean createTemporaryDirectory(String szTempDirName) {
        File tempDir = new File(szTempDirName);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
            if (!tempDir.exists()) {
                return false;
            }
        }
        if (!tempDir.canRead()) {
            return false;
        }
        return tempDir.canWrite();
    }
}

