/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.SerializedRequestProcessor;
import com.sun.portal.netfile.shared.NetFileException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class NetFileResource {
    private Debug debug = null;
    private HashMap ht_resource_bundle_entry_set;
    private String s_bundle;
    private String s_locale;
    private static HashMap ht_locales = new HashMap(6);

    public NetFileResource() {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public NetFileResource(String bundle, String locale) throws NetFileException {
        this();
        if (bundle == null || locale == null) {
            throw new NetFileException();
        }
        this.s_bundle = bundle;
        this.s_locale = locale;
        this.ht_resource_bundle_entry_set = this.getLocalisedBundle(bundle, this.s_locale);
    }

    public NetFileResource(String bundle) throws NetFileException {
        this();
        if (bundle == null) {
            throw new NetFileException();
        }
        String s_locale = Locale.getDefault().toString();
        if (s_locale == null || s_locale.equals("")) {
            throw new NetFileException();
        }
        this.s_bundle = bundle;
        this.s_locale = s_locale;
        this.ht_resource_bundle_entry_set = this.getLocalisedBundle(bundle, s_locale);
    }

    private synchronized HashMap getLocalisedBundle(String bundle, String locale) throws NetFileException {
        HashMap ht_locale_specific_bundles = this.getLocaleHashMap(locale);
        HashMap ht_locale_specific_bundle = (HashMap)ht_locale_specific_bundles.get(bundle);
        if (ht_locale_specific_bundle == null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("HashMap containing bundle " + bundle + " not found for locale " + locale);
            }
            ht_locale_specific_bundle = this.populatei18nBucket(bundle, locale);
            ht_locale_specific_bundles.put(bundle, ht_locale_specific_bundle);
            SerializedRequestProcessor.setResourceMap(locale, bundle, this);
        } else if (this.debug.messageEnabled()) {
            this.debug.message("HashMap containing bundle " + bundle + " found for locale " + locale);
        }
        return ht_locale_specific_bundle;
    }

    private HashMap getLocaleHashMap(String locale) throws NetFileException {
        try {
            HashMap ht_locale_specific_bundles = (HashMap)ht_locales.get(locale);
            if (ht_locale_specific_bundles == null) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("HashMap containing bundles for locale " + locale + " not found");
                }
                ht_locale_specific_bundles = new HashMap(2);
            } else if (this.debug.messageEnabled()) {
                this.debug.message("HashMap containing bundles for locale " + locale + " found");
            }
            ht_locales.put(locale, ht_locale_specific_bundles);
            return ht_locale_specific_bundles;
        }
        catch (Exception e) {
            this.debug.error("Exception in searching for HashMap containg bundles in a locale", (Throwable)e);
            throw new NetFileException();
        }
    }

    public String getString(String s_key) {
        Object o_value = this.ht_resource_bundle_entry_set.get(s_key);
        if (o_value == null) {
            this.debug.error("Key " + s_key + " does not exist in bundle " + this.s_bundle + " for locale " + this.s_locale);
            return s_key;
        }
        return (String)o_value;
    }

    public String getString(String key, Object[] args) {
        MessageFormat mf = new MessageFormat("");
        Locale loc = this.getLocale(this.s_locale);
        mf.setLocale(loc);
        mf.applyPattern(this.getString(key));
        return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public HashMap populatei18nBucket(String bundle, String locale) throws NetFileException {
        HashMap<String, Object> bucket = new HashMap<String, Object>();
        try {
            String key = null;
            Object value = null;
            Locale loc = this.getLocale(locale);
            ResourceBundle resBundle = ResourceBundle.getBundle(bundle, loc);
            Enumeration<String> e = resBundle.getKeys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                value = resBundle.getObject(key);
                bucket.put(key, value);
            }
        }
        catch (Exception e) {
            throw new NetFileException();
        }
        return bucket;
    }

    private Locale getLocale(String locale) {
        StringTokenizer locst;
        if (locale == null || locale.equals("")) {
            locale = Locale.getDefault().toString();
        }
        String lang = (locst = new StringTokenizer(locale, "_")).hasMoreTokens() ? locst.nextToken() : "";
        String country = locst.hasMoreTokens() ? locst.nextToken() : "";
        String variant = locst.hasMoreTokens() ? locst.nextToken() : "";
        while (locst.hasMoreTokens()) {
            variant = variant + "_" + locst.nextToken();
        }
        Locale loc = new Locale(lang, country, variant);
        return loc;
    }
}

