/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.portal.netfile.servlet.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.NetFileContext;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class NetFileContextImpl
implements NetFileContext,
SSOTokenListener {
    private AMUser user;
    private String szUserName;
    private AMStoreConnection connection;
    private Map userAttributes;
    private Locale userLocale;
    private String HTMLCharset;
    private Debug debug = null;
    private boolean applyDefault = false;

    public NetFileContextImpl(SSOToken token) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        try {
            this.connection = new AMStoreConnection(token);
            this.applyDefault = false;
            this.getAMUserObject(token);
            this.szUserName = token.getPrincipal().getName();
            this.userAttributes = this.getServiceAttributes("srapNetFileService");
        }
        catch (SSOException ssoe) {
            this.applyDefault = true;
            return;
        }
    }

    private Map[] getIPSPreferences() {
        Map[] nfAttrs = new HashMap[]{this.userAttributes == null ? this.getServiceAttributes("srapNetFileService") : this.userAttributes, this.getGlobalAttributes("srapNetFileService")};
        return nfAttrs;
    }

    private void getAMUserObject(SSOToken token) throws SSOException {
        this.user = this.connection.getUser(token.getPrincipal().getName());
    }

    private Map getServiceAttributes(String szServiceName) {
        try {
            Map serviceAttrs = szServiceName == null || szServiceName.length() == 0 ? this.user.getServiceAttributes("srapNetFileService") : this.user.getServiceAttributes(szServiceName);
            return serviceAttrs;
        }
        catch (SSOException ssoe) {
            ssoe.printStackTrace();
        }
        catch (AMException ame) {
            ame.printStackTrace();
        }
        return null;
    }

    private Map getGlobalAttributes(String szServiceName) {
        Map attrs = null;
        if (szServiceName == null || szServiceName.length() == 0) {
            return null;
        }
        try {
            AMSchema schema = this.connection.getSchema(szServiceName, AMSchema.Type.GLOBAL);
            attrs = schema.getAttributeDefaults();
            schema = null;
        }
        catch (AMException ame) {
            this.writeDebug("Exception in getting global attributes", (Exception)((Object)ame));
        }
        return attrs;
    }

    public String getOrganizationAttribute(String szServiceName, String szAttributeName, String szDefaultVal) {
        String value;
        String val;
        block9: {
            String orgDN = null;
            val = szDefaultVal;
            value = szDefaultVal;
            AMOrganization org = null;
            AMSchema schema = null;
            AMTemplate temp = null;
            try {
                orgDN = this.user.getOrganizationDN();
                if (orgDN == null) {
                    return null;
                }
                org = this.connection.getOrganization(orgDN);
                if (org.orgTemplateExists(szServiceName)) {
                    temp = org.getTemplate(szServiceName, 302);
                    Set vals = temp.getAttribute(szAttributeName);
                    if (vals != null && vals.size() > 0) {
                        Iterator iter = vals.iterator();
                        value = (String)iter.next();
                    }
                    break block9;
                }
                schema = this.connection.getSchema(szServiceName, AMSchema.Type.ORGANIZATION);
                Map mapVals = schema.getAttributeDefaults();
                NetFileAttributeExtractor nfAttrExtr = new NetFileAttributeExtractor(mapVals);
                String data = nfAttrExtr.getString(szAttributeName, szDefaultVal);
                if (data == null || data.trim().length() == 0) {
                    if (this.applyDefault) {
                        return szDefaultVal;
                    }
                    break block9;
                }
                return data;
            }
            catch (AMException ame) {
                this.writeDebug("AMException in getting Org Attribute ", (Exception)((Object)ame));
            }
            catch (SSOException ssoe) {
                this.writeDebug("SSOException in getting Org Attribute ", (Exception)((Object)ssoe));
            }
            catch (Exception e) {
                this.writeDebug("Exception in getting Org Attribute ", e);
            }
        }
        val = value;
        return val;
    }

    public List getOrganizationAttributeValues(String serviceName, String attributeName) {
        AbstractList data;
        block10: {
            String orgDN = null;
            data = null;
            try {
                orgDN = this.user.getOrganizationDN();
                if (orgDN == null) {
                    return null;
                }
                AMOrganization org = this.connection.getOrganization(orgDN);
                if (org.orgTemplateExists(serviceName)) {
                    AMTemplate template = org.getTemplate(serviceName, 302);
                    Set values = template.getAttribute(attributeName);
                    if (values != null && values.size() > 0) {
                        data = new ArrayList();
                        Iterator iter = values.iterator();
                        while (iter.hasNext()) {
                            data.add(iter.next());
                        }
                    }
                    break block10;
                }
                AMSchema schema = this.connection.getSchema(serviceName, AMSchema.Type.ORGANIZATION);
                Map mapVals = schema.getAttributeDefaults();
                Set keys = mapVals.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    Set values;
                    String attrib = (String)i.next();
                    if (!attrib.equalsIgnoreCase(attributeName) || (values = (Set)mapVals.get(attrib)) == null) continue;
                    data = new Vector();
                    Object[] obj = values.toArray();
                    int index = 0;
                    while (index < obj.length) {
                        data.add(obj[index]);
                        ++index;
                    }
                    break;
                }
            }
            catch (AMException ame) {
                this.writeDebug("AMException in getting Org Attribute ", (Exception)((Object)ame));
            }
            catch (SSOException ssoe) {
                this.writeDebug("SSOException in getting Org Attribute ", (Exception)((Object)ssoe));
            }
            catch (Exception e) {
                this.writeDebug("Exception in getting Org Attribute ", e);
            }
        }
        return data;
    }

    public Map[] getPreferences() {
        try {
            return this.getIPSPreferences();
        }
        catch (Exception e) {
            this.writeDebug("Error in getting preferences", e);
            return null;
        }
    }

    public boolean savePreferences(Map prefs) throws Exception {
        try {
            this.user.setAttributes(prefs);
        }
        catch (AMException pe) {
            this.writeDebug("Preferences not saved", (Exception)((Object)pe));
            return false;
        }
        catch (SSOException pe) {
            this.writeDebug("Preferences not saved", (Exception)((Object)pe));
            return false;
        }
        catch (Exception e) {
            this.writeDebug("Preferences not saved", e);
            return false;
        }
        try {
            this.user.store();
            return true;
        }
        catch (Exception e) {
            this.writeDebug("Preferences not saved", e);
            return false;
        }
    }

    public void ssoTokenChanged(SSOTokenEvent event) {
        try {
            SSOToken token = event.getToken();
            int type = event.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPolicyAssigned(SSOToken token) throws AMException, SSOException {
        boolean allowed;
        block5: {
            allowed = false;
            try {
                PolicyEvaluator policyEval = new PolicyEvaluator("srapNetFileService");
                allowed = policyEval.isAllowed(token, "", "sunPortalNetFileExecute", Collections.EMPTY_MAP);
                if (this.debug.messageEnabled() && !allowed) {
                    this.debug.message("NetFileContext.isExecutable: Not allowed to execute Netmail.");
                }
            }
            catch (PolicyException pe) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("NetFileContext.isExecutable: Policy evaluation failed. " + (Object)((Object)pe));
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("NetFileContext.isExecutable: Policy evaluation failed. " + (Object)((Object)ssoe));
            }
        }
        return allowed;
    }

    public boolean isServiceAssigned(String szServiceName) throws AMException, SSOException {
        Set vals = null;
        vals = this.user.getAssignedServices();
        if (vals == null || vals.isEmpty()) {
            this.writeDebug("NetFile service has not been assigned for the user");
            return false;
        }
        Iterator iter = vals.iterator();
        while (iter.hasNext()) {
            String szAServiceName = (String)iter.next();
            if (!szAServiceName.equals(szServiceName)) continue;
            return true;
        }
        return false;
    }

    public boolean isExecutable(SSOToken token) {
        try {
            return this.isPolicyAssigned(token) && this.isServiceAssigned("srapNetFileService");
        }
        catch (Exception e) {
            this.writeDebug("Exception in finding if user can use NetFile", e);
            return false;
        }
    }

    public boolean isSessionValid(SSOToken token) {
        try {
            if (token == null) {
                return false;
            }
            SSOTokenManager manager = SSOTokenManager.getInstance();
            if (!manager.isValidToken(token)) {
                return false;
            }
        }
        catch (Exception e) {
            this.writeDebug("Exception in determining if session is valid", e);
            return false;
        }
        return true;
    }

    public Locale getUserLocale() {
        Locale locale = null;
        try {
            Map data = this.getServiceAttributes("iPlanetAMUserService");
            Set values = (Set)data.get("preferredlocale");
            NetFileAttributeExtractor nfAttr = new NetFileAttributeExtractor(data);
            String locstr = nfAttr.getString("preferredlocale", Locale.getDefault().toString());
            StringTokenizer locst = new StringTokenizer(locstr, "_");
            if (locst.countTokens() > 0) {
                String lang = locst.hasMoreTokens() ? locst.nextToken() : "";
                String country = locst.hasMoreTokens() ? locst.nextToken() : "";
                String variant = locst.hasMoreTokens() ? locst.nextToken() : "";
                while (locst.hasMoreTokens()) {
                    variant = variant + "_" + locst.nextToken();
                }
                locale = new Locale(lang, country, variant);
            } else {
                locale = Locale.getDefault();
            }
            this.userLocale = locale;
            if (this.debug.messageEnabled()) {
                this.writeDebug("Locale is " + this.userLocale.toString());
            }
        }
        catch (Exception e) {
            this.writeDebug("UserLocale Error is ", e);
            return null;
        }
        return locale;
    }

    public void determineHTMLCharset(HttpServletRequest req) {
        AMClientDetector amCD = new AMClientDetector();
        String clientType = amCD.getClientType(req);
        try {
            Client clientObj = Client.getInstance((String)clientType);
            this.HTMLCharset = clientObj.getCharset(this.getUserLocale());
        }
        catch (ClientException ce) {
            this.writeDebug("ClientException in determining charset ", (Exception)((Object)ce));
        }
        this.writeDebug("HTML Charset is " + this.HTMLCharset);
        amCD = null;
        Object var3_3 = null;
    }

    public String getHTMLCharset() {
        return this.HTMLCharset;
    }

    public void loadMailAttributesAsCollection(Hashtable htMailData) {
        String fromAddr = "";
        String replyToAddr = "";
        String imapSrvr = "";
        String smtpSrvr = "";
        String imapUserId = "";
        String defaultMailDom = "";
        Map mailData = this.getServiceAttributes("SunPortalNetMailService");
        if (mailData == null || mailData.isEmpty()) {
            this.writeDebug("Could not obtain mail attributes");
            return;
        }
        NetFileAttributeExtractor nfAttr = new NetFileAttributeExtractor(mailData);
        imapSrvr = nfAttr.getString("sunPortalNetmailIMAPServerName", "");
        smtpSrvr = nfAttr.getString("sunPortalNetmailSMTPServerName", "");
        imapUserId = nfAttr.getString("sunPortalNetmailIMAPUserid", "");
        defaultMailDom = nfAttr.getString("sunPortalNetmailDefaultMailDomain", "");
        replyToAddr = nfAttr.getString("sunPortalNetmailReplyToAddress", "");
        if (imapSrvr != null && imapSrvr.length() != 0) {
            defaultMailDom = imapSrvr;
        }
        if (smtpSrvr != null && smtpSrvr.length() != 0) {
            defaultMailDom = smtpSrvr;
        }
        if (defaultMailDom != null) {
            fromAddr = defaultMailDom.length() != 0 ? (imapUserId != null && imapUserId.length() != 0 ? imapUserId + "@" + defaultMailDom : "") : "";
        }
        if (fromAddr == null) {
            htMailData.put("sunPortalUserFromAddress", "");
        } else {
            htMailData.put("sunPortalUserFromAddress", fromAddr);
        }
        if (replyToAddr == null) {
            if (fromAddr == null) {
                htMailData.put("sunPortalUserReplyToAddress", "");
            } else {
                htMailData.put("sunPortalUserReplyToAddress", fromAddr);
            }
        } else if (replyToAddr.length() == 0) {
            if (fromAddr != null) {
                htMailData.put("sunPortalUserReplyToAddress", fromAddr);
            }
        } else {
            htMailData.put("sunPortalUserReplyToAddress", replyToAddr);
        }
        htMailData.put("mailserver", smtpSrvr);
    }

    public Map getUserPreferences() throws Exception {
        throw new UnsupportedOperationException("Method not implemented");
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }
}

