/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.CompositeRewriter;
import com.sun.portal.rewriter.engines.LanguageConstants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import java.io.Reader;
import java.io.StringReader;

public abstract class AbstractRewriter
implements Rewriter,
LanguageConstants {
    protected final RuleSet ruleSet;
    private final String mime;
    private final CompositeRewriter chainRewriter;

    protected AbstractRewriter(CompositeRewriter compositeRewriter, RuleSet ruleSet, String string) {
        this.ruleSet = ruleSet;
        this.mime = string;
        this.chainRewriter = compositeRewriter;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public String getMIME() {
        return this.mime;
    }

    protected abstract String plugableRewriter(String var1, Translator var2);

    protected String endRewriting(String string, Translator translator) {
        return string;
    }

    public final String rewrite(String string, Translator translator) {
        boolean bl = translator.getLookAheadInfo().markTranslationRoot();
        if (StringHelper.normalize(string).length() < 1) {
            return string;
        }
        String string2 = this.plugableRewriter(string, translator);
        if (!bl) {
            return string2.toString();
        }
        String string3 = this.endRewriting(string2.toString(), translator);
        this.recordPage(translator, string3, string);
        return string3;
    }

    protected final CompositeRewriter getCompositeRewriter() {
        return this.chainRewriter;
    }

    public Reader rewrite(Reader reader, Translator translator) {
        return new StringReader(this.rewrite(Resource.read(reader), translator));
    }

    protected static final int getSBLength(int n) {
        return Math.round((float)n * 1.5f);
    }

    private void recordPage(Translator translator, String string, String string2) {
        if (Debug.isMessageEnabled()) {
            String string3 = "\n{\n" + translator.getBaseSpec() + "RuleSet ID: " + this.getRuleSet().getID() + ",\n" + "Parser MIME: " + this.getMIME() + ",\n";
            Debug.recordPageMessage(string3 + "Rewriten Content:\n" + string + "\n}\n");
            Debug.recordOriginalPage(string3 + "Original Content:\n" + string2 + "\n}\n");
        }
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

