/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util;

import com.sun.portal.rewriter.util.Constants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class StringHelper {
    public static final String ASTERISK = "*";
    public static final String EMPTY_STRING = "";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String SINGLE_QUOTES = "'";
    public static final String ESCAPE_DOUBLE_QUOTES = "\\\"";
    public static final String ESCAPE_SINGLE_QUOTES = "\\'";
    private String sourceString = "";
    private String delimList = "";

    private StringHelper(String string, String string2) {
        if (string != null) {
            this.sourceString = string;
        }
        if (string2 != null) {
            this.delimList = string2;
        }
    }

    private String[] parse(boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.sourceString, this.delimList, bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl3;
            String string = stringTokenizer.nextToken();
            boolean bl4 = bl3 = this.delimList.indexOf(string) != -1;
            if (!bl3) {
                arrayList.add(string);
            } else if (n == 0) {
                arrayList.add(EMPTY_STRING);
            } else if (bl2) {
                arrayList.add(EMPTY_STRING);
            }
            bl2 = bl3;
            ++n;
        }
        if (bl2) {
            arrayList.add(EMPTY_STRING);
        }
        return arrayList.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    private static String[] split(String string, String string2, boolean bl) {
        return new StringHelper(string, string2).parse(bl);
    }

    public static String[] splitString(String string, String string2) {
        return StringHelper.split(string, string2, true);
    }

    public static String[] splitString(String string, String string2, int n) {
        String[] stringArray = StringHelper.splitString(string, string2);
        return StringHelper.ensureLength(stringArray, n);
    }

    public static String[] separateTokens(String string, String string2) {
        return StringHelper.split(string, string2, false);
    }

    public static String[] separateTokens(String string, String string2, int n) {
        String[] stringArray = StringHelper.separateTokens(string, string2);
        return StringHelper.ensureLength(stringArray, n);
    }

    private static String[] ensureLength(String[] objectArray, int n) {
        if (n > objectArray.length) {
            Object[] objectArray2 = new String[n];
            Arrays.fill(objectArray2, EMPTY_STRING);
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    public static String searchAndReplace(String string, String[][] stringArray) {
        if (string == null || stringArray == null) {
            return string;
        }
        String string2 = string;
        int n = 0;
        while (n < stringArray.length) {
            string2 = StringHelper.searchAndReplace(string2, stringArray[n][0], stringArray[n][1]);
            ++n;
        }
        return string2;
    }

    public static String searchAndReplace(String string, String string2, String string3) {
        int n;
        int n2;
        int n3;
        int n4;
        if (string == null || string2 == null || (n4 = string2.length()) == 0) {
            return string;
        }
        if (string3 == null) {
            string3 = EMPTY_STRING;
        }
        int n5 = string.length();
        int n6 = string3.length();
        if (n4 == n6) {
            n3 = n5;
        } else {
            int n7;
            n2 = 0;
            n = 0;
            while ((n7 = string.indexOf(string2, n)) != -1) {
                ++n2;
                n = n7 + n4;
            }
            if (n2 == 0) {
                return string;
            }
            n3 = n5 - n2 * (n4 - n6);
        }
        n2 = 0;
        n = string.indexOf(string2, n2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + n4;
            n = string.indexOf(string2, n2);
        }
        n = n5;
        stringBuffer.append(string.substring(n2, n));
        return stringBuffer.toString();
    }

    public static String normalize(String string) {
        return string != null ? string.trim() : EMPTY_STRING;
    }

    public static String normalize(String string, String string2) {
        String string3 = StringHelper.normalize(string);
        return string3.length() < 1 ? string2 : string3;
    }

    public static String stackTrace2String(Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
        return null;
    }

    public static String findMatchByIgnoringCase(Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            return string2;
        }
        return null;
    }

    public static final String[] parsePatterns(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(ASTERISK);
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(ASTERISK, n);
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        string2 = string.substring(n);
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    public static String[] regExpSplit(String string, String string2) {
        int n;
        if (string == null) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        String string3 = string.trim();
        while (string3.startsWith(DOUBLE_QUOTES) || string3.startsWith(SINGLE_QUOTES) || string3.startsWith(ESCAPE_SINGLE_QUOTES) || string3.startsWith(ESCAPE_DOUBLE_QUOTES)) {
            string3 = string3.substring(1).trim();
        }
        while (string3.startsWith("&#")) {
            n = string3.indexOf(";");
            if (n == -1) break;
            string3 = string3.substring(n + 1).trim();
        }
        n = string.indexOf(string3);
        while (string3.endsWith(ESCAPE_SINGLE_QUOTES) || string3.endsWith(ESCAPE_DOUBLE_QUOTES) || string3.endsWith(DOUBLE_QUOTES) || string3.endsWith(SINGLE_QUOTES)) {
            if (!(string3 = string3.substring(0, string3.length() - 1).trim()).endsWith("\\")) continue;
            string3 = string3.substring(0, string3.length() - 1).trim();
        }
        return new String[]{string.substring(0, n), string3, string.substring(n + string3.length())};
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{EMPTY_STRING, ":"}, {":::", ":"}, {"jini://raja.sun. com ;mahesh.sun.com;jini://srinu.sil.co.in", ";"}, {",y,,", ","}, {"test", " "}, {",y,", ","}, {",y", ","}, {" ,y", ","}};
        int n = 0;
        while (n < stringArrayArray.length) {
            System.out.println(Arrays.asList(StringHelper.splitString(stringArrayArray[n][0], stringArrayArray[n][1])));
            ++n;
        }
    }
}

