/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.xml;

import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.URI;
import com.sun.portal.rewriter.util.xml.Node;
import com.sun.portal.rewriter.util.xml.Tag;
import com.sun.portal.rewriter.util.xml.TagParser;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class Document {
    private org.w3c.dom.Document w3cDocument;

    public Document(org.w3c.dom.Document document) {
        this.w3cDocument = document;
    }

    public Node getRootNode() {
        return new Node(this.w3cDocument.getDocumentElement());
    }

    public static String parseEncoding(String string) {
        String string2;
        Tag tag;
        String string3 = System.getProperty("file.encoding");
        if (StringHelper.normalize(string).length() == 0) {
            return string3;
        }
        int n = string.indexOf("<?");
        int n2 = string.indexOf("?>");
        if (n != -1 && n2 != -1 && (tag = TagParser.parse(string.substring(n + 2, n2 - 1))).getName().equalsIgnoreCase("xml") && (string2 = tag.get("encoding")) != null) {
            string3 = string2;
        }
        return string3;
    }

    public static String parseEncoding(byte[] byArray) throws UnsupportedEncodingException {
        return Document.parseEncoding(new String(byArray));
    }

    public static String parseHeadder(String string) {
        string = StringHelper.normalize(string);
        int n = string.indexOf("<?");
        int n2 = string.indexOf("?>");
        if (n != -1 && n2 != -1) {
            return string.substring(n, n2 + 2);
        }
        return "";
    }

    public static Document create(byte[] byArray, boolean bl, boolean bl2) throws Exception {
        if (byArray.length == 0) {
            throw new InvalidXMLException("Key May not exist in the Store or Zero length XML Bytes supplied ", new String(byArray), null, 1002);
        }
        DocumentBuilder documentBuilder = Document.getXMLBuilder(bl2, bl, true);
        org.w3c.dom.Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(byArray)));
        return new Document(document);
    }

    public static Document create(byte[] byArray) throws Exception {
        return Document.create(byArray, true, true);
    }

    public static Document create(String string, boolean bl, boolean bl2) throws Exception {
        String string2 = StringHelper.normalize(string);
        if (string2.length() < 1) {
            throw new InvalidXMLException("Key May not exist in the Store or null XML String supplied ", string, null, 1002);
        }
        DocumentBuilder documentBuilder = Document.getXMLBuilder(bl2, bl, true);
        org.w3c.dom.Document document = documentBuilder.parse(new InputSource(new StringReader(string.toString())));
        return new Document(document);
    }

    public static Document create(String string) throws Exception {
        return Document.create(string, true, true);
    }

    public static Document create(String string, boolean bl, boolean bl2, boolean bl3) throws Exception {
        String string2 = StringHelper.normalize(string);
        if (string2.length() < 1) {
            throw new InvalidXMLException("Key May not exist in the Store or null XML String supplied ", string, null, 1002);
        }
        DocumentBuilder documentBuilder = Document.getXMLBuilder(bl2, bl, bl3);
        org.w3c.dom.Document document = documentBuilder.parse(new InputSource(new StringReader(string.toString())));
        return new Document(document);
    }

    private static DocumentBuilder getXMLBuilder(boolean bl, boolean bl2, boolean bl3) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        documentBuilderFactory.setValidating(bl2);
        documentBuilderFactory.setExpandEntityReferences(bl3);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        CustomErrorHandler customErrorHandler = new CustomErrorHandler();
        documentBuilder.setErrorHandler(customErrorHandler);
        documentBuilder.setEntityResolver(customErrorHandler);
        return documentBuilder;
    }

    public static Node[] selectNodes(Document document, String string) {
        if ((string = string.trim()).startsWith("\\")) {
            String[] stringArray = StringHelper.splitString(string.substring(2), "\\");
            if (document != null && document.w3cDocument != null) {
                org.w3c.dom.Document document2 = document.w3cDocument;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                NodeList nodeList = document2.getElementsByTagName(stringArray[stringArray.length - 1]);
                int n = 0;
                while (n < nodeList.getLength()) {
                    org.w3c.dom.Node node = nodeList.item(n);
                    int n2 = stringArray.length - 2;
                    while (n2 >= 0) {
                        org.w3c.dom.Node node2 = node.getParentNode();
                        if (node2.getNodeName().equals(stringArray[n2])) {
                            if (n2 != 0) {
                                node = node2;
                            } else if (n2 == 0) {
                                arrayList.add(new Node(nodeList.item(n)));
                            }
                        }
                        --n2;
                    }
                    ++n;
                }
                if (arrayList.size() > 0) {
                    return arrayList.toArray(Node.EMPTY_NODE_ARRAY);
                }
            }
        } else {
            Debug.error("bug - in Document.java");
        }
        return Node.EMPTY_NODE_ARRAY;
    }

    public static void main(String[] stringArray) throws Exception {
        Document.create(Resource.read(stringArray[0]));
    }

    private static class CustomErrorHandler
    extends DefaultHandler {
        private CustomErrorHandler() {
        }

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI = " + string + " Line = " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            this.doRest(string, sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            this.doRest(string, sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            String string = "Warning: " + this.getParseExceptionInfo(sAXParseException);
            this.doRest(string, sAXParseException);
        }

        private void doRest(String string, SAXException sAXException) throws SAXException {
            Debug.warning(string, sAXException);
            throw sAXException;
        }

        public InputSource resolveEntity(String string, String string2) {
            if (Debug.isMessageEnabled()) {
                Debug.message(" Public ID: " + string + "System ID: " + string2);
            }
            if (string2 != null && string2.trim().toLowerCase().startsWith("jar://")) {
                try {
                    String string3 = new URI(string2).getPath();
                    if (StringHelper.normalize(string3).length() == 0) {
                        return null;
                    }
                    String string4 = Resource.read(string3);
                    if (StringHelper.normalize(string4).length() == 0) {
                        return null;
                    }
                    return new InputSource(new StringReader(string4));
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }
    }
}

