/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.DataServiceException;
import com.sun.portal.rewriter.InvalidXMLException;
import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.RuleSetManager;
import com.sun.portal.rewriter.URISpec;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.CompositeRewriter;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.TypedHashCache;
import java.util.Properties;

public final class RewriterFactory {
    private static final TypedHashCache rewriterCache = new TypedHashCache(class$com$sun$portal$rewriter$Rewriter == null ? (class$com$sun$portal$rewriter$Rewriter = RewriterFactory.class$("com.sun.portal.rewriter.Rewriter")) : class$com$sun$portal$rewriter$Rewriter);
    static /* synthetic */ Class class$com$sun$portal$rewriter$Rewriter;

    public static void init(Properties properties) {
        DataService dataService = RuleSetManager.init(properties);
        dataService.getChangeNotifier().addObserver(rewriterCache);
    }

    public static Rewriter getInstance(String string, URISpec uRISpec) throws InvalidXMLException, DataServiceException {
        return RewriterFactory.getInstance(string, uRISpec.getMIME());
    }

    public static Rewriter getInstance(String string, String string2) throws InvalidXMLException, DataServiceException {
        CompositeRewriter compositeRewriter = (CompositeRewriter)rewriterCache.get(string.toLowerCase());
        if (compositeRewriter == null) {
            RuleSet ruleSet = RuleSetManager.getInstance(string);
            compositeRewriter = new CompositeRewriter(ruleSet);
            rewriterCache.put(ruleSet.getID(), compositeRewriter);
        } else if (Debug.isMessageEnabled()) {
            Debug.message("Using the Cached Rewriter id : " + string);
        }
        return compositeRewriter.getInstance(string2);
    }

    public static Rewriter create(String string, String string2) throws InvalidXMLException {
        RuleSet ruleSet = RuleSetManager.create(string);
        return RewriterFactory.create(ruleSet, string2);
    }

    public static Rewriter create(RuleSet ruleSet, String string) {
        string = StringHelper.normalize(string);
        CompositeRewriter compositeRewriter = new CompositeRewriter(ruleSet);
        return compositeRewriter.getInstance(string);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[1];
        Properties properties = new Properties();
        properties.setProperty("DATA_SERVICE_TYPE", "FILE");
        properties.setProperty("DATA_SERVICE_BASE", string);
        RewriterFactory.init(properties);
        Rewriter rewriter = RewriterFactory.create(RuleSetManager.retrieve(string2), "text/css");
        Debug.println(((AbstractRewriter)rewriter).getRuleSet().toXML());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

