/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.DefaultJSFunctionSpec;
import com.sun.portal.rewriter.JSFunctionSpec;
import com.sun.portal.rewriter.LookAheadInfo;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.URISpec;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.DecoratedURI;

public abstract class AbstractTranslator
implements Translator {
    protected final LookAheadInfo lookAheadInfo = new LookAheadInfo();
    private JSFunctionSpec jsFunctionSpec = DefaultJSFunctionSpec.getDefault();
    private final URISpec baseSpec;

    public AbstractTranslator(URISpec uRISpec) {
        this.baseSpec = uRISpec;
    }

    public AbstractTranslator(URISpec uRISpec, JSFunctionSpec jSFunctionSpec) {
        this(uRISpec);
        this.setJSFunctionSpec(jSFunctionSpec);
    }

    private void setJSFunctionSpec(JSFunctionSpec jSFunctionSpec) {
        if (jSFunctionSpec != null) {
            this.jsFunctionSpec = jSFunctionSpec;
        }
    }

    public URISpec getBaseSpec() {
        return this.baseSpec;
    }

    public JSFunctionSpec getJSFunctionSpec() {
        return this.jsFunctionSpec;
    }

    public LookAheadInfo getLookAheadInfo() {
        return this.lookAheadInfo;
    }

    public final String convert2Absolute(String string) {
        URISpec uRISpec = this.lookAheadInfo.isAppletCodeBaseExists() ? this.lookAheadInfo.getAppletCodeBase() : this.getBaseSpec();
        return AbstractTranslator.convert2Absolute(string, uRISpec, this);
    }

    static final String convert2Absolute(String string, URISpec uRISpec, Translator translator) {
        String[] stringArray = StringHelper.regExpSplit(string, "");
        if (stringArray.length != 3 || stringArray[1].length() == 0) {
            return string;
        }
        String string2 = stringArray[1];
        if (string2.equals("#") || string2.equals("?") || string2.startsWith("+")) {
            return string;
        }
        if (string2.startsWith("\\")) {
            string2 = "/" + string2.substring(1);
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(Math.round((float)string.length() * 1.25f));
            stringBuffer.append(stringArray[0]);
            DecoratedURI decoratedURI = uRISpec.getBaseURI().getResolveURI().resolve(string2);
            if (translator != null) {
                String string3 = translator.translate(string2, decoratedURI);
                stringBuffer.append(string3);
                AbstractTranslator.recordURI(uRISpec, string, decoratedURI, string3);
            } else {
                stringBuffer.append(decoratedURI.toExternalForm());
                AbstractTranslator.recordURI(uRISpec, string, decoratedURI, "No Custom Handling was Done..");
            }
            stringBuffer.append(stringArray[2]);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            Debug.recordURIWarning("Invalid URI:\n\tPage URI:" + uRISpec.getBaseURI().getInputString() + ",\n\t" + "Original URI:" + string + ",\n", exception);
            return string;
        }
    }

    private static void recordURI(URISpec uRISpec, String string, DecoratedURI decoratedURI, String string2) {
        if (Debug.isMessageEnabled()) {
            Debug.recordURIMessage("\n{\n\tPage URI:" + uRISpec.getBaseURI().getInputString() + ",\n\t" + "Original URI:" + string + ",\n\t" + "After DefaultHandling:" + decoratedURI.toExternalForm() + ",\n\t" + "After CustomHandling:" + string2 + "\n},\n");
        }
    }

    public abstract String translate(String var1, DecoratedURI var2);
}

