/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.log.LogRecord;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.ApplicationLogin;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SSOUtil;
import java.util.Hashtable;

public class GWLogManager {
    private static String logName = "srapGateway";
    public static LogManager lm = null;
    public static boolean loggingEnabled = false;
    private static SSOToken appSession = null;
    private static int logId = 0;
    public static Hashtable logIdMap = new Hashtable();
    private static String actualLogName = null;
    private static boolean logError = false;

    public static String getUserId(String sessionID) {
        try {
            SSOToken ssoToken = SSOUtil.getSSOToken(sessionID);
            String userDN = ssoToken.getPrincipal().getName();
            return userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
        }
        catch (Exception ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("GWLogManager: Unable to get user ID -> " + ex);
            }
            return "";
        }
    }

    public static synchronized int getLogId() {
        return ++logId;
    }

    public static void createDefault() {
        GWLogManager.createDefault(logName);
    }

    private static SSOToken createSession(String sessid) {
        SSOToken token = null;
        try {
            token = SSOUtil.getSSOToken(sessid);
        }
        catch (SSOException ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session!");
            }
            ex.printStackTrace();
            token = null;
        }
        catch (Exception ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session!");
            }
            ex.printStackTrace();
            token = null;
        }
        return token;
    }

    public static void createDefault(String name) {
        block5: {
            if (appSession == null) {
                String sessid = ApplicationLogin.login("srapGateway");
                if (sessid == null) {
                    GWDebug.debug.error("Unable to create logging session. Make sure credentials provided in file /etc/opt/SUNWps/.auth_password." + System.getProperty("conf.suffix") + " are correct");
                    return;
                }
                appSession = GWLogManager.createSession(sessid);
            }
            lm = new LogManager(appSession);
            if (name != null && name.length() > 0) {
                logName = name;
            }
            try {
                lm.create(logName);
                actualLogName = logName;
            }
            catch (LogException e) {
                actualLogName = null;
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("GWLogManager: Unable to create log");
                GWDebug.debug.error("GWLogManager: " + e.toString());
            }
        }
    }

    public static void write(String type, String msg) {
        if (lm == null) {
            return;
        }
        if (logError) {
            return;
        }
        try {
            LogRecord lr = new LogRecord(type, msg);
            lm.write(lr, logName);
        }
        catch (Exception e) {
            logError = true;
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("GWLogManager: Unable to create log record");
                String reason = e.toString();
                GWDebug.debug.error("GWLogManager: " + reason);
            }
            String string = actualLogName;
            synchronized (string) {
                if (logError) {
                    appSession = null;
                    GWLogManager.createDefault(actualLogName);
                    logError = false;
                }
            }
        }
    }

    static {
        loggingEnabled = GatewayProfile.getBoolean("LoggingEnabled", false);
    }
}

