/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.yahoo;

import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.rewriter.SRAPTranslator;
import com.sun.portal.rproxy.rewriter.yahoo.OrderedHashMap;
import com.sun.portal.rproxy.rewriter.yahoo.QueryStringParser;
import com.sun.portal.rproxy.rewriter.yahoo.YahooException;
import com.sun.portal.rproxy.rewriter.yahoo.YahooProfile;
import com.sun.portal.util.GWDebug;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Map;
import sun.misc.BASE64Encoder;

public class YahooTranslator
extends SRAPTranslator {
    private String corporateYahooID = null;
    private String corporateYahooPassword = null;

    public YahooTranslator(Request aReq) {
        super(aReq);
        this.init();
    }

    public YahooTranslator(Request aReq, String aMIME) {
        super(aReq, aMIME);
        this.init();
    }

    public String translateQueryString(String queryString) {
        try {
            if (this.isYahooAuthURL(queryString)) {
                if (queryString.startsWith("?")) {
                    queryString = queryString.substring(1);
                }
                QueryStringParser qparser = new QueryStringParser(queryString);
                OrderedHashMap parsedQueryString = qparser.getProperties();
                String rewrittenUrl = this.prefixGateway(parsedQueryString.get("ypburl").toString());
                parsedQueryString.put("ypburl", rewrittenUrl);
                String newMD5 = this.recomputeMD5(parsedQueryString);
                parsedQueryString.put("sign", newMD5);
                return this.resurrectQueryString(parsedQueryString);
            }
            if (this.isYahooLogoutURL(queryString)) {
                if (queryString.startsWith("?")) {
                    queryString = queryString.substring(1);
                }
                QueryStringParser qparser = new QueryStringParser(queryString);
                OrderedHashMap parsedQueryString = qparser.getProperties();
                String rewrittenUrl = this.prefixGateway(parsedQueryString.get("ypburl").toString());
                parsedQueryString.put("ypburl", rewrittenUrl);
                return this.resurrectQueryString(parsedQueryString);
            }
            if (this.isYahooEditURL(queryString)) {
                if (queryString.startsWith("?")) {
                    queryString = queryString.substring(1);
                }
                QueryStringParser qparser = new QueryStringParser(queryString);
                OrderedHashMap parsedQueryString = qparser.getProperties();
                String rewrittenUrl = this.prefixGateway(parsedQueryString.get(".done").toString());
                parsedQueryString.put(".done", rewrittenUrl);
                return this.resurrectQueryString(parsedQueryString);
            }
            return queryString;
        }
        catch (YahooException ye) {
            return queryString;
        }
    }

    private String resurrectQueryString(OrderedHashMap parsedQueryString) {
        Iterator keys = parsedQueryString.getOrderedKeyIterator();
        Object valueHolder = null;
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("?");
        String key = null;
        while (keys.hasNext()) {
            key = keys.next().toString();
            valueHolder = parsedQueryString.get(key);
            if (valueHolder == null) {
                sbuff.append(key).append("=");
            } else {
                sbuff.append(key).append("=").append((Object)valueHolder);
            }
            if (!keys.hasNext()) continue;
            sbuff.append("&");
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("QueryStringTranslator :" + sbuff.toString());
        }
        return sbuff.toString();
    }

    private String recomputeMD5(Map nameValues) throws YahooException {
        Object temp = nameValues.get("ma");
        String ma = null;
        if (temp != null) {
            ma = temp.toString();
        }
        String[] signArgs = new String[]{this.corporateYahooID, nameValues.get("login").toString(), nameValues.get("usernum").toString(), nameValues.get("ypburl").toString(), ma, this.corporateYahooPassword};
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("QueryStringTranslator Yahoo MD5 Sum :" + this.getSign(signArgs));
        }
        return this.getSign(signArgs);
    }

    private boolean isYahooEditURL(String url) {
        return url.indexOf(".done=") > 0;
    }

    private boolean isYahooLogoutURL(String url) {
        return url.indexOf("ypburl") > 0;
    }

    private boolean isYahooAuthURL(String url) {
        return url.indexOf("&ypburl") > 0 && url.indexOf("&sign") > 0;
    }

    private String getSign(String[] args) throws YahooException {
        int i;
        String sign = null;
        StringBuffer signBuf = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    md.update(args[i].getBytes());
                }
                ++i;
            }
            BASE64Encoder encoder = new BASE64Encoder();
            signBuf = new StringBuffer(encoder.encodeBuffer(md.digest()));
            String newsign = signBuf.substring(0, 24);
            signBuf = new StringBuffer(newsign);
        }
        catch (Exception e) {
            throw new YahooException(e.getMessage(), e);
        }
        if (signBuf != null) {
            int length = signBuf.length();
            i = 0;
            while (i < length) {
                switch (signBuf.charAt(i)) {
                    case '+': {
                        signBuf.setCharAt(i, '.');
                        break;
                    }
                    case '/': {
                        signBuf.setCharAt(i, '_');
                        break;
                    }
                    case '=': {
                        signBuf.setCharAt(i, '-');
                        break;
                    }
                }
                ++i;
            }
        }
        if (signBuf != null) {
            sign = signBuf.toString();
        }
        return sign;
    }

    private void init() {
        if (YahooProfile.isYahooServiceInstalled()) {
            YahooProfile.getInstance();
            this.corporateYahooPassword = YahooProfile.getString("CorporatePassword", "NoYahoo");
            YahooProfile.getInstance();
            this.corporateYahooID = YahooProfile.getString("CorporateID", "NoID");
        }
    }
}

