/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.BasicAuthentication;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.CachedSocketFactory;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class HTTPRetriever
implements Retriever {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final byte[] crlf = new byte[]{13, 10};
    protected static final String scrlf = new String(crlf);
    private static String gateway_ip;
    private static boolean cookie_management;
    private static String cookie_name;
    private static boolean doBasicAuthentication;
    public static int numBytesRead;
    private static final int defaultBufferSize = 2048;
    protected static HashMap proxyPasswdList;
    protected static final String PROXY_PASSWD_LIST = "ProxyPasswdList";
    private static final boolean _useHTTPProxy;

    public static String getProxyPassword(String proxyHost) {
        Object passwd = proxyPasswdList.get(proxyHost.trim().toLowerCase());
        if (passwd != null) {
            return passwd.toString();
        }
        return null;
    }

    public Response getResponse2(Request req, String destinationHost, Integer logId, byte[] param) {
        Response result;
        CachedSocket s;
        block32: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = HTTPRetriever.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                int to;
                int i = 0;
                while (i < 2) {
                    result = new HTTPResponse();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever retrieving " + req);
                    }
                    if (req.getUseProxy()) {
                        s = CachedSocketFactory.getCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever getProxyHost connecting to: " + req.getProxyHost());
                        }
                    } else {
                        s = CachedSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                        }
                    }
                    if (s == null) {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                        }
                        return null;
                    }
                    try {
                        this.sendRequest2(req, s, param);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    catch (Exception e) {
                        if (req.getUseProxy()) {
                            s = CachedSocketFactory.getNewCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getProxyHost());
                            }
                        } else {
                            s = CachedSocketFactory.getNewCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                            }
                        }
                        this.sendRequest2(req, s, param);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    if (!doBasicAuthentication || i != 0) break;
                    if (result.getStatusCode().compareTo("401") == 0) {
                        if (password == null || !BasicAuthentication.getPassword(req, destinationHost)) {
                            break;
                        }
                    } else {
                        if (password == null) break;
                        BasicAuthentication.storePassword(req, destinationHost);
                        break;
                    }
                    ++i;
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                String ka = result.getResponseHeader("keep-alive");
                if (ka != null && (to = Integer.parseInt(ka.substring(ka.indexOf("timeout=") + 8, ka.indexOf(44)))) > 0) {
                    s.setTimeout(to);
                }
                if (result.getResponseHeader("Connection: close") != null) {
                    in.setClosed();
                } else {
                    in.setClosed();
                }
                in.setLength(length);
                ((HTTPResponse)result).setContentStream(in);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", ex);
                }
                result = null;
                if (s == null) break block32;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    public void sendRequest(Request req, CachedSocket s) throws IOException, EOFException {
        if (cookie_management && !req.getHost().equals(gateway_ip)) {
            this.restoreCookieHeader(req);
        }
        OutputStream out = s.getOutputStream();
        out.write(req.getRequestHeaderBytes());
        out.flush();
        String contentLength = req.getRequestHeader("Content-length");
        if (contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            byte[] content = new byte[2048];
            int read = 0;
            int totalRead = 0;
            BufferedInputStream reqIn = req.getContentStream();
            while (totalRead + 2048 < length) {
                read = reqIn.read(content, 0, 2048);
                if (read == -1 && totalRead < length) {
                    throw new EOFException();
                }
                if (read == 0) break;
                out.write(content, 0, read);
                totalRead += read;
            }
            int buffoffset = 0;
            while (totalRead < length) {
                read = reqIn.read(content, buffoffset, length - totalRead);
                if (read == -1 && totalRead < length) {
                    throw new EOFException();
                }
                if (read == 0) break;
                totalRead += read;
                buffoffset += read;
            }
            out.write(content, 0, buffoffset);
            req.addSize(totalRead);
        }
        out.flush();
    }

    public void sendRequest2(Request req, CachedSocket s, byte[] content) throws IOException, EOFException {
        if (cookie_management && !req.getHost().equals(gateway_ip)) {
            this.restoreCookieHeader(req);
        }
        OutputStream out = s.getOutputStream();
        out.write(req.getRequestHeaderBytes());
        out.flush();
        String contentLength = req.getRequestHeader("Content-length");
        if (contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            out.write(content);
        }
        out.flush();
    }

    public void getResponseHeader(HTTPResponse result, CSBufferedInputStream in, Request req) throws IOException, EOFException {
        boolean toSetCookie = cookie_management && !req.getHost().equals(gateway_ip);
        boolean keepGoing = true;
        in.setLength(4000);
        ByteArrayOutputStream byteOutStrm = new ByteArrayOutputStream();
        while (keepGoing) {
            int b = in.read();
            if (b == -1) {
                keepGoing = false;
                throw new EOFException();
            }
            byteOutStrm.write(b);
            if (b != 10) continue;
            String s = byteOutStrm.toString();
            if (s.regionMatches(true, 0, SET_COOKIE, 0, SET_COOKIE.length()) && toSetCookie) {
                String s_new = this.modifyCookieHeader(result, req, s);
                if (s_new != null) {
                    result.addHeaderLine(s_new);
                }
            } else if (s.toLowerCase().startsWith("content-length")) {
                String myHeader = result.getResponseHeader("Content-Length");
                if (myHeader == null) {
                    result.addHeaderLine(s);
                }
            } else if (s.toLowerCase().startsWith("content-disposition")) {
                s = byteOutStrm.toString("ISO-8859-1");
                result.addHeaderLine(s);
            } else {
                result.addHeaderLine(s);
            }
            keepGoing = !result.isHeaderComplete();
            byteOutStrm.reset();
        }
    }

    public Response getResponse(Request req, String destinationHost, Integer logId) {
        Response result;
        CachedSocket s;
        block37: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = HTTPRetriever.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                int to;
                int i = 0;
                while (i < 2) {
                    result = new HTTPResponse();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever retrieving " + req);
                    }
                    if (req.getUseProxy()) {
                        s = CachedSocketFactory.getCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever getProxyHost connecting to: " + req.getProxyHost());
                        }
                    } else {
                        s = CachedSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                        }
                    }
                    if (s == null) {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                        }
                        return null;
                    }
                    try {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever before sendRequest(): req == " + req);
                        }
                        if (req.getContentStream() != null) {
                            req.getContentStream().mark(Integer.MAX_VALUE);
                        }
                        this.sendRequest(req, s);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    catch (Exception e) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("HTTPRetriever: Caught exception ", e);
                        }
                        if (req.getUseProxy()) {
                            s = CachedSocketFactory.getNewCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getProxyHost());
                            }
                        } else {
                            s = CachedSocketFactory.getNewCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                            }
                        }
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: inside catch before sendRequest req.getObject() == " + req.getObject());
                        }
                        if (req.getContentStream() != null) {
                            req.getContentStream().reset();
                        }
                        this.sendRequest(req, s);
                        in = s.getInputStream();
                        this.getResponseHeader((HTTPResponse)result, in, req);
                    }
                    if (!doBasicAuthentication || i != 0) break;
                    if (result.getStatusCode().compareTo("401") == 0) {
                        if (password == null || !BasicAuthentication.getPassword(req, destinationHost)) {
                            break;
                        }
                    } else {
                        if (password == null) break;
                        BasicAuthentication.storePassword(req, destinationHost);
                        break;
                    }
                    ++i;
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                String ka = result.getResponseHeader("keep-alive");
                if (ka != null && (to = Integer.parseInt(ka.substring(ka.indexOf("timeout=") + 8, ka.indexOf(44)))) > 0) {
                    s.setTimeout(to);
                }
                if (result.getResponseHeader("Connection: close") != null) {
                    in.setClosed();
                } else {
                    in.setClosed();
                }
                in.setLength(length);
                ((HTTPResponse)result).setContentStream(in);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", ex);
                }
                result = null;
                if (s == null) break block37;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    private String modifyCookieHeader(HTTPResponse resp, Request req, String cookie_header) {
        if (cookie_header == null) {
            return null;
        }
        int index = cookie_header.indexOf(58);
        if (index == -1 || index + 1 == cookie_header.length()) {
            return cookie_header;
        }
        String cookie = cookie_header.substring(index + 1).trim();
        StringTokenizer tokens = new StringTokenizer(cookie, ";");
        if (!tokens.hasMoreTokens()) {
            return cookie_header;
        }
        String nameAndValue = tokens.nextToken().trim();
        if (nameAndValue.startsWith(cookie_name + "=")) {
            return cookie_header;
        }
        int equIndex = nameAndValue.indexOf(61);
        if (equIndex != -1) {
            String tmpValue = nameAndValue.substring(equIndex + 1);
            try {
                tmpValue = URLEncoder.encode(tmpValue);
                nameAndValue = nameAndValue.substring(0, equIndex + 1) + tmpValue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer();
        String path = null;
        String domain = null;
        boolean domainAppended = false;
        boolean pathAppended = false;
        String reqHost = req.getHost();
        String reqPath = req.getObject();
        if (_useHTTPProxy) {
            reqHost = req.getURL();
            int tmpIndx = reqHost.indexOf(58) + 3;
            int tmpIndx1 = reqHost.indexOf(58, tmpIndx);
            int indxSlash = reqHost.indexOf(47, tmpIndx);
            if (indxSlash == -1) {
                indxSlash = reqHost.length();
                reqPath = "/";
            } else {
                reqPath = reqHost.substring(indxSlash);
            }
            reqHost = tmpIndx1 == -1 ? reqHost.substring(tmpIndx, indxSlash) : (indxSlash < tmpIndx1 ? reqHost.substring(tmpIndx, indxSlash) : reqHost.substring(tmpIndx, tmpIndx1));
        }
        while (tokens.hasMoreTokens()) {
            String val;
            String attr;
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            equIndex = token.indexOf(61);
            if (equIndex < 0) {
                attr = token;
                val = null;
            } else {
                attr = token.substring(0, equIndex).trim();
                val = equIndex + 1 == token.length() ? null : token.substring(equIndex + 1).trim();
            }
            if (attr.equalsIgnoreCase("path")) {
                path = val;
                if (path == null || reqPath.startsWith(path)) continue;
                return null;
            }
            if (attr.equalsIgnoreCase("domain")) {
                domain = val;
                if (domain == null) continue;
                if (domain.length() < 3) {
                    return null;
                }
                if (domain.charAt(domain.length() - 1) == '.') {
                    return null;
                }
                if (reqHost.toLowerCase().endsWith(domain.toLowerCase())) continue;
                return null;
            }
            sb.append("; " + token);
        }
        StringBuffer sbnv = new StringBuffer(2 * nameAndValue.length());
        sbnv.append(SET_COOKIE).append(": ");
        if (path != null) {
            sbnv.append(URLEncoder.encode(path.replace('_', ';')));
        }
        if (domain != null) {
            sbnv.append(URLEncoder.encode(domain.replace('_', ';')));
        } else {
            sbnv.append(URLEncoder.encode(URLEncoder.encode(reqHost).replace('_', ';')));
        }
        sbnv.append("_");
        sbnv.append(nameAndValue);
        sbnv.append("|");
        String gwHost = SystemProperties.get("gateway.host", null);
        String reqGWHost = req.getGatewayHost();
        if (gwHost != null) {
            if (reqGWHost != null && !reqGWHost.equalsIgnoreCase(gwHost)) {
                try {
                    URL tmpUrl = new URL(req.getGatewayURL());
                    gwHost = tmpUrl.getHost();
                }
                catch (MalformedURLException ex) {}
            }
        } else {
            gwHost = reqGWHost;
        }
        if (gwHost != null && gwHost.indexOf(46) == gwHost.lastIndexOf(46)) {
            gwHost = null;
        }
        if (gwHost != null && gwHost.indexOf(46) != -1) {
            sb.append("; domain=");
            String gwdomain = gwHost.substring(gwHost.indexOf(46)).toLowerCase();
            sb.append(gwdomain);
        }
        if (domain != null) {
            sbnv.append(domain);
        } else {
            sbnv.append(reqHost.toLowerCase());
        }
        sbnv.append("|");
        sb.append("; path=/");
        if (path != null) {
            sbnv.append(path);
        } else {
            String s = reqPath;
            if (s == null) {
                sbnv.append("/");
            } else {
                int i = s.lastIndexOf(47);
                if (i < 1) {
                    sbnv.append("/");
                } else {
                    sbnv.append(s.substring(0, i));
                }
            }
        }
        sbnv.append("|iplanet");
        sbnv.append((Object)sb).append(scrlf);
        return sbnv.toString();
    }

    private void restoreCookieHeader(Request req) {
        String cookie_header = req.getRequestHeader("Cookie");
        if (cookie_header == null) {
            return;
        }
        int index = cookie_header.indexOf(58);
        if (index == -1 || index + 1 == cookie_header.length()) {
            return;
        }
        String cookies = cookie_header.substring(index + 1).trim();
        StringTokenizer tokens = new StringTokenizer(cookies, ";");
        String reqHost = req.getHost();
        String reqPath = req.getObject();
        if (_useHTTPProxy) {
            reqHost = req.getURL();
            int tmpIndx = reqHost.indexOf(58) + 3;
            int tmpIndx1 = reqHost.indexOf(58, tmpIndx);
            int indxSlash = reqHost.indexOf(47, tmpIndx);
            if (indxSlash == -1) {
                indxSlash = reqHost.length();
                reqPath = "/";
            } else {
                reqPath = reqHost.substring(indxSlash);
            }
            reqHost = tmpIndx1 == -1 ? reqHost.substring(tmpIndx, indxSlash) : (indxSlash < tmpIndx1 ? reqHost.substring(tmpIndx, indxSlash) : reqHost.substring(tmpIndx, tmpIndx1));
        }
        StringBuffer sb = new StringBuffer("Cookie:");
        StringBuffer sbc = null;
        LinkedList ll = new LinkedList();
        while (tokens.hasMoreTokens()) {
            sbc = new StringBuffer();
            String token = tokens.nextToken().trim();
            if (!token.endsWith("|iplanet")) {
                sb.append(" " + token + ";");
                continue;
            }
            int index1 = token.indexOf("_");
            String st = token.substring(index1 + 1);
            if ((index1 = (token = st).lastIndexOf(124)) < 2) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            int index2 = token.lastIndexOf(124, index1 - 1);
            if (index2 < 1) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            int index3 = token.lastIndexOf(124, index2 - 1);
            if (index3 < 0) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            if (index3 + 1 == index2 || index2 + 1 == index1) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            String name = token.substring(0, index3);
            if (name.indexOf("=") > -1) {
                name = name.substring(0, name.indexOf("="));
            }
            String domain = token.substring(index3 + 1, index2);
            String path = token.substring(index2 + 1, index1);
            if (!reqHost.toLowerCase().endsWith(domain.toLowerCase()) || !reqPath.startsWith(path)) continue;
            String orig_cookie = token.substring(0, index3);
            if (orig_cookie.indexOf(37, index1 = orig_cookie.indexOf(61) + 1) != -1) {
                try {
                    String newValue = URLDecoder.decode(orig_cookie.substring(index1));
                    orig_cookie = orig_cookie.substring(0, index1) + newValue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            sbc.append(" ").append(orig_cookie).append(";");
            HTTPRetriever.addCookieToList(ll, name, path, sbc);
        }
        int i = 2;
        while (i < ll.size()) {
            sb.append((Object)((StringBuffer)ll.get(i)));
            i += 3;
        }
        int len = sb.length();
        if (sb.charAt(len - 1) == ';') {
            sb.setLength(len - 1);
        }
        req.setRequestHeader("Cookie", sb.toString() + scrlf);
    }

    private static void addCookieToList(LinkedList ll, String name, String path, StringBuffer cookie) {
        int i = ll.indexOf(name);
        boolean notAdded = true;
        if (i > -1) {
            int j = i;
            while (notAdded && j < ll.size()) {
                String path0 = (String)ll.get(j + 1);
                if (((String)ll.get(j)).equals(name) && path.startsWith((String)ll.get(j + 1))) {
                    ll.add(j, name);
                    ll.add(j + 1, path);
                    ll.add(j + 2, cookie);
                    notAdded = false;
                }
                j += 3;
            }
        }
        if (notAdded) {
            ll.add(name);
            ll.add(path);
            ll.add(cookie);
        }
    }

    static {
        doBasicAuthentication = false;
        numBytesRead = 0;
        List ds = GatewayProfile.getStringList(PROXY_PASSWD_LIST);
        int numElements = ds.size();
        proxyPasswdList = new HashMap();
        if (ds != null) {
            int i = 0;
            while (i < numElements) {
                String proxy = ds.get(i).toString().trim();
                int index = proxy.indexOf(124);
                if (index != -1) {
                    String passwd = proxy.substring(index + 1);
                    proxy = proxy.substring(0, index).trim().toLowerCase();
                    index = passwd.indexOf(124);
                    passwd = index != -1 ? passwd.substring(0, index).trim() + ":" + passwd.substring(index + 1).trim() : passwd.trim();
                    proxyPasswdList.put(proxy, Base64.encode(passwd) + scrlf);
                } else {
                    proxyPasswdList.put(proxy.toLowerCase(), null);
                }
                ++i;
            }
        }
        try {
            byte[] ip = InetAddress.getLocalHost().getAddress();
            gateway_ip = Integer.toString(ip[0] & 0xFF) + "." + Integer.toString(ip[1] & 0xFF) + "." + Integer.toString(ip[2] & 0xFF) + "." + Integer.toString(ip[3] & 0xFF);
        }
        catch (Exception e) {
            gateway_ip = null;
        }
        cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();
        cookie_name = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        doBasicAuthentication = GatewayProfile.getBoolean("DoBasicAuthentication", false) && ServiceIdentifier.isGateway();
        _useHTTPProxy = GatewayProfile.getBoolean("UseHTTPProxy", false);
    }
}

