/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.DomainWebProxyConfig;
import com.sun.portal.rproxy.connectionhandler.GatewayServletInputStream;
import com.sun.portal.rproxy.connectionhandler.MatchHttps;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HTTPRequest
implements Request,
HttpServletRequest {
    private List _headerLines = new ArrayList();
    private boolean _firstLine = true;
    private boolean _useProxy = false;
    private boolean _forwardCookie = false;
    private boolean _archiveTranslate = true;
    private String _protocol = null;
    private String _crlf = new String(new byte[]{13, 10});
    private char lf = (char)10;
    private String _method = null;
    private String _url = "";
    private String _uri = "";
    private String _port = null;
    private String _host = null;
    private String _gatewayhost = null;
    private String _object = "";
    private String _gwscheme = "";
    private String _proxyHost;
    private int _proxyPort;
    private String _httpVersion = null;
    private boolean _headerComplete = false;
    private Map _headerCache = new HashMap();
    private BufferedInputStream _contentStream;
    private int _size = 0;
    private static final String STRING_HTTP_PORT = "80";
    private static final String STRING_HTTPS_PORT = "443";
    private static String _cookieName;
    private static String cookiePrefix;
    private static String _colonString;
    private static boolean _useProxyFlag;
    private static final int PROXY_HTTP_PORT = 8080;
    private static MatchHttps UseWebProxyURL;
    private static MatchHttps DontUseWebProxyURL;
    private static MatchHttps ForwardCookieURL;
    private static final String DEFAULT_SSL_PORT = "443";
    private static String sslPort;
    private static String defaultGW;
    private static final String HTTP_1_0 = "HTTP/1.0";
    private static boolean useNewDomainLogic;
    private String gatewayURL;

    public HTTPRequest() {
        this._gatewayhost = defaultGW;
    }

    public HTTPRequest(String urlstr) {
        this._gatewayhost = "";
        this._method = "GET";
        this.parseURI("/" + urlstr);
        this._httpVersion = HTTP_1_0;
    }

    public HTTPRequest(String protocol, int port) {
        this._gatewayhost = defaultGW;
        StringBuffer buff = new StringBuffer();
        buff.append(protocol).append("://").append(defaultGW);
        if (protocol.equalsIgnoreCase("http")) {
            if (port != 80) {
                buff.append(':').append(port);
            }
        } else if (port != 443) {
            buff.append(':').append(port);
        }
        buff.append('/');
        this.gatewayURL = buff.toString();
    }

    public void addHeader(String key, String value) {
        this.setRequestHeader(key, value + this._crlf);
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public String getURL() {
        return this._url;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURI() {
        return this._uri;
    }

    public String getHTTPVersion() {
        if (this._httpVersion.equals("HTTP/1.1")) {
            return HTTP_1_0;
        }
        return this._httpVersion;
    }

    public byte[] getRequestHeaderBytes() {
        ByteArrayOutputStream outBAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(outBAOS);
            try {
                out.write((this.getMethod() + " ").getBytes());
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                if (this._useProxy && !this._protocol.equals("https")) {
                    out.write(this.getURL().getBytes("ISO-8859-1"));
                } else {
                    out.write(this.getObject().getBytes("ISO-8859-1"));
                }
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                String httpVersion = this.getHTTPVersion();
                if (httpVersion.compareTo("HTTP/0.9") > 0) {
                    out.write((" " + this.getHTTPVersion()).getBytes());
                }
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            out.write("\r\n".getBytes());
            if (this._protocol != null && this._port != null) {
                if (this._protocol.equals("http") && this._port.equals(STRING_HTTP_PORT) || this._protocol.equals("https") && this._port.equals("443")) {
                    out.write(("Host: " + this.getHost() + "\r\n").getBytes());
                } else {
                    out.write(("Host: " + this.getHost() + ":" + this.getPort() + "\r\n").getBytes());
                }
            } else {
                out.write(("Host: " + this.getHost() + "\r\n").getBytes());
            }
            int numHeaders = this._headerLines.size();
            int i = 0;
            while (i < numHeaders) {
                String s = (String)this._headerLines.get(i);
                if (!s.regionMatches(true, 0, "host", 0, 4)) {
                    int singleSlash;
                    int doubleSlash;
                    if (s.regionMatches(true, 0, "referer", 0, 7)) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message(" ******* " + s);
                        }
                        if ((doubleSlash = s.indexOf("//")) == -1) {
                            out.write(s.getBytes());
                        } else {
                            singleSlash = s.indexOf("/http", doubleSlash + 2);
                            if (singleSlash == -1) {
                                out.write(s.getBytes());
                            } else {
                                out.write(("Referer: " + s.substring(singleSlash + 1)).getBytes());
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message(" ******* Referer: " + s.substring(singleSlash + 1));
                                }
                            }
                        }
                    } else if (s.regionMatches(true, 0, "Destination", 0, 11)) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message(" ******* " + s);
                        }
                        if ((doubleSlash = s.indexOf("//")) == -1) {
                            out.write(s.getBytes());
                        } else {
                            singleSlash = s.indexOf("/http", doubleSlash + 2);
                            if (singleSlash == -1) {
                                out.write(s.getBytes());
                            } else {
                                out.write(("Destination: " + s.substring(singleSlash + 1)).getBytes());
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message(" ******* Destination: " + s.substring(singleSlash + 1));
                                }
                            }
                        }
                    } else if (!s.regionMatches(true, 0, "cookie", 0, 6) || this._forwardCookie) {
                        out.write(s.getBytes());
                    } else {
                        String sc = this.removeSidFromCookie(s);
                        if (sc != null) {
                            out.write(sc.getBytes());
                        }
                    }
                }
                ++i;
            }
            out.write("\r\n".getBytes());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outBAOS.toByteArray();
    }

    private String removeSidFromCookie(String cookies) {
        if (cookies.length() < 8) {
            return cookies;
        }
        String sc = cookies.substring(7);
        StringBuffer result = new StringBuffer("Cookie:");
        StringTokenizer st = new StringTokenizer(sc, ";");
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken().trim();
            if (cookie.startsWith(cookiePrefix)) continue;
            result.append(" ").append(cookie).append(";");
        }
        if (result.charAt(result.length() - 1) == ':') {
            return null;
        }
        result.setLength(result.length() - 1);
        result.append(this._crlf);
        return result.toString();
    }

    public String getRequestHeader(String header) {
        String result = (String)this._headerCache.get(header);
        if (result != null) {
            return result;
        }
        int headerLen = header.length();
        int numHeaders = this._headerLines.size();
        int i = 0;
        while (i < numHeaders) {
            String s = (String)this._headerLines.get(i);
            if (s.regionMatches(true, 0, header, 0, headerLen)) {
                this._headerCache.put(header, s);
                return s;
            }
            ++i;
        }
        return null;
    }

    public void setRequestHeader(String header, String value) {
        boolean removeHeader = false;
        if (header == null || value == null) {
            return;
        }
        int vallen = value.length();
        if (vallen == 0) {
            removeHeader = true;
        } else if (value.charAt(vallen - 1) != '\n' || value.charAt(vallen - 2) != '\r') {
            value = value + this._crlf;
        }
        int headerLen = header.length();
        int numHeaders = this._headerLines.size();
        int i = 0;
        while (i < numHeaders) {
            String s = (String)this._headerLines.get(i);
            if (s.regionMatches(true, 0, header, 0, headerLen)) {
                this._headerLines.remove(i);
                if (!removeHeader) {
                    this._headerLines.add(value);
                }
                this._headerCache.remove(header);
                return;
            }
            ++i;
        }
        if (!removeHeader) {
            this._headerLines.add(value);
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getHost() {
        return this._host;
    }

    public String getGatewayHost() {
        return this._gatewayhost;
    }

    public String getPort() {
        return this._port;
    }

    public String getGatewayScheme() {
        return this._gwscheme;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public boolean getUseProxy() {
        return this._useProxy;
    }

    public String getObject() {
        return this._object;
    }

    public int getSize() {
        return this._size;
    }

    public void addSize(int size) {
        this._size += size;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setObject(String object) {
        this._object = object;
    }

    public void setGatewayHost(String gwhost) {
        this._gatewayhost = gwhost;
    }

    public void setArchiveTranslate(boolean t) {
        this._archiveTranslate = t;
    }

    public boolean getArchiveTranslate() {
        return this._archiveTranslate;
    }

    public BufferedInputStream getContentStream() {
        return this._contentStream;
    }

    public void setContentStream(BufferedInputStream in) {
        this._contentStream = in;
    }

    public void addHeaderLine(String s) {
        if (this._firstLine) {
            if (s.equals(this._crlf)) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Persistence Return !!");
                }
                return;
            }
            int strLength = s.length();
            if (strLength > 0 && s.charAt(strLength - 1) == this.lf) {
                if (!s.endsWith(this._crlf)) {
                    s = s.substring(0, strLength - 1) + this._crlf;
                }
                if (s.startsWith(this._crlf)) {
                    s = s.substring(2);
                } else if (s.charAt(0) == this.lf) {
                    s = s.substring(1);
                }
                if (s.equals(this._crlf)) {
                    return;
                }
                this._firstLine = false;
                StringTokenizer st = new StringTokenizer(s);
                this._method = st.nextToken();
                this.parseURI(this.URLDecode(st.nextToken()));
                try {
                    this._httpVersion = st.nextToken();
                }
                catch (NoSuchElementException ex) {
                    this._httpVersion = "HTTP/0.9";
                    this._headerComplete = true;
                }
            }
        } else {
            int strLength = s.length();
            if (!s.endsWith(this._crlf) && strLength > 0) {
                s = s.substring(0, strLength - 1) + this._crlf;
            }
            if (s.equals(this._crlf)) {
                this._headerComplete = true;
            } else if (s.regionMatches(true, 0, "host:", 0, 5)) {
                if (s.length() > 5) {
                    this._gatewayhost = s.substring(5).trim();
                    int index = this._gatewayhost.indexOf(58);
                    if (index != -1) {
                        this._gatewayhost = this._gatewayhost.substring(0, index);
                    }
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRequest: gateway host is " + this._gatewayhost);
                    }
                }
            } else {
                this._headerLines.add(s);
            }
        }
    }

    private String URLDecode(String url) {
        int i;
        StringBuffer sb = new StringBuffer();
        int start = 0;
        start = url.indexOf("://");
        if (start == -1 && (start = url.indexOf(":/")) != -1) {
            sb.append(url.substring(0, start + 2)).append('/').append(url.substring(start + 2));
            url = sb.toString();
            sb.setLength(0);
        }
        start = 0;
        int indexParam = url.indexOf(63);
        if (indexParam == -1) {
            indexParam = url.length();
        }
        do {
            if ((i = url.indexOf(_colonString, start)) == -1 || i > indexParam) {
                sb.append(url.substring(start));
                break;
            }
            sb.append(url.substring(start, i));
            sb.append(':');
            start = i + _colonString.length();
        } while (i != -1);
        return sb.toString();
    }

    private String parseGatewayScheme(String url) {
        if (url.length() < 2) {
            return url;
        }
        int index = url.indexOf(47, 1);
        if (index == -1) {
            this._gwscheme = url.substring(1);
            return new String("/");
        }
        if (index == 1) {
            return url.substring(1);
        }
        int index2 = url.indexOf(58, 1);
        if (index2 == -1 || index2 > index) {
            this._gwscheme = url.substring(1, index);
            return url.substring(index);
        }
        return url;
    }

    private String checkURL(String s, int andBegin) {
        s = s.substring(0, andBegin) + "/" + s.substring(andBegin);
        this._url = s.substring(1);
        int tmpUriIndex = this._uri.indexOf(63, andBegin);
        this._uri = this._uri.substring(0, tmpUriIndex) + "/" + this._uri.substring(tmpUriIndex);
        return s;
    }

    private void parseURI(String s) {
        this._uri = s;
        int colonSlashIndex = this._uri.indexOf(":/");
        if (colonSlashIndex != -1) {
            int percentIndex;
            int colonIndex = this._uri.indexOf(58, colonSlashIndex + 1);
            int slashIndex = this._uri.indexOf(47, colonSlashIndex + 3);
            if (slashIndex == -1 && (slashIndex = this._uri.indexOf(63, colonSlashIndex + 3)) == -1) {
                slashIndex = this._uri.length();
            }
            if ((colonIndex == -1 || colonIndex > slashIndex) && (percentIndex = this._uri.indexOf(37, colonSlashIndex + 1)) != -1) {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this._uri.substring(0, colonIndex + 3));
                    sb.append(URLDecoder.decode(this._uri.substring(colonIndex + 3, slashIndex)));
                    if (slashIndex != this._uri.length()) {
                        sb.append(this._uri.substring(slashIndex));
                    }
                    this._uri = sb.toString();
                }
                catch (Exception encodeEx) {
                    // empty catch block
                }
            }
        }
        s = this._uri;
        s = this.parseGatewayScheme(s);
        this._url = s.substring(1);
        int start = s.indexOf(58);
        if (start != -1) {
            this._protocol = s.substring(1, s.indexOf(58));
        }
        if ((start = s.indexOf("//")) == -1) {
            start = s.indexOf(":/");
        }
        if (start != -1) {
            String hostport;
            int endHost;
            int end = s.indexOf(47, start + 2);
            if (end == -1 && (end = s.indexOf(63, start + 2)) != -1) {
                s = this.checkURL(s, end);
            }
            if ((endHost = (hostport = s.substring(start, end == -1 ? s.length() : end)).indexOf(58, 1)) == -1) {
                this._port = this._protocol.equals("https") ? "443" : STRING_HTTP_PORT;
                this._host = hostport.substring(2);
            } else {
                this._host = hostport.substring(2, endHost);
                this._port = hostport.substring(endHost + 1);
            }
            if (end != -1) {
                this._object = s.substring(end);
            }
        }
        String testURL = this._port == null || this._port.equals(STRING_HTTP_PORT) ? new String(this._protocol + "://" + this._host) : new String(this._protocol + "://" + this._host + ":" + this._port);
        String proxy_port = DomainWebProxyConfig.getWebProxy(this._host);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("HTTPRequest: proxy:port = " + proxy_port);
        }
        if (proxy_port == null || proxy_port.length() == 0) {
            this._proxyHost = null;
        } else {
            int i = proxy_port.indexOf(58);
            if (i == -1 || i + 1 >= proxy_port.length()) {
                this._proxyHost = proxy_port;
                this._proxyPort = 8080;
            } else {
                this._proxyHost = proxy_port.substring(0, i);
                this._proxyPort = Integer.parseInt(proxy_port.substring(i + 1));
            }
        }
        this._useProxy = _useProxyFlag ? this._proxyHost != null && !DontUseWebProxyURL.hasMatch(testURL) : this._proxyHost != null && UseWebProxyURL.hasMatch(testURL);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("_useProxy : " + this._useProxy + " testURL : " + testURL + " _proxyHost : " + this._proxyHost);
        }
        this._forwardCookie = !ServiceIdentifier.isGateway() ? true : ForwardCookieURL.hasMatch(testURL);
    }

    public boolean isHeaderComplete() {
        return this._headerComplete;
    }

    public String getSessionID() {
        String s = this.getRequestHeader("Cookie");
        if (s == null) {
            return null;
        }
        String cookies = s.substring(s.indexOf(58) + 1);
        String result = null;
        StringTokenizer st = new StringTokenizer(cookies, ";");
        while (st.hasMoreTokens() && result == null) {
            String curCookie = st.nextToken().trim();
            if (!curCookie.startsWith(cookiePrefix)) continue;
            result = curCookie.substring(curCookie.indexOf("=") + 1).trim();
        }
        return result;
    }

    public Properties getNetworkInfo() {
        return null;
    }

    public byte[] getCertificate() {
        return null;
    }

    public String toString() {
        return new String(this.getRequestHeaderBytes());
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        String line = this.getRequestHeader("Content-length");
        StringTokenizer tokens = new StringTokenizer(line, " ");
        tokens.nextToken();
        String length = tokens.nextToken().trim();
        return Integer.parseInt(length);
    }

    public String getContentType() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getHeader(String name) {
        return null;
    }

    public Enumeration getHeaders(String name) {
        return null;
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public ServletInputStream getInputStream() {
        GatewayServletInputStream ret = new GatewayServletInputStream(this._contentStream);
        return ret;
    }

    public int getIntHeader(String name) {
        return 0;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public BufferedReader getReader() {
        return null;
    }

    public String getRealPath(String name) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object obj) {
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return true;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public String getGatewayURL() {
        return this.gatewayURL;
    }

    public void setGatewayURL(String url) {
        this.gatewayURL = url;
    }

    static {
        _colonString = ":";
        UseWebProxyURL = new MatchHttps("UseWebProxyURL");
        DontUseWebProxyURL = new MatchHttps("DontUseWebProxyURL");
        ForwardCookieURL = new MatchHttps("ForwardCookieURL");
        useNewDomainLogic = false;
        String logic = SystemProperties.get("gateway.newDomainLogic", "false");
        useNewDomainLogic = logic.equalsIgnoreCase("true");
        sslPort = "443";
        _useProxyFlag = GatewayProfile.getBoolean("UseProxy", false);
        List all_servers = GatewayProfile.getStringList("PortalServerList");
        Iterator iterator = all_servers.iterator();
        while (iterator.hasNext()) {
            try {
                String name = iterator.next().toString();
                URL url = new URL(name);
                String protocol = url.getProtocol();
                String host = url.getHost();
                int port = url.getPort();
                boolean isDefaultPort = false;
                ForwardCookieURL.add(name);
                if (port == 80 && protocol.equals("http") || port == 443 && protocol.equals("https")) {
                    isDefaultPort = true;
                    ForwardCookieURL.add(protocol + "://" + host);
                }
                String ip = InetAddress.getByName(host).getHostAddress();
                ForwardCookieURL.add(protocol + "://" + ip + ":" + port);
                if (!isDefaultPort) continue;
                ForwardCookieURL.add(protocol + "://" + ip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        defaultGW = SystemProperties.get("gateway.host", "");
        _cookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        cookiePrefix = _cookieName + "=";
    }
}

