/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netfile.FileOption;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class WinFile {
    private static final String sccsID = "@(#)WinFile.java\t1.58 00/08/31 Sun Microsystems, Inc.";
    private char c_eol = (char)10;
    private String s_empty_string;
    private String smbpath = this.s_empty_string = "";
    private static Debug debug = null;
    private NetFileLogManager logMgr = null;
    private String ABS_PATH_SMBCLIENT;
    private String ABS_PATH_SMB_CONF;
    private String s_machine_encoding;
    private String s_machine_encoding_original;
    private SSOToken ssoToken = null;
    private int i_number_of_directories_traversed;
    public static final String FILE_ATTRS = "ADHRS";

    WinFile(NetFileLogManager log_Mgr, String s_machine_encoding, SSOToken token) throws NetFileException {
        this.logMgr = log_Mgr;
        this.s_machine_encoding_original = s_machine_encoding;
        this.ssoToken = token;
        this.i_number_of_directories_traversed = 0;
        FileOption filopt = new FileOption(this.logMgr, s_machine_encoding, this.ssoToken);
        this.s_machine_encoding = this.getSmbNameForEncoding(s_machine_encoding);
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
        String[] pathinfo = filopt.grepPlatinfo();
        this.smbpath = pathinfo[0];
        File f_smbclient = new File(this.smbpath + "/smbclient");
        debug.message("Smbclient path=" + this.smbpath);
        if (!f_smbclient.exists()) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "smbclient_not_found");
        }
        this.ABS_PATH_SMBCLIENT = this.smbpath + "/smbclient";
        this.ABS_PATH_SMB_CONF = this.smbpath + "/smb.conf";
        debug.message("machine encoding=" + this.s_machine_encoding_original + ",encodin code=" + s_machine_encoding);
    }

    String[] getWinType(String machine, String domain, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            domain = domain.trim();
            String[] sa_domain_os_server = this.getWinHostInfo(machine, nfr_user_locale_i18n_bucket);
            if (sa_domain_os_server == null) {
                return new String[]{"?WIN", this.s_empty_string};
            }
            if (domain.equals(this.s_empty_string)) {
                return new String[]{"?NT", this.s_empty_string};
            }
            if (!sa_domain_os_server[0].equalsIgnoreCase(domain)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "invalid-domain");
            }
            return new String[]{"?NT", sa_domain_os_server[0]};
        }
        catch (Exception e) {
            debug.error("Error getting type of Windows Machine", (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error21");
        }
    }

    String getShares(String usernam, String passwrd, String machnam, String domainname, NetFileResource nfr_user_locale_i18n_bucket, List hostdata) throws Exception, NetFileException {
        try {
            int i_number_of_machines_saved = hostdata.size();
            String[] sa_shares = this.getStoredShares(hostdata, machnam, nfr_user_locale_i18n_bucket);
            String[] sa_command = this.constructListSharesCommand(machnam, usernam, passwrd, domainname);
            String s_output = this.execute(sa_command);
            this.isOutputOk(s_output);
            int i_index_of_first_dashes = s_output.indexOf("---------");
            if (i_index_of_first_dashes < 0) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unrecognised_smboutput_format");
            }
            int i_index_of_second_dashes = s_output.indexOf("----", i_index_of_first_dashes + "---------".length());
            if (i_index_of_second_dashes <= i_index_of_first_dashes + "---------".length()) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unrecognised_smboutput_format");
            }
            int i_index_of_eol = s_output.indexOf(this.c_eol, i_index_of_second_dashes);
            if (i_index_of_second_dashes >= i_index_of_eol) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unrecognised_smboutput_format");
            }
            int i_index_of_last_eol = i_index_of_eol;
            Vector<String> v_shares = new Vector<String>();
            int i_position_of_end_of_share_name = i_index_of_second_dashes - i_index_of_first_dashes;
            while (true) {
                if (i_index_of_last_eol > (i_index_of_eol = s_output.indexOf(this.c_eol, i_index_of_last_eol + 1))) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unrecognised_smboutput_format");
                }
                String s_curren_row = s_output.substring(i_index_of_last_eol + 1, i_index_of_eol);
                if ((s_curren_row = s_curren_row.trim()).equals(this.s_empty_string)) break;
                String s_share_name = s_curren_row.substring(0, i_position_of_end_of_share_name);
                if ((s_share_name = s_share_name.trim()).equals(this.s_empty_string)) break;
                if (s_share_name.endsWith("$")) {
                    if (this.addShare(sa_shares, s_share_name)) {
                        v_shares.addElement(s_share_name);
                    }
                } else {
                    v_shares.addElement(s_share_name);
                }
                i_index_of_last_eol = i_index_of_eol;
            }
            String string = this.s_empty_string;
            int i_shares = v_shares.size();
            if (i_shares == 0) {
                string = " ";
            } else {
                int i = 0;
                while (i < v_shares.size()) {
                    string = string + (String)v_shares.elementAt(i) + this.c_eol;
                    ++i;
                }
            }
            return string;
        }
        catch (NetFileException e) {
            debug.error("Exception getting shares", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            debug.error("Problem get PC shares", (Throwable)e);
            return "ERROR:" + e.getMessage();
        }
    }

    private boolean addShare(String[] sa_shares, String s_share_name) {
        boolean b_add_share = false;
        int i = 0;
        while (i < sa_shares.length) {
            if (s_share_name.equals(sa_shares[i])) {
                b_add_share = true;
                break;
            }
            ++i;
        }
        return b_add_share;
    }

    private String[] getStoredShares(List l_host_data, String machine, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        Iterator i_host_data = l_host_data.iterator();
        String[] shares = new String[]{};
        while (i_host_data.hasNext()) {
            int i_vms_position;
            String s_machine_data = (String)i_host_data.next();
            String s_machine_name = null;
            if (!s_machine_data.startsWith("machine_name=")) {
                throw new NetFileException("illegal format of stored machine data");
            }
            int i_index_of_eol = s_machine_data.indexOf(this.c_eol, "machine_name=".length());
            if (i_index_of_eol <= "machine_name=".length()) {
                throw new NetFileException("unable to extract machine name");
            }
            s_machine_name = s_machine_data.substring("machine_name=".length(), i_index_of_eol);
            if (!s_machine_name.equals(machine)) continue;
            int i_data_start_position = s_machine_data.indexOf("\nmachine_type=");
            i_index_of_eol = s_machine_data.indexOf(this.c_eol, i_data_start_position += "\nmachine_type=".length());
            if (i_index_of_eol <= i_data_start_position) {
                throw new NetFileException("unable to extract machine type");
            }
            String s_machine_type = s_machine_data.substring(i_data_start_position, i_index_of_eol);
            if (!s_machine_type.equals("WIN") && !s_machine_type.equals("NT")) break;
            Vector<String> v_shares = new Vector<String>();
            while ((i_vms_position = s_machine_data.indexOf("\nshare_name=", i_data_start_position)) >= 0 && i_data_start_position < i_vms_position) {
                i_data_start_position = i_vms_position += "\nshare_name=".length();
                i_index_of_eol = s_machine_data.indexOf(this.c_eol, i_vms_position);
                if (i_vms_position >= i_index_of_eol) break;
                v_shares.addElement(s_machine_data.substring(i_vms_position, i_index_of_eol));
            }
            int i_shares = v_shares.size();
            shares = new String[i_shares];
            int i = 0;
            while (i < i_shares) {
                shares[i] = (String)v_shares.elementAt(i);
                ++i;
            }
        }
        return shares;
    }

    String[] getPCDir(String user_name, String password, String machine, String share, String directory, String domain, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            String[] sa_command = this.constructCommand(machine, share, user_name, password, directory, "ls", domain);
            String s_smb_output = this.execute(sa_command);
            this.isOutputOk(s_smb_output);
            debug.message("Recvd=\n" + s_smb_output);
            int start = 0;
            int end = -1;
            int max_index = s_smb_output.length();
            ArrayList<String[]> al_file_listing = new ArrayList<String[]>();
            boolean has_file_listing_started = false;
            int index = 0;
            while (index < max_index) {
                start = end + 1;
                if ((end = s_smb_output.indexOf(this.c_eol, start)) <= start) break;
                String[] sa_file = this.extractFileInformation(s_smb_output, start, end, has_file_listing_started);
                if (sa_file != null) {
                    al_file_listing.add(sa_file);
                    has_file_listing_started = true;
                }
                ++index;
            }
            int i_files_in_listing = al_file_listing.size();
            int i_num_of_strings = i_files_in_listing * 4;
            String[] sa_file_listing = new String[i_num_of_strings];
            int i = 0;
            int j = 0;
            while (i < i_num_of_strings) {
                String[] sa_file = (String[])al_file_listing.get(j);
                System.arraycopy(sa_file, 0, sa_file_listing, i, 4);
                i += 4;
                ++j;
            }
            this.printFileListing(sa_file_listing);
            return sa_file_listing;
        }
        catch (Exception e) {
            debug.error("Exception in getting the file listing", (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error35");
        }
    }

    private void printFileListing(String[] files) {
        if (null == files) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < files.length) {
            if (0 == i % 4) {
                sb.append("\n");
            }
            sb.append(files[i]).append(",");
            ++i;
        }
        debug.message("File listing = " + sb.toString());
    }

    /*
     * Unable to fully structure code
     */
    String[] extractFileInformation(String string, int start, int end, boolean has_listing_started) throws NetFileException {
        i_charcter_pointer = end - 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        s_time_of_creation = string.substring(i_charcter_pointer + 1, end);
        s_time_of_creation = s_time_of_creation.trim();
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        s_size = string.substring(i_charcter_pointer + 1, i_index_of_last_space);
        try {
            Integer.parseInt(s_size);
            ** GOTO lbl69
        }
        catch (Exception e) {
            if (has_listing_started) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "smbclient_listing_parse_exception", NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_size", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", s_size});
            }
            return null;
        }
        while (string.charAt(i_charcter_pointer) == ' ') {
            --i_charcter_pointer;
lbl69:
            // 2 sources

            if (i_charcter_pointer >= start) continue;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) == ' ') break;
            --i_charcter_pointer;
        }
        maybeFileName = i_index_of_last_space;
        s_type = string.substring(i_charcter_pointer + 1, i_index_of_last_space);
        while (i_charcter_pointer >= start) {
            if (string.charAt(i_charcter_pointer) != ' ') break;
            --i_charcter_pointer;
        }
        i_index_of_last_space = i_charcter_pointer + 1;
        s_file_name = string.substring(start, i_index_of_last_space);
        s_file_name = s_file_name.trim();
        orig_s_type = s_type;
        s_type = s_type.toUpperCase();
        if (s_file_name.equals("")) {
            s_file_name = orig_s_type;
            s_type = "";
        }
        if (!this.verifyFileAttributes(s_type)) {
            s_file_name = string.substring(start, maybeFileName).trim();
            s_type = "";
        }
        s_type = s_type.indexOf("H") > -1 ? "H" : (s_type.indexOf("D") > -1 ? "D" : "-");
        if (s_file_name.equals(".") || s_file_name.equals("..")) {
            return null;
        }
        if (s_type.equalsIgnoreCase("H")) {
            return null;
        }
        return new String[]{s_type, s_file_name, s_size, s_time_of_creation};
    }

    private boolean verifyFileAttributes(String strAttrs) {
        if (null == strAttrs || strAttrs.equals("")) {
            return true;
        }
        strAttrs = strAttrs.trim().toUpperCase();
        int i = 0;
        while (i < strAttrs.length()) {
            if (-1 == FILE_ATTRS.indexOf(strAttrs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    String getPCFile(String username, String password, String machine, String share, String file, String start_directory, String domain, String local_temporary_dir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        try {
            Long l_random = new Long(System.currentTimeMillis());
            if (file.startsWith("\"")) {
                file = file.substring(1, file.length());
            }
            String local_temp_file_name = local_temporary_dir + "/" + l_random.toString() + username.toUpperCase() + file;
            String s_get_file_command = "get \"" + file + "\" \"" + local_temp_file_name + "\"";
            String[] sa_command = this.constructCommand(machine, share, username, password, start_directory, s_get_file_command, domain);
            String s_output = this.execute(sa_command);
            this.isOutputOk(s_output);
            FileOption filopt = new FileOption(this.logMgr, this.s_machine_encoding_original, this.ssoToken);
            return local_temp_file_name;
        }
        catch (Exception ex) {
            debug.error("Exception in running Runtime.exec()", (Throwable)ex);
            FileOption filopt = new FileOption(this.logMgr, this.s_machine_encoding_original, this.ssoToken);
            filopt.doError(filopt.getPlatformLocalisedString("error21"));
            return "ERROR:" + nfr_user_locale_i18n_bucket.getString("error21");
        }
    }

    String putPCFile(String user_name, String password, String machine, String share, String local_temporary_file, String remote_target_file, String directory, String domain, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        FileOption filopt = new FileOption(this.logMgr, this.s_machine_encoding_original, this.ssoToken);
        try {
            try {
                String s_command = "put \"" + local_temporary_file + "\" \"" + remote_target_file + "\"";
                String[] sa_command = this.constructCommand(machine, share, user_name, password, directory, s_command, domain);
                String txtouting = this.execute(sa_command);
                this.isOutputOk(txtouting);
                String string = nfr_user_locale_i18n_bucket.getString("info6");
                Object var16_17 = null;
                filopt = null;
                return string;
            }
            catch (Exception ex) {
                debug.error("Exception putting file", (Throwable)ex);
                filopt.doError(filopt.getPlatformLocalisedString("error21"));
                String string = "ERROR:" + nfr_user_locale_i18n_bucket.getString("error21");
                Object var16_18 = null;
                filopt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            filopt = null;
            throw throwable;
        }
    }

    String[] smbDir(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, String domainname, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String[] sa_results = this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, domainname, maxsrchdir, nfr_user_locale_i18n_bucket);
        if (sa_results.length == 0) {
            return new String[]{"        "};
        }
        return sa_results;
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, String domainname, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            ++this.i_number_of_directories_traversed;
            debug.message(this + ":Directory number being searched=" + this.i_number_of_directories_traversed);
            if (this.i_number_of_directories_traversed > maxsrchdir) {
                return new String[0];
            }
            String[] sa_file_listing = this.getPCDir(usernam, passwrd, machnam, VMSnam, dir_nam, domainname, nfr_user_locale_i18n_bucket);
            Vector<String> v_search_results = new Vector<String>();
            int i = 0;
            while (i < sa_file_listing.length && this.i_number_of_directories_traversed <= maxsrchdir) {
                if (sa_file_listing[i].startsWith("ERROR:")) {
                    throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + dir_nam + "\\"});
                }
                if (sa_file_listing[i].equalsIgnoreCase("d")) {
                    String s_error = this.s_empty_string;
                    String s_directory = dir_nam + "\\" + sa_file_listing[i + 1];
                    try {
                        String[] sa_search_results = this.search(usernam, passwrd, machnam, VMSnam, pattern, s_directory, domainname, maxsrchdir, nfr_user_locale_i18n_bucket);
                        int j = 0;
                        while (j < sa_search_results.length) {
                            v_search_results.addElement(sa_search_results[j]);
                            ++j;
                        }
                    }
                    catch (NetFileException e) {
                        s_error = "(" + e.getMessage(nfr_user_locale_i18n_bucket) + ")";
                    }
                    if (sa_file_listing[i + 1].indexOf(pattern) > -1) {
                        v_search_results.addElement("\\" + VMSnam + s_directory + "\\" + s_error);
                    }
                } else if (sa_file_listing[i + 1].indexOf(pattern) > -1) {
                    v_search_results.addElement("\\" + VMSnam + dir_nam + "\\" + sa_file_listing[i + 1]);
                }
                i += 4;
            }
            if (v_search_results.size() == 0) {
                return new String[0];
            }
            String[] sa_new_results = new String[v_search_results.size()];
            int i2 = 0;
            while (i2 < sa_new_results.length) {
                sa_new_results[i2] = (String)v_search_results.elementAt(i2);
                ++i2;
            }
            return sa_new_results;
        }
        catch (NetFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + dir_nam + "\\"});
        }
    }

    String mkdir(String machine, String share, String user_name, String password, String domain, String parent_directory, String directory_to_create, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            String command = "mkdir \"" + directory_to_create + "\"";
            String[] sa_command = this.constructCommand(machine, share, user_name, password, parent_directory, command, domain);
            String output = this.execute(sa_command);
            this.isOutputOk(output);
            return nfr_user_locale_i18n_bucket.getString("warning52");
        }
        catch (Exception e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_directory");
        }
    }

    String delPCFile(String user_name, String password, String machine, String share, String file, String directory, String domain, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            String[] sa_command = this.constructCommand(machine, share, user_name, password, directory, "rm \"" + file + "\"", domain);
            String txtouting = this.execute(sa_command);
            this.isOutputOk(txtouting);
            if (txtouting.indexOf(file.substring(1, file.length() - 1), 0) >= 0) {
                return nfr_user_locale_i18n_bucket.getString("error34");
            }
        }
        catch (Exception e) {
            debug.error("Problem in deleting file " + file + " on machine " + machine, (Throwable)e);
            return "ERROR:" + nfr_user_locale_i18n_bucket.getString("error_in_connection_to_server");
        }
        return nfr_user_locale_i18n_bucket.getString("info5");
    }

    String[] getWinHostInfo(String machine, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            String result;
            block5: {
                String[] command = this.constructListSharesCommand(machine, null, null, this.s_empty_string);
                result = this.execute(command);
                try {
                    this.isOutputOk(result);
                }
                catch (NetFileException e) {
                    if (e.getMessage().indexOf("ERRnoaccess") > -1) break block5;
                    throw e;
                }
            }
            int i_start = 0;
            int i_end = -1;
            String[] sa_host_info = null;
            int i_length = result.length();
            int i_max_index = i_length - 1;
            while (i_end < i_max_index && (i_start = i_end + 1) < i_max_index && i_start <= (i_end = result.indexOf(this.c_eol, i_start)) && (sa_host_info = this.searchHostInfo(result, i_start, i_end)) == null) {
            }
            return sa_host_info;
        }
        catch (Exception e) {
            debug.message("Exception in getting Windows info", (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error27");
        }
    }

    private int search(String searched, String to_search, int lower_limit, int upper_limit) {
        int i_index = searched.indexOf(to_search, lower_limit);
        if (i_index < lower_limit) {
            return -1;
        }
        if (i_index > upper_limit) {
            return -1;
        }
        return i_index;
    }

    private String[] searchHostInfo(String string, int i_start, int i_end) {
        int i_index_of_domain = this.search(string, "Domain", i_start, i_end);
        if (i_index_of_domain < 0) {
            return null;
        }
        int i_index_of_equal = this.search(string, "=", i_index_of_domain, i_end);
        if (i_index_of_equal < 0) {
            return null;
        }
        int i_index_of_opening_bracket_1 = this.search(string, "[", i_index_of_equal, i_end);
        if (i_index_of_opening_bracket_1 < 0) {
            return null;
        }
        int i_index_of_closing_bracket_1 = this.search(string, "]", i_index_of_opening_bracket_1, i_end);
        if (i_index_of_closing_bracket_1 < 0) {
            return null;
        }
        int i_index_of_os = this.search(string, "OS", i_index_of_closing_bracket_1, i_end);
        if (i_index_of_os < 0) {
            return null;
        }
        i_index_of_equal = this.search(string, "=", i_index_of_os, i_end);
        if (i_index_of_equal < 0) {
            return null;
        }
        int i_index_of_opening_bracket_2 = this.search(string, "[", i_index_of_equal, i_end);
        if (i_index_of_opening_bracket_2 < 0) {
            return null;
        }
        int i_index_of_closing_bracket_2 = this.search(string, "]", i_index_of_opening_bracket_2, i_end);
        if (i_index_of_closing_bracket_2 < 0) {
            return null;
        }
        int i_index_of_server = this.search(string, "Server", i_index_of_closing_bracket_2, i_end);
        if (i_index_of_server < 0) {
            return null;
        }
        i_index_of_equal = this.search(string, "=", i_index_of_server, i_end);
        if (i_index_of_equal < 0) {
            return null;
        }
        int i_index_of_opening_bracket_3 = this.search(string, "[", i_index_of_equal, i_end);
        if (i_index_of_opening_bracket_3 < 0) {
            return null;
        }
        int i_index_of_closing_bracket_3 = this.search(string, "]", i_index_of_opening_bracket_3, i_end);
        if (i_index_of_closing_bracket_3 < 0) {
            return null;
        }
        return new String[]{string.substring(i_index_of_opening_bracket_1 + 1, i_index_of_closing_bracket_1), string.substring(i_index_of_opening_bracket_2 + 1, i_index_of_closing_bracket_2), string.substring(i_index_of_opening_bracket_3 + 1, i_index_of_closing_bracket_3)};
    }

    String execute(String[] command) throws Exception {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            InputStream process_output_stream = process.getInputStream();
            String process_output = this.read(process_output_stream);
            try {
                process.destroy();
            }
            catch (Exception e) {
                debug.error("Problem destroying the process", (Throwable)e);
            }
            return process_output;
        }
        catch (Exception e) {
            debug.error("Exception in executing smbclient command", (Throwable)e);
            throw e;
        }
    }

    String read(InputStream stream) throws Exception {
        StringBuffer buffer = new StringBuffer();
        debug.message("Encoding to read smb output=" + this.s_machine_encoding_original);
        InputStreamReader ips_reader = new InputStreamReader(stream, this.s_machine_encoding_original);
        BufferedReader br_list = new BufferedReader(ips_reader);
        String s_input_line = null;
        while ((s_input_line = br_list.readLine()) != null) {
            buffer.append(s_input_line).append(this.c_eol);
        }
        ips_reader = null;
        return buffer.toString();
    }

    private String[] constructListSharesCommand(String service, String user_name, String password, String domain) {
        String user_password = null;
        if (user_name != null) {
            user_password = user_name + "%" + password;
        }
        if (password == null || password.equals(this.s_empty_string)) {
            if (domain.trim().equals(this.s_empty_string)) {
                if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
                    return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-N", "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
                }
                return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-N", "-U", user_name, "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
            }
            if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
                return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-N", "-W", domain, "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
            }
            return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-N", "-U", user_name, "-W", domain, "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
        }
        if (domain.trim().equals(this.s_empty_string)) {
            if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
                return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-N", "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
            }
            return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-U", user_password, "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
        }
        if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
            return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-N", "-W", domain, "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
        }
        return new String[]{this.ABS_PATH_SMBCLIENT, "-L", "\\" + service, "-U", user_password, "-W", domain, "-t", this.s_machine_encoding, "-s", this.ABS_PATH_SMB_CONF};
    }

    private String[] constructCommand(String service, String share, String user_name, String password, String start_directory, String command, String domain) {
        if (start_directory.equals(this.s_empty_string)) {
            start_directory = "\\";
        }
        String s_service = "\\\\" + service + "\\" + share;
        String s_user_and_password = user_name + "%" + password;
        if (password == null || password.equals(this.s_empty_string)) {
            if (domain.trim().equals(this.s_empty_string)) {
                if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
                    return new String[]{this.ABS_PATH_SMBCLIENT, s_service, "-N", "-D", start_directory, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
                }
                return new String[]{this.ABS_PATH_SMBCLIENT, s_service, "-N", "-U", user_name, "-D", start_directory, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
            }
            if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
                return new String[]{this.ABS_PATH_SMBCLIENT, s_service, "-N", "-D", start_directory, "-W", domain, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
            }
            return new String[]{this.ABS_PATH_SMBCLIENT, s_service, "-N", "-U", user_name, "-D", start_directory, "-W", domain, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
        }
        if (domain.trim().equals(this.s_empty_string)) {
            if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
                return new String[]{this.ABS_PATH_SMBCLIENT, s_service, password, "-D", start_directory, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
            }
            return new String[]{this.ABS_PATH_SMBCLIENT, s_service, "-U", s_user_and_password, "-D", start_directory, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
        }
        if (user_name == null || user_name.trim().equals(this.s_empty_string)) {
            return new String[]{this.ABS_PATH_SMBCLIENT, s_service, password, "-D", start_directory, "-W", domain, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
        }
        return new String[]{this.ABS_PATH_SMBCLIENT, s_service, "-U", s_user_and_password, "-D", start_directory, "-W", domain, "-s", this.ABS_PATH_SMB_CONF, "-t", this.s_machine_encoding, "-c", command, ";"};
    }

    private boolean isOutputOk(String output) throws NetFileException {
        String error_code = this.getErrorCode(output);
        debug.message("Error code=" + error_code);
        if (error_code != null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + error_code);
        }
        return true;
    }

    private String getErrorCode(String string) {
        int i_start = 0;
        int i_end = -1;
        String error_code = null;
        int i_length = string.length();
        int i_max_index = i_length - 1;
        while (i_end < i_max_index && (i_start = i_end + 1) < i_max_index && i_start <= (i_end = string.indexOf(this.c_eol, i_start)) && (error_code = this.searchForError(string, i_start, i_end)) == null) {
        }
        return error_code;
    }

    private String searchForError(String string, int i_start, int i_end) {
        int i_index = string.indexOf("ERR", i_start);
        if (i_start > i_index) {
            return null;
        }
        if (i_index >= i_end) {
            return null;
        }
        int i_last_index = i_index;
        if (i_last_index > (i_index = string.indexOf("-", i_last_index))) {
            return null;
        }
        if (i_index >= i_end) {
            return null;
        }
        i_last_index = i_index;
        if (i_last_index > (i_index = string.indexOf("ERR", i_last_index))) {
            int i = i_last_index;
            while (i < i_end) {
                if (Character.isWhitespace(string.charAt(i))) break;
                ++i;
            }
            int j = i + 1;
            while (j < i_end) {
                if (!Character.isWhitespace(string.charAt(j))) break;
                ++j;
            }
            int k = j + 1;
            while (k < i_end) {
                if (Character.isWhitespace(string.charAt(k))) break;
                ++k;
            }
            String s_code = string.substring(j, k).trim();
            try {
                Integer.parseInt(s_code);
                return s_code;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (i_index >= i_end) {
            return null;
        }
        int i = i_index;
        while (i < i_end) {
            if (string.charAt(i) == ' ') {
                return string.substring(i_index, i);
            }
            ++i;
        }
        return null;
    }

    private String getSmbNameForEncoding(String encoding) {
        FileOption file_option = new FileOption(this.logMgr, encoding, this.ssoToken);
        return file_option.getPlatformLocalisedString(encoding);
    }

    public void rename(String username, String password, String machine, String domain, String share, String directory, String old_file_name, String new_file_name) throws NetFileException {
        try {
            String[] sa_command = this.constructCommand(machine, share, username, password, directory, "rename \"" + old_file_name + "\"    " + "\"" + new_file_name + "\"", domain);
            String txtouting = this.execute(sa_command);
            this.isOutputOk(txtouting);
        }
        catch (Exception e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "noop_no_reason");
        }
    }
}

