/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.FileOption;
import com.sun.portal.netfile.NetFileContext;
import com.sun.portal.netfile.NetFileContextImpl;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import com.sun.portal.netfile.NetFileServlet;
import com.sun.portal.netfile.SessionTempDirCounter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetFileUploadServlet
extends HttpServlet {
    private static Debug debug = null;
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain; charset=UTF-8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGetPost(request, response);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGetPost(HttpServletRequest request, HttpServletResponse response) {
        if (NetFileUploadServlet.debug.messageEnabled()) {
            NetFileUploadServlet.debug.message("Getting upload request");
        }
        s_temp_local_file = null;
        locale = null;
        s_destination_file = null;
        oops_to_applet = null;
        nfr_user_locale_i18n_bucket = null;
        ht_request_parameters = null;
        s_machine_encoding = null;
        manager = null;
        ssoToken = null;
        nfContext = null;
        bHasIncremented = false;
        lm_log_manager = null;
        message = null;
        try {
            block56: {
                block55: {
                    block52: {
                        block54: {
                            block53: {
                                ips_from_applet = request.getInputStream();
                                oips_from_applet = new ObjectInputStream((InputStream)ips_from_applet);
                                so_request = (Serializable[])oips_from_applet.readObject();
                                if (NetFileUploadServlet.debug.messageEnabled()) {
                                    NetFileUploadServlet.debug.message("Read the object=" + oips_from_applet.toString());
                                }
                                response.setContentType("application/octet-stream");
                                ht_request_parameters = (Hashtable)so_request[0];
                                ba_file_block = (byte[])so_request[1];
                                i_bytes_read = (Integer)so_request[2];
                                o_temp_local_file = ht_request_parameters.get("s_temp_local_file");
                                if (o_temp_local_file != null) break block52;
                                count = NetFileServlet.mapIDInUseCount.get(this.extractSession(request));
                                if (count != null) break block53;
                                var30_26 = null;
                                ** GOTO lbl159
                            }
                            counter = (SessionTempDirCounter)count;
                            if (counter.increment(this.extractSession(request))) break block54;
                            ** GOTO lbl170
                        }
                        bHasIncremented = true;
                        manager = SSOTokenManager.getInstance();
                        ssoToken = manager.createSSOToken(this.extractSession(request));
                        if (!this.validateSession(request, response, ssoToken, nfContext = new NetFileContextImpl(ssoToken))) {
                        } else {
                            lm_log_manager = this.createLogManager(ssoToken);
                            s_machine_encoding = (String)ht_request_parameters.get("machine_encoding");
                            locale = (String)ht_request_parameters.get("locale");
                            s_destination_file = (String)ht_request_parameters.get("filename");
                            s_temporary_directory = (String)ht_request_parameters.get("tmpdir");
                            if (NetFileUploadServlet.debug.messageEnabled()) {
                                NetFileUploadServlet.debug.message("Temporary directory=" + s_temporary_directory);
                            }
                            nfr_user_locale_i18n_bucket = this.getUserLocaleBundle(locale, s_machine_encoding, lm_log_manager);
                            s_temp_local_file = s_temporary_directory + "/" + System.currentTimeMillis() + s_destination_file;
                            ht_request_parameters.put("s_temp_local_file", s_temp_local_file);
                            f = new File(s_temp_local_file);
                            if (!f.exists()) {
                                f.createNewFile();
                            }
                            try {
                                message = this.moveFile(s_temp_local_file, nfr_user_locale_i18n_bucket, s_machine_encoding, ht_request_parameters, ssoToken, lm_log_manager);
                            }
                            catch (NetFileException e) {
                                message = e.getMessage(nfr_user_locale_i18n_bucket);
                                throw new NetFileException(message);
                            }
                        }
                    }
                    s_temp_local_file = (String)o_temp_local_file;
                    count = NetFileServlet.mapIDInUseCount.get(this.extractSession(request));
                    if (count != null) break block55;
                    ** GOTO lbl194
                }
                counter = (SessionTempDirCounter)count;
                if (counter.increment(this.extractSession(request))) break block56;
                ** GOTO lbl206
            }
            bHasIncremented = true;
            fops_temp_local_file = new FileOutputStream(s_temp_local_file, true);
            fops_temp_local_file.write(ba_file_block, 0, i_bytes_read);
            fops_temp_local_file.close();
            f_temp_local_file = new File(s_temp_local_file);
            l_file_size = f_temp_local_file.length();
            ht_request_parameters.put("l_bytes_recieved", new Long(l_file_size));
            if (NetFileUploadServlet.debug.messageEnabled()) {
                NetFileUploadServlet.debug.message("Wrote to the file " + s_temp_local_file);
            }
            if (is_last_block = (b_is_last_block = (Boolean)ht_request_parameters.get("b_is_final_request")).booleanValue()) {
                manager = SSOTokenManager.getInstance();
                ssoToken = manager.createSSOToken(this.extractSession(request));
                s_machine_encoding = (String)ht_request_parameters.get("machine_encoding");
                locale = (String)ht_request_parameters.get("locale");
                nfr_user_locale_i18n_bucket = this.getUserLocaleBundle(locale, s_machine_encoding, lm_log_manager);
                if (NetFileUploadServlet.debug.messageEnabled()) {
                    NetFileUploadServlet.debug.message("Moving file of size " + l_file_size + " bytes");
                }
                try {
                    message = this.moveFile(s_temp_local_file, nfr_user_locale_i18n_bucket, s_machine_encoding, ht_request_parameters, ssoToken, lm_log_manager);
                }
                catch (NetFileException e) {
                    message = "ERROR:" + e.getMessage(nfr_user_locale_i18n_bucket);
                }
                ht_request_parameters.put("s_status", message);
                if (NetFileUploadServlet.debug.messageEnabled()) {
                    NetFileUploadServlet.debug.message("Upload completion time " + System.currentTimeMillis());
                }
            } else {
                ht_request_parameters.put("s_status", "OK");
            }
            ops_to_applet = response.getOutputStream();
            oops_to_applet = new ObjectOutputStream((OutputStream)ops_to_applet);
            oops_to_applet.writeObject(ht_request_parameters);
            oops_to_applet.flush();
            if (NetFileUploadServlet.debug.messageEnabled()) {
                NetFileUploadServlet.debug.message("Written to the applet");
            }
            ** GOTO lbl218
        }
        catch (Throwable e) {
            s_machine_encoding = (String)ht_request_parameters.get("machine_encoding");
            locale = (String)ht_request_parameters.get("locale");
            try {
                if (nfr_user_locale_i18n_bucket == null) {
                    nfr_user_locale_i18n_bucket = this.getUserLocaleBundle(locale, s_machine_encoding, lm_log_manager);
                }
            }
            catch (Throwable thr) {
                NetFileUploadServlet.debug.error("Error in obtaining the resource bundle");
            }
            if (oops_to_applet == null) {
                try {
                    oops_to_applet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.processException(ht_request_parameters, nfr_user_locale_i18n_bucket, e, s_machine_encoding, oops_to_applet, ssoToken, lm_log_manager);
            var30_32 = null;
            try {
                if (!bHasIncremented) {
                    ht_request_parameters.put("s_status", "ERROR: Invalid session");
                } else {
                    this.resetTempDirCounter(request);
                }
                oops_to_applet.close();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var29_50) {
                var30_33 = null;
                ** try [egrp 6[TRYBLOCK] [6 : 1020->1051)] { 
lbl149:
                // 1 sources

                if (!bHasIncremented) {
                    ht_request_parameters.put("s_status", "ERROR: Invalid session");
                } else {
                    this.resetTempDirCounter(request);
                }
                oops_to_applet.close();
                throw var29_50;
lbl156:
                // 1 sources

                catch (Exception e) {
                    e.printStackTrace();
                }
                throw var29_50;
            }
lbl159:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [6 : 1020->1051)] { 
lbl160:
            // 1 sources

            if (!bHasIncremented) {
                ht_request_parameters.put("s_status", "ERROR: Invalid session");
            } else {
                this.resetTempDirCounter(request);
            }
            oops_to_applet.close();
            return;
lbl167:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
            return;
lbl170:
            // 1 sources

            var30_27 = null;
            ** try [egrp 6[TRYBLOCK] [6 : 1020->1051)] { 
lbl172:
            // 1 sources

            if (!bHasIncremented) {
                ht_request_parameters.put("s_status", "ERROR: Invalid session");
            } else {
                this.resetTempDirCounter(request);
            }
            oops_to_applet.close();
            return;
lbl179:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
            return;
            var30_28 = null;
            ** try [egrp 6[TRYBLOCK] [6 : 1020->1051)] { 
lbl184:
            // 1 sources

            if (!bHasIncremented) {
                ht_request_parameters.put("s_status", "ERROR: Invalid session");
            } else {
                this.resetTempDirCounter(request);
            }
            oops_to_applet.close();
            return;
lbl191:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
            return;
lbl194:
            // 1 sources

            var30_29 = null;
            ** try [egrp 6[TRYBLOCK] [6 : 1020->1051)] { 
lbl196:
            // 1 sources

            if (!bHasIncremented) {
                ht_request_parameters.put("s_status", "ERROR: Invalid session");
            } else {
                this.resetTempDirCounter(request);
            }
            oops_to_applet.close();
            return;
lbl203:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
            return;
lbl206:
            // 1 sources

            var30_30 = null;
            ** try [egrp 6[TRYBLOCK] [6 : 1020->1051)] { 
lbl208:
            // 1 sources

            if (!bHasIncremented) {
                ht_request_parameters.put("s_status", "ERROR: Invalid session");
            } else {
                this.resetTempDirCounter(request);
            }
            oops_to_applet.close();
            return;
lbl215:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
            return;
lbl218:
            // 1 sources

            var30_31 = null;
            try {}
            catch (Exception e) {}
            e.printStackTrace();
            return;
            if (!bHasIncremented) {
                ht_request_parameters.put("s_status", "ERROR: Invalid session");
            } else {
                this.resetTempDirCounter(request);
            }
            oops_to_applet.close();
            return;
        }
    }

    private void processException(Hashtable ht_request_parameters, NetFileResource nfr_user_locale_i18n_bucket, Throwable e, String s_machine_encoding, ObjectOutputStream oops_to_applet, SSOToken ssoToken, NetFileLogManager lm_log_manager) {
        try {
            String message = null;
            debug.error("Exception uploading a file", e);
            if (e instanceof NetFileException) {
                if (s_machine_encoding == null) {
                    s_machine_encoding = "UTF8";
                }
                FileOption fo_log = new FileOption(lm_log_manager, s_machine_encoding, ssoToken);
                message = ((NetFileException)e).getMessage(fo_log.getPlatformLocalisedBundle());
                if (debug.messageEnabled()) {
                    debug.message("Message from=" + message);
                }
                fo_log.doLog(message);
                if (nfr_user_locale_i18n_bucket != null) {
                    message = ((NetFileException)e).getMessage(nfr_user_locale_i18n_bucket);
                }
                if (debug.messageEnabled()) {
                    debug.message("Message from=" + message);
                }
            }
            if (ht_request_parameters == null) {
                throw new Exception("ht_request_parameters is null");
            }
            if (oops_to_applet != null) {
                try {
                    ht_request_parameters.put("s_status", "ERROR:" + message);
                    oops_to_applet.writeObject(ht_request_parameters);
                    oops_to_applet.flush();
                }
                catch (Throwable ex) {
                    debug.error("Exception sending error message after exception in upload of file", ex);
                }
            }
        }
        catch (Exception ex) {
            debug.error("Exception logging exception in upload of file", (Throwable)ex);
        }
    }

    private String moveFile(String s_temp_local_file, NetFileResource nfr_user_locale_i18n_bucket, String s_machine_encoding, Hashtable ht_request_parameters, SSOToken ssoToken, NetFileLogManager lm_log_manager) throws Throwable {
        String message = "ERROR:Unable to upload file";
        try {
            FileOption file_option = new FileOption(lm_log_manager, s_machine_encoding, ssoToken);
            String s_destination_file = (String)ht_request_parameters.get("filename");
            String s_temporary_directory = (String)ht_request_parameters.get("tmpdir");
            String domain = (String)ht_request_parameters.get("domain");
            String machine = (String)ht_request_parameters.get("machine");
            String type = (String)ht_request_parameters.get("type");
            String user_name = (String)ht_request_parameters.get("username");
            String directory = (String)ht_request_parameters.get("dir");
            String share = (String)ht_request_parameters.get("VMS");
            String password = (String)ht_request_parameters.get("pass");
            message = "ERROR:" + nfr_user_locale_i18n_bucket.getString("error24");
            if (debug.messageEnabled()) {
                debug.message("Uploading file:" + s_temp_local_file);
            }
            message = file_option.uploadFile(user_name, password, machine, domain, type, directory, share, s_temp_local_file, s_destination_file, s_temporary_directory, nfr_user_locale_i18n_bucket);
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            try {
                File file;
                if (s_temp_local_file != null && (file = new File(s_temp_local_file)).exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                debug.error("Exception deleting local file", (Throwable)e);
            }
            throw throwable;
        }
        try {
            File file;
            if (s_temp_local_file != null && (file = new File(s_temp_local_file)).exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            debug.error("Exception deleting local file", (Throwable)e);
        }
        return message;
    }

    private NetFileResource getUserLocaleBundle(String s_locale, String s_machine_encoding, NetFileLogManager lm_log_manager) throws Throwable {
        NetFileResource nfr_user_locale_i18n_bucket = null;
        if (s_locale == null) {
            FileOption file_option = new FileOption(lm_log_manager, s_machine_encoding);
            nfr_user_locale_i18n_bucket = file_option.getPlatformLocalisedBundle();
        } else {
            nfr_user_locale_i18n_bucket = NetFileResource.getInstance("srapNetFileAppletJava1", s_locale);
        }
        return nfr_user_locale_i18n_bucket;
    }

    private boolean validateSession(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken, NetFileContext nfContext) {
        Object out = null;
        try {
            return nfContext.isSessionValid(ssoToken) && nfContext.isExecutable(ssoToken);
        }
        catch (Exception e) {
            debug.error("General Exception in NetFileUploadServlet", (Throwable)e);
            return false;
        }
    }

    private String extractSession(HttpServletRequest req) {
        String session = null;
        session = req.getHeader("iPSsessionID");
        Cookie[] cookie = req.getCookies();
        if (cookie != null) {
            int i = 0;
            while (i < cookie.length) {
                if (cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) {
                    session = cookie[i].getValue();
                    if (NetFileServlet.isEncoded) {
                        session = URLDecoder.decode(session);
                    }
                }
                ++i;
            }
        }
        return session;
    }

    private void resetTempDirCounter(HttpServletRequest request) {
        Object count = NetFileServlet.mapIDInUseCount.get(this.extractSession(request));
        if (count == null) {
            return;
        }
        SessionTempDirCounter counter = (SessionTempDirCounter)count;
        counter.decrement(this.extractSession(request));
    }

    private NetFileLogManager createLogManager(SSOToken ssoToken) {
        String tokenId = ssoToken.getTokenID().toString();
        try {
            Object obj = NetFileServlet.logManagerCache.get(tokenId);
            if (obj == null) {
                NetFileLogManager logMgr = new NetFileLogManager(ssoToken);
                NetFileServlet.logManagerCache.put(tokenId, logMgr);
                return logMgr;
            }
            return (NetFileLogManager)obj;
        }
        catch (Exception e) {
            debug.error("Unable to create LogManager for ssoToken-" + tokenId);
            return null;
        }
    }
}

