/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.FileOption;
import com.sun.portal.netfile.NetFileContext;
import com.sun.portal.netfile.NetFileContextImpl;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import com.sun.portal.netfile.NetFileServlet;
import com.sun.portal.netfile.NetFileURLDecoder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetFileOpenFileServlet
extends HttpServlet {
    private static Debug debug;
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain; charset=UTF-8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    private String get(Hashtable ht_request_parameters, String key) throws Exception {
        Object o_value = ht_request_parameters.get(key);
        if (o_value == null) {
            return null;
        }
        String[] sa_value = (String[])o_value;
        if (sa_value.length == 1) {
            return sa_value[0];
        }
        throw new Exception("illegal size of array of values of parameter " + key);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block20: {
            block19: {
                f_local_file = null;
                file_name = null;
                file_option = null;
                manager = null;
                ssoToken = null;
                lm_log_manager = null;
                try {
                    try {
                        manager = SSOTokenManager.getInstance();
                        ssoToken = manager.createSSOToken(this.extractSession(req));
                        nfContext = new NetFileContextImpl(ssoToken);
                        if (!this.validateSession(req, res, ssoToken, nfContext)) {
                            var21_11 = null;
                            break block19;
                        }
                        lm_log_manager = this.createLogManager(ssoToken);
                        nfContext.determineHTMLCharset(req);
                        htmlCharset = nfContext.getHTMLCharset();
                        ht_request_parameters = this.parseHttpRequestForParameters(req);
                        s_local_file_name = this.get(ht_request_parameters, "localfile");
                        NetFileOpenFileServlet.debug.message("Filename=" + s_local_file_name);
                        if (s_local_file_name == null) {
                            throw new Exception("local file name is null");
                        }
                        f_local_file = new File(s_local_file_name);
                        s_function = this.get(ht_request_parameters, "func");
                        s_locale = this.get(ht_request_parameters, "locale");
                        s_machine_encoding = this.get(ht_request_parameters, "machine_encoding");
                        nfr_user_locale_i18n_bucket = this.getUserLocaleBundle(lm_log_manager, s_locale, s_machine_encoding);
                        file_name = this.get(ht_request_parameters, "filename");
                        if (file_name == null) {
                            throw new Exception("file name is null");
                        }
                        s_return_type = this.getReturnType(lm_log_manager, file_name, nfr_user_locale_i18n_bucket, ssoToken, s_machine_encoding);
                        i_file_size = f_local_file.length();
                        file_option = new FileOption(lm_log_manager, s_machine_encoding);
                        if (s_function.equals("viewFile")) {
                            NetFileOpenFileServlet.debug.message("Opening file");
                            file_option.doLog(file_option.getPlatformLocalisedString("func24") + file_name);
                            this.setContentTypeForOpen(res, req, file_name, i_file_size, s_return_type, htmlCharset);
                        } else if (s_function.equals("downloadFile")) {
                            NetFileOpenFileServlet.debug.message("Downloading file");
                            file_option.doLog(file_option.getPlatformLocalisedString("func13") + file_name);
                            this.setContentTypeForDownload(res, req, file_name, i_file_size, s_return_type, htmlCharset);
                        }
                        this.returnFile(f_local_file, res);
                        break block20;
                    }
                    catch (NetFileException e) {
                        NetFileOpenFileServlet.debug.error("Exception while fetching files", (Throwable)e);
                        file_option.doError(e.getMessage(file_option.getPlatformLocalisedBundle()));
                        var21_13 = null;
                        try {
                            if (f_local_file == null) return;
                            if (f_local_file.exists() == false) return;
                            NetFileOpenFileServlet.debug.message("Deleted " + f_local_file.getAbsolutePath());
                            f_local_file.delete();
                            return;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Throwable e) {
                        NetFileOpenFileServlet.debug.error("Exception opening file " + file_name, e);
                        var21_14 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 475->524)] { 
lbl66:
                        // 1 sources

                        if (f_local_file == null) return;
                        if (f_local_file.exists() == false) return;
                        NetFileOpenFileServlet.debug.message("Deleted " + f_local_file.getAbsolutePath());
                        f_local_file.delete();
                        return;
lbl72:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable var20_31) {
                    block21: {
                        var21_15 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 475->524)] { 
lbl79:
                        // 1 sources

                        if (f_local_file != null) {
                            if (f_local_file.exists()) {
                                NetFileOpenFileServlet.debug.message("Deleted " + f_local_file.getAbsolutePath());
                                f_local_file.delete();
                            }
                            f_local_file = null;
                        }
                        break block21;
lbl86:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    file_option = null;
                    throw var20_31;
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 475->524)] { 
lbl93:
            // 1 sources

            if (f_local_file == null) return;
            if (f_local_file.exists() == false) return;
            NetFileOpenFileServlet.debug.message("Deleted " + f_local_file.getAbsolutePath());
            f_local_file.delete();
            return;
lbl99:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var21_12 = null;
        ** try [egrp 2[TRYBLOCK] [3 : 475->524)] { 
lbl105:
        // 1 sources

        if (f_local_file == null) return;
        if (f_local_file.exists() == false) return;
        NetFileOpenFileServlet.debug.message("Deleted " + f_local_file.getAbsolutePath());
        f_local_file.delete();
        return;
lbl111:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
    }

    private NetFileResource getUserLocaleBundle(NetFileLogManager lm_log_manager, String s_locale, String s_machine_encoding) throws Throwable {
        NetFileResource nfr_user_locale_i18n_bucket = null;
        if (s_locale == null) {
            FileOption file_option = new FileOption(lm_log_manager, s_machine_encoding);
            nfr_user_locale_i18n_bucket = file_option.getPlatformLocalisedBundle();
        } else {
            nfr_user_locale_i18n_bucket = NetFileResource.getInstance("srapNetFileAppletJava1", s_locale);
        }
        return nfr_user_locale_i18n_bucket;
    }

    private String getReturnType(NetFileLogManager lm_log_manager, String file_name, NetFileResource nfr_user_locale_i18n_bucket, SSOToken token, String s_machine_encoding) throws Throwable {
        int i_index_of_dot = file_name.lastIndexOf(46);
        String suffix = file_name.substring(i_index_of_dot + 1, file_name.length());
        FileOption file_option = new FileOption(lm_log_manager, s_machine_encoding);
        file_option.setSSOToken(token);
        return file_option.getFileContentType(suffix, nfr_user_locale_i18n_bucket);
    }

    private void setContentTypeForOpen(HttpServletResponse res, HttpServletRequest req, String filename, long file_size, String returntype, String HTMLcharsetname) throws Throwable {
        if (returntype == null || returntype.trim().length() == 0) {
            res.setContentType("application/octet-stream; charset=" + HTMLcharsetname);
        } else {
            res.setContentType(returntype.trim() + "; charset=" + HTMLcharsetname);
        }
        res.setHeader("Content-disposition", "filename=" + filename);
        res.setHeader("Content-length", Long.toString(file_size));
    }

    private void setContentTypeForDownload(HttpServletResponse res, HttpServletRequest req, String filename, long file_size, String returntype, String HTMLcharsetname) {
        res.setHeader("Content-Type", "application/octet-stream; charset=" + HTMLcharsetname);
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        res.setHeader("Content-length", Long.toString(file_size));
        res.setHeader("Content-Transfer-Encoding", HTMLcharsetname);
    }

    Hashtable parseHttpRequestForParameters(HttpServletRequest hsr_req) throws Throwable {
        String key;
        String s_query_string = hsr_req.getQueryString();
        StringTokenizer st_params = new StringTokenizer(s_query_string, "&");
        Hashtable ht_params = new Hashtable();
        NetFileURLDecoder decoder = new NetFileURLDecoder();
        while (st_params.hasMoreTokens()) {
            String s_token = st_params.nextToken();
            int i_index_equal = s_token.indexOf(61);
            if (i_index_equal <= 0) continue;
            key = s_token.substring(0, i_index_equal);
            Object o_values = ht_params.get(key);
            Vector<String> v_values = null;
            if (o_values == null) {
                v_values = new Vector<String>(3);
                ht_params.put(key, v_values);
            }
            String value = "";
            if (++i_index_equal < s_token.length()) {
                value = s_token.substring(i_index_equal, s_token.length());
            }
            v_values.addElement(decoder.decode(value, "UTF8"));
        }
        Hashtable<String, String[]> ht_params_1 = new Hashtable<String, String[]>();
        Enumeration e_params = ht_params.keys();
        while (e_params.hasMoreElements()) {
            key = (String)e_params.nextElement();
            Vector v_values = (Vector)ht_params.get(key);
            int i_size = v_values.size();
            String[] sa_values = new String[i_size];
            int i = 0;
            while (i < i_size) {
                sa_values[i] = (String)v_values.elementAt(i);
                ++i;
            }
            ht_params_1.put(key, sa_values);
        }
        return ht_params_1;
    }

    private void returnFile(File file, HttpServletResponse res) throws Throwable {
        long file_size = file.length();
        FileInputStream fis_local_file = new FileInputStream(file);
        ServletOutputStream sops_response = res.getOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = fis_local_file.read(buf)) != -1) {
            sops_response.write(buf, 0, bytesRead);
        }
        sops_response.close();
        fis_local_file.close();
        debug.message("Exiting doView");
    }

    private boolean validateSession(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken, NetFileContext nfContext) {
        PrintWriter out = null;
        try {
            if (nfContext.isSessionValid(ssoToken) && nfContext.isExecutable(ssoToken)) {
                return true;
            }
            if (out == null) {
                res.setContentType(CONTENT_TYPE_TEXT_PLAIN);
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
            }
            out.println("ERROR: Session is Invalid or no policy to execute ");
            out.close();
            return false;
        }
        catch (Exception e) {
            if (out == null) {
                try {
                    res.setContentType(CONTENT_TYPE_TEXT_PLAIN);
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
                }
                catch (Exception e1) {
                    return false;
                }
            }
            out.println("ERROR:" + e.getMessage());
            debug.error("General Exception in NetFileOpenFileServlet", (Throwable)e);
            return false;
        }
    }

    private String extractSession(HttpServletRequest req) {
        String session = null;
        session = req.getHeader("iPSsessionID");
        Cookie[] cookie = req.getCookies();
        if (cookie != null) {
            int i = 0;
            while (i < cookie.length) {
                if (cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) {
                    session = cookie[i].getValue();
                    if (NetFileServlet.isEncoded) {
                        session = URLDecoder.decode(session);
                    }
                }
                ++i;
            }
        }
        return session;
    }

    private NetFileLogManager createLogManager(SSOToken ssoToken) {
        String tokenId = ssoToken.getTokenID().toString();
        try {
            Object obj = NetFileServlet.logManagerCache.get(tokenId);
            if (obj == null) {
                NetFileLogManager logMgr = new NetFileLogManager(ssoToken);
                NetFileServlet.logManagerCache.put(tokenId, logMgr);
                return logMgr;
            }
            return (NetFileLogManager)obj;
        }
        catch (Exception e) {
            debug.error("Unable to create LogManager for ssoToken-" + tokenId);
            return null;
        }
    }
}

