/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.log.LogRecord;
import com.iplanet.sso.SSOToken;

public class NetFileLogManager {
    public static final String logFile = "srapNetFile";
    private LogManager logMgr = null;
    public Debug debug = null;

    public NetFileLogManager(SSOToken token) throws Exception {
        this.createLog(token);
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)logFile);
        }
    }

    public void doError(String msg) {
        if (this.logMgr == null) {
            return;
        }
        String suffix = ":Error - ";
        LogRecord logrec = new LogRecord(logFile, suffix + msg);
        try {
            this.logMgr.write(logrec, logFile);
        }
        catch (LogException le) {
            this.debug.error("FileOption - doError - write log record didn't work: ", (Throwable)le);
        }
    }

    public void doLog(String msg) {
        if (this.logMgr == null) {
            return;
        }
        try {
            String suffix = ":Log - ";
            LogRecord logrec = new LogRecord(logFile, suffix + msg);
            try {
                this.logMgr.write(logrec, logFile);
            }
            catch (LogException le) {
                this.debug.error("FileOption - doLog - write log record didn't work: ", (Throwable)le);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void createLog(SSOToken ssoToken) throws Exception {
        this.logMgr = new LogManager(ssoToken);
        this.logMgr.create(logFile);
    }
}

