/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.NetFileAttributeExtractor;
import com.sun.portal.netfile.NetFileContext;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileHostDenialProcessor;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetFileHostDataProcessor {
    public NetFileLogManager logMgr;
    private Debug debug;
    private char c_eol = (char)10;
    private String s_empty_string = "";
    private String S_DEFAULT_ENCODING = "ISO-8859-1";
    private List allowedHosts;
    private List deniedHosts;
    private List listOfHosts;
    private String commondata = this.s_empty_string;
    private String defaultDomain = this.s_empty_string;
    private String[] localHostAddrs;

    public NetFileHostDataProcessor(NetFileLogManager logMgr) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        if (logMgr == null) {
            this.logMgr = logMgr;
        }
        this.localHostAddrs = this.getRPaddrs();
    }

    StringBuffer processHostsData(StringBuffer returnbufstr, NetFileContext nfContext, NetFileAttributeExtractor nfAttrs, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        ArrayList al_denied_hosts;
        InetAddress[] ia_denied_hosts;
        block21: {
            this.loadHostDataSets(nfAttrs);
            NetFileHostDenialProcessor nfhdp = new NetFileHostDenialProcessor();
            ia_denied_hosts = this.deniedHosts != null && !this.deniedHosts.isEmpty() ? nfhdp.getDeniedHostsAddresses(this.deniedHosts) : new InetAddress[]{};
            String s_common_data = this.s_empty_string;
            if (this.commondata != null) {
                s_common_data = this.commondata;
            }
            al_denied_hosts = new ArrayList();
            try {
                if (s_common_data != null && !s_common_data.trim().equals(this.s_empty_string)) {
                    HashMap ht_hosts_shares_set_by_admin = this.parseCommonHostsData(s_common_data, nfContext, nfr_user_locale_i18n_bucket);
                    Iterator e_machine_type_password_shares = this.listOfHosts.iterator();
                    while (e_machine_type_password_shares.hasNext()) {
                        String s_user_added_host_share = (String)e_machine_type_password_shares.next();
                        s_user_added_host_share = this.getDecryptedHostInfo(s_user_added_host_share);
                        String s_host_name = this.getMachineName(s_user_added_host_share);
                        String szFQHostName = nfhdp.getFQHostName(s_host_name, this.defaultDomain);
                        InetAddress[] hostIAddresses = null;
                        try {
                            hostIAddresses = this.getInetAddresses(szFQHostName);
                        }
                        catch (UnknownHostException uhe) {
                            this.debug.error("Exception in determining the host address", (Throwable)uhe);
                            continue;
                        }
                        if (this.isLocalHost(hostIAddresses)) continue;
                        if (nfhdp.isHostAllowed(this.allowedHosts, this.deniedHosts, szFQHostName, hostIAddresses, true)) {
                            if (ia_denied_hosts != null && nfhdp.isHostDenied(hostIAddresses, ia_denied_hosts)) {
                                al_denied_hosts.add(s_host_name);
                            }
                        } else {
                            al_denied_hosts.add(s_host_name);
                        }
                        try {
                            HashMap ht_matching_host = this.getMatchingHost(szFQHostName, ht_hosts_shares_set_by_admin);
                            if (ht_matching_host != null) {
                                s_user_added_host_share = this.mergeHost(s_user_added_host_share, ht_matching_host);
                                this.removeValue(ht_hosts_shares_set_by_admin, ht_matching_host);
                            }
                        }
                        catch (Exception e) {
                            this.debug.error("Error in merging hosts", (Throwable)e);
                        }
                        returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                    }
                    Object[] o_hosts_and_denied_hosts = this.addUnmergedHosts(nfhdp, ht_hosts_shares_set_by_admin, al_denied_hosts, ia_denied_hosts);
                    String s_common_hosts_not_added_by_user = (String)o_hosts_and_denied_hosts[0];
                    al_denied_hosts = (ArrayList)o_hosts_and_denied_hosts[1];
                    returnbufstr.append(s_common_hosts_not_added_by_user).append(this.c_eol);
                    break block21;
                }
                if (this.listOfHosts.isEmpty()) break block21;
                Iterator e_machine_type_password_shares = this.listOfHosts.iterator();
                while (e_machine_type_password_shares.hasNext()) {
                    String s_user_added_host_share = (String)e_machine_type_password_shares.next();
                    s_user_added_host_share = this.getDecryptedHostInfo(s_user_added_host_share);
                    String s_host_name = this.getMachineName(s_user_added_host_share);
                    String szFQHostName = nfhdp.getFQHostName(s_host_name, this.defaultDomain);
                    InetAddress[] hostIAddresses = null;
                    try {
                        hostIAddresses = this.getInetAddresses(szFQHostName);
                    }
                    catch (UnknownHostException uhe) {
                        this.debug.error("Exception in determining the host address", (Throwable)uhe);
                        continue;
                    }
                    if (this.isLocalHost(hostIAddresses)) continue;
                    if (nfhdp.isHostAllowed(this.allowedHosts, this.deniedHosts, szFQHostName, hostIAddresses, true)) {
                        if (ia_denied_hosts != null) {
                            if (nfhdp.isHostDenied(s_user_added_host_share, ia_denied_hosts)) {
                                al_denied_hosts.add(s_host_name);
                            }
                            returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                            continue;
                        }
                        returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                        continue;
                    }
                    returnbufstr.append("sunPortalNetFileHostTypePassShare=").append(s_user_added_host_share).append(this.c_eol);
                    al_denied_hosts.add(s_host_name);
                }
            }
            catch (Exception e) {
                this.debug.error("Exception extracting common data or host data or in merging them", (Throwable)e);
            }
        }
        if (ia_denied_hosts != null) {
            int i = 0;
            while (i < al_denied_hosts.size()) {
                returnbufstr.append("iplanet-srap-netfile-denied-host=").append((String)al_denied_hosts.get(i)).append(this.c_eol);
                ++i;
            }
        }
        return returnbufstr;
    }

    void removeValue(HashMap ht_contaier, HashMap ht_contained) {
        Set s_keys = ht_contaier.keySet();
        Iterator i_contaier = s_keys.iterator();
        while (i_contaier.hasNext()) {
            Object o_key = i_contaier.next();
            Object o_value = ht_contaier.get(o_key);
            if (o_value == null || !(o_value instanceof HashMap) || (HashMap)o_value != ht_contained) continue;
            ht_contaier.remove(o_key);
        }
    }

    Object[] addUnmergedHosts(NetFileHostDenialProcessor nfhdp, HashMap ht_hosts_added_by_admin, ArrayList al_denied_hosts, InetAddress[] ia_denied_hosts) {
        Collection c_keys = ht_hosts_added_by_admin.values();
        Iterator i_keys = c_keys.iterator();
        StringBuffer sb_host_data = new StringBuffer();
        while (i_keys.hasNext()) {
            try {
                HashMap ht_admin_added_host = (HashMap)i_keys.next();
                sb_host_data.append("sunPortalNetFileHostTypePassShare=");
                String s_host_name = (String)ht_admin_added_host.get("machine_name");
                String szFQHostName = nfhdp.getFQHostName(s_host_name.trim(), this.defaultDomain);
                InetAddress[] hostIAddresses = null;
                try {
                    hostIAddresses = this.getInetAddresses(szFQHostName);
                }
                catch (UnknownHostException uhe) {
                    this.debug.error("Exception in determining the host address", (Throwable)uhe);
                    continue;
                }
                if (this.isLocalHost(hostIAddresses)) continue;
                if (nfhdp.isHostAllowed(this.allowedHosts, this.deniedHosts, szFQHostName, hostIAddresses, true)) {
                    if (nfhdp.isHostDenied(szFQHostName, ia_denied_hosts)) {
                        al_denied_hosts.add(s_host_name);
                    }
                } else {
                    al_denied_hosts.add(s_host_name);
                }
                StringBuffer sb_host_name = new StringBuffer();
                sb_host_name.append("machine_name=").append(s_host_name).append(this.c_eol);
                sb_host_data = this.mergeAttribute("machine_name", "machine_name=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_type", "machine_type=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_encoding", "machine_encoding=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_domain", "machine_domain=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_password", "machine_password=", ht_admin_added_host, sb_host_data);
                sb_host_data = this.mergeAttribute("machine_user_name", "machine_user_name=", ht_admin_added_host, sb_host_data);
                Vector v_common_shares = (Vector)ht_admin_added_host.get("shares");
                Vector v_share_passwords = (Vector)ht_admin_added_host.get("share_passwords");
                int i_num_shares = v_common_shares.size();
                int i = 0;
                while (i < i_num_shares) {
                    sb_host_data.append("share_name=").append((String)v_common_shares.elementAt(i)).append(this.c_eol).append("share_password=").append((String)v_share_passwords.elementAt(i)).append(this.c_eol);
                    ++i;
                }
                sb_host_data.append(this.c_eol).append(this.c_eol);
            }
            catch (Exception e) {
                this.debug.error("Exception in common hosts unmerged with the hosts added by the user", (Throwable)e);
            }
        }
        return new Object[]{sb_host_data.toString(), al_denied_hosts};
    }

    StringBuffer mergeAttribute(String s_attribute_name, String attribute_tag, HashMap ht_host_data, StringBuffer sb_host_data) {
        Object o_temp = ht_host_data.get(s_attribute_name);
        String s_temp = this.s_empty_string;
        if (o_temp != null) {
            s_temp = (String)o_temp;
        }
        sb_host_data.append(attribute_tag).append(s_temp).append(this.c_eol);
        return sb_host_data;
    }

    Vector removeEmptyCommonHostData(Vector v_raw_common_host_data) {
        Enumeration e_raw_common_host_data = v_raw_common_host_data.elements();
        Vector<String> v_refinedcommon_host_data = new Vector<String>();
        while (e_raw_common_host_data.hasMoreElements()) {
            String s_host_shares_set_by_admin;
            Object o_host_shares_set_by_admin = e_raw_common_host_data.nextElement();
            if (o_host_shares_set_by_admin == null || (s_host_shares_set_by_admin = (String)o_host_shares_set_by_admin).trim().length() <= 0) continue;
            v_refinedcommon_host_data.addElement(s_host_shares_set_by_admin);
        }
        return v_refinedcommon_host_data;
    }

    InetAddress[] getAllInetAddresses(String s_host_name) throws Exception {
        return InetAddress.getAllByName(s_host_name.trim());
    }

    HashMap parseCommonHostsData(String s_common_data, NetFileContext nfContext, NetFileResource nfr_user_locale_i18n_bucket) {
        StringTokenizer st_lines = new StringTokenizer(s_common_data, "\n");
        Vector<String> v_common_hosts = new Vector<String>();
        StringBuffer sb_host_data = null;
        while (st_lines.hasMoreTokens()) {
            String s_current_data = st_lines.nextToken();
            if (s_current_data.startsWith("machine_name=")) {
                if (sb_host_data != null) {
                    v_common_hosts.addElement(sb_host_data.toString());
                }
                sb_host_data = new StringBuffer();
                sb_host_data.append(s_current_data).append(this.c_eol);
                continue;
            }
            sb_host_data.append(s_current_data).append(this.c_eol);
        }
        if (sb_host_data != null) {
            v_common_hosts.addElement(sb_host_data.toString());
        }
        int i_common_hosts = v_common_hosts.size();
        HashMap<String, HashMap> ht_common_hosts_data = new HashMap<String, HashMap>(i_common_hosts * 2);
        int i = 0;
        while (i < i_common_hosts) {
            try {
                String s_common_host_data = (String)v_common_hosts.elementAt(i);
                HashMap ht_s_common_host_data = this.parseHost(s_common_host_data, "\n");
                if (ht_s_common_host_data != null) {
                    Object o_host_name = ht_s_common_host_data.get("machine_name");
                    if (o_host_name != null) {
                        String s_host_name = (String)o_host_name;
                        ht_common_hosts_data.put(s_host_name, ht_s_common_host_data);
                    }
                    ht_s_common_host_data = this.verifyHostData(ht_s_common_host_data, nfContext, nfr_user_locale_i18n_bucket);
                }
            }
            catch (NetFileException e) {
                this.debug.message("Unable to parse common host data" + e.getMessage(nfr_user_locale_i18n_bucket));
            }
            catch (Throwable e) {
                this.debug.message("Unable to parse common host data", e);
            }
            ++i;
        }
        return ht_common_hosts_data;
    }

    HashMap verifyHostData(HashMap ht_s_common_host_data, NetFileContext nfContext, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        if (ht_s_common_host_data.get("machine_name") == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_type");
        }
        ht_s_common_host_data = this.verifyCharacterEncoding(ht_s_common_host_data, nfContext, nfr_user_locale_i18n_bucket);
        if ((ht_s_common_host_data = this.verifyMachineType(ht_s_common_host_data)).get("machine_domain") == null) {
            ht_s_common_host_data.put("machine_domain", this.s_empty_string);
        }
        if (ht_s_common_host_data.get("machine_password") == null) {
            ht_s_common_host_data.put("machine_password", this.s_empty_string);
        }
        if (ht_s_common_host_data.get("machine_user_name") == null) {
            ht_s_common_host_data.put("machine_user_name", this.s_empty_string);
        }
        return ht_s_common_host_data;
    }

    HashMap verifyMachineType(HashMap ht_s_common_host_data) throws NetFileException {
        Object o_type = ht_s_common_host_data.get("machine_type");
        if (o_type == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_type");
        }
        String s_type = (String)o_type;
        if (!(s_type.equals("FTP") || s_type.equals("NETWARE") || s_type.equals("NFS") || s_type.equals("NT") || s_type.equals("WIN"))) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_type");
        }
        return ht_s_common_host_data;
    }

    HashMap verifyCharacterEncoding(HashMap ht_host, NetFileContext nfContext, NetFileResource nfr_user_locale_i18n_bucket) {
        String s_encoding_display_name;
        Object o_encoding = ht_host.remove("machine_encoding");
        String s_encoding = this.s_empty_string;
        if (o_encoding != null) {
            s_encoding = (String)o_encoding;
            s_encoding = s_encoding.trim();
        }
        if ((s_encoding_display_name = nfr_user_locale_i18n_bucket.getString("encoding_" + s_encoding)) == null || s_encoding_display_name.trim().equals(this.s_empty_string) || s_encoding_display_name.trim().equals("encoding_" + s_encoding)) {
            String s_os_char_set = nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileOSCharSet", this.S_DEFAULT_ENCODING);
            if (s_os_char_set.equals(this.s_empty_string)) {
                s_os_char_set = this.S_DEFAULT_ENCODING;
            } else {
                String s_os_char_set_display_name = nfr_user_locale_i18n_bucket.getString("encoding_" + s_os_char_set);
                if (s_os_char_set_display_name == null || s_os_char_set_display_name.trim().equals(this.s_empty_string) || s_os_char_set_display_name.trim().equals("encoding_" + s_os_char_set)) {
                    s_os_char_set = this.S_DEFAULT_ENCODING;
                }
            }
            s_encoding = s_os_char_set;
            s_encoding_display_name = nfr_user_locale_i18n_bucket.getString("encoding_" + s_encoding);
        }
        this.debug.message("machine encoding2=" + s_encoding_display_name);
        ht_host.put("machine_encoding", s_encoding_display_name);
        return ht_host;
    }

    String mergeHost(String s_user_added_host_share, HashMap ht_matching_common_host) throws NetFileException {
        HashMap ht_user_added_host = this.parseHost(s_user_added_host_share, "\n");
        StringBuffer sb_host_data = new StringBuffer();
        sb_host_data.append("machine_name=").append(ht_user_added_host.get("machine_name")).append(this.c_eol);
        boolean b_are_types_different = this.areTypeDifferent(ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_type", "machine_type", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_encoding", "machine_encoding", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_domain", "machine_domain", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_password", "machine_password", ht_matching_common_host, ht_user_added_host);
        sb_host_data = this.mergeAttribute(sb_host_data, "machine_user_name", "machine_user_name", ht_matching_common_host, ht_user_added_host);
        Vector v_shares = (Vector)ht_user_added_host.get("shares");
        Vector v_passwords = (Vector)ht_user_added_host.get("share_passwords");
        Vector v_common_shares = (Vector)ht_matching_common_host.get("shares");
        Vector v_common_share_passwords = (Vector)ht_matching_common_host.get("share_passwords");
        this.debug.message("b_are_types_different=" + b_are_types_different);
        if (!b_are_types_different) {
            Vector[] v_share_data = this.mergeShares(v_shares, v_passwords, v_common_shares, v_common_share_passwords);
            v_shares = v_share_data[0];
            v_passwords = v_share_data[1];
        }
        int i_num_shares = v_shares.size();
        int i = 0;
        while (i < i_num_shares) {
            sb_host_data.append("share_name=").append((String)v_shares.elementAt(i)).append(this.c_eol).append("share_password=").append((String)v_passwords.elementAt(i)).append(this.c_eol);
            ++i;
        }
        sb_host_data.append(this.c_eol);
        return sb_host_data.toString();
    }

    boolean areTypeDifferent(HashMap ht_matching_common_host, HashMap ht_user_added_host) {
        Object o_common_type = ht_matching_common_host.get("machine_type");
        if (o_common_type == null) {
            return false;
        }
        return !((String)ht_user_added_host.get("machine_type")).equals((String)o_common_type);
    }

    Vector[] mergeShares(Vector v_shares, Vector v_passwords, Vector v_common_shares, Vector v_common_share_passwords) {
        Enumeration e_shares = v_shares.elements();
        while (e_shares.hasMoreElements()) {
            String s_share = (String)e_shares.nextElement();
            if (!v_common_shares.contains(s_share)) continue;
            v_common_shares.remove(s_share);
        }
        Enumeration e_common_shares = v_common_shares.elements();
        Enumeration e_common_share_passwords = v_common_share_passwords.elements();
        while (e_common_shares.hasMoreElements()) {
            v_shares.addElement(e_common_shares.nextElement());
            if (e_common_share_passwords.hasMoreElements()) {
                v_passwords.addElement((String)e_common_share_passwords.nextElement());
                continue;
            }
            v_passwords.addElement(this.s_empty_string);
        }
        return new Vector[]{v_shares, v_passwords};
    }

    StringBuffer mergeAttribute(StringBuffer sb_host_data, String attribute_name1, String attribute_name2, HashMap ht_matching_common_host, HashMap ht_user_added_host) {
        sb_host_data.append(attribute_name1).append("=");
        Object o_temp = ht_user_added_host.get(attribute_name1);
        if (o_temp == null) {
            o_temp = ht_matching_common_host.get(attribute_name2);
        }
        if (o_temp != null) {
            sb_host_data.append((String)o_temp);
        }
        sb_host_data.append(this.c_eol);
        return sb_host_data;
    }

    HashMap parseHost(String s_user_added_host_share, String separator) throws NetFileException {
        StringTokenizer st_tokens = new StringTokenizer(s_user_added_host_share, separator);
        HashMap<String, Object> ht_host = new HashMap<String, Object>(st_tokens.countTokens() * 2);
        try {
            Vector<String> v_shares = new Vector<String>();
            Vector<String> v_share_passwords = new Vector<String>();
            ht_host.put("shares", v_shares);
            ht_host.put("share_passwords", v_share_passwords);
            while (st_tokens.hasMoreTokens()) {
                String token = st_tokens.nextToken();
                if (token.startsWith("machine_name=")) {
                    String s_name = this.removePrefix("machine_name=", token);
                    ht_host.put("machine_name", s_name);
                    InetAddress[] ia_common_host = this.getAllInetAddresses(s_name);
                    ht_host.put("all_inet_addresses", ia_common_host);
                    continue;
                }
                if (token.startsWith("machine_type=")) {
                    ht_host.put("machine_type", this.removePrefix("machine_type=", token));
                    continue;
                }
                if (token.startsWith("machine_encoding=")) {
                    ht_host.put("machine_encoding", this.removePrefix("machine_encoding=", token));
                    continue;
                }
                if (token.startsWith("machine_encoding=")) {
                    ht_host.put("machine_encoding", this.removePrefix("machine_encoding=", token));
                    continue;
                }
                if (token.startsWith("machine_domain=")) {
                    ht_host.put("machine_domain", this.removePrefix("machine_domain=", token));
                    continue;
                }
                if (token.startsWith("machine_password=")) {
                    ht_host.put("machine_password", this.removePrefix("machine_password=", token));
                    continue;
                }
                if (token.startsWith("machine_user_name=")) {
                    ht_host.put("machine_user_name", this.removePrefix("machine_user_name=", token));
                    continue;
                }
                if (!token.startsWith("share_name=")) continue;
                v_shares.addElement(this.removePrefix("share_name=", token));
                String s_password = st_tokens.nextToken();
                v_share_passwords.addElement(this.removePrefix("share_password=", s_password));
            }
        }
        catch (Exception e) {
            this.debug.error("Unable to parse host data", (Throwable)e);
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_data_format", s_user_added_host_share});
        }
        return ht_host;
    }

    String removePrefix(String prefix, String string) throws NetFileException {
        if (!string.startsWith(prefix)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "illegal_machine_data_format");
        }
        return string.substring(prefix.length(), string.length());
    }

    HashMap getMatchingHost(String s_host_added_by_user, HashMap ht_host_shares_set_by_admin) {
        try {
            InetAddress ia_host_added_by_user = InetAddress.getByName(s_host_added_by_user);
            Collection c_keys = ht_host_shares_set_by_admin.values();
            Iterator i_keys = c_keys.iterator();
            while (i_keys.hasNext()) {
                HashMap ht_host = (HashMap)i_keys.next();
                Object o_inet_addresses = ht_host.get("all_inet_addresses");
                if (o_inet_addresses == null) {
                    return null;
                }
                InetAddress[] ia_host = (InetAddress[])o_inet_addresses;
                if (!ia_host[0].equals(ia_host_added_by_user)) continue;
                this.debug.message("Got matching host");
                return ht_host;
            }
        }
        catch (Exception e) {
            this.debug.message("Exception while finding host matching a given host among common hosts by IP", (Throwable)e);
            return null;
        }
        return null;
    }

    private String getMachineName(String s_user_added_host_share) throws Exception {
        String s_machine_name = null;
        if (s_user_added_host_share == null) {
            throw new NullPointerException("null host information");
        }
        int i_index_of_name = s_user_added_host_share.indexOf("machine_name=");
        if (i_index_of_name < -1) {
            throw new Exception("Invalid host data - does not contain machine name");
        }
        i_index_of_name = "machine_name=".length();
        int i_index_of_eol = s_user_added_host_share.indexOf(this.c_eol, i_index_of_name);
        if (i_index_of_eol <= i_index_of_name) {
            throw new Exception("Invalid host data - machine name does not end in \\n");
        }
        s_machine_name = s_user_added_host_share.substring(i_index_of_name, i_index_of_eol);
        return s_machine_name;
    }

    List getAllowedHostsList(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getStringList("sunPortalNetFileAllowedHostList");
    }

    List getDeniedHostsList(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getStringList("sunPortalNetFileDeniedHostList");
    }

    String getCommonHosts(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getString("sunPortalNetFileCommonHostData", "");
    }

    List getUserAddedHostsList(NetFileAttributeExtractor nfAttrs) {
        return nfAttrs.getStringList("sunPortalNetFileHostTypePassShare");
    }

    String getDecryptedHostInfo(String szEncryptedHostInfo) {
        return AMPasswordUtil.decrypt((String)szEncryptedHostInfo);
    }

    InetAddress[] getInetAddresses(String szHost) throws UnknownHostException {
        return InetAddress.getAllByName(szHost);
    }

    void setDefaultDomain(String szDefaultDomain) {
        this.defaultDomain = szDefaultDomain;
    }

    void loadHostDataSets(NetFileAttributeExtractor nfAttrs) {
        this.deniedHosts = this.getDeniedHostsList(nfAttrs);
        if (this.debug.messageEnabled()) {
            this.debug.message("Denied hosts are " + this.deniedHosts);
        }
        this.allowedHosts = this.getAllowedHostsList(nfAttrs);
        if (this.debug.messageEnabled()) {
            this.debug.message("Allowed hosts are " + this.allowedHosts);
        }
        this.commondata = this.getCommonHosts(nfAttrs);
        this.listOfHosts = this.getUserAddedHostsList(nfAttrs);
    }

    boolean isLocalHost(InetAddress[] hostIAddresses) {
        if (this.localHostAddrs == null || this.localHostAddrs.length < 1) {
            return true;
        }
        int i = 0;
        while (i < hostIAddresses.length) {
            int k = 0;
            while (k < this.localHostAddrs.length) {
                if (this.localHostAddrs[k].trim().equals(hostIAddresses[i].getHostAddress().trim())) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message(hostIAddresses[i].getHostName() + " is a local host");
                    }
                    return true;
                }
                ++k;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    String[] getRPaddrs() {
        String configparam = "";
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = new String[]{"/sbin/ifconfig", "-a"};
            Process shellconn = rt.exec(progarr);
            InputStream shellout = shellconn.getInputStream();
            while ((c = shellout.read()) > -1) {
                void var3_12;
                char chtxt = (char)var3_12;
                buftxt.append(chtxt);
            }
            rt = null;
            shellout.close();
            shellout = null;
            shellconn.destroy();
            shellconn = null;
            configparam = buftxt.toString();
        }
        catch (IOException ex) {
            this.debug.error("FileOption IOException in getrpaddrs: ", (Throwable)ex);
            String[] rphostip = new String[]{"Failed Execution: " + ex, "\u0000"};
            Object rt = null;
            return rphostip;
        }
        if (configparam.equals("")) {
            this.debug.message("Cannot get local machine hostname.");
            String[] rphostip = new String[]{"Cannot get local machine hostname.", "\u0000"};
            return rphostip;
        }
        StringTokenizer pars = new StringTokenizer(configparam, "\n");
        int parscnt = pars.countTokens();
        String[] hostip = new String[parscnt];
        int inetindx = 0;
        int inetmaskindx = 0;
        int rpj = 0;
        String[] rphostip = new String[parscnt];
        int j = 0;
        while (j < parscnt) {
            hostip[j] = pars.nextToken();
            inetindx = hostip[j].indexOf("inet", 0);
            inetmaskindx = hostip[j].indexOf("netmask", 0);
            if (inetindx >= 0 && inetmaskindx >= 0) {
                rphostip[rpj] = hostip[j].substring(inetindx + 5, inetmaskindx);
                ++rpj;
            }
            ++j;
        }
        int ips = rpj;
        while (ips < rphostip.length) {
            rphostip[ips] = "\u0000";
            ++ips;
        }
        return rphostip;
    }
}

