/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.FileOption;
import com.sun.portal.netfile.FullFtpClient;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;

class FtpFile {
    private static final String sccsID = "@(#)FtpFile.java\t1.34 00/03/14 Sun Microsystems, Inc.";
    protected NetFileLogManager logMgr = null;
    protected static Debug debug = null;
    protected String s_machine_encoding;
    protected FullFtpClient ffc = null;
    protected int i_number_of_directories_traversed;

    FtpFile(NetFileLogManager log_Mgr, String s_machine_encoding) {
        this.logMgr = log_Mgr;
        this.i_number_of_directories_traversed = 0;
        this.s_machine_encoding = s_machine_encoding;
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    String[] ftpDir(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String[] sa_results = this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir, nfr_user_locale_i18n_bucket);
        if (sa_results.length == 0) {
            return new String[]{"        "};
        }
        return sa_results;
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            ++this.i_number_of_directories_traversed;
            debug.message(this + ":Directory number being searched=" + this.i_number_of_directories_traversed);
            if (this.i_number_of_directories_traversed > maxsrchdir) {
                return new String[0];
            }
            String[] sa_file_listing = this.getFTPDir(usernam, passwrd, machnam, VMSnam, dir_nam, nfr_user_locale_i18n_bucket);
            if (sa_file_listing[0] == null) {
                return new String[0];
            }
            if (sa_file_listing[0].startsWith("ERROR:")) {
                debug.message("Error in searching is :" + sa_file_listing[0]);
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + dir_nam + "/"});
            }
            Vector<String> v_search_results = new Vector<String>();
            int i = 0;
            while (i < sa_file_listing.length && this.i_number_of_directories_traversed <= maxsrchdir) {
                if (sa_file_listing[i] == null) break;
                if (sa_file_listing[i].equalsIgnoreCase("d")) {
                    String s_error = "";
                    String s_directory = dir_nam + "/" + sa_file_listing[i + 1];
                    try {
                        String[] sa_search_results = this.search(usernam, passwrd, machnam, VMSnam, pattern, s_directory, maxsrchdir, nfr_user_locale_i18n_bucket);
                        int j = 0;
                        while (j < sa_search_results.length) {
                            v_search_results.addElement(sa_search_results[j]);
                            ++j;
                        }
                    }
                    catch (NetFileException e) {
                        s_error = "(" + e.getMessage(nfr_user_locale_i18n_bucket) + ")";
                    }
                    catch (Exception e) {
                        debug.error("Exception in searching directory " + s_directory + " in " + VMSnam, (Throwable)e);
                        s_error = "(" + nfr_user_locale_i18n_bucket.getString("error13") + ")";
                    }
                    if (sa_file_listing[i + 1].indexOf(pattern) > -1) {
                        v_search_results.addElement("/" + VMSnam + s_directory + "/" + s_error);
                    }
                } else if (sa_file_listing[i + 1].indexOf(pattern) > -1) {
                    v_search_results.addElement("/" + VMSnam + dir_nam + "/" + sa_file_listing[i + 1]);
                }
                i += 4;
            }
            if (v_search_results.size() == 0) {
                return new String[0];
            }
            String[] sa_new_results = new String[v_search_results.size()];
            int i2 = 0;
            while (i2 < sa_new_results.length) {
                sa_new_results[i2] = (String)v_search_results.elementAt(i2);
                ++i2;
            }
            return sa_new_results;
        }
        catch (NetFileException e) {
            throw e;
        }
        catch (Exception e) {
            debug.error("Exception in searching " + VMSnam + dir_nam + "/", (Throwable)e);
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "error13", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", VMSnam + dir_nam + "/"});
        }
    }

    InputStream getInputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam) throws NetFileException {
        Exception e = null;
        TelnetInputStream ftpin = null;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpin = this.ffc.get(mainfilenam);
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Exceptione obtaining the FTP file", this.ffc);
        return ftpin;
    }

    OutputStream getOutputFTPStream(String usernam, String passwrd, String machnam, String VMSnam, String remotefil_arg, String dir_nam) throws NetFileException {
        Exception e = null;
        TelnetOutputStream ftpout = null;
        try {
            this.ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpout = this.ffc.put(remotefil_arg);
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Could upload file", this.ffc);
        return ftpout;
    }

    void closeFtpFile() {
        try {
            if (this.ffc != null) {
                this.ffc.quit();
            }
            this.ffc = null;
        }
        catch (IOException ioe) {
            this.ffc = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getFTPFile(String usernam, String passwrd, String machnam, String VMSnam, String mainfilenam, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        String mknodfilename = "";
        String txtouting = "";
        Exception e = null;
        FullFtpClient ffc = null;
        try {
            int c;
            TelnetInputStream ftpout = null;
            BufferedOutputStream bos = null;
            StringBuffer buftxt = new StringBuffer(4096);
            String newftpdir = "";
            String tempdir = tmpdir;
            int userPart = usersession.indexOf("=@");
            Long random = new Long(System.currentTimeMillis());
            mknodfilename = tempdir + "/" + random.toString() + usernam.toUpperCase() + mainfilenam;
            File newfil = new File(mknodfilename);
            if (newfil.exists()) {
                newfil.delete();
            }
            bos = new BufferedOutputStream(new FileOutputStream(newfil));
            ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            ftpout = ffc.get(mainfilenam);
            while ((c = ((InputStream)ftpout).read()) > -1) {
                void var14_22;
                bos.write((int)var14_22);
                buftxt.append((char)var14_22);
            }
            ((InputStream)ftpout).close();
            bos.flush();
            bos.close();
            txtouting = buftxt.toString();
            if (txtouting.startsWith("ERROR:") || txtouting.indexOf(nfr_user_locale_i18n_bucket.getString("permissiondenied")) >= 0 || txtouting.indexOf(nfr_user_locale_i18n_bucket.getString("nosuchfile")) >= 0) {
                FileOption fil4 = new FileOption(this.logMgr, this.s_machine_encoding);
                fil4.doError(nfr_user_locale_i18n_bucket.getString("error6"));
                return "ERROR:" + nfr_user_locale_i18n_bucket.getString("error6");
            }
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Exceptione obtaining the FTP file", ffc);
        return mknodfilename;
    }

    String putFTPFile(String usernam, String passwrd, String machnam, String VMSnam, String localfil_arg, String remotefil_arg, String dir_nam, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        Exception e = null;
        FullFtpClient ffc = null;
        try {
            ffc = this.initialiseFtpClient(usernam, passwrd, machnam, VMSnam, dir_nam);
            TelnetOutputStream theFile = ffc.put(remotefil_arg);
            FileInputStream fin = new FileInputStream(localfil_arg);
            int fileSize = fin.available();
            int blockSize = 0x100000;
            byte[] data = null;
            data = fileSize > blockSize ? new byte[blockSize] : new byte[fileSize];
            int bytesRead = 0;
            do {
                bytesRead = fin.read(data);
                theFile.write(data, 0, bytesRead);
            } while (bytesRead == blockSize);
            theFile.flush();
            data = null;
            fin.close();
            theFile.close();
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Could not upload file", ffc);
        return nfr_user_locale_i18n_bucket.getString("info6");
    }

    String delFTPFile(String username, String password, String machine, String share, String file_to_delete, String directory, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        FullFtpClient ffc = null;
        Exception e = null;
        try {
            ffc = this.initialiseFtpClient(username, password, machine, share, directory);
            ffc.delete(file_to_delete);
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Could not delete file", ffc);
        return nfr_user_locale_i18n_bucket.getString("info5");
    }

    String reEncodeString(String string) throws Exception {
        return new String(string.getBytes(), this.s_machine_encoding);
    }

    String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        FullFtpClient full_ftp_client = null;
        Exception e = null;
        NetFileException nfe = null;
        String[] file_listing = new String[]{};
        try {
            full_ftp_client = this.initialiseFtpClient(username, password, machname, VMSname, dirS);
            Vector names_list = this.getNamesList(full_ftp_client);
            Vector full_listing = this.getList(full_ftp_client, false);
            String[][] listing = this.processListings(names_list, full_listing);
            int number_of_files = names_list.size();
            file_listing = new String[number_of_files * 4];
            int j = 0;
            int i = 0;
            while (i < number_of_files) {
                if (!listing[i][1].equals("..") && !listing[i][1].startsWith(".")) {
                    file_listing[j++] = listing[i][0];
                    file_listing[j++] = listing[i][1];
                    StringBuffer sb = new StringBuffer();
                    boolean multibyte = false;
                    int l = 0;
                    while (l < listing[i][1].length()) {
                        int k = Character.getNumericValue(listing[i][1].charAt(l));
                        sb.append(k).append(",");
                        if (k > 255) {
                            multibyte = true;
                        }
                        ++l;
                    }
                    file_listing[j++] = listing[i][3];
                    file_listing[j++] = listing[i][2];
                }
                ++i;
            }
        }
        catch (NetFileException ex) {
            nfe = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessingForGetFTPDir(nfe, e, "Could not obtain FTP listing", full_ftp_client);
        return file_listing;
    }

    private Vector getNamesList(FullFtpClient full_ftp_client) throws Exception {
        return this.getList(full_ftp_client, true);
    }

    private Vector getList(FullFtpClient full_ftp_client, boolean names_only) throws Exception {
        if (full_ftp_client == null) {
            throw new IllegalArgumentException("null full ftp client");
        }
        TelnetInputStream list = null;
        Vector<String> v_list = new Vector<String>();
        list = names_only ? full_ftp_client.nlist() : full_ftp_client.list(true);
        InputStreamReader ipsr_list = new InputStreamReader((InputStream)list, this.s_machine_encoding);
        BufferedReader br_list = new BufferedReader(ipsr_list);
        String s_input_line = null;
        while ((s_input_line = br_list.readLine()) != null) {
            v_list.add(s_input_line);
        }
        br_list.close();
        ipsr_list.close();
        list.close();
        s_input_line = null;
        br_list = null;
        ipsr_list = null;
        list = null;
        return v_list;
    }

    private String[][] processListings(Vector v_file_names, Vector v_full_listing) throws Exception {
        int listing_size = v_full_listing.size();
        if (listing_size <= 0) {
            return new String[0][];
        }
        String last_entry = (String)v_full_listing.elementAt(listing_size - 1);
        boolean is_windows = !last_entry.startsWith("-") && !last_entry.startsWith("d") && !last_entry.startsWith("l") && !last_entry.startsWith("d") && !last_entry.startsWith("b") && !last_entry.startsWith("c") && !last_entry.startsWith("p") && !last_entry.startsWith("s") && !last_entry.startsWith("D");
        String[][] listing = null;
        listing = is_windows ? this.processMSDirectoryListingType(v_file_names, v_full_listing) : this.processUnixDirectoryListingType(v_file_names, v_full_listing);
        return listing;
    }

    private String[][] processUnixDirectoryListingType(Vector v_file_names, Vector v_full_listing) throws Exception {
        int number_of_files = v_file_names.size();
        int full_listing_length = v_full_listing.size();
        String[][] listing = new String[number_of_files][4];
        String file_name = null;
        String full_listing_row = null;
        int i = number_of_files - 1;
        int j = full_listing_length - 1;
        while (i >= 0) {
            listing[i][1] = file_name = (String)v_file_names.elementAt(i);
            full_listing_row = (String)v_full_listing.elementAt(j);
            debug.message(full_listing_row);
            listing[i][0] = full_listing_row.charAt(0) == 'd' ? "d" : full_listing_row.charAt(0) + "";
            int k = -1;
            if (listing[i][0].equals("l")) {
                k = full_listing_row.indexOf(file_name + " ->") - 1;
                listing[i][1] = file_name = full_listing_row.substring(k, full_listing_row.length());
            } else {
                k = full_listing_row.lastIndexOf(file_name) - 1;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            int end_of_date = k + 1;
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            listing[i][2] = full_listing_row.substring(k + 1, end_of_date);
            while (k >= 0) {
                if (full_listing_row.charAt(k) != ' ') break;
                --k;
            }
            int end_of_length = k + 1;
            while (k >= 0) {
                if (full_listing_row.charAt(k) == ' ') break;
                --k;
            }
            listing[i][3] = full_listing_row.substring(k + 1, end_of_length);
            --i;
            --j;
        }
        return listing;
    }

    private String[][] processMSDirectoryListingType(Vector v_file_names, Vector v_full_listing) throws Exception {
        int number_of_files = v_file_names.size();
        String[][] listing = new String[number_of_files][4];
        String file_name = null;
        String full_listing_row = null;
        int i = number_of_files - 1;
        while (i >= 0) {
            listing[i][1] = file_name = (String)v_file_names.elementAt(i);
            full_listing_row = (String)v_full_listing.elementAt(i);
            if (full_listing_row.indexOf("<DIR>") > 0) {
                listing[i][3] = "0";
                listing[i][0] = "d";
            } else {
                listing[i][0] = "-";
            }
            int j = 0;
            while (j < full_listing_row.length()) {
                if (full_listing_row.charAt(j) == ' ') break;
                ++j;
            }
            while (j < full_listing_row.length()) {
                if (full_listing_row.charAt(j) != ' ') break;
                ++j;
            }
            while (j < full_listing_row.length()) {
                if (full_listing_row.charAt(j) == ' ') break;
                ++j;
            }
            listing[i][2] = full_listing_row.substring(0, j);
            if (listing[i][3] == null) {
                int start_of_length = -1;
                while (j < full_listing_row.length()) {
                    if (full_listing_row.charAt(j) != ' ') break;
                    ++j;
                }
                start_of_length = j;
                while (j < full_listing_row.length()) {
                    if (full_listing_row.charAt(j) == ' ') break;
                    ++j;
                }
                listing[i][3] = full_listing_row.substring(start_of_length, j);
            }
            --i;
        }
        return listing;
    }

    private String extractPermissionsForFile(String listing_line, String file) throws Exception, NetFileException {
        debug.message("Listing line=" + listing_line);
        String suffix = " " + file;
        char ch_file_type = '-';
        if (listing_line.endsWith(suffix)) {
            int i_index_of_blank;
            ch_file_type = listing_line.charAt(0);
            if (ch_file_type == 'd' || ch_file_type == 'D') {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error34");
            }
            if (!Character.isDigit(ch_file_type) && (i_index_of_blank = listing_line.indexOf(" ", 0)) > 0) {
                return listing_line.substring(0, i_index_of_blank);
            }
        }
        return null;
    }

    private boolean isPermissionOk(String s_permission_string, String permission, String user_type) {
        debug.message("Permission line=" + s_permission_string);
        char ch_permission = 'r';
        int i_check_position = 0;
        int i_offset = 1;
        if (permission.equals("write")) {
            i_check_position = 1;
            ch_permission = 'w';
        } else if (permission.equals("execute")) {
            i_check_position = 2;
            ch_permission = 'x';
        }
        if (user_type.equals("group")) {
            i_offset = 4;
        } else if (user_type.equals("others")) {
            i_offset = 7;
        }
        return s_permission_string.charAt(i_offset + i_check_position) == ch_permission;
    }

    void rename(String username, String password, String machine, String share, String directory, String old_file_name, String new_file_name) throws NetFileException {
        FullFtpClient ffc = null;
        Exception e = null;
        try {
            ffc = this.initialiseFtpClient(username, password, machine, share, directory);
            ffc.rename(old_file_name, new_file_name);
        }
        catch (Exception ex) {
            e = ex;
        }
        this.performFinalProcessing(e, "Could not rename file", ffc);
    }

    private void performFinalProcessing(Exception ex, String message_to_debug, FullFtpClient ffc) throws NetFileException {
        if (ex != null) {
            debug.error(message_to_debug, (Throwable)ex);
            if (ex instanceof FileNotFoundException) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "no_file_or_permission");
            }
            try {
                if (ffc != null) {
                    ffc.quit();
                    ffc.closeServer();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "noop_no_reason");
        }
    }

    private void performFinalProcessingForGetFTPDir(NetFileException nfe, Exception ex, String message_to_debug, FullFtpClient ffc) throws NetFileException {
        if (nfe != null) {
            throw nfe;
        }
        if (ex != null) {
            debug.error(message_to_debug, (Throwable)ex);
            if (ex instanceof FileNotFoundException) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "no_file_or_permission");
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "noop_no_reason");
        }
        try {
            if (ffc != null) {
                ffc.quit();
                ffc.closeServer();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private FullFtpClient initialiseFtpClient(String username, String password, String machine, String share, String directory) throws NetFileException {
        FullFtpClient ffc = null;
        try {
            ffc = new FullFtpClient(machine, this.s_machine_encoding);
            ffc.setMachineToAccess(machine);
        }
        catch (Exception ioe) {
            debug.error("Failed to Bind on Port 21 to host: " + machine, (Throwable)ioe);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error19");
        }
        try {
            ffc.login(username, password);
        }
        catch (Exception e) {
            debug.error("Login Error to " + machine, (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error12");
        }
        try {
            ffc.cd(share + directory);
        }
        catch (Exception ioe) {
            debug.error("Cannot change to directory " + share + directory, (Throwable)ioe);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error20");
        }
        try {
            ffc.binary();
        }
        catch (Exception ioe) {
            debug.error("Cannot change mode to binary", (Throwable)ioe);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error20");
        }
        return ffc;
    }
}

