/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.CheckPort;
import com.sun.portal.netfile.FtpFile;
import com.sun.portal.netfile.FullFtpClient;
import com.sun.portal.netfile.NetFileAttributeExtractor;
import com.sun.portal.netfile.NetFileCompression;
import com.sun.portal.netfile.NetFileContextImpl;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import com.sun.portal.netfile.NetWareFile;
import com.sun.portal.netfile.NfsFile;
import com.sun.portal.netfile.RandomNumber;
import com.sun.portal.netfile.SendFile;
import com.sun.portal.netfile.WinFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

class FileOption {
    public static final String DEBUG_FILE = "srapNetFile";
    private static final String WIN = "WIN";
    private static final String NT = "NT";
    private static final String NFS = "NFS";
    private static final String NETWARE = "NETWARE";
    private static final String FTP = "FTP";
    private static final String ERROR = "ERROR:";
    private static final String MESSAGE_1 = " Processing of file ";
    private static final String TEXT_SEPERATOR = "textseperator";
    public static final String SERVLET_PROPERTIES = "srapNetFileServletJava1";
    public static final String APPLET_PROPERTIES = "srapNetFileAppletJava1";
    private static final String END_OF_STRING = "\u0000";
    private String[] pathinfo;
    private String[] ntdom;
    private String[] domwin;
    private String s_empty_string;
    private String exerr;
    private String[] rettxt;
    private static NetFileResource nfr_platform_locale_i18n_bucket;
    private static Debug debug;
    private static String s_platform_locale_error;
    private NetFileLogManager logMgr;
    private String s_machine_encoding;
    private SSOToken ssoToken;
    private char c_eol;

    FileOption(NetFileLogManager log_Mgr, String s_machine_encoding) {
        this.exerr = this.s_empty_string = "";
        this.rettxt = new String[2];
        this.logMgr = null;
        this.ssoToken = null;
        this.c_eol = (char)10;
        this.logMgr = log_Mgr;
        this.s_machine_encoding = s_machine_encoding;
        this.pathinfo = new String[2];
        this.ntdom = new String[2];
        this.domwin = new String[2];
        if (debug == null) {
            debug = Debug.getInstance((String)DEBUG_FILE);
        }
        try {
            FileOption.setPlatformLocaleBundle();
        }
        catch (NetFileException e) {
            debug.error("Could not obtain platform specific locale bundle properly", (Throwable)e);
        }
    }

    FileOption(NetFileLogManager log_Mgr, String s_machine_encoding, SSOToken ssoToken) {
        this.exerr = this.s_empty_string = "";
        this.rettxt = new String[2];
        this.logMgr = null;
        this.ssoToken = null;
        this.c_eol = (char)10;
        this.logMgr = log_Mgr;
        this.s_machine_encoding = s_machine_encoding;
        this.pathinfo = new String[2];
        this.ntdom = new String[2];
        this.domwin = new String[2];
        this.setSSOToken(ssoToken);
        if (debug == null) {
            debug = Debug.getInstance((String)DEBUG_FILE);
        }
        try {
            FileOption.setPlatformLocaleBundle();
        }
        catch (NetFileException e) {
            debug.error("Could not obtain platform specific locale bundle properly", (Throwable)e);
        }
    }

    private static synchronized void setPlatformLocaleBundle() throws NetFileException {
        if (nfr_platform_locale_i18n_bucket == null && (s_platform_locale_error = (nfr_platform_locale_i18n_bucket = NetFileResource.getInstance(SERVLET_PROPERTIES)).getString("error")) == null) {
            throw new NetFileException("There is no entry for key error in srapNetFileServletJava1.properties");
        }
    }

    public void setSSOToken(SSOToken token) {
        this.ssoToken = token;
    }

    public SSOToken getSSOToken() {
        return this.ssoToken;
    }

    public String getPlatformLocalisedString(String string) {
        return nfr_platform_locale_i18n_bucket.getString(string);
    }

    public NetFileResource getPlatformLocalisedBundle() {
        if (nfr_platform_locale_i18n_bucket == null) {
            debug.error(" nfr_platform_locale_i18n_bucket not initialised yet in FileOption");
        }
        return nfr_platform_locale_i18n_bucket;
    }

    String[] expandVMS(String user_name, String password, String machine_name, String domain, String machine_type, String VMS, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket) throws Throwable {
        return this.expandDir(user_name, password, machine_name, domain, machine_type, this.s_empty_string, VMS, temporary_directory, nfr_user_locale_i18n_bucket);
    }

    String expandMachine(String username, String password, String machname, String domain, String machtype, NetFileResource nfr_user_locale_i18n_bucket, String usersession, NetFileAttributeExtractor nfAttrs) throws NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String domainname = domain;
        String txt = this.s_empty_string;
        if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
            try {
                String dir = "\\";
                List l_hosts_data = nfAttrs.getStringList("sunPortalNetFileHostTypePassShare");
                ArrayList<String> decryptedData = null;
                decryptedData = l_hosts_data != null ? new ArrayList(l_hosts_data.size()) : new ArrayList<String>(1);
                Iterator iter = l_hosts_data.iterator();
                while (iter.hasNext()) {
                    decryptedData.add(AMPasswordUtil.decrypt((String)((String)iter.next())));
                }
                WinFile gpc = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                txt = gpc.getShares(usernam, passwrd, machnam, domainname, nfr_user_locale_i18n_bucket, decryptedData);
            }
            catch (NetFileException e) {
                debug.error("There was a NetFile exception");
                throw e;
            }
            catch (Exception e) {
                debug.error("FileOption expandMachine unable to retrieve hostdata from profile for getShares()", (Throwable)e);
                txt = ERROR + e.getMessage();
            }
            return txt;
        }
        return "         ";
    }

    String[] expandDir(String user_name, String password, String machine_name, String domain, String machine_type, String directory, String VMS, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException, Exception {
        debug.message("Expanding directory");
        if (user_name == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_user_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, user_name});
        }
        if (user_name.equals(this.s_empty_string)) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_user_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, user_name});
        }
        if (password == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_password");
        }
        if (machine_name == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, machine_name});
        }
        if (machine_name.equals(this.s_empty_string)) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, machine_name});
        }
        boolean is_machine_type_invalid = false;
        if (machine_type == null) {
            is_machine_type_invalid = true;
        } else if (!(machine_type.equals(FTP) || machine_type.equals(NFS) || machine_type.equals(WIN) || machine_type.equals(NT) || machine_type.equals(NETWARE))) {
            is_machine_type_invalid = true;
        }
        if (is_machine_type_invalid) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_type", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, machine_type});
        }
        boolean is_vms_name_invalid = false;
        if (VMS == null) {
            is_vms_name_invalid = true;
        } else if (VMS.equals(this.s_empty_string)) {
            is_vms_name_invalid = true;
        }
        if (is_vms_name_invalid) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_vms_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, VMS});
        }
        if (directory == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_directory_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, directory});
        }
        if (temporary_directory == null) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_temporary_directory_name", NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, directory});
        }
        if (machine_type.equalsIgnoreCase(this.s_empty_string)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
        }
        if (machine_type.indexOf(NETWARE, 0) >= 0) {
            NetWareFile netwaredir = new NetWareFile(this.logMgr, this.s_machine_encoding);
            this.rettxt = netwaredir.getFTPDir(user_name, password, machine_name, VMS, directory, nfr_user_locale_i18n_bucket);
        } else if (machine_type.indexOf(WIN, 0) >= 0 || machine_type.indexOf(NT, 0) >= 0) {
            if (directory.equals(" ") || directory == null || directory.equals(this.s_empty_string)) {
                directory = "\\";
            }
            WinFile gpc = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
            this.rettxt = gpc.getPCDir(user_name, password, machine_name, VMS, directory, domain, nfr_user_locale_i18n_bucket);
        } else if (machine_type.indexOf(FTP, 0) >= 0) {
            FtpFile gff = new FtpFile(this.logMgr, this.s_machine_encoding);
            this.rettxt = gff.getFTPDir(user_name, password, machine_name, VMS, directory, nfr_user_locale_i18n_bucket);
        } else if (machine_type.indexOf(NFS, 0) >= 0) {
            NfsFile gnf = new NfsFile(this.logMgr, this.s_machine_encoding);
            this.rettxt = gnf.getNFSDir(user_name, password, VMS, machine_name, directory, temporary_directory, nfr_user_locale_i18n_bucket);
        } else {
            throw new Exception(nfr_platform_locale_i18n_bucket.getString("error3"));
        }
        debug.message("Expand over");
        return this.rettxt;
    }

    String openFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String VMSnam = VMSname;
        String main_filename = mainfilenam;
        String dir = dir_nam;
        String tempdir = tmpdir;
        String domainname = domain;
        String mainfilename = this.s_empty_string;
        String txt = this.s_empty_string;
        try {
            int indx = main_filename.indexOf("*", 0);
            mainfilename = indx >= 0 ? main_filename.substring(0, indx) : main_filename;
            if (machtyp.equalsIgnoreCase(this.s_empty_string)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
            }
            if (machtyp.indexOf(NETWARE, 0) >= 0) {
                NetWareFile nf = new NetWareFile(this.logMgr, this.s_machine_encoding);
                txt = nf.getFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, usersession);
            }
            if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
                if (dir.equals(" ") || dir == null || dir.equals(this.s_empty_string)) {
                    dir = "\\";
                }
                WinFile gpc = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                debug.message("Getting " + mainfilename);
                txt = gpc.getPCFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, tempdir, nfr_user_locale_i18n_bucket, usersession);
                debug.message("Got " + mainfilename);
            }
            if (machtyp.indexOf(FTP, 0) >= 0) {
                debug.message("FileOptin:openFile(" + mainfilename + ")");
                FtpFile gff = new FtpFile(this.logMgr, this.s_machine_encoding);
                txt = gff.getFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, usersession);
                debug.message("Outcome=" + txt);
            }
            if (machtyp.indexOf(NFS, 0) >= 0) {
                NfsFile gfs = new NfsFile(this.logMgr, this.s_machine_encoding);
                txt = gfs.getNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, usersession);
            }
            if (txt.indexOf("FileNotFound", 0) >= 0) {
                throw new NetFileException(new String[]{mainfilename, NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, NetFileException.KEY_IDENTIFIER_PREFIX + "error2"});
            }
            if (txt.toUpperCase().indexOf("ERROR", 0) >= 0) {
                throw new NetFileException(new String[]{mainfilename, NetFileException.KEY_IDENTIFIER_PREFIX + TEXT_SEPERATOR, NetFileException.KEY_IDENTIFIER_PREFIX + "error2"});
            }
        }
        catch (Exception e) {
            txt = ERROR + e.getMessage();
            debug.error("Problem getting file", (Throwable)e);
        }
        return txt;
    }

    /*
     * WARNING - void declaration
     */
    String getFileSuffix(String mainfilenam, String localfilenam, NetFileResource nfr_user_locale_i18n_bucket) {
        int indx;
        String suffix = this.s_empty_string;
        if (!localfilenam.equals(this.s_empty_string)) {
            try {
                int c;
                Runtime rt = Runtime.getRuntime();
                StringBuffer buftxt = new StringBuffer(80);
                String[] progarr = new String[]{"/usr/bin/file", localfilenam};
                Process shellconn = rt.exec(progarr);
                InputStream shellout = shellconn.getInputStream();
                while ((c = shellout.read()) > -1) {
                    void var6_12;
                    char chtxt = (char)var6_12;
                    buftxt.append(chtxt);
                }
                shellout.close();
                suffix = buftxt.toString();
            }
            catch (IOException ex) {
                debug.error("FileOption runtime exec failed exception in getfilesuffix: ", (Throwable)ex);
                return ERROR + nfr_user_locale_i18n_bucket.getString("error21");
            }
            if (suffix.indexOf("text", 0) >= 0) {
                return "txt";
            }
            if (suffix.indexOf("gif", 0) >= 0) {
                return "gif";
            }
        }
        if ((indx = mainfilenam.lastIndexOf(".")) >= 0) {
            suffix = mainfilenam.substring(indx + 1);
        }
        return suffix;
    }

    String getFileContentType(String filsuffix, NetFileResource nfr_user_locale_i18n_bucket) {
        String filesuffix = filsuffix;
        this.grepPlatinfo();
        String mimepath = this.pathinfo[1];
        String filecontenttype = this.s_empty_string;
        String mimefile = mimepath + "/mime.types";
        if (debug.messageEnabled()) {
            debug.message("The mime.types file is at " + mimefile);
        }
        if ((filecontenttype = this.mimeTypes(mimefile, filesuffix, nfr_user_locale_i18n_bucket)).equals(this.s_empty_string)) {
            return "application/octet-stream";
        }
        return filecontenttype;
    }

    /*
     * WARNING - void declaration
     */
    String mimeTypes(String mimefile, String filesuffix, NetFileResource nfr_user_locale_i18n_bucket) {
        String mimtyp = this.s_empty_string;
        String[] tokn = new String[200];
        String sep = ",";
        String MIME_typ = this.s_empty_string;
        String fil_suffix = filesuffix.toLowerCase();
        boolean found = false;
        try {
            int c;
            File inputFile = new File(mimefile);
            StringBuffer buftxt = new StringBuffer(80);
            FileInputStream fis = new FileInputStream(inputFile);
            while ((c = fis.read()) != -1) {
                void var16_17;
                char chtxt = (char)var16_17;
                buftxt.append(chtxt);
            }
            fis.close();
            mimtyp = buftxt.toString();
        }
        catch (FileNotFoundException e) {
            debug.error("FileOption mimetypes Filenotfound exception: ", (Throwable)e);
        }
        catch (IOException e) {
            debug.error("FileOption mimetypes IOException: ", (Throwable)e);
        }
        int indx = mimtyp.indexOf("type=", 0);
        String mimetyp = this.s_empty_string;
        if (indx >= 0) {
            mimetyp = mimtyp.substring(indx);
        }
        Vector<String> cache = new Vector<String>();
        StringTokenizer pars = new StringTokenizer(mimetyp, "\n");
        int parscnt = pars.countTokens();
        cache.removeAllElements();
        int i = 0;
        while (i < parscnt) {
            tokn[i] = pars.nextToken();
            cache.addElement(tokn[i]);
            ++i;
        }
        Object[] rowdata = new Object[100];
        Object[] coldata = new Object[100];
        if (cache.size() > 0) {
            int row = 0;
            while (row < cache.size() && !found) {
                String str_cache = (String)cache.elementAt(row);
                StringTokenizer parsnew = new StringTokenizer(str_cache, " ");
                int parscntnew = parsnew.countTokens();
                int j = 0;
                while (j < parscntnew && !found) {
                    rowdata[j] = parsnew.nextToken();
                    int extindx = rowdata[j].toString().indexOf("exts=", 0);
                    if (extindx >= 0) {
                        String extstr = rowdata[j].toString().substring(extindx);
                        StringTokenizer extpars = new StringTokenizer(extstr, sep);
                        int extparscnt = extpars.countTokens();
                        int s = 0;
                        while (s < extparscnt && !found) {
                            coldata[s] = extpars.nextToken();
                            if (coldata[s].toString().indexOf(fil_suffix) >= 0) {
                                int typindx = str_cache.indexOf("type=", 0);
                                MIME_typ = str_cache.substring(typindx + 5, str_cache.indexOf("exts="));
                                found = true;
                            }
                            ++s;
                        }
                    }
                    ++j;
                }
                ++row;
            }
        }
        return MIME_typ;
    }

    /*
     * Loose catch block
     */
    String[] compressFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession, String szCompressMethod) throws Exception, NetFileException {
        block100: {
            File file32;
            String copied_local_file;
            String target_file;
            String localfilenam;
            String text;
            String machtyp;
            block97: {
                block89: {
                    String zipdir = null;
                    String usernam = username;
                    String passwrd = password;
                    String machnam = machname;
                    machtyp = machtype;
                    String VMSnam = VMSname;
                    String mainfile_name = mainfilenam;
                    String dir = dir_nam;
                    String tempdir = tmpdir;
                    String domainname = domain;
                    String txt = this.s_empty_string;
                    text = this.s_empty_string;
                    boolean retv = false;
                    debug.message("Temporary directory=" + tmpdir);
                    String mainfilename = this.s_empty_string;
                    boolean indxcompr = false;
                    boolean intflg = true;
                    String newstr = this.s_empty_string;
                    String oldstr = mainfile_name;
                    localfilenam = this.s_empty_string;
                    target_file = this.s_empty_string;
                    copied_local_file = this.s_empty_string;
                    if (machtyp.equalsIgnoreCase(this.s_empty_string)) {
                        throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
                    }
                    if (mainfile_name.equals(this.s_empty_string)) {
                        throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
                    }
                    debug.error("Parsing file name ... ");
                    Vector cachechk = this.parse(mainfile_name, "\n");
                    if (cachechk.size() <= 0) {
                        debug.error("No files selected for compression");
                    }
                    if (cachechk.size() <= 0) break block89;
                    int fil_zip = 0;
                    while (fil_zip < cachechk.size()) {
                        block91: {
                            Exception e2222;
                            File file22;
                            Object var46_48;
                            InputStream instream;
                            OutputStream outstream;
                            WinFile gpc;
                            NfsFile nfsFile;
                            NetWareFile nwfile;
                            FtpFile gff;
                            block92: {
                                gff = null;
                                nwfile = null;
                                nfsFile = null;
                                gpc = null;
                                outstream = null;
                                instream = null;
                                if (szCompressMethod.equalsIgnoreCase("gzip")) {
                                    mainfile_name = (String)cachechk.elementAt(fil_zip) + ".gz";
                                } else if (szCompressMethod.equalsIgnoreCase("zip")) {
                                    mainfile_name = (String)cachechk.elementAt(fil_zip) + ".zip";
                                }
                                if (machtyp.indexOf(FTP, 0) >= 0) {
                                    debug.error(szCompressMethod + MESSAGE_1 + (String)cachechk.elementAt(fil_zip));
                                    gff = new FtpFile(this.logMgr, this.s_machine_encoding);
                                    instream = gff.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.elementAt(fil_zip), dir);
                                    outstream = gff.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir);
                                } else if (machtyp.indexOf(NETWARE, 0) >= 0) {
                                    debug.error(szCompressMethod + MESSAGE_1 + (String)cachechk.elementAt(fil_zip));
                                    nwfile = new NetWareFile(this.logMgr, this.s_machine_encoding);
                                    instream = nwfile.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.elementAt(fil_zip), dir);
                                    outstream = nwfile.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir);
                                } else if (machtyp.indexOf(NFS, 0) >= 0) {
                                    debug.error(szCompressMethod + MESSAGE_1 + (String)cachechk.elementAt(fil_zip));
                                    nfsFile = new NfsFile(this.logMgr, this.s_machine_encoding);
                                    instream = nfsFile.getNFSInputStream(usernam, passwrd, VMSnam, machnam, (String)cachechk.elementAt(fil_zip), dir);
                                    outstream = nfsFile.getNFSOutputStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir);
                                } else {
                                    if (machtyp.indexOf(WIN, 0) < 0 && machtyp.indexOf(NT, 0) < 0) break;
                                    debug.error(szCompressMethod + MESSAGE_1 + (String)cachechk.elementAt(fil_zip));
                                    mainfilename = (String)cachechk.elementAt(fil_zip);
                                    gpc = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                                    localfilenam = gpc.getPCFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, tempdir, nfr_user_locale_i18n_bucket, usersession);
                                    RandomNumber rndnum = new RandomNumber();
                                    String ranom = rndnum.randomNumbers();
                                    zipdir = tempdir + "/tmpzip." + ranom;
                                    File fil = new File(zipdir);
                                    if (!fil.exists()) {
                                        fil.mkdir();
                                        if (!fil.exists()) {
                                            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_temp_zip_dir");
                                        }
                                    }
                                    target_file = zipdir;
                                    instream = new FileInputStream(localfilenam);
                                    copied_local_file = zipdir + "/" + mainfile_name;
                                    outstream = new FileOutputStream(copied_local_file);
                                }
                                try {
                                    block90: {
                                        NetFileCompression nfComp = new NetFileCompression();
                                        nfComp.setCompressMethod(szCompressMethod);
                                        nfComp.doCompress(instream, outstream, cachechk.elementAt(fil_zip));
                                        if (machtyp.indexOf(WIN, 0) < 0 && machtyp.indexOf(NT, 0) < 0) break block90;
                                        text = gpc.putPCFile(usernam, passwrd, machnam, VMSnam, copied_local_file, mainfile_name, dir, domainname, nfr_user_locale_i18n_bucket);
                                    }
                                    var46_48 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        break block91;
                                    }
                                    if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                        break block91;
                                    }
                                    if (nfsFile == null) break block92;
                                }
                                catch (Throwable throwable) {
                                    var46_48 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                    } else if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                    } else if (nfsFile != null) {
                                        nfsFile.closeNfsFile();
                                    } else if (gpc != null) {
                                        if (instream != null) {
                                            instream.close();
                                        }
                                        if (outstream != null) {
                                            outstream.close();
                                        }
                                        try {
                                            file22 = new File(localfilenam);
                                            if (file22.exists()) {
                                                file22.delete();
                                            }
                                        }
                                        catch (Exception e2222) {
                                            // empty catch block
                                        }
                                        try {
                                            file22 = new File(target_file);
                                            if (file22.exists()) {
                                                file22.delete();
                                            }
                                        }
                                        catch (Exception e2222) {
                                            // empty catch block
                                        }
                                        try {
                                            file22 = new File(copied_local_file);
                                            if (file22.exists()) {
                                                file22.delete();
                                            }
                                        }
                                        catch (Exception e2222) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                nfsFile.closeNfsFile();
                                break block91;
                            }
                            if (gpc != null) {
                                if (instream != null) {
                                    instream.close();
                                }
                                if (outstream != null) {
                                    outstream.close();
                                }
                                try {
                                    file22 = new File(localfilenam);
                                    if (file22.exists()) {
                                        file22.delete();
                                    }
                                }
                                catch (Exception e2222) {
                                    // empty catch block
                                }
                                try {
                                    file22 = new File(target_file);
                                    if (file22.exists()) {
                                        file22.delete();
                                    }
                                }
                                catch (Exception e2222) {
                                    // empty catch block
                                }
                                try {
                                    file22 = new File(copied_local_file);
                                    if (file22.exists()) {
                                        file22.delete();
                                    }
                                    break block91;
                                }
                                catch (Exception e2222) {}
                            }
                            break block91;
                            {
                                catch (Exception e3) {
                                    text = ERROR;
                                    debug.error("Error in compressing file to Server " + machnam, (Throwable)e3);
                                    var46_48 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        break block91;
                                    }
                                    if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                        break block91;
                                    }
                                    if (nfsFile != null) {
                                        nfsFile.closeNfsFile();
                                        break block91;
                                    }
                                    if (gpc == null) break block91;
                                    if (instream != null) {
                                        instream.close();
                                    }
                                    if (outstream != null) {
                                        outstream.close();
                                    }
                                    try {
                                        file22 = new File(localfilenam);
                                        if (file22.exists()) {
                                            file22.delete();
                                        }
                                    }
                                    catch (Exception e2222) {
                                        // empty catch block
                                    }
                                    try {
                                        file22 = new File(target_file);
                                        if (file22.exists()) {
                                            file22.delete();
                                        }
                                    }
                                    catch (Exception e2222) {
                                        // empty catch block
                                    }
                                    try {
                                        file22 = new File(copied_local_file);
                                        if (file22.exists()) {
                                            file22.delete();
                                        }
                                    }
                                    catch (Exception e2222) {}
                                }
                            }
                        }
                        ++fil_zip;
                    }
                }
                Object var49_51 = null;
                if (!text.startsWith(ERROR)) break block97;
                if (machtyp.indexOf(NETWARE) > 0 && text.indexOf(nfr_user_locale_i18n_bucket.getString("error6")) >= 0) {
                    this.doError(this.getPlatformLocalisedString("invalidfilename"));
                    this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("invalidfilename");
                    this.rettxt[1] = END_OF_STRING;
                    return this.rettxt;
                }
                this.doError(this.getPlatformLocalisedString("error2"));
                this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2");
                this.rettxt[1] = END_OF_STRING;
                return this.rettxt;
            }
            try {
                file32 = new File(localfilenam);
                if (file32.exists()) {
                    file32.delete();
                }
            }
            catch (Exception e4) {
                // empty catch block
            }
            try {
                file32 = new File(target_file);
                if (file32.exists()) {
                    file32.delete();
                }
            }
            catch (Exception e4) {
                // empty catch block
            }
            try {
                file32 = new File(copied_local_file);
                if (file32.exists()) {
                    file32.delete();
                }
                break block100;
            }
            catch (Exception e4) {}
            break block100;
            {
                catch (Exception e) {
                    File file32;
                    debug.error("Exception compressing file", (Throwable)e);
                    String[] stringArray = new String[]{"ERROR: " + nfr_user_locale_i18n_bucket.getString("error2"), END_OF_STRING};
                    Object var49_52 = null;
                    if (text.startsWith(ERROR)) {
                        if (machtyp.indexOf(NETWARE) > 0 && text.indexOf(nfr_user_locale_i18n_bucket.getString("error6")) >= 0) {
                            this.doError(this.getPlatformLocalisedString("invalidfilename"));
                            this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("invalidfilename");
                            this.rettxt[1] = END_OF_STRING;
                            return this.rettxt;
                        }
                        this.doError(this.getPlatformLocalisedString("error2"));
                        this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2");
                        this.rettxt[1] = END_OF_STRING;
                        return this.rettxt;
                    }
                    try {
                        file32 = new File(localfilenam);
                        if (file32.exists()) {
                            file32.delete();
                        }
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    try {
                        file32 = new File(target_file);
                        if (file32.exists()) {
                            file32.delete();
                        }
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    try {
                        file32 = new File(copied_local_file);
                        if (file32.exists()) {
                            file32.delete();
                        }
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    return stringArray;
                }
            }
            catch (Throwable throwable) {
                File file32;
                Object var49_53 = null;
                if (text.startsWith(ERROR)) {
                    if (machtyp.indexOf(NETWARE) > 0 && text.indexOf(nfr_user_locale_i18n_bucket.getString("error6")) >= 0) {
                        this.doError(this.getPlatformLocalisedString("invalidfilename"));
                        this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("invalidfilename");
                        this.rettxt[1] = END_OF_STRING;
                        return this.rettxt;
                    }
                    this.doError(this.getPlatformLocalisedString("error2"));
                    this.rettxt[0] = "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2");
                    this.rettxt[1] = END_OF_STRING;
                    return this.rettxt;
                }
                try {
                    file32 = new File(localfilenam);
                    if (file32.exists()) {
                        file32.delete();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                try {
                    file32 = new File(target_file);
                    if (file32.exists()) {
                        file32.delete();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                try {
                    file32 = new File(copied_local_file);
                    if (file32.exists()) {
                        file32.delete();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.rettxt[0] = nfr_user_locale_i18n_bucket.getString("info9");
        return this.rettxt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String mailFile(String username, String password, String machine, String domain, String machine_type, String directory, String share, String files_to_send, String mail_server, String from, String to, String reply, String cc, String bcc, String subject, String message, String debug_value, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket, String character_set, String usersession) throws NetFileException {
        String string;
        debug.message("Mailing files=" + files_to_send);
        HashMap<String, String> m_files_to_send = new HashMap<String, String>();
        try {
            try {
                if (from.equals(this.s_empty_string)) throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error41");
                if (to.equals(this.s_empty_string)) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error41");
                }
                if (files_to_send.equals(this.s_empty_string)) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "warning9");
                }
                if (directory.trim().equals(" ") || directory == null) {
                    directory = this.s_empty_string;
                }
                if (machine_type.equalsIgnoreCase(this.s_empty_string)) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error1");
                }
                Vector v_files_to_send = this.parse(files_to_send, "*,");
                if (v_files_to_send.size() > 0) {
                    String result;
                    int fil_mail = 0;
                    while (true) {
                        if (fil_mail >= v_files_to_send.size()) break;
                        String filename = (String)v_files_to_send.elementAt(fil_mail);
                        result = this.openFile(username, password, machine, domain, machine_type, directory, share, filename, temporary_directory, nfr_user_locale_i18n_bucket, usersession);
                        if (result.startsWith(ERROR)) {
                            String string2 = result;
                            Object var29_32 = null;
                            this.deleteFiles(m_files_to_send);
                            return string2;
                        }
                        m_files_to_send.put(result, filename);
                        ++fil_mail;
                    }
                    SendFile sendfil = new SendFile();
                    result = sendfil.sendAttachedFile(to, from, reply, cc, bcc, mail_server, subject, message, m_files_to_send, debug_value, character_set, nfr_user_locale_i18n_bucket, files_to_send);
                    debug.message("Number of files in map=" + m_files_to_send.size());
                    String string3 = result;
                    Object var29_33 = null;
                    this.deleteFiles(m_files_to_send);
                    return string3;
                }
                string = nfr_user_locale_i18n_bucket.getString("no_files_to_mail");
            }
            catch (Exception e) {
                debug.error("Error mailing file", (Throwable)e);
                String string4 = ERROR + nfr_user_locale_i18n_bucket.getString("error4");
                Object var29_35 = null;
                this.deleteFiles(m_files_to_send);
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var29_36 = null;
            this.deleteFiles(m_files_to_send);
            throw throwable;
        }
        Object var29_34 = null;
        this.deleteFiles(m_files_to_send);
        return string;
    }

    private void deleteFiles(Map list_of_files) {
        debug.message("Deleting files");
        Iterator it = list_of_files.keySet().iterator();
        while (it.hasNext()) {
            try {
                Object o_filename = it.next();
                String s_filename = (String)o_filename;
                File delFil = new File(s_filename);
                debug.message("Deleting :" + delFil.getAbsolutePath());
                if (!delFil.exists()) continue;
                delFil.delete();
            }
            catch (Exception e) {
                debug.error("Exception deleting file", (Throwable)e);
            }
        }
    }

    String[] searchFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String search_pattern, int maxsearchdir, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String VMSnam = VMSname;
        String searchpattern = search_pattern;
        String dir = dir_nam;
        String domainname = domain;
        int maxsrchdir = maxsearchdir;
        String tempdir = tmpdir;
        String localfilenam = this.s_empty_string;
        String newname = this.s_empty_string;
        String new_repl = this.s_empty_string;
        boolean indtxt = false;
        String[] txt = new String[100];
        try {
            newname = machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0 ? VMSnam + dir : (machtyp.indexOf(NETWARE, 0) >= 0 ? VMSnam + "/" + dir : VMSnam + "/" + dir);
            if (newname.indexOf("//", 0) >= 0) {
                newname = newname.replace('/', ' ');
            }
            if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
                WinFile srpat = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                txt = srpat.smbDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, domainname, maxsrchdir, nfr_user_locale_i18n_bucket);
            } else if (machtyp.indexOf(FTP, 0) >= 0) {
                FtpFile srpat = new FtpFile(this.logMgr, this.s_machine_encoding);
                debug.message("Starting FileOption.FTP search in directory " + dir + " of VMS " + VMSnam + " with pattern " + searchpattern);
                txt = srpat.ftpDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, maxsrchdir, nfr_user_locale_i18n_bucket);
            } else if (machtyp.indexOf(NETWARE, 0) >= 0) {
                NetWareFile srpat = new NetWareFile(this.logMgr, this.s_machine_encoding);
                txt = srpat.ftpDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, maxsrchdir, nfr_user_locale_i18n_bucket);
            } else if (machtyp.indexOf(NFS, 0) >= 0) {
                txt = new NfsFile(this.logMgr, this.s_machine_encoding).search(usernam, passwrd, machnam, VMSnam, search_pattern, dir, domain, maxsrchdir, nfr_user_locale_i18n_bucket);
                if (txt.length == 0) {
                    txt = new String[]{"    "};
                }
            } else {
                txt[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error1");
            }
        }
        catch (Exception e) {
            debug.error("Exception searching files", (Throwable)e);
            txt[0] = ERROR + e.getMessage();
        }
        debug.message("Search over");
        txt = this.makeSearchResultsPresentable(txt);
        return txt;
    }

    private String[] makeSearchResultsPresentable(String[] sa_results) {
        int i = 0;
        while (i < sa_results.length) {
            String s_result = sa_results[i];
            char c_separator = s_result.charAt(0);
            if (c_separator == '\\' || c_separator == '/') {
                StringTokenizer st_tokens = new StringTokenizer(s_result, this.s_empty_string + c_separator);
                StringBuffer sb_presentable_result = new StringBuffer();
                sb_presentable_result.append(c_separator);
                int i_num_tokens = st_tokens.countTokens();
                int j = 0;
                while (j < i_num_tokens - 1) {
                    sb_presentable_result.append(st_tokens.nextToken()).append(c_separator);
                    ++j;
                }
                sb_presentable_result.append(st_tokens.nextToken());
                if (s_result.charAt(s_result.length() - 1) == c_separator) {
                    sb_presentable_result.append(c_separator);
                }
                sa_results[i] = sb_presentable_result.toString();
            }
            ++i;
        }
        return sa_results;
    }

    /*
     * WARNING - void declaration
     */
    String[] createDir(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String newdir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String VMSnam = VMSname;
        String newdir = newdir_nam;
        String mountdir = this.s_empty_string;
        String dir = dir_nam;
        String domainname = domain;
        String tempdir = tmpdir;
        String smbpath = this.s_empty_string;
        String mkdirres = this.s_empty_string;
        String[] returnmkdirres = new String[100];
        int mk = 0;
        try {
            String theLine;
            BufferedReader theList;
            String prwrkd;
            FullFtpClient fc;
            StringBuffer buftxt;
            returnmkdirres[mk] = nfr_user_locale_i18n_bucket.getString("warning52") + newdir + this.c_eol;
            ++mk;
            if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
                return new String[]{new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken).mkdir(machname, VMSname, usernam, passwrd, domain, dir, newdir_nam, nfr_user_locale_i18n_bucket), this.s_empty_string};
            }
            if (machtyp.indexOf(FTP, 0) >= 0) {
                String oldftpdir = VMSnam + dir;
                buftxt = new StringBuffer();
                try {
                    fc = new FullFtpClient(machnam, this.s_machine_encoding);
                    fc.login(usernam, passwrd);
                    fc.cd(oldftpdir);
                    prwrkd = fc.pwd();
                    fc.mkdir(newdir);
                    fc.setMachineToAccess(machnam);
                    theList = new BufferedReader(new InputStreamReader(fc.list()));
                    while ((theLine = theList.readLine()) != null) {
                        void var30_39;
                        buftxt.append((String)var30_39).append(this.c_eol);
                    }
                    mkdirres = buftxt.toString();
                    theList.close();
                    fc.closeServer();
                }
                catch (IOException ex) {
                    this.exerr = ex.toString();
                }
            } else {
                if (machtyp.indexOf(NFS, 0) >= 0) {
                    return new String[]{new NfsFile(this.logMgr, this.s_machine_encoding).mkdir(machname, VMSname, usernam, passwrd, dir, newdir_nam, nfr_user_locale_i18n_bucket), this.s_empty_string};
                }
                if (machtyp.indexOf(NETWARE, 0) >= 0) {
                    String oldnetwaredir = VMSnam + dir;
                    buftxt = new StringBuffer();
                    try {
                        fc = new FullFtpClient(machnam, this.s_machine_encoding);
                        fc.login(usernam, passwrd);
                        fc.cd(oldnetwaredir);
                        prwrkd = fc.pwd();
                        fc.mkdir(newdir);
                        fc.setMachineToAccess(machnam);
                        theList = new BufferedReader(new InputStreamReader(fc.list()));
                        while ((theLine = theList.readLine()) != null) {
                            buftxt.append(theLine).append(this.c_eol);
                        }
                        mkdirres = buftxt.toString();
                        theList.close();
                        fc.closeServer();
                    }
                    catch (IOException ex) {
                        this.exerr = ex.toString();
                    }
                } else {
                    this.doError(this.getPlatformLocalisedString("error3"));
                    returnmkdirres[mk] = ERROR + nfr_user_locale_i18n_bucket.getString("error3");
                }
            }
            if (this.exerr.indexOf("File exists", 0) >= 0 || this.exerr.indexOf("550", 0) >= 0) {
                this.doError(newdir + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newdir + nfr_user_locale_i18n_bucket.getString("error6");
                int k = ++mk;
                while (k < returnmkdirres.length) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                    ++k;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("LoginException", 0) >= 0 || this.exerr.indexOf("password", 0) >= 0) {
                this.doError(newdir + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newdir + nfr_user_locale_i18n_bucket.getString("error6");
                int k = ++mk;
                while (k < returnmkdirres.length) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                    ++k;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("errsrv", 0) >= 0 || this.exerr.indexOf("fail", 0) >= 0) {
                this.doError(newdir + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newdir + nfr_user_locale_i18n_bucket.getString("error6");
                int k = ++mk;
                while (k < returnmkdirres.length) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                    ++k;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("errdos", 0) >= 0 || this.exerr.indexOf("fail", 0) >= 0) {
                this.doError(newdir + this.getPlatformLocalisedString("error6"));
                returnmkdirres[mk] = ERROR + newdir + nfr_user_locale_i18n_bucket.getString("error6");
                int k = ++mk;
                while (k < returnmkdirres.length) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                    ++k;
                }
                return returnmkdirres;
            }
            if (this.exerr.indexOf("smbclient: not found", 0) >= 0) {
                this.doError(newdir + this.getPlatformLocalisedString("error35"));
                returnmkdirres[mk] = ERROR + newdir + nfr_user_locale_i18n_bucket.getString("error35");
                int k = ++mk;
                while (k < returnmkdirres.length) {
                    returnmkdirres[mk] = END_OF_STRING;
                    ++mk;
                    ++k;
                }
                return returnmkdirres;
            }
            this.doLog(this.getPlatformLocalisedString("func34"));
            int k = mk;
            while (k < returnmkdirres.length) {
                returnmkdirres[mk] = END_OF_STRING;
                ++mk;
                ++k;
            }
        }
        catch (Exception e) {
            returnmkdirres[0] = ERROR + e.getMessage();
            debug.error("Error creating directory", (Throwable)e);
        }
        return returnmkdirres;
    }

    private Vector parse(String string, String delimiter) {
        int i_index_of_delimiter = 0;
        int i_start_index = 0;
        int i_size_of_delimiter = delimiter.length();
        Vector<String> v_tokens = new Vector<String>();
        while (i_start_index < (i_index_of_delimiter = string.indexOf(delimiter, i_start_index))) {
            String token = string.substring(i_start_index, i_index_of_delimiter);
            v_tokens.addElement(token);
            i_start_index = i_index_of_delimiter + i_size_of_delimiter;
        }
        return v_tokens;
    }

    String uploadFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String localfilename, String remotefilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String VMSnam = VMSname;
        String remotefilename = remotefilenam;
        String dir = dir_nam;
        String tempdir = tmpdir;
        String domainname = domain;
        String localfilenam = localfilename;
        String text = this.s_empty_string;
        try {
            if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
                WinFile ppf = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                text = ppf.putPCFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, domainname, nfr_user_locale_i18n_bucket);
            }
            if (machtyp.indexOf(FTP, 0) >= 0) {
                FtpFile pff = new FtpFile(this.logMgr, this.s_machine_encoding);
                text = pff.putFTPFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, nfr_user_locale_i18n_bucket);
            }
            if (machtyp.indexOf(NFS, 0) >= 0) {
                NfsFile pnff = new NfsFile(this.logMgr, this.s_machine_encoding);
                text = pnff.putNFSFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, tempdir, nfr_user_locale_i18n_bucket);
            }
            if (machtyp.indexOf(NETWARE, 0) >= 0) {
                NetWareFile nff = new NetWareFile(this.logMgr, this.s_machine_encoding);
                text = nff.putFTPFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, nfr_user_locale_i18n_bucket);
            }
        }
        catch (Exception e) {
            text = ERROR + e.getMessage();
            debug.error("Error putting a file", (Throwable)e);
        }
        debug.message("Upload file result=" + text);
        return text;
    }

    String[] getMachineType(String machname, String machinetype, String domainname, String[] sa_current_machines, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String machinename = machname;
        String machpack = this.s_empty_string;
        String machinetyp = machinetype;
        String[] machtype = new String[2];
        String machdomain = domainname;
        ArrayList rphost_ip = this.getRPaddrs(nfr_user_locale_i18n_bucket);
        try {
            try {
                InetAddress machhost = InetAddress.getByName(machinename);
                machpack = machhost.toString();
            }
            catch (UnknownHostException ue) {
                debug.error("Unknown host", (Throwable)ue);
                this.doError(this.getPlatformLocalisedString("error27"));
                machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error27");
                machtype[1] = END_OF_STRING;
                return machtype;
            }
            int machip = machpack.indexOf("/", 0);
            String newip = machpack.substring(machip + 1);
            int k = 0;
            while (k < rphost_ip.size()) {
                if (((String)rphost_ip.get(k)).trim().equals(newip.trim())) {
                    this.doError(this.getPlatformLocalisedString("error8"));
                    machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error8");
                    machtype[1] = END_OF_STRING;
                    return machtype;
                }
                ++k;
            }
            if (this.isMachineAlreadyAdded(machinename, sa_current_machines)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "machine_already_added");
            }
            if (machinetyp.indexOf("autodetect") >= 0) {
                CheckPort chkportwin = new CheckPort();
                int winstat = chkportwin.checkTcpPort(machinename, 139);
                chkportwin = null;
                if (winstat == 1) {
                    WinFile wf = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                    String[] wrnt = wf.getWinType(machinename, machdomain, nfr_user_locale_i18n_bucket);
                    machtype[0] = wrnt[0];
                    machtype[1] = wrnt[1];
                    return machtype;
                }
                CheckPort chkportftp = new CheckPort();
                int ftpstat = chkportftp.checkTcpPort(machinename, 21);
                chkportftp = null;
                if (ftpstat == 1) {
                    NetWareFile nff = new NetWareFile(this.logMgr, this.s_machine_encoding);
                    boolean isNetWare = nff.getFTPType(machinename);
                    if (isNetWare) {
                        machtype[0] = "?NETWARE\n";
                        machtype[1] = END_OF_STRING;
                    } else {
                        machtype[0] = "?FTP\n";
                        machtype[1] = END_OF_STRING;
                    }
                    return machtype;
                }
                CheckPort chkportnfs = new CheckPort();
                int nfsstat = chkportnfs.checkTcpPort(machinename, 2049);
                chkportnfs = null;
                if (nfsstat == 1) {
                    machtype[0] = "?NFS\n";
                    machtype[1] = END_OF_STRING;
                    return machtype;
                }
                if (winstat == -1 && ftpstat == -1 && nfsstat == -1) {
                    this.doError(this.getPlatformLocalisedString("error27"));
                    machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error27");
                    machtype[1] = END_OF_STRING;
                    return machtype;
                }
            } else {
                if (machinetyp.indexOf(FTP) >= 0) {
                    CheckPort chkportftp = new CheckPort();
                    int ftpstat = chkportftp.checkTcpPort(machinename, 21);
                    chkportftp = null;
                    if (ftpstat == 1) {
                        machtype[0] = "?FTP\n";
                        machtype[1] = END_OF_STRING;
                        return machtype;
                    }
                    this.doError(this.getPlatformLocalisedString("error9"));
                    machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error9");
                    machtype[1] = END_OF_STRING;
                    return machtype;
                }
                if (machinetyp.indexOf(NETWARE) >= 0) {
                    CheckPort chkportftp = new CheckPort();
                    int ftpstat = chkportftp.checkTcpPort(machinename, 21);
                    chkportftp = null;
                    if (ftpstat == 1) {
                        NetWareFile nff = new NetWareFile(this.logMgr, this.s_machine_encoding);
                        boolean isNetWare = nff.getFTPType(machinename);
                        if (isNetWare) {
                            machtype[0] = "?NETWARE\n";
                            machtype[1] = END_OF_STRING;
                        } else {
                            this.doError(this.getPlatformLocalisedString("error9"));
                            machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error9");
                            machtype[1] = END_OF_STRING;
                        }
                        return machtype;
                    }
                } else {
                    if (machinetyp.indexOf(WIN) >= 0) {
                        CheckPort chkportwin = new CheckPort();
                        int winstat = chkportwin.checkTcpPort(machinename, 139);
                        chkportwin = null;
                        if (winstat == 1) {
                            WinFile wf = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                            String[] wrnt = wf.getWinType(machinename, machdomain, nfr_user_locale_i18n_bucket);
                            machtype[0] = wrnt[0];
                            machtype[1] = wrnt[1];
                            return machtype;
                        }
                        this.doError(this.getPlatformLocalisedString("error9"));
                        machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error9");
                        machtype[1] = END_OF_STRING;
                        return machtype;
                    }
                    if (machinetyp.indexOf(NFS) >= 0) {
                        CheckPort chkportnfs = new CheckPort();
                        int nfsstat = chkportnfs.checkTcpPort(machinename, 2049);
                        chkportnfs = null;
                        if (nfsstat == 1) {
                            machtype[0] = "?NFS\n";
                            machtype[1] = END_OF_STRING;
                            return machtype;
                        }
                        this.doError(this.getPlatformLocalisedString("error9"));
                        machtype[0] = ERROR + nfr_user_locale_i18n_bucket.getString("error9");
                        machtype[1] = END_OF_STRING;
                        return machtype;
                    }
                    if (machinetyp.indexOf(NETWARE) < 0 && machinetyp.indexOf("REMOTE") >= 0) {
                        machtype[0] = "?RC";
                        machtype[1] = END_OF_STRING;
                        return machtype;
                    }
                }
            }
        }
        catch (Exception e) {
            debug.message("Error getting machine type", (Throwable)e);
            machtype[0] = ERROR + e.getMessage();
            machtype[1] = END_OF_STRING;
        }
        return machtype;
    }

    boolean isMachineAlreadyAdded(String s_machine, String[] sa_current_machines) throws UnknownHostException, NetFileException {
        InetAddress[] ia_machine = InetAddress.getAllByName(s_machine);
        debug.message(ia_machine.toString());
        int i_number_of_machines = sa_current_machines.length;
        debug.message("Number of machines=" + i_number_of_machines);
        int i = 0;
        while (i < i_number_of_machines) {
            try {
                InetAddress[] ia_current_machine = InetAddress.getAllByName(sa_current_machines[i]);
                debug.message(ia_current_machine.toString());
                if (this.areMachinesSame(ia_machine, ia_current_machine)) {
                    return true;
                }
            }
            catch (Exception e) {
                debug.error("Problem resolving host", (Throwable)e);
            }
            ++i;
        }
        return false;
    }

    boolean areMachinesSame(InetAddress[] ia_machine, InetAddress[] ia_current_machine) {
        int i_num_machine_ips = ia_machine.length;
        int i_num_current_machine_ips = ia_current_machine.length;
        int i = 0;
        while (i < i_num_current_machine_ips) {
            int j = 0;
            while (j < i_num_machine_ips) {
                if (ia_machine[j].equals(ia_current_machine[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    ArrayList getRPaddrs(NetFileResource nfr_user_locale_i18n_bucket) {
        String netfile_denyhosts = "129.146.48.120,129.146.48.112";
        ArrayList<String> rphostip = new ArrayList<String>();
        String configparam = this.s_empty_string;
        String denyaddrs = netfile_denyhosts;
        StringTokenizer parsnew = new StringTokenizer(denyaddrs, ",");
        int parscntnew = parsnew.countTokens();
        int rpj = 0;
        while (rpj < parscntnew) {
            rphostip.add(parsnew.nextToken());
            ++rpj;
        }
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = new String[]{"/sbin/ifconfig", "-a"};
            Process shellconn = rt.exec(progarr);
            InputStream shellout = shellconn.getInputStream();
            while ((c = shellout.read()) > -1) {
                void var10_18;
                char chtxt = (char)var10_18;
                buftxt.append(chtxt);
            }
            rt = null;
            shellout.close();
            shellout = null;
            shellconn.destroy();
            shellconn = null;
            configparam = buftxt.toString();
        }
        catch (IOException ex) {
            debug.error("FileOption IOException in getrpaddrs: ", (Throwable)ex);
            rphostip.add("Failed Execution: " + ex);
            Object rt = null;
            return rphostip;
        }
        if (configparam.equals(this.s_empty_string)) {
            debug.message("Cannot get local machine hostname.");
            rphostip.add("Cannot get local machine hostname.");
            return rphostip;
        }
        StringTokenizer pars = new StringTokenizer(configparam, "\n");
        int parscnt = pars.countTokens();
        String hostip = "";
        int inetindx = 0;
        int inetmaskindx = 0;
        int j = 0;
        while (j < parscnt) {
            hostip = pars.nextToken();
            inetindx = hostip.indexOf("inet", 0);
            inetmaskindx = hostip.indexOf("netmask", 0);
            if (inetindx >= 0 && inetmaskindx >= 0) {
                rphostip.add(hostip.substring(inetindx + 5, inetmaskindx));
            }
            ++j;
        }
        return rphostip;
    }

    String deleteFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String usernam = username;
        String passwrd = password;
        String machnam = machname;
        String machtyp = machtype;
        String VMSnam = VMSname;
        String mainfile_name = mainfilenam;
        String dir = dir_nam;
        String tempdir = tmpdir;
        String domainname = domain;
        String txt = this.s_empty_string;
        Vector<String> cachechk = new Vector<String>();
        String mainfilename = this.s_empty_string;
        int indx = 0;
        boolean intflg = true;
        String newstr = this.s_empty_string;
        String oldstr = mainfile_name;
        try {
            if (mainfile_name.equals(this.s_empty_string)) {
                this.doError(this.getPlatformLocalisedString("warning9"));
                txt = ERROR + nfr_user_locale_i18n_bucket.getString("warning9");
                return txt;
            }
            cachechk.removeAllElements();
            while (intflg) {
                indx = mainfile_name.indexOf("*,", 0);
                if (indx >= 0) {
                    newstr = mainfile_name.substring(0, indx);
                    cachechk.addElement(newstr);
                    mainfile_name = oldstr = mainfile_name.substring(indx + 2);
                    continue;
                }
                indx = oldstr.indexOf("*", 0);
                if (indx >= 0) {
                    newstr = oldstr.substring(0, indx);
                    cachechk.addElement(newstr);
                }
                intflg = false;
            }
            if (cachechk.size() > 0) {
                int fil = 0;
                while (fil < cachechk.size()) {
                    mainfilename = (String)cachechk.elementAt(fil);
                    if (machtyp.equalsIgnoreCase(this.s_empty_string)) {
                        this.doError(this.getPlatformLocalisedString("error1"));
                        return ERROR + nfr_user_locale_i18n_bucket.getString("error1");
                    }
                    if (machtyp.indexOf(NETWARE, 0) >= 0) {
                        NetWareFile n = new NetWareFile(this.logMgr, this.s_machine_encoding);
                        txt = n.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfr_user_locale_i18n_bucket);
                    }
                    if (machtyp.indexOf(WIN, 0) >= 0 || machtyp.indexOf(NT, 0) >= 0) {
                        WinFile gpc = new WinFile(this.logMgr, this.s_machine_encoding, this.ssoToken);
                        txt = gpc.delPCFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, nfr_user_locale_i18n_bucket);
                    }
                    if (machtyp.indexOf(FTP, 0) >= 0) {
                        FtpFile gff = new FtpFile(this.logMgr, this.s_machine_encoding);
                        txt = gff.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfr_user_locale_i18n_bucket);
                    }
                    if (machtyp.indexOf(NFS, 0) >= 0) {
                        NfsFile gfs = new NfsFile(this.logMgr, this.s_machine_encoding);
                        txt = gfs.delNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket);
                    }
                    if (txt.indexOf("FileNotFound", 0) >= 0) {
                        this.doError(this.getPlatformLocalisedString("error2"));
                        return "ERROR: " + nfr_user_locale_i18n_bucket.getString("error2") + ": " + mainfilename;
                    }
                    if (txt.indexOf("ERROR", 0) >= 0) {
                        this.doError(this.getPlatformLocalisedString("error37"));
                        return "ERROR: " + nfr_user_locale_i18n_bucket.getString("error37") + ": " + mainfilename;
                    }
                    ++fil;
                }
            }
            return txt;
        }
        catch (Exception e) {
            debug.error("Problem deleting file", (Throwable)e);
            return ERROR + e.getMessage();
        }
    }

    void doError(String msg) {
        if (this.logMgr == null) {
            return;
        }
        this.logMgr.doError(s_platform_locale_error + msg);
    }

    void doLog(String msg) {
        if (this.logMgr == null) {
            return;
        }
        this.logMgr.doLog(msg);
    }

    String[] grepPlatinfo() {
        NetFileContextImpl nfContext = new NetFileContextImpl(this.getSSOToken());
        this.pathinfo[0] = nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileSMBClientLocation", this.s_empty_string);
        this.pathinfo[1] = nfContext.getOrganizationAttribute("srapNetFileService", "sunPortalNetFileMimetypesConfigFileLocation", this.s_empty_string);
        debug.error("Paths are " + this.pathinfo[0] + this.c_eol + this.pathinfo[1]);
        return this.pathinfo;
    }

    static String checkSessionState(HttpServletRequest req) {
        SSOTokenManager manager = null;
        SSOToken ssoToken = null;
        try {
            manager = SSOTokenManager.getInstance();
            String tokenId = req.getHeader("iPSsessionID");
            ssoToken = manager.createSSOToken(tokenId);
            if (manager.isValidToken(ssoToken)) {
                return "VALID";
            }
            return "INACTIVE";
        }
        catch (SSOException ssoe) {
            debug.error("SSO Exception in File Option while checking session state " + (Object)((Object)ssoe));
            return "INACTIVE";
        }
    }

    public void downloadFolder(PrintWriter out, String[] parameters, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException, Exception {
        if (out == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "null_writer_to_applet_error");
        }
        if (parameters == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "null_parameters_error");
        }
        if (nfr_user_locale_i18n_bucket == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "null_localistaion_bucket_error");
        }
        if (parameters.length != 10) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "missing_parameters_error");
        }
        String[] files = this.getFilesInDirectory(parameters, nfr_user_locale_i18n_bucket);
        if (files.length < 1) {
            throw new NetFileException("empty directory");
        }
        int i = 0;
        while (i < files.length) {
            String file_name = files[i];
            out.println(file_name);
            out.flush();
            ++i;
        }
        out.println();
        out.flush();
    }

    private String[] getFilesInDirectory(String[] parameters, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException, Exception {
        String[] listing = this.expandDir(parameters[0], parameters[1], parameters[4], parameters[6], parameters[5], parameters[3], parameters[2], parameters[7], nfr_user_locale_i18n_bucket);
        if (listing == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        if (listing.length == 0) {
            return listing;
        }
        if (listing[0] == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        if (listing[0].startsWith(ERROR)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + listing[0].substring(ERROR.length() + 1, listing[0].length()));
        }
        if (listing.length % 4 != 0) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "The array size is not multiple of 4");
        }
        Vector<String> v_files_in_directory = new Vector<String>();
        int i_index = 0;
        while (i_index < listing.length) {
            String s_name;
            String s_type = listing[i_index];
            if (s_type == null || (s_name = listing[i_index + 1]) == null) break;
            if (s_type.equals("-")) {
                v_files_in_directory.addElement(s_name);
            }
            if (i_index + 4 >= listing.length) {
                debug.message("breaking");
                break;
            }
            i_index += 4;
        }
        int i_listing_size = v_files_in_directory.size();
        String[] file_listing = new String[i_listing_size];
        int i = 0;
        while (i < i_listing_size) {
            file_listing[i] = (String)v_files_in_directory.elementAt(i);
            ++i;
        }
        return file_listing;
    }

    void rename(String username, String password, String machine, String type, String domain, String share, String directory, String old_file_name, String new_file_name, String s_machine_encoding) throws NetFileException {
        if (type.equals(WIN) || type.equals(NT)) {
            new WinFile(this.logMgr, s_machine_encoding, this.ssoToken).rename(username, password, machine, domain, share, directory, old_file_name, new_file_name);
        } else if (type.equals(FTP)) {
            new FtpFile(this.logMgr, s_machine_encoding).rename(username, password, machine, share, directory, old_file_name, new_file_name);
        } else if (type.equals(NFS)) {
            new NfsFile(this.logMgr, s_machine_encoding).rename(username, password, machine, share, directory, old_file_name, new_file_name);
        } else if (type.equals(NETWARE)) {
            new NetWareFile(this.logMgr, s_machine_encoding).rename(username, password, machine, share, directory, old_file_name, new_file_name);
        } else {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_machine_type_error");
        }
    }

    String doesFileExist(String username, String password, String machine, String type, String domain, String share, String directory, String file_name, String temporary_directory, NetFileResource nfr_user_locale_i18n_bucket) throws Exception, NetFileException {
        String[] sa_file_listing = new String[]{};
        try {
            sa_file_listing = this.expandDir(username, password, machine, domain, type, directory, share, temporary_directory, nfr_user_locale_i18n_bucket);
            debug.message("File listing obtained :" + sa_file_listing.length);
        }
        catch (Exception e) {
            debug.error("Exception in getting the listing", (Throwable)e);
        }
        int i_file_name_pointer = 1;
        while (i_file_name_pointer < sa_file_listing.length) {
            if (file_name.equals(sa_file_listing[i_file_name_pointer])) {
                return "YES";
            }
            i_file_name_pointer += 4;
        }
        return "NO";
    }

    static {
        debug = null;
    }

    class EnumValue
    implements Enumeration {
        String str;

        EnumValue(String s) {
            this.str = s;
        }

        EnumValue(boolean b) {
            this.str = b ? "true" : "false";
        }

        EnumValue(int i) {
            this.str = FileOption.this.s_empty_string + i;
        }

        public boolean hasMoreElements() {
            return this.str != null;
        }

        public Object nextElement() {
            String s = this.str;
            this.str = null;
            return s;
        }
    }
}

