/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp.jasper3.jasper.compiler;

import com.sun.portal.providers.jsp.jasper3.jasper.compiler.GeneratorBase;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.ServletWriter;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.VariableInfo;

abstract class TagGeneratorBase
extends GeneratorBase {
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;

    TagGeneratorBase() {
    }

    protected void setTagHandlerStack(Stack tagHandlerStack) {
        this.tagHandlerStack = tagHandlerStack;
    }

    protected void setTagVarNumbers(Hashtable tagVarNumbers) {
        this.tagVarNumbers = tagVarNumbers;
    }

    protected void tagBegin(TagVariableData tvd) {
        this.tagHandlerStack.push(tvd);
    }

    protected TagVariableData tagEnd() {
        return (TagVariableData)this.tagHandlerStack.pop();
    }

    protected TagVariableData topTag() {
        if (this.tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)this.tagHandlerStack.peek();
    }

    protected String getTagVarName(String prefix, String shortTagName) {
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String tag = prefix + ":" + shortTagName;
            String varName = prefix + "_" + shortTagName + "_";
            if (this.tagVarNumbers.get(tag) != null) {
                Integer i = (Integer)this.tagVarNumbers.get(tag);
                varName = varName + i;
                this.tagVarNumbers.put(tag, new Integer(i + 1));
                String string = varName;
                return string;
            }
            this.tagVarNumbers.put(tag, new Integer(1));
            String string = varName + "0";
            return string;
        }
    }

    protected void declareVariables(ServletWriter writer, VariableInfo[] vi, boolean declare, boolean update, int scope) {
        if (vi != null) {
            int i = 0;
            while (i < vi.length) {
                if (vi[i].getScope() == scope) {
                    if (vi[i].getDeclare() && declare) {
                        writer.println(vi[i].getClassName() + " " + vi[i].getVarName() + " = null;");
                    }
                    if (update) {
                        writer.println(vi[i].getVarName() + " = (" + vi[i].getClassName() + ") pageContext.findAttribute(" + writer.quoteString(vi[i].getVarName()) + ");");
                    }
                }
                ++i;
            }
        }
    }

    class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;

        TagVariableData(String tagHandlerInstanceName, String tagEvalVarName) {
            this.tagHandlerInstanceName = tagHandlerInstanceName;
            this.tagEvalVarName = tagEvalVarName;
        }
    }
}

