/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp.jasper3.jasper.compiler;

import com.sun.portal.providers.jsp.jasper3.jasper.Constants;
import com.sun.portal.providers.jsp.jasper3.jasper.JasperException;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.ConstantPool;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassName {
    static String processClassData(InputStream in) throws JasperException, IOException {
        DataInputStream din = new DataInputStream(in);
        din.readInt();
        din.readUnsignedShort();
        din.readUnsignedShort();
        int count = din.readUnsignedShort();
        ConstantPool[] constantPool = new ConstantPool[count];
        constantPool[0] = new ConstantPool();
        int i = 1;
        while (i < constantPool.length) {
            constantPool[i] = new ConstantPool();
            if (!constantPool[i].read(din)) {
                throw new JasperException(Constants.getString("jsp.error.classname"));
            }
            if (constantPool[i].type == 5 || constantPool[i].type == 6) {
                ++i;
            }
            ++i;
        }
        int i2 = 1;
        while (i2 < constantPool.length) {
            if (constantPool[i2] != null) {
                if (constantPool[i2].index1 > 0) {
                    constantPool[i2].arg1 = constantPool[constantPool[i2].index1];
                }
                if (constantPool[i2].index2 > 0) {
                    constantPool[i2].arg2 = constantPool[constantPool[i2].index2];
                }
            }
            ++i2;
        }
        int accessFlags = din.readUnsignedShort();
        ConstantPool thisClass = constantPool[din.readUnsignedShort()];
        din.close();
        return ClassName.printClassName(thisClass.arg1.strValue);
    }

    private static String printClassName(String s) {
        if (s.charAt(0) == '[') {
            return ClassName.typeString(s, "");
        }
        StringBuffer x = new StringBuffer();
        int j = 0;
        while (j < s.length()) {
            if (s.charAt(j) == '/') {
                x.append('.');
            } else {
                x.append(s.charAt(j));
            }
            ++j;
        }
        return x.toString();
    }

    private static String typeString(String typeString, String varName) {
        int isArray = 0;
        int ndx = 0;
        StringBuffer x = new StringBuffer();
        while (typeString.charAt(ndx) == '[') {
            ++isArray;
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': {
                x.append("byte ");
                break;
            }
            case 'C': {
                x.append("char ");
                break;
            }
            case 'D': {
                x.append("double ");
                break;
            }
            case 'F': {
                x.append("float ");
                break;
            }
            case 'I': {
                x.append("int ");
                break;
            }
            case 'J': {
                x.append("long ");
                break;
            }
            case 'L': {
                int i = ndx + 1;
                while (i < typeString.indexOf(59)) {
                    if (typeString.charAt(i) != '/') {
                        x.append(typeString.charAt(i));
                    } else {
                        x.append('.');
                    }
                    ++i;
                }
                x.append(" ");
                break;
            }
            case 'V': {
                x.append("void ");
                break;
            }
            case 'S': {
                x.append("short ");
                break;
            }
            case 'Z': {
                x.append("boolean ");
            }
        }
        x.append(varName);
        while (isArray > 0) {
            x.append("[]");
            --isArray;
        }
        return x.toString();
    }

    public static String getClassName(String classFile) throws JasperException {
        try {
            FileInputStream fin = new FileInputStream(classFile);
            return ClassName.processClassData(fin);
        }
        catch (IOException ex) {
            throw new JasperException(Constants.getString("jsp.error.classname"), ex);
        }
    }

    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < args.length) {
                System.out.println("Filename: " + args[i] + " Classname: " + ClassName.getClassName(args[i]));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

