/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

class JspSession
implements HttpSession {
    private Hashtable values = new Hashtable();
    private String id;
    private long creationTime;
    private long thisAccessTime = this.creationTime = System.currentTimeMillis();
    private long lastAccessed = this.creationTime;
    private int inactiveInterval = -1;
    private boolean valid = true;

    JspSession() {
        this.id = "" + this.hashCode();
    }

    void accessed() {
        this.lastAccessed = this.thisAccessTime;
        this.thisAccessTime = System.currentTimeMillis();
        this.validate();
    }

    void validate() {
        int thisInterval;
        if (this.inactiveInterval != -1 && (thisInterval = (int)(System.currentTimeMillis() - this.lastAccessed) / 1000) > this.inactiveInterval) {
            this.invalidate();
        }
    }

    public String getId() {
        if (this.valid) {
            return this.id;
        }
        throw new IllegalStateException("invalid session");
    }

    public long getCreationTime() {
        if (this.valid) {
            return this.creationTime;
        }
        throw new IllegalStateException("invalid session");
    }

    public long getLastAccessedTime() {
        if (this.valid) {
            return this.lastAccessed;
        }
        throw new IllegalStateException("invalid session");
    }

    public void invalidate() {
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            this.removeValue(name);
        }
        this.valid = false;
    }

    public boolean isNew() {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        return this.thisAccessTime == this.creationTime;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void setAttribute(String name, Object value) {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.removeValue(name);
        if (value != null && value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent e = new HttpSessionBindingEvent((HttpSession)this, name);
            ((HttpSessionBindingListener)value).valueBound(e);
        }
        this.values.put(name, value);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Object getAttribute(String name) {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        return this.values.get(name);
    }

    public String[] getValueNames() {
        Enumeration e = this.getAttributeNames();
        Vector names = new Vector();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] valueNames = new String[names.size()];
        names.copyInto(valueNames);
        return valueNames;
    }

    public Enumeration getAttributeNames() {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        Hashtable valuesClone = (Hashtable)this.values.clone();
        return valuesClone.keys();
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void removeAttribute(String name) {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        Object o = this.values.get(name);
        if (o instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent e = new HttpSessionBindingEvent((HttpSession)this, name);
            ((HttpSessionBindingListener)o).valueUnbound(e);
        }
        this.values.remove(name);
    }

    public void setMaxInactiveInterval(int interval) {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        this.inactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        if (!this.valid) {
            throw new IllegalStateException("invalid session");
        }
        return this.inactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return new HttpSessionContext(){

            public HttpSession getSession(String sessionId) {
                return null;
            }

            public Enumeration getIds() {
                Vector v = new Vector();
                return v.elements();
            }
        };
    }
}

