/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.desktop.context.ClassInfoCache;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.providers.jsp.JspServletEnvironment;
import com.sun.portal.providers.jsp.jasper3.jasper.EmbededServletOptions;
import com.sun.portal.providers.jsp.jasper3.jasper.JasperException;
import com.sun.portal.providers.jsp.jasper3.jasper.JspEngineContext;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.JspCompiler;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.JspMangler;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.Mangler;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.SunJavaCompiler;
import com.sun.portal.providers.jsp.jasper3.jasper.servlet.JasperLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

class JspServletWrapper {
    HttpJspPage theServlet;
    String jspPath;
    String uri;
    JasperLoader loader;
    EmbededServletOptions options;
    JspServletEnvironment config;
    SunJavaCompiler javaCompiler;
    Mangler mangler;
    ProviderClassLoader pcl;
    File jspFile;
    File classFile;
    long expireTime = 0L;
    int scanInterval = 0;

    JspServletWrapper(String uri, String jspPath, String fullJspPath, String mostSpecificJspPath, JspServletEnvironment cfg, int scanInterval, ProviderClassLoader pcl) {
        this.uri = uri;
        this.jspPath = jspPath;
        this.options = cfg.getOptions();
        this.config = cfg;
        this.scanInterval = scanInterval * 1000;
        this.pcl = pcl;
        this.theServlet = null;
        this.loader = new JasperLoader();
        this.loader.setParentClassLoader((ClassLoader)pcl);
        this.loader.setOptions(this.options);
        this.javaCompiler = new SunJavaCompiler();
        this.mangler = new JspMangler(mostSpecificJspPath, this.options.getScratchDir().getPath());
        this.jspFile = new File(fullJspPath);
        this.classFile = new File(this.mangler.getClassFileName());
    }

    private synchronized void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
        boolean outDated = false;
        if (!this.expired()) {
            return;
        }
        try {
            boolean bl = outDated = this.classFile.lastModified() < this.jspFile.lastModified();
            if (outDated) {
                String outputDir;
                File f;
                String optionsClassPath = ClassInfoCache.getProviderClasspath() + File.pathSeparatorChar + this.options.getClassPath();
                JspEngineContext ctxt = new JspEngineContext(this.loader, optionsClassPath, this.config, this.jspPath, false, this.options, req, res);
                JspCompiler compiler = new JspCompiler(ctxt);
                compiler.setMangler(this.mangler);
                String javaFileName = this.mangler.getJavaFileName();
                int index = javaFileName.lastIndexOf(File.separatorChar);
                if (index != -1 && !(f = new File(outputDir = javaFileName.substring(0, index))).exists()) {
                    f.mkdirs();
                }
                compiler.setJavaCompiler(this.javaCompiler);
                compiler.compile();
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (JasperException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JasperException("Unable to compile JSP", ex);
        }
        if (outDated && this.theServlet != null) {
            this.loader = new JasperLoader();
            this.loader.setParentClassLoader((ClassLoader)this.pcl);
            this.loader.setOptions(this.options);
            this.destroy();
        }
        if (this.theServlet == null) {
            try {
                String fullClassName = this.mangler.getPackageName() + "." + this.mangler.getClassName();
                Class<?> jspClass = this.loader.loadClass(fullClassName);
                this.theServlet = (HttpJspPage)jspClass.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException("Unable to load JSP", ex);
            }
            this.theServlet.init((ServletConfig)this.config);
        }
        this.resetExpireTime();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            try {
                this.loadIfNecessary(request, response);
                if (this.theServlet instanceof SingleThreadModel) {
                    JspServletWrapper jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                        break block6;
                    }
                }
                this.theServlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (FileNotFoundException ex) {
                response.sendError(404, ex.getMessage());
                return;
            }
        }
    }

    void setFullJspFile(String fullJspPath) {
        File currentFullJspPath = new File(fullJspPath);
        if (!this.jspFile.equals(currentFullJspPath)) {
            this.jspFile = currentFullJspPath;
            File jspJavaFile = new File(this.mangler.getJavaFileName());
            jspJavaFile.delete();
            this.classFile.delete();
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            this.theServlet = null;
        }
    }

    String getURI() {
        return this.uri;
    }

    boolean expired() {
        return System.currentTimeMillis() > this.expireTime;
    }

    void resetExpireTime() {
        this.expireTime = System.currentTimeMillis() + (long)this.scanInterval;
    }
}

